/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.bluemix.utility.actions;

import com.ibm.ws.bluemix.utility.actions.BaseLoginAction;
import com.ibm.ws.bluemix.utility.api.BluemixClient;
import com.ibm.ws.bluemix.utility.cloudfoundry.CloudFoundryException;
import com.ibm.ws.bluemix.utility.cloudfoundry.CloudFoundryLoginException;
import com.ibm.ws.bluemix.utility.credentials.BluemixProperties;
import com.ibm.ws.bluemix.utility.credentials.ConfigJson;
import com.ibm.ws.bluemix.utility.credentials.TargetInfo;
import com.ibm.ws.bluemix.utility.utils.Arguments;
import com.ibm.ws.bluemix.utility.utils.NLS;
import com.ibm.ws.bluemix.utility.utils.Option;
import com.ibm.ws.bluemix.utility.utils.ReturnCode;
import java.io.IOException;
import java.net.URL;

public class LoginAction
extends BaseLoginAction {
    private static final Option USER_OPT = new Option("user", true);
    private static final Option PASSWORD_OPT = new Option("password", true);
    private static final Option ORG_OPT = new Option("org", true);
    private static final Option SPACE_OPT = new Option("space", true);
    private static final Option API_OPT = new Option("api", true);
    private static final Option SSO_OPT = new Option("sso", false);

    public LoginAction() {
        this.registerOption(API_OPT);
        this.registerOption(USER_OPT);
        this.registerOption(PASSWORD_OPT);
        this.registerOption(ORG_OPT);
        this.registerOption(SPACE_OPT);
        this.registerOption(SSO_OPT);
    }

    @Override
    public String getActionName() {
        return "login";
    }

    @Override
    public ReturnCode handleAction(Arguments arguments) throws Exception {
        this.stdout.println(NLS.getOption("global.discontinue.warning", "20.0.0.8"));
        boolean apiPrompt = false;
        String api = arguments.getOption(API_OPT);
        if (api == null && (api = this.getSavedAPI()) == null) {
            apiPrompt = true;
            api = this.getResponse(NLS.getOption("login.api", new Object[0]));
        }
        URL apiURL = BluemixClient.getApiEndpoint(api);
        if (!apiPrompt) {
            this.stdout.println(NLS.getOption("login.api.selected", apiURL));
        }
        TargetInfo targetInfo = BluemixClient.newTarget(apiURL);
        BluemixProperties.save(targetInfo);
        BluemixClient client = null;
        client = arguments.hasOption(SSO_OPT) ? this.loginPasscode(arguments, targetInfo) : this.loginPassword(arguments, targetInfo);
        BluemixProperties.save(targetInfo);
        this.stdout.println(NLS.getOption("login.success", new Object[0]));
        String orgName = arguments.getOption(ORG_OPT);
        ReturnCode rc = this.setOrganization(client, orgName);
        if (rc == ReturnCode.OK) {
            String spaceName = arguments.getOption(SPACE_OPT);
            rc = this.setSpace(client, spaceName);
        }
        return rc;
    }

    private BluemixClient loginPassword(Arguments arguments, TargetInfo targetInfo) throws CloudFoundryException {
        boolean userPasswordSet = arguments.getOption(USER_OPT) != null || arguments.getOption(PASSWORD_OPT) != null;
        int retry = 0;
        BluemixClient client = null;
        while (client == null) {
            String user = arguments.getOption(USER_OPT);
            if (user == null) {
                user = this.stdin.readText(NLS.getOption("login.user", new Object[0]));
            } else {
                this.stdout.println(NLS.getOption("login.user.selected", user));
            }
            String password = arguments.getOption(PASSWORD_OPT);
            if (password == null) {
                password = this.stdin.readMaskedText(NLS.getOption("login.password", new Object[0]));
            }
            try {
                client = BluemixClient.login(targetInfo, user, password);
            }
            catch (CloudFoundryLoginException e) {
                if (++retry < 3 && !userPasswordSet) {
                    this.stderr.println(NLS.getOption("error", e.getMessage()));
                    continue;
                }
                throw e;
            }
        }
        return client;
    }

    private BluemixClient loginPasscode(Arguments arguments, TargetInfo targetInfo) throws CloudFoundryException {
        int retry = 0;
        BluemixClient client = null;
        String passcodeURL = targetInfo.getAuthorizationEndpoint() + "/passcode";
        while (client == null) {
            String passcode = this.stdin.readMaskedText(NLS.getOption("login.passcode", passcodeURL));
            try {
                client = BluemixClient.login(targetInfo, passcode);
            }
            catch (CloudFoundryLoginException e) {
                if (++retry < 3) {
                    this.stderr.println(NLS.getOption("error", e.getMessage()));
                    continue;
                }
                throw e;
            }
        }
        return client;
    }

    private String getSavedAPI() {
        TargetInfo targetInfo = null;
        try {
            targetInfo = BluemixProperties.load();
            if (targetInfo != null && targetInfo.getAPI() != null) {
                return targetInfo.getAPI();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            targetInfo = ConfigJson.load();
            if (targetInfo != null && targetInfo.getAPI() != null) {
                return targetInfo.getAPI();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

