/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.bluemix.utility.actions;

import com.ibm.ws.bluemix.utility.TaskErrorException;
import com.ibm.ws.bluemix.utility.actions.BaseAction;
import com.ibm.ws.bluemix.utility.api.BluemixClient;
import com.ibm.ws.bluemix.utility.api.ConfigurationServiceClient;
import com.ibm.ws.bluemix.utility.cloudfoundry.CloudFoundryService;
import com.ibm.ws.bluemix.utility.cloudfoundry.CloudFoundryServicePlan;
import com.ibm.ws.bluemix.utility.utils.Arguments;
import com.ibm.ws.bluemix.utility.utils.NLS;
import com.ibm.ws.bluemix.utility.utils.Option;
import com.ibm.ws.bluemix.utility.utils.ReturnCode;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class MarketplaceAction
extends BaseAction {
    private static final Option ALL_OPT = new Option("all", false, false, true);
    private static final Option CAAS_URL_OPT = new Option("caasUrl", true, false, true);

    public MarketplaceAction() {
        this.registerOption(ALL_OPT);
        this.registerOption(CAAS_URL_OPT);
        this.registerArguments("[serviceType...]");
    }

    @Override
    public String getActionName() {
        return "marketplace";
    }

    @Override
    public ReturnCode handleAction(Arguments arguments) throws Exception {
        boolean showPlanDetails;
        BluemixClient client = BluemixClient.getBluemixClient();
        Set<String> supportedServices = null;
        if (!arguments.getPositionalArguments().isEmpty()) {
            supportedServices = new HashSet<String>(arguments.getPositionalArguments());
            showPlanDetails = true;
        } else if (arguments.hasOption(ALL_OPT)) {
            supportedServices = null;
            showPlanDetails = false;
        } else {
            String caasURL = arguments.getOption(CAAS_URL_OPT);
            ConfigurationServiceClient caasClient = null;
            caasClient = ConfigurationServiceClient.getConfigurationServiceClient(caasURL, client.getTargetInfo());
            supportedServices = caasClient.getSupportedServices();
            showPlanDetails = false;
        }
        List<CloudFoundryService> services = client.getServiceOffering(supportedServices);
        this.printMarketplaceServices(services, showPlanDetails);
        return ReturnCode.OK;
    }

    private void printMarketplaceServices(List<CloudFoundryService> services, boolean showPlanDetails) {
        for (CloudFoundryService service : services) {
            this.stdout.println(NLS.getOption("marketplace.service.label", service.getLabel()));
            this.stdout.println(NLS.getOption("marketplace.service.description", service.getDescription()));
            String documentationUrl = service.getDocumentationUrl();
            if (documentationUrl != null) {
                this.stdout.println(NLS.getOption("marketplate.service.documentation.url", documentationUrl));
            }
            if (!showPlanDetails) {
                this.stdout.println(NLS.getOption("marketplace.plans", this.toString(service.getServicePlans())));
            } else {
                this.stdout.println(NLS.getOption("marketplace.plan.details", new Object[0]));
                List<CloudFoundryServicePlan> plans = service.getServicePlans();
                for (CloudFoundryServicePlan plan : plans) {
                    this.stdout.println(NLS.getOption("marketplace.plan.name", plan.getName()));
                    this.stdout.println(NLS.getOption("marketplace.plan.description", plan.getDescription()));
                }
            }
            this.stdout.println();
        }
    }

    private StringBuilder toString(List<CloudFoundryServicePlan> plans) {
        StringBuilder builder = new StringBuilder();
        for (CloudFoundryServicePlan csp : plans) {
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(csp.getName());
        }
        return builder;
    }

    @Override
    protected void validateArguments(Arguments arguments) throws TaskErrorException {
        if (arguments.hasOption(ALL_OPT) && !arguments.getPositionalArguments().isEmpty()) {
            throw new IllegalArgumentException(NLS.getOption("marketplace.argumentConflict", new Object[0]));
        }
    }
}

