/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.bluemix.utility.utils;

import com.ibm.ws.bluemix.utility.utils.HttpStatus;
import com.ibm.ws.bluemix.utility.utils.IOUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;

public class HttpRequest {
    private final HttpURLConnection response;

    public HttpRequest(HttpURLConnection connection) {
        this.response = connection;
    }

    public int getResponseCode() throws IOException {
        return this.response.getResponseCode();
    }

    public String getResponseMessage() throws IOException {
        return this.response.getResponseMessage();
    }

    public String getErrorResponseBody() throws IOException {
        InputStream in = this.response.getErrorStream();
        return in == null ? null : this.getResponse(in);
    }

    public boolean isJsonContentType() {
        String contentType = this.response.getContentType();
        if (contentType != null) {
            String[] values = contentType.split(";");
            String type = values[0].trim();
            return "application/json".equals(type);
        }
        return false;
    }

    public String getResponseBody() throws IOException {
        return this.getResponse(this.response.getInputStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getResponse(InputStream in) throws IOException {
        StringBuilder jsonResponse = new StringBuilder();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
            char[] chars = new char[2048];
            int charsRead = -1;
            while ((charsRead = reader.read(chars)) != -1) {
                jsonResponse.append(chars, 0, charsRead);
            }
        }
        catch (Throwable throwable) {
            IOUtils.close(reader);
            throw throwable;
        }
        IOUtils.close(reader);
        this.response.disconnect();
        String json = jsonResponse.toString();
        return json;
    }

    public HttpStatus getHttpStatus() throws IOException {
        return new HttpStatus(this.response.getResponseCode(), this.response.getResponseMessage());
    }
}

