/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jca.utils.metagen;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.container.service.annotations.ModuleAnnotations;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.jca.utils.xml.ra.RaActivationSpec;
import com.ibm.ws.jca.utils.xml.ra.RaAdminObject;
import com.ibm.ws.jca.utils.xml.ra.RaAuthenticationMechanism;
import com.ibm.ws.jca.utils.xml.ra.RaConfigProperty;
import com.ibm.ws.jca.utils.xml.ra.RaConnectionDefinition;
import com.ibm.ws.jca.utils.xml.ra.RaConnector;
import com.ibm.ws.jca.utils.xml.ra.RaDescription;
import com.ibm.ws.jca.utils.xml.ra.RaDisplayName;
import com.ibm.ws.jca.utils.xml.ra.RaInboundResourceAdapter;
import com.ibm.ws.jca.utils.xml.ra.RaMessageAdapter;
import com.ibm.ws.jca.utils.xml.ra.RaMessageListener;
import com.ibm.ws.jca.utils.xml.ra.RaOutboundResourceAdapter;
import com.ibm.ws.jca.utils.xml.ra.RaResourceAdapter;
import com.ibm.ws.jca.utils.xml.ra.RaSecurityPermission;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.anno.targets.AnnotationTargets_Targets;
import java.io.Externalizable;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.resource.spi.Activation;
import javax.resource.spi.AdministeredObject;
import javax.resource.spi.AuthenticationMechanism;
import javax.resource.spi.ConfigProperty;
import javax.resource.spi.ConnectionDefinition;
import javax.resource.spi.ConnectionDefinitions;
import javax.resource.spi.Connector;
import javax.resource.spi.ResourceAdapterAssociation;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.SecurityPermission;
import javax.resource.spi.TransactionSupport;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class RAAnnotationProcessor {
    private static final TraceComponent tc = Tr.register(RAAnnotationProcessor.class, (String)"rarInstall", (String)"com.ibm.ws.jca.utils.internal.resources.JcaUtilsMessages");
    private final RaConnector deploymentDescriptor;
    private final String adapterName;
    private final ClassLoader raClassLoader;
    private final ModuleAnnotations raAnnotations;
    private final List<String> raClassNames;
    private final LinkedList<Class<?>> connectorClasses = new LinkedList();
    private final LinkedList<Class<?>> activationClasses = new LinkedList();
    private final LinkedList<Class<?>> connDefClasses = new LinkedList();
    private final LinkedList<Class<?>> connDefsClasses = new LinkedList();
    private final LinkedList<Class<?>> adminObjectClasses = new LinkedList();
    static final long serialVersionUID = 5837521024625331707L;

    public RAAnnotationProcessor(String adapterName, RaConnector dd, ClassLoader raClassLoader, ModuleAnnotations raAnnotations, List<String> raClassNames) throws ResourceAdapterInternalException {
        this.deploymentDescriptor = dd;
        this.adapterName = adapterName;
        this.raClassLoader = raClassLoader;
        this.raAnnotations = raAnnotations;
        this.raClassNames = raClassNames;
    }

    private void findAnnotatedClasses() throws ResourceAdapterInternalException {
        if (this.raAnnotations == null) {
            this.findAnnotatedClassesUsingReflection();
        } else {
            this.findAnnotatedClassesUsingTargets();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void findAnnotatedClassesUsingReflection() throws ResourceAdapterInternalException {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        Class<?> raClass = null;
        try {
            for (String className : this.raClassNames) {
                raClass = this.raClassLoader.loadClass(className);
                if (raClass.getAnnotation(Connector.class) != null) {
                    this.connectorClasses.add(raClass);
                    if (!trace || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("class " + className + " has @Connector"), (Object[])new Object[0]);
                    continue;
                }
                if (raClass.getAnnotation(Activation.class) != null) {
                    this.activationClasses.add(raClass);
                    if (!trace || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("class " + className + " has @Activation"), (Object[])new Object[0]);
                    continue;
                }
                if (raClass.getAnnotation(ConnectionDefinition.class) != null) {
                    this.connDefClasses.add(raClass);
                    if (!trace || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("class " + className + " has @ConnectionDefinition"), (Object[])new Object[0]);
                    continue;
                }
                if (raClass.getAnnotation(ConnectionDefinitions.class) != null) {
                    this.connDefsClasses.add(raClass);
                    if (!trace || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("class " + className + " has @ConnectionDefinitions"), (Object[])new Object[0]);
                    continue;
                }
                if (raClass.getAnnotation(AdministeredObject.class) == null) continue;
                this.adminObjectClasses.add(raClass);
                if (!trace || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("class " + className + " has @AdministeredObject"), (Object[])new Object[0]);
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            void e;
            FFDCFilter.processException((Throwable)noClassDefFoundError, (String)"com.ibm.ws.jca.utils.metagen.RAAnnotationProcessor", (String)"134", (Object)this, (Object[])new Object[0]);
            throw e;
        }
        catch (ClassNotFoundException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jca.utils.metagen.RAAnnotationProcessor", (String)"136", (Object)this, (Object[])new Object[0]);
            throw new ResourceAdapterInternalException((Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void findAnnotatedClassesUsingTargets() throws ResourceAdapterInternalException {
        AnnotationTargets_Targets targets;
        try {
            targets = this.raAnnotations.getAnnotationTargets();
        }
        catch (UnableToAdaptException unableToAdaptException) {
            void e;
            FFDCFilter.processException((Throwable)unableToAdaptException, (String)"com.ibm.ws.jca.utils.metagen.RAAnnotationProcessor", (String)"146", (Object)this, (Object[])new Object[0]);
            throw new ResourceAdapterInternalException((Throwable)e);
        }
        this.findAnnotatedClassesUsingTargets(targets, Connector.class, this.connectorClasses);
        this.findAnnotatedClassesUsingTargets(targets, Activation.class, this.activationClasses);
        this.findAnnotatedClassesUsingTargets(targets, ConnectionDefinition.class, this.connDefClasses);
        this.findAnnotatedClassesUsingTargets(targets, ConnectionDefinitions.class, this.connDefsClasses);
        this.findAnnotatedClassesUsingTargets(targets, AdministeredObject.class, this.adminObjectClasses);
    }

    /*
     * WARNING - void declaration
     */
    private void findAnnotatedClassesUsingTargets(AnnotationTargets_Targets targets, Class<? extends Annotation> annoClass, List<Class<?>> classes) throws ResourceAdapterInternalException {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        Set classNames = targets.getAnnotatedClasses(annoClass.getName());
        for (String className : classNames) {
            try {
                if (trace && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("class " + className + " has @" + annoClass.getSimpleName()), (Object[])new Object[0]);
                }
                classes.add(this.raClassLoader.loadClass(className));
            }
            catch (ClassNotFoundException classNotFoundException) {
                void e;
                FFDCFilter.processException((Throwable)classNotFoundException, (String)"com.ibm.ws.jca.utils.metagen.RAAnnotationProcessor", (String)"169", (Object)this, (Object[])new Object[]{targets, annoClass, classes});
                throw new ResourceAdapterInternalException((Throwable)e);
            }
        }
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public RaConnector getProcessedConnector() throws ResourceAdapterInternalException {
        trace = TraceComponent.isAnyTracingEnabled();
        jcaVersion = this.getAdapterVersion(this.deploymentDescriptor);
        processAnno = this.checkProcessAnnotations(this.deploymentDescriptor, jcaVersion);
        if (!processAnno) {
            if (trace && RAAnnotationProcessor.tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)RAAnnotationProcessor.tc, (String)"Skip annotation processing and return the RaConnector that was passed in", (Object[])new Object[0]);
            }
            return this.deploymentDescriptor;
        }
        this.findAnnotatedClasses();
        resourceAdapterClass = null;
        if (this.deploymentDescriptor != null) {
            rxRA = this.deploymentDescriptor.getResourceAdapter();
            if (rxRA != null) {
                rxAdapterClassName = rxRA.getResourceAdapterClass();
                if (trace && RAAnnotationProcessor.tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)RAAnnotationProcessor.tc, (String)"rxAdapterClassName: ", (Object[])new Object[]{rxAdapterClassName});
                }
                if (rxAdapterClassName != null) {
                    for (Class connectorClass : this.connectorClasses) {
                        if (trace && RAAnnotationProcessor.tc.isDebugEnabled()) {
                            Tr.debug((Object)this, (TraceComponent)RAAnnotationProcessor.tc, (String)"connectorClass to examine: ", (Object[])new Object[]{connectorClass});
                        }
                        if (!rxAdapterClassName.equals(connectorClass.getName())) continue;
                        resourceAdapterClass = connectorClass;
                        if (!trace || !RAAnnotationProcessor.tc.isDebugEnabled()) break;
                        Tr.debug((Object)this, (TraceComponent)RAAnnotationProcessor.tc, (String)"connectorClasses - resourceAdapterClass: ", (Object[])new Object[]{resourceAdapterClass});
                        break;
                    }
                    if (resourceAdapterClass == null) {
                        try {
                            resourceAdapterClass = this.raClassLoader.loadClass(rxAdapterClassName);
                            if (!trace || !RAAnnotationProcessor.tc.isDebugEnabled()) ** GOTO lbl43
                            Tr.debug((Object)this, (TraceComponent)RAAnnotationProcessor.tc, (String)"raClassLoader - resourceAdapterClass: ", (Object[])new Object[]{resourceAdapterClass});
                        }
                        catch (ClassNotFoundException var7_8) {
                            FFDCFilter.processException((Throwable)var7_8, (String)"com.ibm.ws.jca.utils.metagen.RAAnnotationProcessor", (String)"246", (Object)this, (Object[])new Object[0]);
                            throw new ResourceAdapterInternalException(Tr.formatMessage((TraceComponent)RAAnnotationProcessor.tc, (String)"J2CA9904.required.raclass.missing", (Object[])new Object[]{rxAdapterClassName, this.adapterName}), (Throwable)e);
                        }
                    }
                } else if (trace && RAAnnotationProcessor.tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)RAAnnotationProcessor.tc, (String)"ra.xml does not contain a <resourceadapter-class> entry", (Object[])new Object[0]);
                }
            } else if (trace && RAAnnotationProcessor.tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)RAAnnotationProcessor.tc, (String)"ra.xml does not contain a <resourceadapter> entry", (Object[])new Object[0]);
            }
        } else if (trace && RAAnnotationProcessor.tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)RAAnnotationProcessor.tc, (String)"rar does not contain a ra.xml", (Object[])new Object[]{resourceAdapterClass});
        }
lbl43:
        // 8 sources

        if (resourceAdapterClass == null) {
            if (this.connectorClasses.size() == 0) {
                if (trace && RAAnnotationProcessor.tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)RAAnnotationProcessor.tc, (String)"rar does not contain a class annotated with @Connector", (Object[])new Object[0]);
                }
            } else {
                if (this.connectorClasses.size() > 1) {
                    throw new ResourceAdapterInternalException(Tr.formatMessage((TraceComponent)RAAnnotationProcessor.tc, (String)"J2CA9922.multiple.connector.anno.found", (Object[])new Object[]{this.adapterName}));
                }
                resourceAdapterClass = this.connectorClasses.get(0);
            }
        }
        connector = this.processConnector(resourceAdapterClass, this.deploymentDescriptor);
        return connector;
    }

    private RaConnector processConnector(Class<?> connectorClass, RaConnector rxConnector) throws ResourceAdapterInternalException {
        RaResourceAdapter rxRA;
        boolean trace = TraceComponent.isAnyTracingEnabled();
        RaConnector masterConnector = new RaConnector();
        RaResourceAdapter raResourceAdapter = rxRA = rxConnector == null ? null : rxConnector.getResourceAdapter();
        if (trace && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"rxRA", (Object[])new Object[]{rxRA});
            if (rxRA != null) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"rxRA.getResourceAdapterClass", (Object[])new Object[]{rxRA.getResourceAdapterClass()});
            }
        }
        RaResourceAdapter masterRA = null;
        RaOutboundResourceAdapter masterOutbound = null;
        RaInboundResourceAdapter masterInbound = new RaInboundResourceAdapter();
        RaMessageAdapter masterMessageAdapter = new RaMessageAdapter();
        RaConnector annoConnector = null;
        LinkedList<RaConfigProperty> annoRAConfigProperties = new LinkedList<RaConfigProperty>();
        LinkedList<RaConnectionDefinition> annoDefinitions = new LinkedList<RaConnectionDefinition>();
        LinkedList<RaMessageListener> annoMsgListeners = new LinkedList<RaMessageListener>();
        LinkedList<RaAdminObject> annoAdminObjects = new LinkedList<RaAdminObject>();
        if (trace && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Number of classes annotated with @Connector is " + this.connectorClasses.size()), (Object[])new Object[0]);
        }
        if (!this.connectorClasses.isEmpty()) {
            for (Class clazz : this.connectorClasses) {
                if (trace && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("annotated class is " + clazz.getName()), (Object[])new Object[0]);
                }
                if (connectorClass != null) {
                    if (!connectorClass.getName().equals(clazz.getName())) continue;
                    annoConnector = this.getAnnotatedConnector(clazz);
                    if (trace && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)("<resourceadapter-class> set to" + connectorClass.getName()), (Object[])new Object[0]);
                    }
                    annoRAConfigProperties.addAll(this.getAnnotatedConfigProperties(clazz, true));
                    break;
                }
                annoConnector = this.getAnnotatedConnector(clazz);
                annoRAConfigProperties.addAll(this.getAnnotatedConfigProperties(clazz, true));
            }
        }
        if (connectorClass != null && !this.connectorClasses.contains(connectorClass)) {
            annoRAConfigProperties.addAll(this.getAnnotatedConfigProperties(connectorClass, true));
        }
        for (Class clazz : this.connDefClasses) {
            annoDefinitions.add(this.getAnnotatedConnectionDefinition(clazz));
        }
        for (Class clazz : this.connDefsClasses) {
            annoDefinitions.addAll(this.getAnnotatedConnectionDefinitions(clazz));
        }
        for (Class clazz : this.activationClasses) {
            annoMsgListeners.addAll(this.getAnnotatedMessageListeners(clazz));
        }
        for (Class clazz : this.adminObjectClasses) {
            annoAdminObjects.addAll(this.getAnnotatedAdminObjects(clazz));
        }
        if (rxRA != null) {
            List<RaAdminObject> rxAdminObjects;
            List<RaMessageListener> rxMsgListeners;
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"processing ra.xml resource adapter", (Object[])new Object[0]);
            }
            if ((masterRA = (masterConnector = this.mergeConnectors(rxConnector, annoConnector)).getResourceAdapter()).getOutboundResourceAdapter() != null) {
                masterOutbound = masterRA.getOutboundResourceAdapter();
            } else {
                masterOutbound = new RaOutboundResourceAdapter();
                masterRA.setOutboundResourceAdapter(masterOutbound);
            }
            for (RaConfigProperty raConfigProperty : rxRA.getConfigProperties()) {
                if (!trace || !tc.isDebugEnabled()) continue;
                Tr.debug((Object)this, (TraceComponent)tc, (String)("RA config property from xml: " + raConfigProperty), (Object[])new Object[0]);
            }
            masterRA.getConfigProperties().addAll(this.mergeConfigProperties(rxRA.getConfigProperties(), annoRAConfigProperties));
            RaOutboundResourceAdapter rxOutbound = rxRA.getOutboundResourceAdapter();
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"processing outbound connection definitions", (Object[])new Object[]{rxOutbound});
            }
            if (rxOutbound != null) {
                List<RaConnectionDefinition> list = rxOutbound.getConnectionDefinitions();
                if (!list.isEmpty()) {
                    masterOutbound.getConnectionDefinitions().addAll(this.mergeConnectionDefinitions(list, annoDefinitions));
                } else {
                    masterOutbound.getConnectionDefinitions().addAll(annoDefinitions);
                }
            } else {
                if (trace && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("no ra.xml, masterOutbound: " + masterOutbound), (Object[])new Object[0]);
                }
                if (masterOutbound != null) {
                    masterOutbound.getConnectionDefinitions().addAll(annoDefinitions);
                }
            }
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"processing inbound message listeners", (Object[])new Object[0]);
            }
            RaInboundResourceAdapter raInboundResourceAdapter = rxRA.getInboundResourceAdapter();
            masterInbound.setMessageAdapter(masterMessageAdapter);
            masterRA.setInboundResourceAdapter(masterInbound);
            boolean messageListenersMerged = false;
            if (raInboundResourceAdapter != null && raInboundResourceAdapter.getMessageAdapter() != null && !(rxMsgListeners = raInboundResourceAdapter.getMessageAdapter().getMessageListeners()).isEmpty()) {
                masterMessageAdapter.getMessageListeners().addAll(this.mergeMessageListeners(rxMsgListeners, annoMsgListeners));
                messageListenersMerged = true;
            }
            if (!messageListenersMerged) {
                masterMessageAdapter.getMessageListeners().addAll(annoMsgListeners);
            }
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"processing resource adapter admin objects", (Object[])new Object[0]);
            }
            if (!(rxAdminObjects = rxRA.getAdminObjects()).isEmpty()) {
                masterRA.getAdminObjects().addAll(this.mergeAdminObjects(rxAdminObjects, annoAdminObjects));
            } else {
                masterRA.getAdminObjects().addAll(annoAdminObjects);
            }
        } else {
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"only annotations were found", (Object[])new Object[0]);
                Tr.debug((Object)this, (TraceComponent)tc, (String)("number of @Connector annotations: " + this.connectorClasses.size()), (Object[])new Object[0]);
            }
            masterRA = new RaResourceAdapter();
            masterConnector.setResourceAdapter(masterRA);
            masterOutbound = new RaOutboundResourceAdapter();
            masterInbound = new RaInboundResourceAdapter();
            masterMessageAdapter = new RaMessageAdapter();
            if (annoConnector != null) {
                masterRA.setResourceAdapterClass(annoConnector.getResourceAdapter().getResourceAdapterClass());
                if (annoConnector.getDescriptions() != null) {
                    masterConnector.setDescription(annoConnector.getDescription());
                }
                if (annoConnector.getDisplayName() != null) {
                    masterConnector.setDisplayName(annoConnector.getDisplayName());
                }
                if (annoConnector.getResourceAdapterVersion() != null) {
                    masterConnector.setResourceAdapterVersion(annoConnector.getResourceAdapterVersion());
                }
                if (annoConnector.getResourceAdapter().getSecurityPermissions() != null) {
                    masterConnector.getResourceAdapter().setSecurityPermissions(annoConnector.getResourceAdapter().getSecurityPermissions());
                }
                if (annoConnector.getRequiredWorkContext() != null) {
                    masterConnector.setRequiredWorkContext(annoConnector.getRequiredWorkContext());
                }
            }
            if (!annoRAConfigProperties.isEmpty()) {
                masterRA.getConfigProperties().addAll(annoRAConfigProperties);
            }
            boolean outboundWasFound = false;
            if (annoConnector != null && annoConnector.getResourceAdapter().getOutboundResourceAdapter() != null) {
                if (trace && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("transaction support from @Connector: " + annoConnector.getResourceAdapter().getOutboundResourceAdapter().getTransactionSupport()), (Object[])new Object[0]);
                }
                if (annoConnector.getResourceAdapter().getOutboundResourceAdapter().getTransactionSupport() != null) {
                    masterOutbound.setTransactionSupport(annoConnector.getResourceAdapter().getOutboundResourceAdapter().getTransactionSupport());
                    outboundWasFound = true;
                }
                if (trace && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("authentication mechanism from @Connector: " + annoConnector.getResourceAdapter().getOutboundResourceAdapter().getAuthenticationMechanisms()), (Object[])new Object[0]);
                }
                if (!annoConnector.getResourceAdapter().getOutboundResourceAdapter().getAuthenticationMechanisms().isEmpty()) {
                    masterOutbound.setAuthenticationMechanisms(annoConnector.getResourceAdapter().getOutboundResourceAdapter().getAuthenticationMechanisms());
                    outboundWasFound = true;
                }
                if (trace && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("reauthentication support from @Connector: " + annoConnector.getResourceAdapter().getOutboundResourceAdapter().getReauthenticationSupport()), (Object[])new Object[0]);
                }
                if (annoConnector.getResourceAdapter().getOutboundResourceAdapter().getReauthenticationSupport() != null) {
                    masterOutbound.setReauthenticationSupport(annoConnector.getResourceAdapter().getOutboundResourceAdapter().getReauthenticationSupport());
                    outboundWasFound = true;
                }
            }
            if (!annoDefinitions.isEmpty()) {
                masterOutbound.getConnectionDefinitions().addAll(annoDefinitions);
                outboundWasFound = true;
            }
            if (outboundWasFound) {
                masterRA.setOutboundResourceAdapter(masterOutbound);
            }
            if (!annoMsgListeners.isEmpty()) {
                masterMessageAdapter.getMessageListeners().addAll(annoMsgListeners);
                if (masterRA.getInboundResourceAdapter() == null) {
                    masterRA.setInboundResourceAdapter(masterInbound);
                }
                masterInbound.setMessageAdapter(masterMessageAdapter);
                masterRA.setInboundResourceAdapter(masterInbound);
            }
            if (!annoAdminObjects.isEmpty()) {
                masterRA.getAdminObjects().addAll(annoAdminObjects);
            }
        }
        return masterConnector;
    }

    private String getAdapterVersion(RaConnector rxConnector) throws ResourceAdapterInternalException {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        String jcaVersion = "1.7";
        if (rxConnector != null) {
            jcaVersion = rxConnector.getVersion().trim();
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("version from ra.xml is " + jcaVersion), (Object[])new Object[0]);
            }
        } else if (trace && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("no ra.xml, version defaults to " + jcaVersion), (Object[])new Object[0]);
        }
        if (!(jcaVersion.equals("2.0") || jcaVersion.equals("1.7") || jcaVersion.equals("1.6") || jcaVersion.equals("1.5") || jcaVersion.equals("1.0"))) {
            throw new ResourceAdapterInternalException(Tr.formatMessage((TraceComponent)tc, (String)"J2CA9934.not.a.valid.option", (Object[])new Object[]{jcaVersion, "<version>, <spec-version>", "2.0, 1.7, 1.6, 1.5, 1.0"}));
        }
        return jcaVersion;
    }

    private boolean checkProcessAnnotations(RaConnector rxConnector, String jcaVersion) {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        boolean processAnno = true;
        if (rxConnector != null) {
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"connector jee version", (Object[])new Object[]{jcaVersion});
            }
            boolean bl = processAnno = jcaVersion.equals("1.6") || jcaVersion.equals("1.7");
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"processAnno based on version", (Object[])new Object[]{processAnno});
            }
            boolean bl2 = processAnno ? !rxConnector.getMetadataComplete().booleanValue() : (processAnno = false);
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"metadata-complete", (Object[])new Object[]{rxConnector.getMetadataComplete()});
                Tr.debug((Object)this, (TraceComponent)tc, (String)"processAnno based on metadata-complete", (Object[])new Object[]{processAnno});
            }
        }
        return processAnno;
    }

    private RaConnector mergeConnectors(RaConnector rxConnector, RaConnector annoConnector) {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        RaResourceAdapter rxRa = rxConnector.getResourceAdapter();
        boolean useRxOra = false;
        RaOutboundResourceAdapter rxOra = null;
        if (rxRa.getOutboundResourceAdapter() != null) {
            useRxOra = true;
            rxOra = rxRa.getOutboundResourceAdapter();
        }
        boolean useAnno = false;
        RaResourceAdapter annoRa = null;
        boolean useAnnoOra = false;
        RaOutboundResourceAdapter annoOra = null;
        if (annoConnector != null) {
            useAnno = true;
            annoRa = annoConnector.getResourceAdapter();
            if (annoRa.getOutboundResourceAdapter() != null) {
                useAnnoOra = true;
                annoOra = annoConnector.getResourceAdapter().getOutboundResourceAdapter();
            }
        }
        RaConnector connector = new RaConnector();
        RaResourceAdapter ra = new RaResourceAdapter();
        connector.setResourceAdapter(ra);
        RaOutboundResourceAdapter ora = new RaOutboundResourceAdapter();
        if (rxRa.getResourceAdapterClass() != null) {
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"rar.xml resource adapter class", (Object[])new Object[]{rxRa.getResourceAdapterClass()});
            }
            connector.getResourceAdapter().setResourceAdapterClass(rxRa.getResourceAdapterClass());
        } else if (useAnno) {
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"annotated resource adapter class", (Object[])new Object[]{annoRa.getResourceAdapterClass()});
            }
            connector.getResourceAdapter().setResourceAdapterClass(annoRa.getResourceAdapterClass());
        }
        if (!rxConnector.getDescription().isEmpty()) {
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"rar.xml description", (Object[])new Object[]{rxConnector.getDescription()});
            }
            connector.setDescription(rxConnector.getDescription());
        } else if (useAnno && !annoConnector.getDescription().isEmpty()) {
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"@Connector description", (Object[])new Object[]{annoConnector.getDescription()});
            }
            connector.setDescription(annoConnector.getDescription());
        }
        if (!rxConnector.getDisplayName().isEmpty()) {
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"rar.xml display name", (Object[])new Object[]{rxConnector.getDisplayName()});
            }
            connector.setDisplayName(rxConnector.getDisplayName());
        } else if (useAnno && !annoConnector.getDisplayName().isEmpty()) {
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"@Connector display name", (Object[])new Object[]{annoConnector.getDisplayName()});
            }
            connector.setDisplayName(annoConnector.getDisplayName());
        }
        if (rxConnector.getResourceAdapterVersion() != null) {
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"rar.xml resource adapter version", (Object[])new Object[]{rxConnector.getResourceAdapterVersion()});
            }
            connector.setResourceAdapterVersion(rxConnector.getResourceAdapterVersion());
        } else if (useAnno && annoConnector.getResourceAdapterVersion() != null) {
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"@Connector resource adapter version", (Object[])new Object[]{annoConnector.getResourceAdapterVersion()});
            }
            connector.setResourceAdapterVersion(annoConnector.getResourceAdapterVersion());
        }
        if (!rxRa.getSecurityPermissions().isEmpty()) {
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"rar.xml resource adapter security permissions", (Object[])new Object[]{rxRa.getSecurityPermissions()});
            }
            connector.getResourceAdapter().setSecurityPermissions(rxRa.getSecurityPermissions());
        } else if (useAnno && !annoRa.getSecurityPermissions().isEmpty()) {
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"@Connector resource adapter security permissions", (Object[])new Object[]{annoRa.getSecurityPermissions()});
            }
            connector.getResourceAdapter().setSecurityPermissions(annoRa.getSecurityPermissions());
        }
        boolean setRaOra = false;
        if (useRxOra && rxOra.getTransactionSupport() != null) {
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"rar.xml transaction support", (Object[])new Object[]{rxOra.getTransactionSupport()});
            }
            setRaOra = true;
            ora.setTransactionSupport(rxOra.getTransactionSupport());
        } else if (useAnnoOra && annoOra.getTransactionSupport() != null) {
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"@Connector transaction support", (Object[])new Object[]{annoOra.getTransactionSupport()});
            }
            setRaOra = true;
            ora.setTransactionSupport(annoOra.getTransactionSupport());
        }
        if (useRxOra && !rxOra.getAuthenticationMechanisms().isEmpty()) {
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"rar.xml authentication mechanisms", (Object[])new Object[]{rxOra.getAuthenticationMechanisms()});
            }
            setRaOra = true;
            ora.setAuthenticationMechanisms(rxOra.getAuthenticationMechanisms());
        } else if (useAnnoOra && !annoOra.getAuthenticationMechanisms().isEmpty()) {
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"@Connector authentication mechanisms", (Object[])new Object[]{annoOra.getAuthenticationMechanisms()});
            }
            setRaOra = true;
            ora.setAuthenticationMechanisms(annoOra.getAuthenticationMechanisms());
        }
        if (useRxOra && rxOra.getReauthenticationSupport() != null) {
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"rar.xml reauthentication support", (Object[])new Object[]{rxOra.getReauthenticationSupport()});
            }
            setRaOra = true;
            ora.setReauthenticationSupport(rxOra.getReauthenticationSupport());
        } else if (useAnnoOra && annoOra.getReauthenticationSupport() != null) {
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"@Connector reauthentication support", (Object[])new Object[]{annoOra.getReauthenticationSupport()});
            }
            setRaOra = true;
            ora.setReauthenticationSupport(annoOra.getReauthenticationSupport());
        }
        if (setRaOra) {
            ra.setOutboundResourceAdapter(ora);
        }
        if (!rxConnector.getRequiredWorkContext().isEmpty()) {
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"rar.xml required work context", (Object[])new Object[]{rxConnector.getRequiredWorkContext()});
            }
            if (useAnno && !annoConnector.getRequiredWorkContext().isEmpty()) {
                if (trace && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"@Connector required work context", (Object[])new Object[]{rxConnector.getRequiredWorkContext()});
                }
                ArrayList<String> requiredWorkContexts = new ArrayList<String>(rxConnector.getRequiredWorkContext());
                for (String requiredWorkContext : annoConnector.getRequiredWorkContext()) {
                    if (rxConnector.getRequiredWorkContext().contains(requiredWorkContext)) continue;
                    requiredWorkContexts.add(requiredWorkContext);
                }
                connector.setRequiredWorkContext(requiredWorkContexts);
            } else {
                connector.setRequiredWorkContext(rxConnector.getRequiredWorkContext());
            }
        } else if (useAnno && !annoConnector.getRequiredWorkContext().isEmpty()) {
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"@Connector required work context", (Object[])new Object[]{annoConnector.getRequiredWorkContext()});
            }
            connector.setRequiredWorkContext(annoConnector.getRequiredWorkContext());
        }
        return connector;
    }

    private List<RaAdminObject> mergeAdminObjects(List<RaAdminObject> rxAdminObjects, List<RaAdminObject> annoAdminObjects) {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        LinkedList<RaAdminObject> adminObjects = new LinkedList<RaAdminObject>();
        for (RaAdminObject rxAdminObject : rxAdminObjects) {
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Processing rxAdminObject: " + rxAdminObject), (Object[])new Object[0]);
            }
            RaAdminObject annoAdminObject = null;
            for (RaAdminObject aAdminObject : annoAdminObjects) {
                if (trace && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("Processing aAdminObject: " + aAdminObject), (Object[])new Object[0]);
                }
                if (!rxAdminObject.getAdminObjectClass().equals(aAdminObject.getAdminObjectClass())) continue;
                if (trace && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("rx admin class matched anno admin class: " + rxAdminObject.getAdminObjectClass()), (Object[])new Object[0]);
                }
                if (aAdminObject.getAdminObjectInterface() != null && !aAdminObject.getAdminObjectInterface().isEmpty()) {
                    if (!rxAdminObject.getAdminObjectInterface().equals(aAdminObject.getAdminObjectInterface())) continue;
                    if (trace && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)("rx admin interface matched anno admin interface, combine props: " + rxAdminObject.getAdminObjectInterface()), (Object[])new Object[0]);
                    }
                    annoAdminObject = aAdminObject;
                    break;
                }
                if (trace && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("anno admin class does not have annotated interfaces, class interfaces are: " + aAdminObject.getImplementedAdminObjectInterfaces()), (Object[])new Object[0]);
                }
                if (!aAdminObject.getImplementedAdminObjectInterfaces().isEmpty() && aAdminObject.getImplementedAdminObjectInterfaces().size() <= 1 && !rxAdminObject.getAdminObjectInterface().equals(aAdminObject.getImplementedAdminObjectInterfaces().get(0).getName())) continue;
                annoAdminObject = aAdminObject;
                break;
            }
            if (annoAdminObject != null) {
                annoAdminObjects.remove(annoAdminObject);
                if (trace && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("merging: " + rxAdminObject + ", " + annoAdminObject), (Object[])new Object[0]);
                }
                RaAdminObject adminObject = new RaAdminObject();
                adminObject.setAdminObjectClass(rxAdminObject.getAdminObjectClass());
                adminObject.setAdminObjectInterface(rxAdminObject.getAdminObjectInterface());
                adminObject.getConfigProperties().addAll(this.mergeConfigProperties(rxAdminObject.getConfigProperties(), annoAdminObject.getConfigProperties()));
                adminObjects.add(adminObject);
                continue;
            }
            try {
                List<RaConfigProperty> properties = this.mergeConfigProperties(rxAdminObject.getConfigProperties(), this.getAnnotatedConfigProperties(this.raClassLoader.loadClass(rxAdminObject.getAdminObjectClass()), false));
                rxAdminObject.getConfigProperties().clear();
                rxAdminObject.getConfigProperties().addAll(properties);
            }
            catch (Exception properties) {
                FFDCFilter.processException((Throwable)properties, (String)"com.ibm.ws.jca.utils.metagen.RAAnnotationProcessor", (String)"897", (Object)this, (Object[])new Object[]{rxAdminObjects, annoAdminObjects});
                Tr.warning((TraceComponent)tc, (String)"J2CA9919.class.not.found", (Object[])new Object[]{rxAdminObject.getAdminObjectClass(), this.adapterName});
            }
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("add rxAdminObject: " + rxAdminObject), (Object[])new Object[0]);
            }
            adminObjects.add(rxAdminObject);
        }
        if (!annoAdminObjects.isEmpty()) {
            adminObjects.addAll(annoAdminObjects);
        }
        return adminObjects;
    }

    private List<RaMessageListener> mergeMessageListeners(List<RaMessageListener> rxListeners, LinkedList<RaMessageListener> annoListeners) {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        LinkedList<RaMessageListener> listeners = new LinkedList<RaMessageListener>();
        LinkedList copyAnnoListeners = (LinkedList)annoListeners.clone();
        for (RaMessageListener rxListener : rxListeners) {
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("rxlistener type is: " + rxListener.getMessageListenerType()), (Object[])new Object[0]);
            }
            RaMessageListener mergedListener = null;
            RaActivationSpec activationSpec = null;
            for (RaMessageListener aListener : annoListeners) {
                if (trace && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("anno listener type is: " + aListener.getMessageListenerType()), (Object[])new Object[0]);
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("anno listener class is: " + aListener.getActivationSpec().getActivationSpecClass()), (Object[])new Object[0]);
                }
                if (!rxListener.getMessageListenerType().equals(aListener.getMessageListenerType())) continue;
                if (trace && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("ra.xml listener class: " + rxListener.getActivationSpec().getActivationSpecClass()), (Object[])new Object[0]);
                }
                copyAnnoListeners.remove(aListener);
                if (trace && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("ra.xml already contains a message listener with type '" + rxListener.getMessageListenerType() + "'.  Combining the properties from class with @Activation annotation '" + aListener.getActivationSpec().getActivationSpecClass() + "'"), (Object[])new Object[0]);
                }
                RaActivationSpec rxActivationSpec = rxListener.getActivationSpec();
                RaActivationSpec annoActivationSpec = aListener.getActivationSpec();
                if (rxActivationSpec == null) {
                    throw new IllegalArgumentException(Tr.formatMessage((TraceComponent)tc, (String)"J2CA9924.listener.actspec.missing", (Object[])new Object[]{rxListener.getMessageListenerType(), aListener.getActivationSpec().getActivationSpecClass()}));
                }
                if (mergedListener == null) {
                    mergedListener = new RaMessageListener();
                    mergedListener.setMessageListenerType(rxListener.getMessageListenerType());
                    activationSpec = new RaActivationSpec();
                    activationSpec.setActivationSpecClass(rxActivationSpec.getActivationSpecClass());
                }
                activationSpec.getConfigProperties().addAll(this.mergeConfigProperties(rxActivationSpec.getConfigProperties(), annoActivationSpec.getConfigProperties()));
            }
            if (mergedListener != null) {
                mergedListener.setActivationSpec(activationSpec);
                listeners.add(mergedListener);
                continue;
            }
            RaActivationSpec rxActivationSpec = rxListener.getActivationSpec();
            try {
                List<RaConfigProperty> properties = this.mergeConfigProperties(rxActivationSpec.getConfigProperties(), this.getAnnotatedConfigProperties(this.raClassLoader.loadClass(rxActivationSpec.getActivationSpecClass()), false));
                rxActivationSpec.getConfigProperties().clear();
                rxActivationSpec.getConfigProperties().addAll(properties);
            }
            catch (Exception properties) {
                FFDCFilter.processException((Throwable)properties, (String)"com.ibm.ws.jca.utils.metagen.RAAnnotationProcessor", (String)"995", (Object)this, (Object[])new Object[]{rxListeners, annoListeners});
                Tr.warning((TraceComponent)tc, (String)"J2CA9919.class.not.found", (Object[])new Object[]{rxActivationSpec.getActivationSpecClass(), this.adapterName});
            }
            listeners.add(rxListener);
        }
        if (!copyAnnoListeners.isEmpty()) {
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"remaining anno listeners after merge", (Object[])new Object[]{copyAnnoListeners});
            }
            for (RaMessageListener msgListener : copyAnnoListeners) {
                listeners.add(msgListener);
            }
        }
        return listeners;
    }

    private List<RaConnectionDefinition> mergeConnectionDefinitions(List<RaConnectionDefinition> rxDefinitions, List<RaConnectionDefinition> annoDefinitions) {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        LinkedList<RaConnectionDefinition> definitions = new LinkedList<RaConnectionDefinition>();
        for (RaConnectionDefinition rxDef : rxDefinitions) {
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Merging ra.xml connection definition with connection factory interface " + rxDef.getConnectionFactoryInterface()), (Object[])new Object[0]);
            }
            RaConnectionDefinition annoDef = null;
            for (RaConnectionDefinition def : annoDefinitions) {
                if (trace && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("Compare with connection definition annotation " + def.getConnectionFactoryInterface()), (Object[])new Object[0]);
                }
                if (!rxDef.getConnectionFactoryInterface().equals(def.getConnectionFactoryInterface())) continue;
                annoDef = def;
                break;
            }
            if (annoDef != null) {
                annoDefinitions.remove(annoDef);
                if (trace && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("ra.xml already contains a connection definition with the connection factory interface of '" + rxDef.getConnectionFactoryInterface() + "' thus ignoring the @ConnectionDefinition annotation on class '" + annoDef.getManagedConnectionFactoryClass()), (Object[])new Object[0]);
                }
                RaConnectionDefinition definition = new RaConnectionDefinition();
                definition.setConnectionFactoryImplClass(rxDef.getConnectionFactoryImplClass());
                definition.setConnectionFactoryInterface(rxDef.getConnectionFactoryInterface());
                definition.setConnectionImplClass(rxDef.getConnectionImplClass());
                definition.setConnectionInterface(rxDef.getConnectionInterface());
                definition.setManagedConnectionFactoryClass(rxDef.getManagedConnectionFactoryClass());
                definition.getConfigProperties().addAll(this.mergeConfigProperties(rxDef.getConfigProperties(), annoDef.getConfigProperties()));
                definitions.add(definition);
                continue;
            }
            try {
                List<RaConfigProperty> properties = this.mergeConfigProperties(rxDef.getConfigProperties(), this.getAnnotatedConfigProperties(this.raClassLoader.loadClass(rxDef.getManagedConnectionFactoryClass()), false));
                rxDef.getConfigProperties().clear();
                rxDef.getConfigProperties().addAll(properties);
            }
            catch (Exception properties) {
                FFDCFilter.processException((Throwable)properties, (String)"com.ibm.ws.jca.utils.metagen.RAAnnotationProcessor", (String)"1070", (Object)this, (Object[])new Object[]{rxDefinitions, annoDefinitions});
                Tr.warning((TraceComponent)tc, (String)"J2CA9919.class.not.found", (Object[])new Object[]{rxDef.getManagedConnectionFactoryClass(), this.adapterName});
            }
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Add ra.xml connection definition to list of connection definitions", (Object[])new Object[0]);
            }
            definitions.add(rxDef);
        }
        if (!annoDefinitions.isEmpty()) {
            for (RaConnectionDefinition r : annoDefinitions) {
                if (!trace || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)"Add annotated connection definition to list of connection definitions", (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)"anno ", (Object[])new Object[]{r.getConnectionFactoryInterface(), r.getConnectionFactoryImplClass(), r.getConnectionInterface(), r.getConnectionImplClass()});
            }
            definitions.addAll(annoDefinitions);
        }
        return definitions;
    }

    private List<RaConfigProperty> mergeConfigProperties(List<RaConfigProperty> rxConfigProperties, List<RaConfigProperty> annotatedConfigProperties) {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        LinkedList<RaConfigProperty> configProperties = new LinkedList<RaConfigProperty>();
        List annoConfigProperties = null;
        annoConfigProperties = annotatedConfigProperties != null ? (List)((LinkedList)annotatedConfigProperties).clone() : new LinkedList();
        if (trace && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("rxConfigProperties size: " + rxConfigProperties.size()), (Object[])new Object[0]);
        }
        for (RaConfigProperty rxConfigProp : rxConfigProperties) {
            RaConfigProperty annoConfigProp = null;
            if (annoConfigProperties.isEmpty()) {
                return (List)((LinkedList)rxConfigProperties).clone();
            }
            for (RaConfigProperty configProp : annoConfigProperties) {
                if (!this.isEqual(rxConfigProp.getName(), configProp.getName())) continue;
                annoConfigProp = configProp;
                break;
            }
            if (annoConfigProp != null) {
                if (trace && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("merging " + rxConfigProp + ", " + annoConfigProp), (Object[])new Object[0]);
                }
                annoConfigProperties.remove(annoConfigProp);
                if (rxConfigProp.getConfidential() == null) {
                    rxConfigProp.setConfidential(annoConfigProp.getConfidential());
                }
                if (rxConfigProp.getDescription() == null || rxConfigProp.getDescription().isEmpty()) {
                    rxConfigProp.setDescription(annoConfigProp.getDescription());
                }
                if (rxConfigProp.getIgnore() == null) {
                    rxConfigProp.setIgnore(annoConfigProp.getIgnore());
                }
                if (rxConfigProp.getSupportsDynamicUpdates() == null) {
                    rxConfigProp.setSupportsDynamicUpdates(annoConfigProp.getSupportsDynamicUpdates());
                }
                if (rxConfigProp.getType() == null || rxConfigProp.getType().equals("")) {
                    rxConfigProp.setType(annoConfigProp.getType());
                }
                if (rxConfigProp.getDefault() == null || rxConfigProp.getDefault().equals("")) {
                    rxConfigProp.setDefault(annoConfigProp.getDefault());
                }
                configProperties.add(rxConfigProp);
                continue;
            }
            configProperties.add(rxConfigProp);
        }
        if (!annoConfigProperties.isEmpty()) {
            for (RaConfigProperty configProp : annoConfigProperties) {
                configProperties.add(configProp);
            }
        }
        return configProperties;
    }

    private RaConnector getAnnotatedConnector(Class<?> clazz) throws ResourceAdapterInternalException {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"class to look at for ResourceAdapter interface", (Object[])new Object[]{clazz});
            Tr.debug((Object)this, (TraceComponent)tc, (String)("class name is: " + clazz.getName()), (Object[])new Object[0]);
        }
        RaConnector connector = new RaConnector();
        RaResourceAdapter ra = new RaResourceAdapter();
        ra.setResourceAdapterClass(clazz.getName());
        connector.setResourceAdapter(ra);
        RaOutboundResourceAdapter ora = new RaOutboundResourceAdapter();
        ra.setOutboundResourceAdapter(ora);
        RaInboundResourceAdapter ira = new RaInboundResourceAdapter();
        ra.setInboundResourceAdapter(ira);
        if (trace && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"annotated resource adapter class", (Object[])new Object[]{connector.getResourceAdapter().getResourceAdapterClass()});
        }
        Connector anno = clazz.getAnnotation(Connector.class);
        LinkedList<RaDescription> description = new LinkedList<RaDescription>();
        for (String d : anno.description()) {
            RaDescription raDesc = new RaDescription();
            raDesc.setValue(d);
            description.add(raDesc);
        }
        LinkedList<RaDisplayName> displayName = new LinkedList<RaDisplayName>();
        for (String d : anno.displayName()) {
            RaDisplayName raDisplayName = new RaDisplayName();
            raDisplayName.setValue(d);
            displayName.add(raDisplayName);
        }
        String version = anno.version();
        TransactionSupport.TransactionSupportLevel transactionSupport = null;
        if (anno.transactionSupport() != null) {
            transactionSupport = anno.transactionSupport();
        }
        AuthenticationMechanism[] authMechanisms = anno.authMechanisms();
        boolean reauthenticationSupport = anno.reauthenticationSupport();
        SecurityPermission[] securityPermissions = anno.securityPermissions();
        Class[] requiredWorkContexts = anno.requiredWorkContexts();
        if (!description.isEmpty()) {
            connector.setDescription(description);
        }
        if (!displayName.isEmpty()) {
            connector.setDisplayName(displayName);
        }
        if (!version.isEmpty()) {
            connector.setResourceAdapterVersion(version);
        }
        if (transactionSupport != TransactionSupport.TransactionSupportLevel.NoTransaction) {
            ora.setTransactionSupport(transactionSupport.name());
        }
        if (authMechanisms.length > 0) {
            LinkedList<RaAuthenticationMechanism> raAuthenticationMechanism = new LinkedList<RaAuthenticationMechanism>();
            for (AuthenticationMechanism authenticationMechanism : authMechanisms) {
                RaAuthenticationMechanism authenticationMechanism2 = new RaAuthenticationMechanism();
                authenticationMechanism2.setAuthenticationMechanismType(authenticationMechanism.authMechanism());
                raAuthenticationMechanism.add(authenticationMechanism2);
            }
            connector.getResourceAdapter().getOutboundResourceAdapter().setAuthenticationMechanisms(raAuthenticationMechanism);
        }
        if (reauthenticationSupport) {
            connector.getResourceAdapter().getOutboundResourceAdapter().setReauthenticationSupport("true");
        }
        if (securityPermissions.length > 0) {
            LinkedList<RaSecurityPermission> raSecurityPermissions = new LinkedList<RaSecurityPermission>();
            for (SecurityPermission securityPermission : securityPermissions) {
                RaSecurityPermission securityPermission2 = new RaSecurityPermission();
                LinkedList<RaDescription> spDescription = new LinkedList<RaDescription>();
                for (String d : securityPermission.description()) {
                    RaDescription raDesc = new RaDescription();
                    raDesc.setValue(d);
                    spDescription.add(raDesc);
                }
                securityPermission2.setDescription(spDescription);
                securityPermission2.setSecurityPermissionSpec(securityPermission.permissionSpec());
                raSecurityPermissions.add(securityPermission2);
            }
            connector.getResourceAdapter().setSecurityPermissions(raSecurityPermissions);
        }
        if (requiredWorkContexts.length > 0) {
            LinkedList<String> requiredWorkContext = new LinkedList<String>();
            for (Class clazz2 : requiredWorkContexts) {
                requiredWorkContext.add(clazz2.getName());
            }
            connector.setRequiredWorkContext(requiredWorkContext);
        }
        if (trace && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Processed @Connector " + clazz.getName()), (Object[])new Object[0]);
        }
        return connector;
    }

    private List<RaAdminObject> getAnnotatedAdminObjects(Class<?> clazz) throws ResourceAdapterInternalException {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        String className = clazz.getName();
        LinkedList<RaAdminObject> adminObjects = new LinkedList<RaAdminObject>();
        List<RaConfigProperty> configProperties = this.getAnnotatedConfigProperties(clazz, false);
        AdministeredObject anno = clazz.getAnnotation(AdministeredObject.class);
        Class[] aoInterfaces = anno.adminObjectInterfaces();
        if (aoInterfaces.length != 0) {
            for (Class aoInterface : aoInterfaces) {
                RaAdminObject adminObject = new RaAdminObject();
                adminObject.setAdminObjectClass(className);
                adminObject.setAdminObjectInterface(aoInterface.getName());
                adminObject.getConfigProperties().addAll(configProperties);
                adminObjects.add(adminObject);
                if (!trace || !tc.isDebugEnabled()) continue;
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Processed admin object with class " + className + " and interface " + aoInterface.getName()), (Object[])new Object[0]);
            }
        } else {
            LinkedList interfaces = new LinkedList();
            this.findAllInterfacesOnAdminClass(clazz, interfaces);
            RaAdminObject adminObject = new RaAdminObject();
            adminObject.setAdminObjectClass(className);
            adminObject.setAnnAdminObjectInterfaces(interfaces);
            adminObject.getConfigProperties().addAll(configProperties);
            adminObjects.add(adminObject);
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Processed admin object with class " + className + " and interfaces " + interfaces), (Object[])new Object[0]);
            }
        }
        return adminObjects;
    }

    private void findAllInterfacesOnAdminClass(Class<?> clazz, List<Class<?>> interfaceList) {
        Class<?>[] classInterfaces;
        boolean trace = TraceComponent.isAnyTracingEnabled();
        for (Class<?> classInterface : classInterfaces = clazz.getInterfaces()) {
            if (Serializable.class == classInterface || Externalizable.class == classInterface || ResourceAdapterAssociation.class == classInterface) continue;
            interfaceList.add(classInterface);
        }
        if (trace && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Interface list: " + interfaceList), (Object[])new Object[0]);
        }
        if (clazz.getSuperclass() != null) {
            this.findAllInterfacesOnAdminClass(clazz.getSuperclass(), interfaceList);
        }
    }

    private List<RaMessageListener> getAnnotatedMessageListeners(Class<?> clazz) throws ResourceAdapterInternalException {
        Class[] msgListenerClasses;
        boolean trace = TraceComponent.isAnyTracingEnabled();
        LinkedList<RaMessageListener> messageListeners = new LinkedList<RaMessageListener>();
        String className = clazz.getName();
        List<RaConfigProperty> configProperties = this.getAnnotatedConfigProperties(clazz, false);
        Activation anno = clazz.getAnnotation(Activation.class);
        for (Class msgListenerClass : msgListenerClasses = anno.messageListeners()) {
            RaMessageListener messageListener = new RaMessageListener();
            messageListener.setMessageListenerType(msgListenerClass.getName());
            RaActivationSpec activationSpec = new RaActivationSpec();
            activationSpec.setActivationSpecClass(className);
            activationSpec.getConfigProperties().addAll(configProperties);
            messageListener.setActivationSpec(activationSpec);
            messageListeners.add(messageListener);
            if (!trace || !tc.isDebugEnabled()) continue;
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Processed message listener " + msgListenerClass.getName() + " with activation spec " + className), (Object[])new Object[0]);
        }
        return messageListeners;
    }

    private RaConnectionDefinition getAnnotatedConnectionDefinition(Class<?> clazz) throws ResourceAdapterInternalException {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"class to look at for ManagedConnectionFactory interface", (Object[])new Object[]{clazz});
        }
        RaConnectionDefinition definition = new RaConnectionDefinition();
        ConnectionDefinition anno = clazz.getAnnotation(ConnectionDefinition.class);
        String connectionFactoryImpl = anno.connectionFactoryImpl().getName();
        String connectionFactoryInterface = anno.connectionFactory().getName();
        String connectionInterface = anno.connection().getName();
        String connectionImpl = anno.connectionImpl().getName();
        definition.setConnectionFactoryImplClass(connectionFactoryImpl);
        definition.setConnectionFactoryInterface(connectionFactoryInterface);
        definition.setConnectionImplClass(connectionImpl);
        definition.setConnectionInterface(connectionInterface);
        definition.setManagedConnectionFactoryClass(clazz.getName());
        definition.getConfigProperties().addAll(this.getAnnotatedConfigProperties(clazz, false));
        if (trace && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Processed @ConnectionDefinition " + clazz.getName()), (Object[])new Object[0]);
        }
        return definition;
    }

    private List<RaConnectionDefinition> getAnnotatedConnectionDefinitions(Class<?> clazz) throws ResourceAdapterInternalException {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        LinkedList<RaConnectionDefinition> definitions = new LinkedList<RaConnectionDefinition>();
        ConnectionDefinitions anno = clazz.getAnnotation(ConnectionDefinitions.class);
        ConnectionDefinition[] annoDefs = anno.value();
        if (annoDefs != null && annoDefs.length > 0) {
            for (ConnectionDefinition annoDef : annoDefs) {
                RaConnectionDefinition definition = new RaConnectionDefinition();
                String connectionFactoryImpl = annoDef.connectionFactoryImpl().getName();
                String connectionFactoryInterface = annoDef.connectionFactory().getName();
                String connectionInterface = annoDef.connection().getName();
                String connectionImpl = annoDef.connectionImpl().getName();
                definition.setConnectionFactoryImplClass(connectionFactoryImpl);
                definition.setConnectionFactoryInterface(connectionFactoryInterface);
                definition.setConnectionImplClass(connectionImpl);
                definition.setConnectionInterface(connectionInterface);
                definition.setManagedConnectionFactoryClass(clazz.getName());
                definition.getConfigProperties().addAll(this.getAnnotatedConfigProperties(clazz, false));
                definitions.add(definition);
                if (!trace || !tc.isDebugEnabled()) continue;
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Processed @ConnectionDefinitions " + clazz.getName() + " : " + definition), (Object[])new Object[0]);
            }
        }
        return definitions;
    }

    /*
     * WARNING - void declaration
     */
    @FFDCIgnore(value={NoSuchMethodException.class})
    private <T> List<RaConfigProperty> getAnnotatedConfigProperties(Class<?> clazz, boolean processJavaBeanDefaults) throws ResourceAdapterInternalException {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        LinkedList<RaConfigProperty> configProperties = new LinkedList<RaConfigProperty>();
        Object instance = null;
        try {
            Method[] methods;
            Field[] fields;
            for (final Field field : fields = clazz.getDeclaredFields()) {
                String defaultValue;
                String sName;
                String fName;
                Class<?> type;
                RaConfigProperty configProperty;
                ConfigProperty anno;
                block31: {
                    anno = field.getAnnotation(ConfigProperty.class);
                    if (anno == null) continue;
                    if (trace && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Processing " + anno + " on " + field), (Object[])new Object[0]);
                    }
                    configProperty = new RaConfigProperty();
                    type = field.getType();
                    if (anno.type() != Object.class && anno.type() != type) {
                        throw new IllegalStateException(Tr.formatMessage((TraceComponent)tc, (String)"J2CA9940.cfgprop.type.mismatch.field", (Object[])new Object[]{clazz.getSimpleName(), field.getName(), anno.type().getName(), type.getName()}));
                    }
                    fName = field.getName();
                    String upperCaseFieldName = Character.toUpperCase(fName.charAt(0)) + fName.substring(1);
                    String gName = "get" + upperCaseFieldName;
                    sName = "set" + upperCaseFieldName;
                    try {
                        this.checkGetterMethod(clazz, fName, gName, type);
                    }
                    catch (NoSuchMethodException e) {
                        boolean foundGetter = false;
                        if (type == Boolean.class) {
                            try {
                                gName = "is" + upperCaseFieldName;
                                this.checkGetterMethod(clazz, fName, gName, type);
                                foundGetter = true;
                            }
                            catch (NoSuchMethodException noSuchMethodException) {
                                // empty catch block
                            }
                        }
                        if (foundGetter) break block31;
                        throw new IllegalArgumentException(Tr.formatMessage((TraceComponent)tc, (String)"J2CA9938.cfgprop.no.getter", (Object[])new Object[]{clazz.getSimpleName(), fName, type.getName()}));
                    }
                }
                try {
                    clazz.getMethod(sName, type);
                }
                catch (NoSuchMethodException e) {
                    throw new IllegalArgumentException(Tr.formatMessage((TraceComponent)tc, (String)"J2CA9939.cfgprop.no.setter", (Object[])new Object[]{clazz.getSimpleName(), fName, type.getName()}));
                }
                String[] descList = anno.description();
                LinkedList<RaDescription> description = new LinkedList<RaDescription>();
                for (String d : descList) {
                    String[] ra = new RaDescription();
                    ra.setValue(d);
                    description.add((RaDescription)ra);
                }
                String string = defaultValue = !anno.defaultValue().isEmpty() ? anno.defaultValue() : null;
                if (processJavaBeanDefaults && defaultValue == null) {
                    if (instance == null) {
                        instance = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    AccessController.doPrivileged(new PrivilegedAction<Void>(){
                        static final long serialVersionUID = -2564371216821835334L;
                        private static final /* synthetic */ TraceComponent $$$tc$$$;

                        @Override
                        public Void run() {
                            field.setAccessible(true);
                            return null;
                        }

                        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                        static {
                            $$$tc$$$ = Tr.register((String)"com.ibm.ws.jca.utils.metagen.RAAnnotationProcessor$1", 1.class, (String)"rarInstall", (String)"com.ibm.ws.jca.utils.internal.resources.JcaUtilsMessages");
                        }
                    });
                    Object reflectDefaultVal = field.get(instance);
                    defaultValue = reflectDefaultVal == null ? null : reflectDefaultVal.toString();
                }
                Boolean confidential = anno.confidential();
                Boolean ignore = anno.ignore();
                Boolean supportsDynamicUpdates = anno.supportsDynamicUpdates();
                configProperty.setName(field.getName());
                configProperty.setConfidential(confidential);
                configProperty.setDefault(defaultValue);
                configProperty.setDescription(description);
                configProperty.setIgnore(ignore);
                configProperty.setSupportsDynamicUpdates(supportsDynamicUpdates);
                configProperty.setType(type.getName());
                configProperties.add(configProperty);
                if (!trace || !tc.isDebugEnabled()) continue;
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Processed @ConfigProperty " + configProperty), (Object[])new Object[0]);
            }
            for (Method method : methods = clazz.getMethods()) {
                String defaultValue;
                Method getterMethodTemp;
                Object type;
                String name;
                RaConfigProperty configProperty;
                ConfigProperty anno;
                block32: {
                    String mName;
                    anno = method.getAnnotation(ConfigProperty.class);
                    if (anno == null) continue;
                    if (trace && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Processing " + anno + " on " + method), (Object[])new Object[0]);
                    }
                    if (!(mName = method.getName()).startsWith("set") || mName.length() < 4) {
                        throw new IllegalArgumentException(Tr.formatMessage((TraceComponent)tc, (String)"J2CA9927.cfgprop.invalid.method", (Object[])new Object[]{method.getName()}));
                    }
                    Object[] paramTypes = method.getParameterTypes();
                    if (paramTypes.length != 1) {
                        throw new IllegalArgumentException(Tr.formatMessage((TraceComponent)tc, (String)"J2CA9942.cfgprop.invalid.parameters", (Object[])new Object[]{method.getName(), Arrays.toString(paramTypes)}));
                    }
                    configProperty = new RaConfigProperty();
                    String upperName = mName.substring("set".length());
                    name = Character.toLowerCase(upperName.charAt(0)) + upperName.substring(1);
                    String getterName = "get" + upperName;
                    type = paramTypes[0];
                    if (anno.type() != Object.class && anno.type() != type) {
                        throw new IllegalStateException(Tr.formatMessage((TraceComponent)tc, (String)"J2CA9941.cfgprop.type.mismatch.setter", (Object[])new Object[]{clazz.getSimpleName(), name, anno.type().getName(), "", ((Class)type).getName()}));
                    }
                    getterMethodTemp = null;
                    try {
                        getterMethodTemp = this.checkGetterMethod(clazz, name, getterName, (Class<?>)type);
                    }
                    catch (NoSuchMethodException e) {
                        boolean foundGetter = false;
                        if (type == Boolean.class) {
                            getterName = "is" + upperName;
                            try {
                                getterMethodTemp = this.checkGetterMethod(clazz, name, getterName, (Class<?>)type);
                                foundGetter = true;
                            }
                            catch (NoSuchMethodException supportsDynamicUpdates) {
                                // empty catch block
                            }
                        }
                        if (foundGetter) break block32;
                        throw new IllegalArgumentException(Tr.formatMessage((TraceComponent)tc, (String)"J2CA9938.cfgprop.no.getter", (Object[])new Object[]{clazz.getSimpleName(), name, ((Class)type).getName()}));
                    }
                }
                final Method getterMethod = getterMethodTemp;
                String[] descList = anno.description();
                LinkedList<RaDescription> description = new LinkedList<RaDescription>();
                for (String d : descList) {
                    RaDescription ra = new RaDescription();
                    ra.setValue(d);
                    description.add(ra);
                }
                String string = defaultValue = !anno.defaultValue().isEmpty() ? anno.defaultValue() : null;
                if (processJavaBeanDefaults && defaultValue == null) {
                    if (instance == null) {
                        instance = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    AccessController.doPrivileged(new PrivilegedAction<Void>(){
                        static final long serialVersionUID = -1411913138977525388L;
                        private static final /* synthetic */ TraceComponent $$$tc$$$;

                        @Override
                        public Void run() {
                            getterMethod.setAccessible(true);
                            return null;
                        }

                        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                        static {
                            $$$tc$$$ = Tr.register((String)"com.ibm.ws.jca.utils.metagen.RAAnnotationProcessor$2", 2.class, (String)"rarInstall", (String)"com.ibm.ws.jca.utils.internal.resources.JcaUtilsMessages");
                        }
                    });
                    Object reflectDefaultVal = getterMethod.invoke(instance, new Object[0]);
                    defaultValue = reflectDefaultVal == null ? null : reflectDefaultVal.toString();
                }
                Boolean ignore = anno.ignore();
                Boolean supportsDynamicUpdates = anno.supportsDynamicUpdates();
                Boolean confidential = anno.confidential();
                configProperty.setName(name);
                configProperty.setConfidential(confidential);
                configProperty.setDefault(defaultValue);
                configProperty.setDescription(description);
                configProperty.setIgnore(ignore);
                configProperty.setSupportsDynamicUpdates(supportsDynamicUpdates);
                configProperty.setType(((Class)type).getName());
                configProperties.add(configProperty);
                if (!trace || !tc.isDebugEnabled()) continue;
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Processed @ConfigProperty " + configProperty), (Object[])new Object[0]);
            }
            Class<?> superclass = clazz.getSuperclass();
            if (superclass != null) {
                configProperties.addAll(this.getAnnotatedConfigProperties(superclass, processJavaBeanDefaults));
            }
        }
        catch (RuntimeException fields) {
            void e;
            FFDCFilter.processException((Throwable)fields, (String)"com.ibm.ws.jca.utils.metagen.RAAnnotationProcessor", (String)"1688", (Object)this, (Object[])new Object[]{clazz, processJavaBeanDefaults});
            throw e;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jca.utils.metagen.RAAnnotationProcessor", (String)"1690", (Object)this, (Object[])new Object[]{clazz, processJavaBeanDefaults});
            if (e instanceof ResourceAdapterInternalException) {
                throw (ResourceAdapterInternalException)e;
            }
            throw new ResourceAdapterInternalException((Throwable)e);
        }
        return configProperties;
    }

    private Method checkGetterMethod(Class<?> clazz, String propName, String getterName, Class<?> type) throws NoSuchMethodException {
        Method getterMethod = clazz.getMethod(getterName, new Class[0]);
        Class<?> returnType = getterMethod.getReturnType();
        if (returnType != type) {
            throw new IllegalArgumentException(Tr.formatMessage((TraceComponent)tc, (String)"J2CA9937.cfgprop.invalid.return", (Object[])new Object[]{clazz.getSimpleName(), propName, returnType.getName(), type.getName()}));
        }
        return getterMethod;
    }

    public boolean isEqual(String str1, String str2) {
        str1 = str1.substring(0, 1).toUpperCase() + str1.substring(1);
        str2 = str2.substring(0, 1).toUpperCase() + str2.substring(1);
        return str1.equals(str2);
    }

    public boolean isAnnotatedConnector() {
        return this.connectorClasses.size() != 0 || this.activationClasses.size() != 0 || this.connDefClasses.size() != 0 || this.connDefsClasses.size() != 0 || this.adminObjectClasses.size() != 0;
    }
}

