/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.converter;

import com.ibm.xml.xlxp2.scan.Copyright;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xs.ShortList;
import org.apache.xerces.xs.datatypes.ObjectList;
import org.apache.xerces.xs.datatypes.XSDateTime;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class ValueInfo {
    private final String lexical;
    private final int type;
    private final int[] types;
    private final String[] nsMapping;
    private final String defaultNS;

    public ValueInfo(String string, Object object, short s, ShortList shortList) {
        String[] stringArray;
        this.type = s;
        if (shortList != null) {
            stringArray = (String[])object;
            int n = stringArray.getLength();
            this.types = new int[n];
            for (int i = 0; i < n; ++i) {
                this.types[i] = shortList.getLength() == 1 ? (int)shortList.item(0) : (int)shortList.item(i);
            }
        } else {
            this.types = null;
        }
        stringArray = null;
        String string2 = "";
        switch (this.type) {
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                string = ((XSDateTime)object).getLexicalValue();
                break;
            }
            case 19: 
            case 20: {
                QName qName = (QName)object;
                string = qName.rawname;
                if (qName.prefix.length() == 0) {
                    string2 = qName.uri == null ? "" : qName.uri;
                    break;
                }
                stringArray = new String[]{qName.prefix, qName.uri};
                break;
            }
            case 43: 
            case 44: {
                int n;
                ArrayList<String> arrayList = new ArrayList<String>();
                ArrayList<String> arrayList2 = new ArrayList<String>();
                ObjectList objectList = (ObjectList)object;
                StringBuilder stringBuilder = new StringBuilder();
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                block10: for (n = 0; n < objectList.getLength(); ++n) {
                    stringBuilder.append(' ');
                    int n2 = this.types[n];
                    switch (n2) {
                        case 10: 
                        case 11: 
                        case 12: 
                        case 13: 
                        case 14: 
                        case 15: {
                            XSDateTime xSDateTime = (XSDateTime)objectList.item(n);
                            stringBuilder.append(xSDateTime.getLexicalValue());
                            stringTokenizer.nextToken();
                            continue block10;
                        }
                        case 19: 
                        case 20: {
                            QName qName = (QName)objectList.item(n);
                            stringBuilder.append(qName.rawname);
                            stringTokenizer.nextToken();
                            if (qName.prefix.length() == 0) {
                                string2 = qName.uri == null ? "" : qName.uri;
                                continue block10;
                            }
                            if (arrayList.contains(qName.prefix)) continue block10;
                            arrayList.add(qName.prefix);
                            arrayList2.add(qName.uri);
                            continue block10;
                        }
                        default: {
                            stringBuilder.append(stringTokenizer.nextToken());
                        }
                    }
                }
                if (arrayList.size() > 0) {
                    stringArray = new String[arrayList.size() * 2];
                    for (n = 0; n < arrayList.size(); ++n) {
                        stringArray[n * 2] = (String)arrayList.get(n);
                        stringArray[n * 2 + 1] = (String)arrayList2.get(n);
                    }
                }
                string = stringBuilder.substring(1);
            }
        }
        this.lexical = string;
        this.nsMapping = stringArray;
        this.defaultNS = string2;
    }

    public String lexicalValue() {
        return this.lexical;
    }

    public int type() {
        return this.type;
    }

    public int[] itemTypes() {
        return this.types;
    }

    public String[] namespaceMapping() {
        return this.nsMapping;
    }

    public String defaultNamespace() {
        return this.defaultNS;
    }
}

