/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.scan.util;

import com.ibm.xml.xlxp2.scan.Copyright;
import com.ibm.xml.xlxp2.scan.msg.MessageProvider;
import com.ibm.xml.xlxp2.scan.msg.MessageProviderRegistry;
import com.ibm.xml.xlxp2.scan.util.DataBuffer;
import com.ibm.xml.xlxp2.scan.util.NullDataBufferFactory;
import com.ibm.xml.xlxp2.scan.util.XMLString;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public class CharConversionError {
    public int errorCode;
    public int[] errorArgs;
    public IOException exception;

    private CharConversionError(int n) {
        this.errorCode = n;
        this.errorArgs = null;
        this.exception = null;
    }

    private CharConversionError(int n, int[] nArray, IOException iOException) {
        this.errorCode = n;
        this.errorArgs = nArray;
        this.exception = iOException;
    }

    public String formatErrorMessage() {
        MessageProvider messageProvider = MessageProviderRegistry.getMessageProvider("http://w3.xml.ibm.com/#XLXP");
        int n = this.errorArgs == null ? 0 : this.errorArgs.length;
        Object[] objectArray = this.errorArgs == null ? null : new XMLString[n];
        for (int i = 0; i < n; ++i) {
            DataBuffer dataBuffer = NullDataBufferFactory.createNewBuffer();
            XMLString xMLString = new XMLString();
            try {
                dataBuffer.bytes = Integer.toHexString(this.errorArgs[i]).getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                dataBuffer.bytes = new byte[]{63, 63};
            }
            dataBuffer.startOffset = 0;
            dataBuffer.endOffset = dataBuffer.bytes.length;
            xMLString.setValues(dataBuffer, dataBuffer.startOffset, dataBuffer.endOffset);
            objectArray[i] = xMLString;
        }
        return messageProvider.createMessage(null, this.errorCode, objectArray);
    }

    public static CharConversionError unableToConvertOutOfRangeUnicodeCharacter() {
        return new CharConversionError(0);
    }

    public static CharConversionError insufficientInputToDecodeCharacter() {
        return new CharConversionError(1);
    }

    public static CharConversionError missingSecondHalfOfSurrogatePair() {
        return new CharConversionError(2);
    }

    public static CharConversionError invalidSecondHalfOfSurrogatePair() {
        return new CharConversionError(3);
    }

    public static CharConversionError invalidFirstHalfOfSurrogatePair() {
        return new CharConversionError(4);
    }

    public static CharConversionError byteOrderMarkRequired() {
        return new CharConversionError(5);
    }

    public static CharConversionError invalidUTF8SurrogateEncoding() {
        return new CharConversionError(6);
    }

    public static CharConversionError partialMultiPartCharacterSequence() {
        return new CharConversionError(7);
    }

    public static CharConversionError inconsistentEncoding() {
        return new CharConversionError(8);
    }

    public static CharConversionError runtimeIOError(IOException iOException) {
        return new CharConversionError(10, null, iOException);
    }

    public static CharConversionError invalidUTF8CharacterEncoding(int n, int n2, int n3, int n4, int n5) {
        int[] nArray = new int[]{n, n2, n3, n4, n5};
        return new CharConversionError(9, nArray, null);
    }
}

