/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.sib.processor.impl.JSConsumerSet;
import com.ibm.ws.sib.processor.impl.interfaces.ConsumableKey;
import com.ibm.ws.sib.processor.impl.interfaces.JSKeyGroup;
import com.ibm.ws.sib.processor.utils.linkedlist.SimpleEntry;
import com.ibm.ws.sib.utils.ras.SibTr;

public abstract class AbstractConsumerKey
extends SimpleEntry
implements ConsumableKey {
    private static final TraceComponent tc = SibTr.register(AbstractConsumerKey.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    protected JSKeyGroup keyGroup;
    protected JSConsumerSet consumerSet = null;
    protected boolean classifyingMessages = false;
    volatile int closedReason = 0;

    @Override
    public void joinKeyGroup(JSKeyGroup keyGroup) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"joinKeyGroup", (Object)keyGroup);
        }
        if (this.keyGroup != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"joinKeyGroup", (Object)"SIErrorException");
            }
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.ConsumerKey", "1:97:1.2"}, null));
        }
        this.keyGroup = keyGroup;
        keyGroup.addMember(this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"joinKeyGroup");
        }
    }

    @Override
    public void leaveKeyGroup() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"leaveKeyGroup");
        }
        if (this.keyGroup == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"leaveKeyGroup", (Object)"Error");
            }
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.ConsumerKey", "1:124:1.2"}, null));
        }
        this.keyGroup.removeMember(this);
        this.keyGroup = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"leaveKeyGroup");
        }
    }

    @Override
    public JSConsumerSet getConsumerSet() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getConsumerSet");
            SibTr.exit((TraceComponent)tc, (String)"getConsumerSet", (Object)this.consumerSet);
        }
        return this.consumerSet;
    }

    @Override
    public boolean isConsumerSetSuspended() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isConsumerSetSuspended");
        }
        boolean consumerSetSuspended = false;
        if (this.classifyingMessages) {
            consumerSetSuspended = this.consumerSet.isConsumerSetSuspended();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isConsumerSetSuspended", (Object)consumerSetSuspended);
        }
        return consumerSetSuspended;
    }

    @Override
    public boolean prepareAddActiveMessage() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"prepareAddActiveMessage");
        }
        boolean messageAccepted = true;
        if (this.classifyingMessages) {
            messageAccepted = this.consumerSet.prepareAddActiveMessage();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"prepareAddActiveMessage", (Object)messageAccepted);
        }
        return messageAccepted;
    }

    @Override
    public void commitAddActiveMessage() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"commitAddActiveMessage");
        }
        if (this.classifyingMessages) {
            this.consumerSet.commitAddActiveMessage();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"commitAddActiveMessage");
        }
    }

    @Override
    public void rollbackAddActiveMessage() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"rollbackAddActiveMessage");
        }
        if (this.classifyingMessages) {
            this.consumerSet.rollbackAddActiveMessage();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"rollbackAddActiveMessage");
        }
    }

    @Override
    public void removeActiveMessages(int messages) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"removeActiveMessages", (Object)new Object[]{messages});
        }
        if (this.classifyingMessages) {
            this.consumerSet.removeActiveMessages(messages);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"removeActiveMessages");
        }
    }

    @Override
    public boolean isClosedDueToDelete() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isClosedDueToDelete");
            SibTr.exit((TraceComponent)tc, (String)"isClosedDueToDelete", (Object)(this.closedReason == 1 ? 1 : 0));
        }
        return this.closedReason == 1;
    }

    @Override
    public boolean isClosedDueToReceiveExclusive() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isClosedDueToReceiveExclusive");
            SibTr.exit((TraceComponent)tc, (String)"isClosedDueToReceiveExclusive", (Object)(this.closedReason == 2 ? 1 : 0));
        }
        return this.closedReason == 2;
    }

    @Override
    public boolean isClosedDueToLocalizationUnreachable() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isClosedDueToLocalizationUnreachable");
            SibTr.exit((TraceComponent)tc, (String)"isClosedDueToLocalizationUnreachable", (Object)(this.closedReason == 3 ? 1 : 0));
        }
        return this.closedReason == 3;
    }
}

