/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.impl;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.impl.UriBuilderImpl;
import org.apache.cxf.jaxrs.model.MethodInvocationInfo;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.jaxrs.model.OperationResourceInfoStack;
import org.apache.cxf.jaxrs.model.URITemplate;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;

public class UriInfoImpl
implements UriInfo {
    private static final Logger LOG = LogUtils.getL7dLogger(UriInfoImpl.class);
    private static final String CASE_INSENSITIVE_QUERIES = "org.apache.cxf.http.case_insensitive_queries";
    private static final String PARSE_QUERY_VALUE_AS_COLLECTION = "parse.query.value.as.collection";
    private MultivaluedMap<String, String> templateParams;
    private Message message;
    private OperationResourceInfoStack stack;
    private boolean caseInsensitiveQueries;
    private boolean queryValueIsCollection;

    public UriInfoImpl(Message m) {
        this(m, (MultivaluedMap<String, String>)((MultivaluedMap)m.get("jaxrs.template.parameters")));
    }

    public UriInfoImpl(Message m, MultivaluedMap<String, String> templateParams) {
        this.message = m;
        this.templateParams = templateParams;
        if (m != null) {
            this.stack = m.get(OperationResourceInfoStack.class);
            this.caseInsensitiveQueries = MessageUtils.isTrue(m.getContextualProperty(CASE_INSENSITIVE_QUERIES));
            this.queryValueIsCollection = MessageUtils.isTrue(m.getContextualProperty(PARSE_QUERY_VALUE_AS_COLLECTION));
        }
    }

    public URI getAbsolutePath() {
        String path = this.getAbsolutePathAsString();
        return URI.create(path);
    }

    public UriBuilder getAbsolutePathBuilder() {
        return new UriBuilderImpl(this.getAbsolutePath());
    }

    public URI getBaseUri() {
        URI u = URI.create(HttpUtils.getEndpointAddress(this.message));
        return HttpUtils.toAbsoluteUri(u, this.message);
    }

    public UriBuilder getBaseUriBuilder() {
        return new UriBuilderImpl(this.getBaseUri());
    }

    public String getPath() {
        return this.getPath(true);
    }

    public String getPath(boolean decode) {
        String value = this.doGetPath(decode, true);
        if (value.length() > 1 && value.startsWith("/")) {
            return value.substring(1);
        }
        return value;
    }

    public List<PathSegment> getPathSegments() {
        return this.getPathSegments(true);
    }

    public List<PathSegment> getPathSegments(boolean decode) {
        return JAXRSUtils.getPathSegments(this.getPath(false), decode);
    }

    public MultivaluedMap<String, String> getQueryParameters() {
        return this.getQueryParameters(true);
    }

    public MultivaluedMap<String, String> getQueryParameters(boolean decode) {
        MetadataMap<String, String> queries = !this.caseInsensitiveQueries ? new MetadataMap<String, String>() : new MetadataMap(false, true);
        JAXRSUtils.getStructuredParams(queries, (String)this.message.get(Message.QUERY_STRING), "&", decode, decode, this.queryValueIsCollection);
        return queries;
    }

    public URI getRequestUri() {
        String path = this.getAbsolutePathAsString();
        String queries = (String)this.message.get(Message.QUERY_STRING);
        if (queries != null) {
            path = path + "?" + queries;
        }
        return URI.create(path);
    }

    public UriBuilder getRequestUriBuilder() {
        return new UriBuilderImpl(this.getRequestUri());
    }

    public MultivaluedMap<String, String> getPathParameters() {
        return this.getPathParameters(true);
    }

    public MultivaluedMap<String, String> getPathParameters(boolean decode) {
        MetadataMap<String, String> values = new MetadataMap<String, String>();
        if (this.templateParams == null) {
            return values;
        }
        for (Map.Entry entry : this.templateParams.entrySet()) {
            if (((String)entry.getKey()).equals("FINAL_MATCH_GROUP")) continue;
            values.add((String)entry.getKey(), decode ? HttpUtils.pathDecode((String)((List)entry.getValue()).get(0)) : (String)((List)entry.getValue()).get(0));
        }
        return values;
    }

    public List<Object> getMatchedResources() {
        if (this.stack != null) {
            LinkedList<Object> resources = new LinkedList<Object>();
            for (MethodInvocationInfo invocation : this.stack) {
                resources.add(0, invocation.getRealClass());
            }
            return resources;
        }
        LOG.fine("No resource stack information, returning empty list");
        return Collections.emptyList();
    }

    public List<String> getMatchedURIs() {
        return this.getMatchedURIs(true);
    }

    public List<String> getMatchedURIs(boolean decode) {
        if (this.stack != null) {
            ArrayList<String> objects = new ArrayList<String>();
            LinkedList<String> uris = new LinkedList<String>();
            StringBuilder sumPath = new StringBuilder("");
            for (MethodInvocationInfo invocation : this.stack) {
                List<String> templateObjects = invocation.getTemplateValues();
                OperationResourceInfo ori = invocation.getMethodInfo();
                URITemplate[] paths = new URITemplate[]{ori.getClassResourceInfo().getURITemplate(), ori.getURITemplate()};
                if (paths[0] != null) {
                    int count = paths[0].getVariables().size();
                    ArrayList<String> rootObjects = new ArrayList<String>(count);
                    for (int i = 0; i < count && i < templateObjects.size(); ++i) {
                        rootObjects.add(templateObjects.get(i));
                    }
                    uris.add(0, UriInfoImpl.createMatchedPath(paths[0].getValue(), rootObjects, decode));
                }
                if (paths[1] == null || paths[1].getValue().length() <= 1) continue;
                for (URITemplate t : paths) {
                    if (t == null) continue;
                    sumPath.append("/").append(t.getValue());
                }
                objects.addAll(templateObjects);
                uris.add(0, UriInfoImpl.createMatchedPath(sumPath.toString(), objects, decode));
            }
            return uris;
        }
        LOG.fine("No resource stack information, returning empty list");
        return Collections.emptyList();
    }

    private static String createMatchedPath(String uri, List<? extends Object> vars, boolean decode) {
        String uriPath = UriBuilder.fromPath((String)uri).buildFromEncoded(vars.toArray()).getRawPath();
        String string = uriPath = decode ? HttpUtils.pathDecode(uriPath) : uriPath;
        if (uriPath.startsWith("/")) {
            uriPath = uriPath.substring(1);
        }
        return uriPath;
    }

    private String doGetPath(boolean decode, boolean addSlash) {
        String path = HttpUtils.getPathToMatch(this.message, addSlash);
        return decode ? HttpUtils.pathDecode(path) : path;
    }

    private String getAbsolutePathAsString() {
        String address = this.getBaseUri().toString();
        if (MessageUtils.isRequestor(this.message)) {
            return address;
        }
        String path = this.doGetPath(false, false);
        if (path.startsWith("/") && address.endsWith("/")) {
            address = address.substring(0, address.length() - 1);
        }
        if (!(path.isEmpty() || path.startsWith("/") || address.endsWith("/"))) {
            address = address + "/";
        }
        return address + path;
    }

    public URI relativize(URI uri) {
        URI resolved = HttpUtils.resolve(this.getBaseUriBuilder(), uri);
        return HttpUtils.relativize(this.getRequestUri(), resolved);
    }

    public URI resolve(URI uri) {
        return HttpUtils.resolve(this.getBaseUriBuilder(), uri);
    }
}

