/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.kerberos.auth;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.kernel.service.util.JavaInfo;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class Krb5LoginModuleWrapper
implements LoginModule {
    private static final TraceComponent tc = Tr.register(Krb5LoginModuleWrapper.class, (String)"Kerberos", (String)"com.ibm.ws.security.kerberos.auth.internal.resources.KerberosMessages");
    public static final String COM_IBM_SECURITY_AUTH_MODULE_KRB5LOGINMODULE = "com.ibm.security.auth.module.Krb5LoginModule";
    public static final String COM_SUN_SECURITY_AUTH_MODULE_KRB5LOGINMODULE = "com.sun.security.auth.module.Krb5LoginModule";
    public static final String COM_SUN_SECURITY_JGSS_KRB5_INITIATE = "com.sun.security.jgss.krb5.initiate";
    public static final String COM_SUN_SECURITY_JGSS_KRB5_ACCEPT = "com.sun.security.jgss.krb5.accept";
    private static final boolean isIBMJdk8 = (JavaInfo.vendor() == JavaInfo.Vendor.IBM || Krb5LoginModuleWrapper.isIBMLoginModuleAvailable()) && JavaInfo.majorVersion() <= 8;
    public CallbackHandler callbackHandler;
    public Subject subject;
    public Map<String, Object> sharedState;
    public Map<String, Object> options;
    private final Class<? extends LoginModule> krb5LoginModuleClass;
    private final LoginModule krb5loginModule;
    private boolean login_called = false;
    static final long serialVersionUID = -3759819392410479120L;

    @FFDCIgnore(value={Throwable.class})
    private static boolean isIBMLoginModuleAvailable() {
        try {
            Class.forName(COM_IBM_SECURITY_AUTH_MODULE_KRB5LOGINMODULE);
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Krb5LoginModuleWrapper() {
        String targetClass;
        String string = targetClass = isIBMJdk8 ? COM_IBM_SECURITY_AUTH_MODULE_KRB5LOGINMODULE : COM_SUN_SECURITY_AUTH_MODULE_KRB5LOGINMODULE;
        if (TraceComponent.isAnyTracingEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Using target class: " + targetClass), (Object[])new Object[0]);
        }
        this.krb5LoginModuleClass = Krb5LoginModuleWrapper.getClassForName(targetClass);
        try {
            this.krb5loginModule = this.krb5LoginModuleClass.newInstance();
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.kerberos.auth.Krb5LoginModuleWrapper", (String)"72", (Object)this, (Object[])new Object[0]);
            throw new IllegalStateException((Throwable)e);
        }
    }

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> opts) {
        Object useKeytabValue = null;
        this.callbackHandler = callbackHandler;
        this.subject = subject;
        this.sharedState = sharedState;
        this.options = new HashMap(opts);
        String IBM_JDK_USE_KEYTAB = "useKeytab";
        String OPENJDK_USE_KEYTAB = "useKeyTab";
        if (!isIBMJdk8) {
            useKeytabValue = this.options.get("useKeyTab");
        }
        if (isIBMJdk8) {
            String isInitiator;
            if (this.options.containsKey("isInitiator") && "true".equalsIgnoreCase(isInitiator = (String)this.options.remove("isInitiator"))) {
                this.options.put("credsType", "both");
            }
            this.options.remove("doNotPrompt");
            this.options.remove("refreshKrb5Config");
            this.options.remove("useKeyTab");
            if (this.options.containsKey("keyTab")) {
                String keytab = (String)this.options.remove("keyTab");
                this.options.put("useKeytab", keytab);
            }
            this.options.remove("clearPass");
            boolean useTicketCache = Boolean.valueOf((String)this.options.remove("useTicketCache"));
            String ticketCache = (String)this.options.remove("ticketCache");
            if (useTicketCache) {
                if (ticketCache != null) {
                    this.options.put("useCcache", ticketCache);
                } else {
                    this.options.put("useDefaultCcache", "true");
                }
            }
        }
        if (useKeytabValue != null && useKeytabValue.equals("true") && this.options.get("keyTab") == null) {
            this.options.put("keyTab", this.getSystemProperty("KRB5_KTNAME"));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            this.options.put("debug", "true");
        }
        this.krb5loginModule.initialize(subject, callbackHandler, sharedState, this.options);
    }

    @Override
    public boolean login() throws LoginException {
        this.krb5loginModule.login();
        this.login_called = true;
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        if (this.login_called) {
            this.krb5loginModule.commit();
        }
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        if (this.login_called) {
            this.krb5loginModule.abort();
        }
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        if (this.login_called) {
            this.krb5loginModule.logout();
        }
        return true;
    }

    private String getSystemProperty(final String propName) {
        String value = (String)AccessController.doPrivileged(new PrivilegedAction(){
            static final long serialVersionUID = 7182468980653372530L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            public Object run() {
                return System.getProperty(propName);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.kerberos.auth.Krb5LoginModuleWrapper$1", 1.class, (String)"Kerberos", (String)"com.ibm.ws.security.kerberos.auth.internal.resources.KerberosMessages");
            }
        });
        return value;
    }

    /*
     * WARNING - void declaration
     */
    private static Class<? extends LoginModule> getClassForName(String tg) {
        try {
            return Class.forName(tg);
        }
        catch (ClassNotFoundException classNotFoundException) {
            void e;
            FFDCFilter.processException((Throwable)classNotFoundException, (String)"com.ibm.ws.security.kerberos.auth.Krb5LoginModuleWrapper", (String)"177", null, (Object[])new Object[]{tg});
            Tr.error((TraceComponent)tc, (String)"Exception performing class for name.", (Object[])new Object[]{e.getLocalizedMessage()});
            throw new IllegalStateException((Throwable)e);
        }
    }
}

