/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.failsafe;

import java.util.concurrent.TimeUnit;
import net.jodah.failsafe.util.Duration;

public class ExecutionContext {
    final Duration startTime;
    volatile int executions;

    ExecutionContext(Duration startTime) {
        this.startTime = startTime;
    }

    ExecutionContext(ExecutionContext context) {
        this.startTime = context.startTime;
        this.executions = context.executions;
    }

    public Duration getElapsedTime() {
        return new Duration(System.nanoTime() - this.startTime.toNanos(), TimeUnit.NANOSECONDS);
    }

    public int getExecutions() {
        return this.executions;
    }

    public Duration getStartTime() {
        return this.startTime;
    }

    ExecutionContext copy() {
        return new ExecutionContext(this);
    }
}

