/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collective.member.internal.publisher;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class HostNameUtil {
    private static final TraceComponent tc = Tr.register(HostNameUtil.class, (String)"Collective", (String)"com.ibm.ws.collective.member.internal.resources.CollectiveMemberMessages");
    static final String DEFAULT_HOST_NAME = "localhost";
    static final long serialVersionUID = 2194686097385971150L;

    public static String getFQDN() {
        return AccessController.doPrivileged(new GetHostNameAction());
    }

    @Trivial
    static class GetHostNameAction
    implements PrivilegedAction<String> {
        GetHostNameAction() {
        }

        @Override
        @FFDCIgnore(value={UnknownHostException.class})
        public String run() {
            try {
                InetAddress addr = InetAddress.getLocalHost();
                return addr.getCanonicalHostName();
            }
            catch (UnknownHostException e) {
                Tr.error((TraceComponent)tc, (String)"HOST_NAME_UTIL_DETERMINE_HOST_ERROR", (Object[])new Object[]{HostNameUtil.DEFAULT_HOST_NAME, e.getMessage()});
                return HostNameUtil.DEFAULT_HOST_NAME;
            }
        }
    }
}

