/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collective.routing.member.key;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.Arrays;
import org.apache.commons.codec.digest.DigestUtils;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class WebModuleKey {
    private static final TraceComponent tc = Tr.register(WebModuleKey.class, (String)"Collective", (String)"com.ibm.ws.collective.routing.member.internal.resources.RoutingMemberMessages");
    public static final String DIGESTVERSION_VALUE = ">=8.5.5.9";
    private static final String delimiter = ":";
    static final long serialVersionUID = -843912448072777785L;

    /*
     * WARNING - void declaration
     */
    public static String calculateDigest(JSONObject moduleAttributes) {
        String digest;
        block4: {
            digest = "DigestError";
            try {
                StringBuilder infoToDigest = new StringBuilder();
                JSONObject vhost = (JSONObject)moduleAttributes.get((Object)"vhost");
                JSONObject props = (JSONObject)vhost.get((Object)"props");
                String vhostHostname = props.containsKey((Object)"host") ? (String)props.get((Object)"host") : "*";
                Long vhostPort = (Long)props.get((Object)"port");
                String contextRoot = (String)moduleAttributes.get((Object)"ContextRoot");
                JSONArray jsonServletMappings = (JSONArray)moduleAttributes.get((Object)"ServletMappings");
                Object[] servletMappings = new String[jsonServletMappings.size()];
                for (int i = 0; i < jsonServletMappings.size(); ++i) {
                    servletMappings[i] = (String)((JSONObject)jsonServletMappings.get(i)).get((Object)"name");
                }
                Arrays.sort(servletMappings);
                infoToDigest.append(vhostHostname);
                infoToDigest.append(delimiter);
                infoToDigest.append(vhostPort);
                infoToDigest.append(delimiter);
                infoToDigest.append(contextRoot);
                infoToDigest.append(delimiter);
                infoToDigest.append(Arrays.toString(servletMappings));
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("WebModuleKey infoToDigest: " + infoToDigest), (Object[])new Object[0]);
                }
                digest = DigestUtils.md5Hex((String)infoToDigest.toString());
            }
            catch (Exception infoToDigest) {
                void e;
                FFDCFilter.processException((Throwable)infoToDigest, (String)"com.ibm.ws.collective.routing.member.key.WebModuleKey", (String)"115", null, (Object[])new Object[]{moduleAttributes});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)("WebModuleKey exception due to malformed JSON: " + e.toString()), (Object[])new Object[0]);
            }
        }
        return digest;
    }
}

