/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cdi.config.liberty;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.cdi.CDIContainerConfig;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.HashMap;
import java.util.Map;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Modified;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(name="com.ibm.ws.cdi12.cdiContainer", service={CDIContainerConfig.class}, configurationPid={"com.ibm.ws.cdi12.cdiContainer"}, configurationPolicy=ConfigurationPolicy.REQUIRE, immediate=true, property={"service.vendor=IBM"})
public class CDI12ContainerConfig
implements CDIContainerConfig {
    private static final TraceComponent tc = Tr.register(CDI12ContainerConfig.class, (String)"JCDI", (String)"com.ibm.ws.cdi.internal.resources.CDI");
    private static final String ENABLE_IMPLICIT_BEAN_ARCHIVES = "enableImplicitBeanArchives";
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private boolean enableImplicitBeanArchives = true;
    static final long serialVersionUID = -6797521874027214559L;

    protected void activate(ComponentContext compcontext, Map<String, Object> properties) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Activating " + this), (Object[])new Object[0]);
        }
        this.updateConfiguration(properties);
    }

    protected void deactivate(ComponentContext compcontext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Deactivating " + this), (Object[])new Object[0]);
        }
    }

    @Modified
    protected void modified(ComponentContext compcontext, Map<String, Object> properties) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Modifying " + this), (Object[])new Object[0]);
        }
        this.updateConfiguration(properties);
    }

    protected void updateConfiguration(Map<String, Object> properties) {
        if (properties != null) {
            this.properties.clear();
            this.properties.putAll(properties);
            this.enableImplicitBeanArchives = (Boolean)this.properties.get(ENABLE_IMPLICIT_BEAN_ARCHIVES);
            if (tc.isWarningEnabled() && !this.enableImplicitBeanArchives) {
                Tr.warning((TraceComponent)tc, (String)"implicit.bean.scanning.disabled.CWOWB1009W", (Object[])new Object[0]);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Current Properties: " + this.properties), (Object[])new Object[0]);
        }
    }

    public boolean isImplicitBeanArchivesScanningDisabled() {
        return !this.enableImplicitBeanArchives;
    }
}

