/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.openapi.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.microprofile.openapi.impl.model.servers.ServerImpl;
import com.ibm.ws.microprofile.openapi.utils.OpenAPIUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.servers.Server;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ServerInfo {
    private static final TraceComponent tc = Tr.register(ServerInfo.class, (String)"MPOPENAPI", (String)"com.ibm.ws.microprofile.openapi.resources.OpenAPI");
    private int httpPort = -1;
    private int httpsPort = -1;
    private String host;
    private String applicationPath;
    private boolean isUserServer = false;
    static final long serialVersionUID = 5545384020528254709L;

    public ServerInfo() {
    }

    public ServerInfo(String host, int httpPort, int httpsPort, String applicationPath, boolean isUserServer) {
        this.host = host;
        this.httpPort = httpPort;
        this.httpsPort = httpsPort;
        this.applicationPath = applicationPath;
        this.isUserServer = isUserServer;
    }

    public ServerInfo(ServerInfo serverInfo) {
        this.host = serverInfo.host;
        this.httpPort = serverInfo.httpPort;
        this.httpsPort = serverInfo.httpsPort;
        this.applicationPath = serverInfo.applicationPath;
        this.isUserServer = serverInfo.isUserServer;
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public void setHttpPort(int httpPort) {
        this.httpPort = httpPort;
    }

    public int getHttpsPort() {
        return this.httpsPort;
    }

    public void setHttpsPort(int httpsPort) {
        this.httpsPort = httpsPort;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getApplicationPath() {
        return this.applicationPath;
    }

    public void setApplicationPath(String applicationPath) {
        this.applicationPath = applicationPath;
    }

    public boolean getIsUserServer() {
        return this.isUserServer;
    }

    public void setIsUserServer(boolean isUserServer) {
        this.isUserServer = isUserServer;
    }

    @Trivial
    public void updateOpenAPIWithServers(OpenAPI openapi) {
        String port;
        if (this.isUserServer) {
            if (OpenAPIUtils.isEventEnabled(tc)) {
                Tr.event((Object)this, (TraceComponent)tc, (String)"Server information was already set by the user. So not setting Liberty's server information", (Object[])new Object[0]);
            }
            return;
        }
        openapi.setServers(null);
        if (this.httpPort > 0) {
            port = this.httpPort == 80 ? "" : ":" + this.httpPort;
            String url = "http://" + this.host + port;
            if (this.applicationPath != null) {
                url = url + this.applicationPath;
            }
            Server server = new ServerImpl().url(url);
            openapi.addServer(server);
        }
        if (this.httpsPort > 0) {
            port = this.httpsPort == 443 ? "" : ":" + this.httpsPort;
            String secureUrl = "https://" + this.host + port;
            if (this.applicationPath != null) {
                secureUrl = secureUrl + this.applicationPath;
            }
            Server secureServer = new ServerImpl().url(secureUrl);
            openapi.addServer(secureServer);
        }
    }

    public String toString() {
        return "ServerInfo [host=" + this.host + ", httpPort=" + this.httpPort + ", httpsPort=" + this.httpsPort + ", applicationPath=" + this.applicationPath + ", isUserServer=" + this.isUserServer + "]";
    }
}

