/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.common.structures;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.structures.BoundedHashMap;
import com.ibm.ws.security.common.structures.CommonCache;
import java.util.Collections;
import java.util.Map;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class SingleTableCache
extends CommonCache {
    private Map<String, Object> lookupTable;
    static final long serialVersionUID = -173927608572090286L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public SingleTableCache(long timeoutInMilliSeconds) {
        this(0, timeoutInMilliSeconds);
    }

    public SingleTableCache(int entryLimit, long timeoutInMilliSeconds) {
        if (entryLimit > 0) {
            this.entryLimit = entryLimit;
        }
        this.lookupTable = Collections.synchronizedMap(new BoundedHashMap(this.entryLimit));
        if (timeoutInMilliSeconds > 0L) {
            this.timeoutInMilliSeconds = timeoutInMilliSeconds;
        }
        this.scheduleEvictionTask(this.timeoutInMilliSeconds);
    }

    @Override
    public synchronized void remove(@Sensitive Object key) {
        this.lookupTable.remove(key);
    }

    @Override
    public synchronized Object get(@Sensitive String key) {
        return this.lookupTable.get(key);
    }

    @Override
    public synchronized void put(@Sensitive String key, Object value) {
        this.lookupTable.put(key, value);
    }

    @Override
    protected synchronized void evictStaleEntries() {
        this.lookupTable = Collections.synchronizedMap(new BoundedHashMap(this.entryLimit));
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.common.structures.SingleTableCache", SingleTableCache.class, null, null);
    }
}

