/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgIdDSA;
import com.ibm.security.x509.X509Key;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.interfaces.DSAParams;
import java.security.spec.DSAParameterSpec;
import java.security.spec.InvalidParameterSpecException;

final class DSAPublicKey
extends X509Key
implements java.security.interfaces.DSAPublicKey,
Serializable {
    static final long serialVersionUID = -2034453286688059956L;
    private BigInteger y;
    private static String[] z;

    public DSAPublicKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) throws InvalidKeyException {
        this.y = bigInteger;
        this.algid = new AlgIdDSA(bigInteger2, bigInteger3, bigInteger4);
        try {
            this.key = new DerValue(2, bigInteger.toByteArray()).toByteArray();
            this.encode();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(z[1] + iOException.getMessage());
        }
    }

    public DSAPublicKey(byte[] byArray) throws InvalidKeyException {
        this.decode(byArray);
    }

    public BigInteger getY() {
        return this.y;
    }

    public DSAParams getParams() {
        try {
            if (this.algid instanceof DSAParams) {
                return (DSAParams)((Object)this.algid);
            }
            AlgorithmParameters algorithmParameters = this.algid.getAlgParameters();
            if (algorithmParameters == null) {
                return null;
            }
            DSAParameterSpec dSAParameterSpec = algorithmParameters.getParameterSpec(DSAParameterSpec.class);
            return dSAParameterSpec;
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            return null;
        }
    }

    protected void parseKeyBits() throws InvalidKeyException {
        try {
            DerInputStream derInputStream = new DerInputStream(this.key);
            this.y = derInputStream.getInteger();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(z[2] + iOException.getMessage());
        }
    }

    public String toString() {
        return z[0] + this.y.toString() + "\n";
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        String[] stringArray;
        block29: {
            int n2;
            int n3;
            block28: {
                char[] cArray2;
                Object var0;
                block27: {
                    int n4;
                    block26: {
                        char[] cArray3;
                        block25: {
                            int n5;
                            block24: {
                                stringArray = new String[3];
                                var0 = null;
                                char[] cArray4 = "\u0013\u0002a2P\u001f`h+Rz\u0010Y\u001a\u007f3#\f3v#z&".toCharArray();
                                cArray3 = cArray4;
                                n5 = cArray4.length;
                                n3 = 0;
                                if (!true) break block24;
                                n5 = n5;
                                if (n5 <= n3) break block25;
                            }
                            do {
                                int n6;
                                cArray3 = cArray3;
                                int n7 = n3;
                                char c2 = cArray3[n7];
                                switch (n3 % 5) {
                                    case 0: {
                                        n6 = 90;
                                        break;
                                    }
                                    case 1: {
                                        n6 = 64;
                                        break;
                                    }
                                    case 2: {
                                        n6 = 44;
                                        break;
                                    }
                                    case 3: {
                                        n6 = 120;
                                        break;
                                    }
                                    default: {
                                        n6 = 19;
                                    }
                                }
                                cArray3[n7] = (char)(c2 ^ n6);
                                ++n3;
                                n5 = n5;
                            } while (n5 > n3);
                        }
                        stringArray[0] = new String(cArray3).intern();
                        var0 = null;
                        char[] cArray5 = "9/Y\u001c34/XXW\u001f\u0012\f\u001d}9/H\u001d3#z\f".toCharArray();
                        cArray2 = cArray5;
                        n4 = cArray5.length;
                        n3 = 0;
                        if (!true) break block26;
                        n4 = n4;
                        if (n4 <= n3) break block27;
                    }
                    do {
                        int n8;
                        cArray2 = cArray2;
                        int n9 = n3;
                        char c3 = cArray2[n9];
                        switch (n3 % 5) {
                            case 0: {
                                n8 = 90;
                                break;
                            }
                            case 1: {
                                n8 = 64;
                                break;
                            }
                            case 2: {
                                n8 = 44;
                                break;
                            }
                            case 3: {
                                n8 = 120;
                                break;
                            }
                            default: {
                                n8 = 19;
                            }
                        }
                        cArray2[n9] = (char)(c3 ^ n8);
                        ++n3;
                        n4 = n4;
                    } while (n4 > n3);
                }
                stringArray[1] = new String(cArray2).intern();
                var0 = null;
                char[] cArray6 = "\u0013.Z\u0019\u007f3$\f\u0013v#z\f\u00013,!@\rvP".toCharArray();
                cArray = cArray6;
                n2 = cArray6.length;
                n3 = 0;
                if (!true) break block28;
                n2 = n2;
                if (n2 <= n3) break block29;
            }
            do {
                int n10;
                cArray = cArray;
                int n11 = n3;
                char c4 = cArray[n11];
                switch (n3 % 5) {
                    case 0: {
                        n10 = 90;
                        break;
                    }
                    case 1: {
                        n10 = 64;
                        break;
                    }
                    case 2: {
                        n10 = 44;
                        break;
                    }
                    case 3: {
                        n10 = 120;
                        break;
                    }
                    default: {
                        n10 = 19;
                    }
                }
                cArray[n11] = (char)(c4 ^ n10);
                ++n3;
                n2 = n2;
            } while (n2 > n3);
        }
        stringArray[2] = new String(cArray).intern();
        z = stringArray;
    }
}

