/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.certclient;

import com.ibm.misc.Debug;
import com.ibm.security.certclient.PkEeCertReqTransaction;
import com.ibm.security.certclient.PkEeFactory;
import com.ibm.security.certclient.base.PkActiveSource;
import com.ibm.security.certclient.base.PkAttrs;
import com.ibm.security.certclient.base.PkCertRepEvent;
import com.ibm.security.certclient.base.PkCertReqEvent;
import com.ibm.security.certclient.base.PkConfReqEvent;
import com.ibm.security.certclient.base.PkConstants;
import com.ibm.security.certclient.base.PkException;
import com.ibm.security.certclient.base.PkInitReqEvent;
import com.ibm.security.certclient.base.PkNLSConstants;
import com.ibm.security.certclient.base.PkPipe;
import com.ibm.security.certclient.base.PkRejectionException;
import com.ibm.security.certclient.beans.PkEeXMgr;
import com.ibm.security.certclient.beans.PkTcpClient;
import com.ibm.security.certclient.util.JPKI;
import com.ibm.security.certclient.util.PkCertUtils;
import com.ibm.security.certclient.util.PkConnector;
import com.ibm.security.certclient.util.PkUtils;
import com.ibm.security.cmp.PKIHeader;
import com.ibm.security.cmp.PKIMessage;
import com.ibm.security.pkcs10.CertificationRequest;
import com.ibm.security.pkcs10.CertificationRequestInfo;
import com.ibm.security.pkcsutil.PKCSAttribute;
import com.ibm.security.pkcsutil.PKCSAttributes;
import com.ibm.security.pkcsutil.PKCSException;
import com.ibm.security.pkcsutil.PKCSOID;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.x509.CertificateExtensions;
import com.ibm.security.x509.ExtKeyUsageExtension;
import com.ibm.security.x509.KeyUsageExtension;
import com.ibm.security.x509.SubjectAlternativeNameExtension;
import com.ibm.security.x509.SubjectKeyIdentifierExtension;
import com.ibm.security.x509.X500Name;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public final class PkEeCertReqFactory
extends PkEeFactory
implements PkConstants {
    private PkEeCertReqFactory() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public static PkEeCertReqTransaction newCertRequest(int keySize, String subject, int numValidDays, boolean useRSA, boolean useShortSubjectKId, List<String> subjectAltNames, List<String> kUsage, List<String> extkUsage, String iaFile, String revoPwd, String dn) throws PkException {
        String key = useRSA ? "RSA" : "DSA";
        String sigAlg = "SHA1withRSA";
        if (!useRSA) {
            sigAlg = "SHA1withDSA";
        }
        return new CertRequestImpl(keySize, subject, numValidDays, key, sigAlg, useShortSubjectKId, subjectAltNames, kUsage, extkUsage, iaFile, revoPwd, dn);
    }

    public static PkEeCertReqTransaction newCertRequest(int keySize, String subject, int numValidDays, String keyType, String signatureAlgorithm, boolean useShortSubjectKId, List<String> subjectAltNames, List<String> kUsage, List<String> extkUsage, String iaFile, String revoPwd, String dn) throws PkException {
        return new CertRequestImpl(keySize, subject, numValidDays, keyType, signatureAlgorithm, useShortSubjectKId, subjectAltNames, kUsage, extkUsage, iaFile, revoPwd, dn);
    }

    @Deprecated
    public static PkEeCertReqTransaction newCertRequest(int keySize, String subject, int numValidDays, boolean useRSA, boolean useShortSubjectKId, List<String> subjectAltNames, List<String> kUsage, List<String> extkUsage, String iaFile, String revoPwd, String dn, KeyPair keyPair) throws PkException {
        String key = useRSA ? "RSA" : "DSA";
        String sigAlg = "SHA1withRSA";
        if (!useRSA) {
            sigAlg = "SHA1withDSA";
        }
        return new CertRequestImpl(keySize, subject, numValidDays, key, sigAlg, useShortSubjectKId, subjectAltNames, kUsage, extkUsage, iaFile, revoPwd, dn, keyPair);
    }

    public static PkEeCertReqTransaction newCertRequest(int keySize, String subject, int numValidDays, String keyType, String signatureAlgorithm, boolean useShortSubjectKId, List<String> subjectAltNames, List<String> kUsage, List<String> extkUsage, String iaFile, String revoPwd, String dn, KeyPair keyPair) throws PkException {
        return new CertRequestImpl(keySize, subject, numValidDays, keyType, signatureAlgorithm, useShortSubjectKId, subjectAltNames, kUsage, extkUsage, iaFile, revoPwd, dn, keyPair);
    }

    @Deprecated
    public static PkEeCertReqTransaction newCertRequest(String subject, String iaFile, String revoPwd, String dn) throws PkException {
        return new CertRequestImpl(subject, iaFile, revoPwd, dn);
    }

    private static final class CertRequestImpl
    implements PkEeCertReqTransaction {
        private static Debug debug = Debug.getInstance("keycertmanage");
        private final Object className = this.toString();
        private PkEe ee = new PkEe();
        private boolean eeRun = false;

        CertRequestImpl(int keySize, String subject, int numValidDays, String keyType, String signatureAlgorithm, boolean useShortSubjectKId, List<String> subjectAltNames, List<String> kUsage, List<String> extkUsage, String iaFile, String revoPwd, String dn) throws PkException {
            this.ee.setKeyType(keyType);
            this.ee.setKeySize(keySize);
            this.ee.setSignatureAlgorithm(signatureAlgorithm);
            this.ee.setSubject(subject);
            this.ee.setValidity(numValidDays);
            this.ee.setkIdform(useShortSubjectKId);
            this.ee.setSubjectAltNames(subjectAltNames);
            this.ee.setKeyUsage(kUsage);
            this.ee.setExtKeyUsage(extkUsage);
            this.ee.setIafile(iaFile);
            this.ee.setRevoPwd(revoPwd);
            this.ee.setCa_Dn(dn);
            this.ee.setCaPort(PkEeFactory.caPort);
            this.ee.setCaDn(PkEeFactory.caDn);
        }

        CertRequestImpl(int keySize, String subject, int numValidDays, String keyType, String signatureAlgorithm, boolean useShortSubjectKId, List<String> subjectAltNames, List<String> kUsage, List<String> extkUsage, String iaFile, String revoPwd, String dn, KeyPair keyPair) throws PkException {
            this.ee.setKeyType(keyType);
            this.ee.setKeySize(keySize);
            this.ee.setSignatureAlgorithm(signatureAlgorithm);
            this.ee.setSubject(subject);
            this.ee.setValidity(numValidDays);
            this.ee.setkIdform(useShortSubjectKId);
            this.ee.setSubjectAltNames(subjectAltNames);
            this.ee.setKeyUsage(kUsage);
            this.ee.setExtKeyUsage(extkUsage);
            this.ee.setIafile(iaFile);
            this.ee.setRevoPwd(revoPwd);
            this.ee.setKeyPair(keyPair);
            this.ee.setCa_Dn(dn);
            this.ee.setCaPort(PkEeFactory.caPort);
            this.ee.setCaDn(PkEeFactory.caDn);
        }

        @Deprecated
        CertRequestImpl(String subject, String iaFile, String revoPwd, String dn) throws PkException {
            this.ee.setSubject(subject);
            this.ee.setIafile(iaFile);
            this.ee.setRevoPwd(revoPwd);
            this.ee.setCa_Dn(dn);
            this.ee.setKeySize(1024);
            this.ee.setValidity(365);
            this.ee.setKeyType("RSA");
            this.ee.setSignatureAlgorithm("SHA1withRSA");
            this.ee.setkIdform(false);
            this.ee.setCaPort(PkEeFactory.caPort);
            this.ee.setCaDn(PkEeFactory.caDn);
        }

        @Override
        public void setKeyType(String keyType) {
            this.ee.setKeyType(keyType);
        }

        @Override
        public void setKeySize(int keyBits) throws PkException {
            this.ee.setKeySize(keyBits);
        }

        @Override
        public void setValidity(int days) throws PkException {
            this.ee.setValidity(days);
        }

        @Override
        public void setSubjectKeyIdShort(boolean form) {
            this.ee.setkIdform(form);
        }

        @Override
        public void setSubjectAltNames(List<String> subjectAltNames) {
            this.ee.setSubjectAltNamesClear(subjectAltNames);
        }

        @Override
        public void addKeyUsage(List<String> kUsage) {
            this.ee.addKeyUsage(kUsage);
        }

        @Override
        public void addExtKeyUsage(List<String> extKUsage) {
            this.ee.addExtKeyUsage(extKUsage);
        }

        @Override
        public void actionRequest() throws PkException {
            this.runRequest();
        }

        @Override
        public PrivateKey getPrivateKey() {
            if (this.eeRun || this.ee.getPriKey() != null) {
                return this.ee.getPriKey();
            }
            return null;
        }

        @Override
        public PublicKey getPublicKey() {
            if (this.eeRun || this.ee.getPubKey() != null) {
                return this.ee.getPubKey();
            }
            return null;
        }

        @Override
        public KeyPair getKeyPair() {
            if (this.eeRun || this.ee.getKeyPair() != null) {
                return this.ee.getKeyPair();
            }
            return null;
        }

        @Override
        public X509Certificate getSignedCert() {
            if (this.eeRun) {
                return this.ee.getSignedCert();
            }
            return null;
        }

        @Override
        public X509Certificate[] getCertificateChain() {
            if (this.eeRun) {
                return this.ee.getCertificateChain();
            }
            return null;
        }

        @Override
        public void storeNewEntry(String alias, String keyPwd) throws PkException {
            if (!this.eeRun) {
                if (debug != null) {
                    debug.text(1L, this.className, "storeNewEntry", "Signed certificate not created");
                }
                throw new PkRejectionException(PkNLSConstants.EE_MISSING_CERTIFICATE);
            }
            this.ee.keyStore(PkEeFactory.keyStoreType, PkEeFactory.keystoreFilename, PkEeFactory.keystorePwd);
            this.ee.storeEntry(alias, keyPwd);
        }

        @Override
        public byte[] getPKCS10CertReq() throws PkRejectionException {
            try {
                PkAttrs attrs = this.ee.getAttributes();
                X500Name name = (X500Name)attrs.get("x509.info.subject").getValue();
                PublicKey key = (PublicKey)attrs.get("x509.info.key").getValue();
                String provider = (String)attrs.get("cert.oper.PROVIDER").getValue();
                String sigAlg = this.ee.signatureAlgorithm;
                CertificateExtensions cext = new CertificateExtensions();
                if (attrs.has("x509.info.extensions.KeyUsage")) {
                    KeyUsageExtension kue = (KeyUsageExtension)attrs.get("x509.info.extensions.KeyUsage").getValue();
                    cext.set("x509.info.extensions.KeyUsage", kue);
                }
                if (attrs.has("x509.info.extensions.ExtKeyUsage")) {
                    ExtKeyUsageExtension ekue = (ExtKeyUsageExtension)attrs.get("x509.info.extensions.ExtKeyUsage").getValue();
                    cext.set("x509.info.extensions.ExtKeyUsage", ekue);
                }
                if (attrs.has("x509.info.extensions.SubjectAlternativeName")) {
                    SubjectAlternativeNameExtension sane = (SubjectAlternativeNameExtension)attrs.get("x509.info.extensions.SubjectAlternativeName").getValue();
                    cext.set("x509.info.extensions.SubjectAlternativeName", sane);
                }
                if (attrs.has("x509.info.extensions.SubjectKeyIdentifier")) {
                    SubjectKeyIdentifierExtension skie = (SubjectKeyIdentifierExtension)attrs.get("x509.info.extensions.SubjectKeyIdentifier").getValue();
                    cext.set("x509.info.extensions.SubjectKeyIdentifier", skie);
                }
                DerOutputStream extOut = new DerOutputStream();
                cext.encode(extOut, true);
                PKCSAttributes pkAttrs = null;
                if (extOut.size() > 0) {
                    PKCSAttribute pkcsa = new PKCSAttribute(PKCSOID.EXTENSION_REQUEST_OID, cext);
                    pkAttrs = new PKCSAttributes(new PKCSAttribute[]{pkcsa});
                }
                CertificationRequestInfo cri = new CertificationRequestInfo(name, key, pkAttrs, provider);
                CertificationRequest cr = new CertificationRequest(cri, this.ee.getPriKey(), sigAlg, provider);
                return cr.encode();
            }
            catch (IOException ioe) {
                if (debug != null) {
                    debug.exception(4L, this.className, "getPKCS10CertReq", ioe);
                }
                throw new PkRejectionException(PkNLSConstants.CREATE_PKCS10_FROM_CERTREQ_FAILED, ioe);
            }
            catch (CertificateException ce) {
                if (debug != null) {
                    debug.exception(4L, this.className, "getPKCS10CertReq", ce);
                }
                throw new PkRejectionException(PkNLSConstants.CREATE_PKCS10_FROM_CERTREQ_FAILED, ce);
            }
            catch (PKCSException pex) {
                if (debug != null) {
                    debug.exception(4L, this.className, "getPKCS10CertReq", pex);
                }
                throw new PkRejectionException(PkNLSConstants.CREATE_PKCS10_FROM_CERTREQ_FAILED, pex);
            }
            catch (NoSuchAlgorithmException nsae) {
                if (debug != null) {
                    debug.exception(4L, this.className, "getPKCS10CertReq", nsae);
                }
                throw new PkRejectionException(PkNLSConstants.CREATE_PKCS10_FROM_CERTREQ_FAILED, nsae);
            }
        }

        private void runRequest() throws PkException {
            try {
                String host = this.ee.getCaDn();
                int port = this.ee.getCaPort();
                if (debug != null) {
                    debug.text(1L, this.className, "runRequest", "CARA_HOST={0}", host);
                    debug.text(1L, this.className, "runRequest", "RA_CMP_PORT={0}", new Integer(port));
                }
                this.ee.readIAFile();
                PkTcpClient client = new PkTcpClient(host, port, PkEeFactory.getCmpFmt(), 1);
                PkConnector.connect((PkActiveSource)this.ee, new PkPipe[]{new PkEeXMgr(), client}).run();
                if (this.ee.getRunFailed()) {
                    throw this.ee.getRunException();
                }
                this.eeRun = true;
            }
            catch (Exception e2) {
                if (debug != null) {
                    debug.exception(4L, this.className, "runRequest()", e2);
                }
                throw new PkException(e2);
            }
        }
    }

    static final class PkEe
    extends PkActiveSource
    implements PkConstants {
        private String subject;
        private String refNumber;
        private String passPhrase;
        private String iafile;
        private String revoPwd;
        private String CaDn;
        private int caPort;
        private String ca_Dn;
        private KeyStore kstore;
        private int keySize;
        private int numValidDays;
        private String keyType;
        private String signatureAlgorithm;
        private boolean iskIdShortForm;
        private ArrayList<String> keyUsage = new ArrayList(10);
        private ArrayList<String> extKeyUsage = new ArrayList(10);
        private ArrayList<String> subjectAltNames = new ArrayList(5);
        private Exception runException = null;
        private boolean runFailed = false;
        private KeyPair keyPair = null;
        private PrivateKey priKey = null;
        private PublicKey pubKey = null;
        private PkAttrs attributes = null;
        private X509Certificate signedCert = null;
        private X509Certificate[] certificateChain = null;
        private static Debug debug = Debug.getInstance("keycertmanage");
        private final Object className = this.toString();

        protected PkEe() {
            if (debug != null) {
                debug.text(1L, this.className.toString(), "PkEe", "Started End-Entity");
            }
        }

        protected boolean getRunFailed() {
            return this.runFailed;
        }

        protected Exception getRunException() {
            return this.runException;
        }

        protected void setSubject(String subject) throws PkException {
            this.subject = subject;
        }

        protected void setRevoPwd(String revoPwd) {
            this.revoPwd = revoPwd;
        }

        protected void setrefNumber(String refNumber) {
            this.refNumber = refNumber;
        }

        protected void setpassPhrase(String passPhrase) {
            this.passPhrase = passPhrase;
        }

        protected void setIafile(String iafile) throws PkException {
            this.iafile = iafile;
        }

        protected void setCa_Dn(String ca_Dn) {
            this.ca_Dn = ca_Dn != null && ca_Dn.length() != 0 ? ca_Dn : PkEeFactory.getCA_DN();
        }

        protected void setCaDn(String CaDn) {
            this.CaDn = CaDn != null && CaDn.length() != 0 ? CaDn : PkEeFactory.getCaDn();
        }

        protected void setCaPort(int caPort) {
            this.caPort = caPort != 0 ? caPort : PkEeFactory.caPort;
        }

        protected void setKeySize(int keySize) throws PkException {
            if ("DSA".equalsIgnoreCase(this.keyType) ? keySize != 512 && keySize != 1024 && keySize != 2048 : ("EC".equalsIgnoreCase(this.keyType) ? keySize != 192 && keySize != 224 && keySize != 256 && keySize != 384 && keySize != 521 : "RSA".equalsIgnoreCase(this.keyType) && keySize < 512)) {
                throw new PkRejectionException(PkNLSConstants.INVALID_KEY_SIZE + keySize);
            }
            this.keySize = keySize;
        }

        protected void setValidity(int numValidDays) throws PkException {
            if (numValidDays <= 0) {
                throw new PkRejectionException(PkNLSConstants.CERT_BAD_CERT_VALIDITY + numValidDays);
            }
            this.numValidDays = numValidDays;
        }

        protected void setKeyType(String keyType) {
            this.keyType = keyType;
        }

        protected void setSignatureAlgorithm(String signatureAlgorithm) throws PkException {
            boolean ex = false;
            if ("RSA".equalsIgnoreCase(this.keyType)) {
                if (signatureAlgorithm.indexOf("RSA") < 0) {
                    ex = true;
                }
            } else if ("DSA".equalsIgnoreCase(this.keyType)) {
                if (signatureAlgorithm.indexOf("DSA") < 0) {
                    ex = true;
                }
            } else if ("EC".equalsIgnoreCase(this.keyType) && signatureAlgorithm.indexOf("EC") < 0) {
                ex = true;
            }
            if (ex) {
                throw new PkRejectionException(PkNLSConstants.INCORRECT_SIGNATURE_ALGORITHM + signatureAlgorithm);
            }
            this.signatureAlgorithm = signatureAlgorithm;
        }

        protected void setkIdform(boolean useShortSubjectKId) {
            this.iskIdShortForm = useShortSubjectKId;
        }

        protected void setKeyUsage(List<String> kUsage) {
            if (kUsage != null && kUsage.size() > 0) {
                this.keyUsage.addAll(kUsage);
            }
        }

        protected void setKeyPair(KeyPair pair) {
            if (pair != null) {
                this.keyPair = pair;
                this.pubKey = pair.getPublic();
                this.priKey = pair.getPrivate();
            }
        }

        protected void addKeyUsage(List<String> newUsage) {
            if (newUsage != null && newUsage.size() > 0) {
                for (String nextString : newUsage) {
                    if (this.keyUsage.contains(nextString)) continue;
                    this.keyUsage.add(nextString);
                }
            }
        }

        protected void setExtKeyUsage(List<String> kUsage) {
            if (kUsage != null && kUsage.size() > 0) {
                this.extKeyUsage.addAll(kUsage);
            }
        }

        protected void addExtKeyUsage(List<String> newExtKUsage) {
            if (newExtKUsage != null && newExtKUsage.size() > 0) {
                for (String newString : newExtKUsage) {
                    if (this.extKeyUsage.contains(newString)) continue;
                    this.extKeyUsage.add(newString);
                }
            }
        }

        protected void setSubjectAltNames(List<String> subjectAltName) {
            if (subjectAltName != null && subjectAltName.size() > 0) {
                this.subjectAltNames = new ArrayList<String>(subjectAltName);
            }
        }

        protected void setSubjectAltNamesClear(List<String> subjectAltName) {
            this.subjectAltNames = subjectAltName != null && subjectAltName.size() > 0 ? new ArrayList<String>(subjectAltName) : new ArrayList(4);
        }

        protected KeyPair getKeyPair() {
            return this.keyPair;
        }

        protected PublicKey getPubKey() {
            return this.pubKey;
        }

        protected PrivateKey getPriKey() {
            return this.priKey;
        }

        protected X509Certificate getSignedCert() {
            return this.signedCert;
        }

        protected X509Certificate[] getCertificateChain() {
            return this.certificateChain;
        }

        protected PkAttrs getAttributes() throws PkRejectionException {
            this.attributes = this.getAttrs();
            return this.attributes;
        }

        protected String getCa_Dn() {
            return this.ca_Dn;
        }

        protected int getCaPort() {
            return this.caPort;
        }

        protected String getCaDn() {
            return this.CaDn;
        }

        protected void storeEntry(String alias, String pwd) throws PkException {
            try {
                Certificate[] chain = new X509Certificate[]{this.signedCert};
                this.kstore.setKeyEntry(alias, this.priKey, pwd.toCharArray(), chain);
                FileOutputStream file = new FileOutputStream(PkEeFactory.keystoreFilename);
                file = new FileOutputStream(PkEeFactory.keystoreFilename);
                this.kstore.store(file, PkEeFactory.keystorePwd);
                file.close();
            }
            catch (Exception ex) {
                if (debug != null) {
                    debug.exception(4L, this.className, "storeEntry", ex);
                }
                throw new PkException(PkNLSConstants.EE_INVALID_CONFIG_KEYSTORE, ex);
            }
        }

        protected PkAttrs getAttrs() throws PkRejectionException {
            String subject = this.subject;
            String domain = this.getCa_Dn();
            String refNumber = this.refNumber;
            String passPhrase = this.passPhrase;
            String notBefore = new Long(new Date().getTime()).toString();
            long tmp1 = (long)this.numValidDays * 24L * 60L * 60L * 1000L;
            String issuedCertValidity = new Long(tmp1).toString();
            if (debug != null) {
                debug.text(1L, this.className, "makeCertReq", "issuedCertValidity {0}", issuedCertValidity);
            }
            PkAttrs attrs = new PkAttrs();
            Key[] keyPair = null;
            if (this.keyPair == null) {
                if (debug != null) {
                    debug.text(1L, this.className, "getAttrs", "keyPair is null");
                }
                try {
                    keyPair = PkCertUtils.generateKeyPair(this.keyType, this.keySize, null);
                    this.pubKey = (PublicKey)keyPair[0];
                    this.priKey = (PrivateKey)keyPair[1];
                }
                catch (Exception e2) {
                    if (debug != null) {
                        debug.exception(4L, this.className, "getAttrs", e2);
                    }
                    throw new PkRejectionException(PkNLSConstants.KEY_PAIR_CREATION_FAILED, e2);
                }
            }
            JPKI pkcert = new JPKI();
            String[] values = new String[]{subject, domain, "3", refNumber, passPhrase, notBefore, issuedCertValidity};
            try {
                String[] san = null;
                String[] ku = null;
                String[] xku = null;
                this.subjectAltNames.trimToSize();
                this.keyUsage.trimToSize();
                this.extKeyUsage.trimToSize();
                if (this.subjectAltNames.size() > 0) {
                    san = this.subjectAltNames.toArray(new String[0]);
                }
                if (this.keyUsage.size() > 0) {
                    ku = this.keyUsage.toArray(new String[0]);
                }
                if (this.extKeyUsage.size() > 0) {
                    xku = this.extKeyUsage.toArray(new String[0]);
                }
                attrs = pkcert.initialCertRequest(values, san, ku, xku, this.pubKey, this.priKey, this.signatureAlgorithm);
                SubjectKeyIdentifierExtension ski = null;
                byte[] kIDTmp = PkUtils.computeKID(this.pubKey, this.iskIdShortForm);
                ski = new SubjectKeyIdentifierExtension(kIDTmp);
                attrs.repOrAdd("x509.info.extensions.SubjectKeyIdentifier", 3, ski);
            }
            catch (Exception e3) {
                if (debug != null) {
                    debug.exception(4L, this.className, "getAttrs", e3);
                }
                throw new PkRejectionException(PkNLSConstants.CREATE_CERTREQ_FAILED, e3);
            }
            return attrs;
        }

        @Override
        public void run() {
            PkCertRepEvent repTmp = null;
            this.runFailed = false;
            this.runException = null;
            try {
                if (this.attributes == null) {
                    this.attributes = this.getAttrs();
                }
                PkInitReqEvent req = new PkInitReqEvent(this, null, this.attributes);
                repTmp = this.propagate((PkCertReqEvent)req);
            }
            catch (Exception e2) {
                this.runFailed = true;
                this.runException = e2;
                if (debug != null) {
                    debug.exception(4L, this.className, "PkEe.run", e2);
                }
                return;
            }
            this.signedCert = (X509Certificate)repTmp.getCert();
            this.certificateChain = repTmp.getCertificateChain();
            if (debug != null) {
                debug.text(1L, this.className, "PkEe.run", "propagated cert-request");
            }
            PKIMessage msg = (PKIMessage)repTmp.getMsg();
            PKIHeader head = msg.getHeader();
            Object[] values1 = new Object[]{head, this.passPhrase, this.refNumber, this.revoPwd};
            JPKI pkcert = new JPKI();
            try {
                PkConfReqEvent req1 = new PkConfReqEvent(this, null, pkcert.confRequest(values1, null));
                this.propagate(req1);
            }
            catch (Exception e3) {
                this.runFailed = true;
                this.runException = e3;
                if (debug != null) {
                    debug.exception(4L, this.className, "PkEe.run", e3);
                }
                return;
            }
            if (debug != null) {
                debug.text(1L, this.className, "PkEe.run", "propagated conf-request");
            }
        }

        protected void keyStore(String keyStoreType, String fileName, char[] keyStorePwd) throws PkException {
            FileInputStream inp = null;
            this.kstore = null;
            if (keyStorePwd == null) {
                if (debug != null) {
                    debug.text(4L, this.className, "keyStore", "password cannot be null");
                }
                throw new PkException(PkNLSConstants.EE_INVALID_CONFIG_KEYSTORE);
            }
            try {
                this.kstore = KeyStore.getInstance(keyStoreType, PkEeFactory.getProvider());
                try {
                    inp = new FileInputStream(fileName);
                    this.kstore.load(inp, keyStorePwd);
                    inp.close();
                }
                catch (FileNotFoundException e2) {
                    this.kstore.load(null, keyStorePwd);
                    FileOutputStream file = new FileOutputStream(fileName);
                    this.kstore.store(file, keyStorePwd);
                    file.close();
                }
            }
            catch (GeneralSecurityException e3) {
                if (debug != null) {
                    debug.exception(4L, this.className, "keyStore", e3);
                }
                throw new PkException(e3);
            }
            catch (IOException ioe) {
                if (debug != null) {
                    debug.exception(4L, this.className, "keyStore", ioe);
                }
                throw new PkException(ioe);
            }
            catch (Exception e4) {
                if (debug != null) {
                    debug.exception(4L, this.className, "keyStore", e4);
                }
                throw new PkException(e4);
            }
        }

        private void readIAFile() throws PkException {
            File tstFile;
            String fileName = this.iafile;
            if (fileName == null) {
                if (debug != null) {
                    debug.text(1L, this.className, "readIAFile", "iafile cannot be null");
                }
                throw new PkException(PkNLSConstants.IA_FILE_FORMAT_FAILURE);
            }
            try {
                tstFile = new File(fileName);
            }
            catch (NullPointerException npe) {
                if (debug != null) {
                    debug.exception(4L, this.className, "readIAFile", npe);
                }
                throw new PkException("", npe);
            }
            if (tstFile.exists()) {
                try {
                    if (debug != null) {
                        debug.text(1L, this.className, "makeCertReq", "file found now processing");
                    }
                    BufferedReader myRdr = new BufferedReader(new FileReader(fileName));
                    String lineData = myRdr.readLine();
                    this.refNumber = new String(lineData);
                    this.passPhrase = new String(myRdr.readLine());
                    myRdr.close();
                }
                catch (Exception e2) {
                    if (debug != null) {
                        debug.exception(4L, this.className, "readIAFile:" + fileName, e2);
                    }
                    throw new PkException("" + fileName, e2);
                }
            } else {
                if (debug != null) {
                    debug.text(4L, this.className, "readIAFile", PkNLSConstants.IA_FILE_FORMAT_FAILURE);
                }
                throw new PkException(PkNLSConstants.IA_FILE_FORMAT_FAILURE);
            }
        }
    }
}

