/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.util.BitArray;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.GeneralNameInterface;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;

public final class IPAddressName
implements GeneralNameInterface {
    private byte[] address;
    private boolean isIPv4;
    private String name;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.IPAddressName";
    private static final int MASKSIZE = 16;
    private static final int IN6ADDRSZ = 16;
    private static final int INT16SZ = 2;
    private static final int INADDRSZ = 4;

    public IPAddressName(DerValue derValue) throws IOException {
        this(derValue.getOctetString());
        if (debug != null) {
            debug.entry(16384L, (Object)className, "IPAddressName", derValue);
            debug.exit(16384L, className, "IPAddressName");
        }
    }

    public IPAddressName(byte[] address) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "IPAddressName", (Object)address);
        }
        if (address != null) {
            if (address.length == 4 || address.length == 8) {
                this.isIPv4 = true;
            } else if (address.length == 16 || address.length == 32) {
                this.isIPv4 = false;
            } else {
                throw new IOException("Invalid IPAddressName");
            }
            this.address = (byte[])address.clone();
        } else {
            this.address = address;
        }
        if (debug != null) {
            debug.exit(16384L, className, "IPAddressName");
        }
    }

    public IPAddressName(String name) throws IOException {
        if (name == null || name.length() == 0) {
            throw new IOException("IPAddressName cannot be null");
        }
        if (name.charAt(name.length() - 1) == '/') {
            throw new IOException("Invalid IPAddress " + name);
        }
        if (name.indexOf(":") >= 0) {
            this.parseIPv6(name);
            this.isIPv4 = false;
        } else if (name.indexOf(".") >= 0) {
            this.isIPv4 = true;
            int slashNdx = name.indexOf(47);
            if (slashNdx == -1) {
                this.address = IPAddressName.ipv4_getByteArray(name);
                if (this.address == null) {
                    throw new IOException("Invalid IPAddress" + name);
                }
            } else {
                this.address = new byte[8];
                byte[] mask = IPAddressName.ipv4_getByteArray(name.substring(slashNdx + 1));
                byte[] host = IPAddressName.ipv4_getByteArray(name.substring(0, slashNdx));
                if (mask == null || host == null) {
                    throw new IOException("Invalid IPAddress" + name);
                }
                System.arraycopy(host, 0, this.address, 0, 4);
                System.arraycopy(mask, 0, this.address, 4, 4);
            }
        } else {
            throw new IOException("Invalid IPAddressName " + name);
        }
    }

    private void parseIPv6(String name) throws IOException {
        int slashNdx = name.indexOf(47);
        if (slashNdx >= 0) {
            this.address = new byte[32];
            byte[] base = IPAddressName.ipv6_getByteArray(name.substring(0, slashNdx));
            if (base == null) {
                throw new IOException("Invalid IPAddress" + name);
            }
            System.arraycopy(base, 0, this.address, 0, 16);
        } else {
            this.address = IPAddressName.ipv6_getByteArray(name);
            if (this.address == null) {
                throw new IOException("Invalid IPAddress" + name);
            }
        }
        if (slashNdx >= 0) {
            String prefixStr = name.substring(slashNdx + 1);
            int prefixLen = Integer.parseInt(prefixStr);
            if (prefixLen > 128) {
                throw new IOException("Prefix may not be longer than 128");
            }
            BitArray bitArray = new BitArray(128);
            for (int i2 = 0; i2 < prefixLen; ++i2) {
                bitArray.set(i2, true);
            }
            byte[] maskArray = bitArray.toByteArray();
            for (int i3 = 0; i3 < 16; ++i3) {
                this.address[16 + i3] = maskArray[i3];
            }
        }
    }

    @Override
    public int getType() {
        if (debug != null) {
            debug.entry(16384L, className, "getType");
            debug.exit(16384L, (Object)className, "getType", 7);
        }
        return 7;
    }

    @Override
    public void encode(DerOutputStream out) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", out);
        }
        if (this.address != null) {
            out.putOctetString(this.address);
        }
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public String toString() {
        try {
            return "IPAddress: " + this.getName();
        }
        catch (IOException ioe) {
            HexDumpEncoder enc = new HexDumpEncoder();
            return "IPAddress: " + enc.encodeBuffer(this.address);
        }
    }

    public byte[] getBytes() {
        if (this.address != null) {
            return (byte[])this.address.clone();
        }
        return null;
    }

    public String getName() throws IOException {
        String s2 = "";
        if (this.address != null) {
            if (this.isIPv4) {
                s2 = s2 + (this.address[0] & 0xFF) + "." + (this.address[1] & 0xFF) + "." + (this.address[2] & 0xFF) + "." + (this.address[3] & 0xFF);
                if (this.address.length == 8) {
                    s2 = s2 + "/" + (this.address[4] & 0xFF) + "." + (this.address[5] & 0xFF) + "." + (this.address[6] & 0xFF) + "." + (this.address[7] & 0xFF);
                }
            } else {
                String sep = "";
                int len = this.address.length;
                for (int i2 = 0; i2 < 8; ++i2) {
                    int comp = ((this.address[i2 * 2] & 0xFF) << 8) + (this.address[i2 * 2 + 1] & 0xFF);
                    String compStr = Integer.toHexString(comp);
                    if (compStr.length() > 4) {
                        compStr = compStr.substring(compStr.length() - 4, compStr.length());
                    }
                    sep = i2 == 7 ? (len == 16 ? "" : "/") : ":";
                    s2 = s2 + compStr + sep;
                }
                if (len == 32) {
                    int i3;
                    byte[] maskBytes = new byte[16];
                    for (int i4 = 16; i4 < 32; ++i4) {
                        maskBytes[i4 - 16] = this.address[i4];
                    }
                    BitArray ba = new BitArray(128, maskBytes);
                    for (i3 = 0; i3 < 128 && ba.get(i3); ++i3) {
                    }
                    s2 = s2 + i3;
                    while (i3 < 128) {
                        if (ba.get(i3)) {
                            throw new IOException("Invalid IPv6 subdomain - set bit " + i3 + " not contiguous");
                        }
                        ++i3;
                    }
                }
            }
        }
        return s2;
    }

    static byte[] ipv6_getByteArray(String src) {
        byte[] srcb = null;
        try {
            srcb = src.getBytes("8859_1");
        }
        catch (UnsupportedEncodingException ex) {
            if (debug != null) {
                debug.exception(16384L, className, "ipv6_getByteArray", ex);
            }
            srcb = src.getBytes();
        }
        byte[] dst = new byte[16];
        int colonp = -1;
        int i2 = 0;
        int j2 = 0;
        if (srcb[i2] == 58 && srcb[++i2] != 58) {
            return null;
        }
        boolean saw_xdigit = false;
        int val = 0;
        while (i2 < srcb.length) {
            byte ch;
            int chval;
            if ((chval = Character.digit((char)(ch = srcb[i2++]), 16)) != -1) {
                val <<= 4;
                if ((val |= chval) > 65535) {
                    return null;
                }
                saw_xdigit = true;
                continue;
            }
            if (ch == 58) {
                if (!saw_xdigit) {
                    if (colonp != -1) {
                        return null;
                    }
                    colonp = j2;
                    continue;
                }
                if (i2 == srcb.length) {
                    return null;
                }
                if (j2 + 2 > 16) {
                    return null;
                }
                dst[j2++] = (byte)(val >> 8 & 0xFF);
                dst[j2++] = (byte)(val & 0xFF);
                saw_xdigit = false;
                val = 0;
                continue;
            }
            if (ch == 46 && j2 + 4 <= 16) {
                byte[] v4addr = IPAddressName.ipv4_getByteArray(src.substring(i2));
                for (int k2 = 0; k2 < 4; ++k2) {
                    dst[j2++] = v4addr[k2];
                }
                saw_xdigit = false;
                break;
            }
            return null;
        }
        if (saw_xdigit) {
            if (j2 + 2 > 16) {
                return null;
            }
            dst[j2++] = (byte)(val >> 8 & 0xFF);
            dst[j2++] = (byte)(val & 0xFF);
        }
        if (colonp != -1) {
            int n2 = j2 - colonp;
            if (j2 == 16) {
                return null;
            }
            for (i2 = 1; i2 <= n2; ++i2) {
                dst[16 - i2] = dst[colonp + n2 - i2];
                dst[colonp + n2 - i2] = 0;
            }
            j2 = 16;
        }
        if (j2 != 16) {
            return null;
        }
        return dst;
    }

    static byte[] ipv4_getByteArray(String src) {
        byte[] dst = new byte[4];
        byte[] srcb = null;
        try {
            srcb = src.getBytes("8859_1");
        }
        catch (UnsupportedEncodingException ex) {
            if (debug != null) {
                debug.exception(16384L, className, "ipv4_getByteArray", ex);
            }
            srcb = src.getBytes();
        }
        boolean saw_digit = false;
        int octets = 0;
        int i2 = 0;
        int cur = 0;
        while (i2 < srcb.length) {
            byte ch;
            if (Character.isDigit((char)(ch = srcb[i2++]))) {
                dst[cur] = (byte)(dst[cur] * 10 + (Character.digit((char)ch, 10) & 0xFF));
                if (dst[cur] > 255) {
                    return null;
                }
                if (saw_digit) continue;
                if (++octets > 4) {
                    return null;
                }
                saw_digit = true;
                continue;
            }
            if (ch == 46 && saw_digit) {
                if (octets == 4) {
                    return null;
                }
                dst[++cur] = 0;
                saw_digit = false;
                continue;
            }
            return null;
        }
        if (octets < 4) {
            return null;
        }
        return dst;
    }

    @Override
    public int constrains(GeneralNameInterface inputName) throws UnsupportedOperationException {
        int constraintType;
        if (this.address == null) {
            return 2;
        }
        if (inputName == null) {
            constraintType = -1;
        } else if (inputName.getType() != 7) {
            constraintType = -1;
        } else if (((IPAddressName)inputName).equals(this)) {
            constraintType = 0;
        } else {
            byte[] otherAddress = ((IPAddressName)inputName).getBytes();
            if (otherAddress.length == 4 && this.address.length == 4) {
                constraintType = 3;
            } else if (otherAddress.length == 8 && this.address.length == 8 || otherAddress.length == 32 && this.address.length == 32) {
                boolean otherSubsetOfThis = true;
                boolean thisSubsetOfOther = true;
                boolean thisEmpty = false;
                boolean otherEmpty = false;
                int maskOffset = this.address.length / 2;
                for (int i2 = 0; i2 < maskOffset; ++i2) {
                    if ((byte)(this.address[i2] & this.address[i2 + maskOffset]) != this.address[i2]) {
                        thisEmpty = true;
                    }
                    if ((byte)(otherAddress[i2] & otherAddress[i2 + maskOffset]) != otherAddress[i2]) {
                        otherEmpty = true;
                    }
                    if ((byte)(this.address[i2 + maskOffset] & otherAddress[i2 + maskOffset]) != this.address[i2 + maskOffset] || (byte)(this.address[i2] & this.address[i2 + maskOffset]) != (byte)(otherAddress[i2] & this.address[i2 + maskOffset])) {
                        otherSubsetOfThis = false;
                    }
                    if ((byte)(otherAddress[i2 + maskOffset] & this.address[i2 + maskOffset]) == otherAddress[i2 + maskOffset] && (byte)(otherAddress[i2] & otherAddress[i2 + maskOffset]) == (byte)(this.address[i2] & otherAddress[i2 + maskOffset])) continue;
                    thisSubsetOfOther = false;
                }
                constraintType = thisEmpty || otherEmpty ? (thisEmpty && otherEmpty ? 0 : (thisEmpty ? 2 : 1)) : (otherSubsetOfThis ? 1 : (thisSubsetOfOther ? 2 : 3));
            } else if (otherAddress.length == 8 || otherAddress.length == 32) {
                int i3;
                int maskOffset = otherAddress.length / 2;
                for (i3 = 0; i3 < maskOffset && (this.address[i3] & otherAddress[i3 + maskOffset]) == otherAddress[i3]; ++i3) {
                }
                constraintType = i3 == maskOffset ? 2 : 3;
            } else if (this.address.length == 8 || this.address.length == 32) {
                int i4;
                int maskOffset = this.address.length / 2;
                for (i4 = 0; i4 < maskOffset && (otherAddress[i4] & this.address[i4 + maskOffset]) == this.address[i4]; ++i4) {
                }
                constraintType = i4 == maskOffset ? 1 : 3;
            } else {
                constraintType = 3;
            }
        }
        return constraintType;
    }

    @Override
    public int subtreeDepth() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("subtreeDepth() not defined for IPAddressName");
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IPAddressName)) {
            return false;
        }
        byte[] other = ((IPAddressName)obj).getBytes();
        if (other == null) {
            return this.address == null;
        }
        if (this.address == null) {
            return false;
        }
        if (other.length != this.address.length) {
            return false;
        }
        if (this.address.length == 8 || this.address.length == 32) {
            int i2;
            int maskLen = this.address.length / 2;
            byte[] maskedThis = new byte[maskLen];
            byte[] maskedOther = new byte[maskLen];
            for (i2 = 0; i2 < maskLen; ++i2) {
                maskedThis[i2] = (byte)(this.address[i2] & this.address[i2 + maskLen]);
                maskedOther[i2] = (byte)(other[i2] & other[i2 + maskLen]);
                if (maskedThis[i2] == maskedOther[i2]) continue;
                return false;
            }
            for (i2 = maskLen; i2 < this.address.length; ++i2) {
                if (this.address[i2] == other[i2]) continue;
                return false;
            }
            return true;
        }
        return Arrays.equals(other, this.address);
    }

    public int hashCode() {
        int retval = 0;
        if (this.address != null) {
            for (int i2 = 0; i2 < this.address.length; ++i2) {
                retval += this.address[i2] * i2;
            }
        }
        return retval;
    }
}

