/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.common.jwk.impl;

import com.ibm.json.java.JSONObject;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.jwk.interfaces.JWK;
import com.ibm.ws.security.common.random.RandomUtils;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.RsaJsonWebKey;
import org.jose4j.lang.JoseException;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class Jose4jRsaJWK
extends RsaJsonWebKey
implements JWK {
    private static final long serialVersionUID = 1L;
    private static final TraceComponent tc = Tr.register(Jose4jRsaJWK.class, (String)"SecurityCommonJWK", (String)"com.ibm.ws.security.common.jwk.internal.resources.JWKCommonMessages");
    private static final int KID_LENGTH = 20;
    protected long created = new Date().getTime();

    /*
     * WARNING - void declaration
     */
    public static Jose4jRsaJWK getInstance(int size, String alg, String use, String type) {
        String kid = RandomUtils.getRandomAlphaNumeric((int)20);
        KeyPairGenerator keyGenerator = null;
        try {
            keyGenerator = KeyPairGenerator.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            FFDCFilter.processException((Throwable)noSuchAlgorithmException, (String)"com.ibm.ws.security.common.jwk.impl.Jose4jRsaJWK", (String)"66", null, (Object[])new Object[]{size, alg, use, type});
            if (tc.isDebugEnabled()) {
                void e;
                Tr.debug((TraceComponent)tc, (String)("Caught unexpected exception: " + e.getLocalizedMessage()), (Object[])new Object[]{e});
            }
            return null;
        }
        keyGenerator.initialize(size);
        KeyPair keypair = keyGenerator.generateKeyPair();
        RSAPublicKey pubKey = (RSAPublicKey)keypair.getPublic();
        RSAPrivateKey priKey = (RSAPrivateKey)keypair.getPrivate();
        Jose4jRsaJWK jwk = new Jose4jRsaJWK(pubKey);
        jwk.setPrivateKey(priKey);
        jwk.setAlgorithm(alg);
        jwk.setKeyId(kid);
        jwk.setUse(use == null ? "sig" : use);
        return jwk;
    }

    /*
     * WARNING - void declaration
     */
    public static Jose4jRsaJWK getInstance(JSONObject keyObject) {
        Jose4jRsaJWK jwk;
        block4: {
            HashMap<String, Object> params = new HashMap<String, Object>();
            Set entries = keyObject.entrySet();
            for (Map.Entry entry : entries) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Entry key:" + (String)entry.getKey() + " value:" + entry.getValue().toString()), (Object[])new Object[0]);
                }
                params.put((String)entry.getKey(), entry.getValue());
            }
            jwk = null;
            try {
                jwk = new Jose4jRsaJWK(params);
            }
            catch (JoseException entry) {
                void e;
                FFDCFilter.processException((Throwable)entry, (String)"com.ibm.ws.security.common.jwk.impl.Jose4jRsaJWK", (String)"108", null, (Object[])new Object[]{keyObject});
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)("Caught unexpected exception: " + e.getLocalizedMessage()), (Object[])new Object[]{e});
            }
        }
        return jwk;
    }

    public static Jose4jRsaJWK getInstance(String alg, String use, PublicKey publicKey, PrivateKey privateKey, String kid) {
        RSAPublicKey pubKey = (RSAPublicKey)publicKey;
        RSAPrivateKey priKey = (RSAPrivateKey)privateKey;
        Jose4jRsaJWK jwk = new Jose4jRsaJWK(pubKey);
        jwk.setPrivateKey(priKey);
        jwk.setAlgorithm(alg);
        jwk.setKeyId(kid);
        jwk.setUse(use == null ? "sig" : use);
        return jwk;
    }

    public Jose4jRsaJWK(RSAPublicKey publicKey) {
        super(publicKey);
    }

    public Jose4jRsaJWK(Map<String, Object> params) throws JoseException {
        super(params);
    }

    public String getKeyID() {
        return this.getKeyId();
    }

    public String getKeyX5t() {
        return this.getX509CertificateSha1Thumbprint();
    }

    public String getKeyUse() {
        return this.getUse();
    }

    public byte[] getSharedKey() {
        return null;
    }

    public long getCreated() {
        return this.created;
    }

    @Override
    public void parse() {
    }

    @Override
    public void generateKey() {
    }

    @Override
    public JSONObject getJsonObject() {
        Map params = this.toParams(JsonWebKey.OutputControlLevel.INCLUDE_SYMMETRIC);
        JSONObject jsonObject = new JSONObject();
        this.addProp(jsonObject, params, "kid");
        this.addProp(jsonObject, params, "use");
        this.addProp(jsonObject, params, "alg");
        this.addProp(jsonObject, params, "kty");
        this.addProp(jsonObject, params, "n");
        this.addProp(jsonObject, params, "e");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"JSON Web Key:", (Object[])new Object[]{jsonObject});
        }
        return jsonObject;
    }

    protected void addProp(JSONObject jsonObject, Map<String, Object> params, String key) {
        Object obj = params.get(key);
        if (obj == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Key:" + key + " returned null"), (Object[])new Object[0]);
            }
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Key:" + key + " json-type:" + obj.toString()), (Object[])new Object[0]);
        }
        if (obj instanceof String) {
            jsonObject.put((Object)key, (Object)((String)obj));
        } else if (obj instanceof JSONObject) {
            jsonObject.put((Object)key, (Object)((JSONObject)obj).toString());
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Error json type:" + obj.getClass().getName() + " value:" + obj.toString()), (Object[])new Object[0]);
            }
            jsonObject.put((Object)key, (Object)((JSONObject)obj).toString());
        }
    }
}

