/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsoc;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.wsoc.EndpointMethodHelper;
import com.ibm.ws.wsoc.MethodData;
import com.ibm.ws.wsoc.impl.MethodDataImpl;
import com.ibm.ws.wsoc.util.Utils;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.websocket.CloseReason;
import javax.websocket.DecodeException;
import javax.websocket.Decoder;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.PongMessage;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpointConfig;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class AnnotatedEndpoint
extends Endpoint
implements Cloneable {
    private static final TraceComponent tc = Tr.register(AnnotatedEndpoint.class, (String)"websockets", (String)"com.ibm.ws.wsoc.internal.resources.WebSockets");
    private Class<?> sepClass = null;
    private Object appInstance = null;
    private EndpointMethodHelper onError = null;
    private EndpointMethodHelper onClose = null;
    private EndpointMethodHelper onOpen = null;
    private EndpointMethodHelper onMessageText = null;
    private EndpointMethodHelper onMessageBinary = null;
    private EndpointMethodHelper onMessagePong = null;
    private String endpointPath = null;
    private String requestPath = null;
    private boolean shouldProcessPath = true;
    private static final Class<?>[] messageTextTypesAllowed = new Class[]{String.class, Reader.class, Character.TYPE, Character.class, Byte.TYPE, Byte.class, Short.TYPE, Short.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, Float.TYPE, Float.class, Double.TYPE, Double.class, Boolean.TYPE, Boolean.class};
    private static List<Class<?>> messageTextTypesList = Arrays.asList(messageTextTypesAllowed);
    private static final Class<?>[] messageBinaryTypesAllowed = new Class[]{ByteBuffer.class, InputStream.class, byte[].class};
    private static List<Class<?>> messageBinaryTypesList = Arrays.asList(messageBinaryTypesAllowed);
    private static final Class<?>[] messagePongTypesAllowed = new Class[]{PongMessage.class};
    private static List<Class<?>> messagePongTypesList = Arrays.asList(messagePongTypesAllowed);
    static final long serialVersionUID = -1843994030589059901L;

    public void initialize(Class<?> clazz, EndpointConfig endpointConfig) throws DeploymentException {
        this.initialize(clazz, endpointConfig, true);
    }

    public void initialize(Class<?> clazz, EndpointConfig endpointConfig, boolean isServer) throws DeploymentException {
        if (!this.isValid(clazz, isServer)) {
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"invalid.endpointclass", (Object[])new Object[]{clazz.getName()});
            Tr.error((TraceComponent)tc, (String)"invalid.endpointclass", (Object[])new Object[]{clazz.getName()});
            throw new DeploymentException(msg);
        }
        this.sepClass = clazz;
        this.shouldProcessPath = isServer;
        if (this.shouldProcessPath) {
            this.endpointPath = ((ServerEndpointConfig)endpointConfig).getPath();
        }
        this.processOnMessage(clazz, endpointConfig);
        this.processOpenCloseError(this.sepClass);
        if (this.onOpen == null && this.onMessageText == null && this.onMessageBinary == null && this.onMessagePong == null) {
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"missing.annotation", (Object[])new Object[]{clazz.getName()});
            Tr.error((TraceComponent)tc, (String)"missing.annotation", (Object[])new Object[]{clazz.getName()});
            throw new DeploymentException(msg);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Annotated Endpoint: " + clazz + " initialized with endpoint : " + this.endpointPath + " onMessageText :" + this.onMessageText + " onMessageBinary :" + this.onMessageBinary + " onMessagePong :" + this.onMessagePong + " onOpen :" + this.onOpen + " onError :" + this.onError + " onClose :" + this.onClose), (Object[])new Object[0]);
        }
    }

    public void setAppInstance(Object instance) {
        this.appInstance = instance;
    }

    public boolean isValid(Class<?> clazz, boolean needsNoArgConstructor) {
        boolean valid = false;
        int modifiers = clazz.getModifiers();
        if (Modifier.isPublic(modifiers) && !Modifier.isAbstract(modifiers)) {
            if (needsNoArgConstructor) {
                Constructor<?>[] constructors;
                for (Constructor<?> constructor : constructors = clazz.getConstructors()) {
                    if (constructor.getParameterTypes().length != 0 || !Modifier.isPublic(constructor.getModifiers())) continue;
                    valid = true;
                    break;
                }
            } else {
                valid = true;
            }
        }
        return valid;
    }

    public void onOpen(Session session, EndpointConfig config) {
        if (this.onOpen != null) {
            try {
                int configIndex;
                Object[] args = new Object[this.onOpen.getMethod().getParameterTypes().length];
                MethodData methodData = this.onOpen.getMethodData();
                int sessionIndex = methodData.getSessionIndex();
                if (sessionIndex >= 0) {
                    args[sessionIndex] = session;
                }
                if ((configIndex = methodData.getEndpointConfigIndex()) >= 0) {
                    args[configIndex] = config;
                }
                if (this.shouldProcessPath) {
                    try {
                        this.onOpen.processPathParameters(this, args);
                    }
                    catch (DecodeException decodeException) {
                        FFDCFilter.processException((Throwable)decodeException, (String)"com.ibm.ws.wsoc.AnnotatedEndpoint", (String)"178", (Object)this, (Object[])new Object[]{session, config});
                        return;
                    }
                }
                this.onOpen.getMethod().invoke(this.appInstance, args);
            }
            catch (IllegalAccessException illegalAccessException) {
                FFDCFilter.processException((Throwable)illegalAccessException, (String)"com.ibm.ws.wsoc.AnnotatedEndpoint", (String)"187", (Object)this, (Object[])new Object[]{session, config});
            }
            catch (IllegalArgumentException illegalArgumentException) {
                FFDCFilter.processException((Throwable)illegalArgumentException, (String)"com.ibm.ws.wsoc.AnnotatedEndpoint", (String)"189", (Object)this, (Object[])new Object[]{session, config});
            }
            catch (InvocationTargetException invocationTargetException) {
                FFDCFilter.processException((Throwable)invocationTargetException, (String)"com.ibm.ws.wsoc.AnnotatedEndpoint", (String)"191", (Object)this, (Object[])new Object[]{session, config});
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void onClose(Session session, CloseReason closeReason) {
        if (this.onClose != null) {
            int reasonIndex;
            Object[] args = new Object[this.onClose.getMethod().getParameterTypes().length];
            MethodData methodData = this.onClose.getMethodData();
            int sessionIndex = methodData.getSessionIndex();
            if (sessionIndex >= 0) {
                args[sessionIndex] = session;
            }
            if ((reasonIndex = methodData.getCloseReasonIndex()) >= 0) {
                args[reasonIndex] = closeReason;
            }
            if (this.shouldProcessPath) {
                try {
                    this.onClose.processPathParameters(this, args);
                }
                catch (DecodeException decodeException) {
                    void e;
                    FFDCFilter.processException((Throwable)decodeException, (String)"com.ibm.ws.wsoc.AnnotatedEndpoint", (String)"221", (Object)this, (Object[])new Object[]{session, closeReason});
                    this.onError(session, (Throwable)e);
                    return;
                }
            }
            try {
                if (this.appInstance == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"application instance is null in onClose", (Object[])new Object[0]);
                    }
                    return;
                }
                this.onClose.getMethod().invoke(this.appInstance, args);
            }
            catch (IllegalAccessException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.wsoc.AnnotatedEndpoint", (String)"245", (Object)this, (Object[])new Object[]{session, closeReason});
                this.onError(session, e);
            }
            catch (IllegalArgumentException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.wsoc.AnnotatedEndpoint", (String)"249", (Object)this, (Object[])new Object[]{session, closeReason});
                this.onError(session, e);
            }
            catch (InvocationTargetException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.wsoc.AnnotatedEndpoint", (String)"251", (Object)this, (Object[])new Object[]{session, closeReason});
                this.onError(session, e);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("onClose() is called on Endpoint class: " + this.sepClass + " which does not have onClose method defined"), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void onError(Session session, Throwable thr) {
        if (this.onError != null) {
            int throableIndx;
            Object[] args = new Object[this.onError.getMethod().getParameterTypes().length];
            MethodData methodData = this.onError.getMethodData();
            int sessionIndex = methodData.getSessionIndex();
            if (sessionIndex >= 0) {
                args[sessionIndex] = session;
            }
            if ((throableIndx = methodData.getThrowableIndex()) >= 0) {
                args[throableIndx] = thr;
            }
            if (this.shouldProcessPath) {
                try {
                    this.onError.processPathParameters(this, args);
                }
                catch (DecodeException decodeException) {
                    void e;
                    FFDCFilter.processException((Throwable)decodeException, (String)"com.ibm.ws.wsoc.AnnotatedEndpoint", (String)"284", (Object)this, (Object[])new Object[]{session, thr});
                    thr = e;
                }
            }
            try {
                if (this.appInstance == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"application instance is null in onError", (Object[])new Object[0]);
                    }
                    return;
                }
                this.onError.getMethod().invoke(this.appInstance, args);
            }
            catch (IllegalAccessException illegalAccessException) {
                FFDCFilter.processException((Throwable)illegalAccessException, (String)"com.ibm.ws.wsoc.AnnotatedEndpoint", (String)"307", (Object)this, (Object[])new Object[]{session, thr});
            }
            catch (IllegalArgumentException illegalArgumentException) {
                FFDCFilter.processException((Throwable)illegalArgumentException, (String)"com.ibm.ws.wsoc.AnnotatedEndpoint", (String)"309", (Object)this, (Object[])new Object[]{session, thr});
            }
            catch (InvocationTargetException invocationTargetException) {
                FFDCFilter.processException((Throwable)invocationTargetException, (String)"com.ibm.ws.wsoc.AnnotatedEndpoint", (String)"311", (Object)this, (Object[])new Object[]{session, thr});
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Trying to report error: '" + thr.getMessage() + "' calling onError(). However onError() is not defined on the endpoint: " + this.sepClass.getName()), (Object[])new Object[0]);
            }
            FFDCFilter.processException((Throwable)thr, (String)this.getClass().getName(), (String)"288", (Object)this);
        }
    }

    public EndpointMethodHelper getOnMessageTextMethod() {
        return this.onMessageText;
    }

    public EndpointMethodHelper getOnMessageBinaryMethod() {
        return this.onMessageBinary;
    }

    public EndpointMethodHelper getOnMessagePongMethod() {
        return this.onMessagePong;
    }

    public Object getAppInstance() {
        return this.appInstance;
    }

    private void processOnMessage(Class<?> clazz, EndpointConfig endpointConfig) throws DeploymentException {
        boolean onMsgBinaryProcessed = false;
        boolean onMsgPongProcessed = false;
        boolean onMsgTextProcessed = false;
        Method[] methods = this.getDeclaredMethodsPrivileged(clazz);
        EndpointMethodHelper onMessageTextLocal = null;
        EndpointMethodHelper onMessageBinaryLocal = null;
        EndpointMethodHelper onMessagePongLocal = null;
        for (Method method : methods) {
            if (!method.isAnnotationPresent(OnMessage.class)) continue;
            onMessagePongLocal = this.discoverOnMessagePongMethodAnnotation(clazz, method);
            if (onMessagePongLocal.getMethodData().getMessageType() != null) {
                if (onMsgPongProcessed) {
                    String msg = Tr.formatMessage((TraceComponent)tc, (String)"morethanonepong.annotation", (Object[])new Object[]{clazz.getName()});
                    Tr.error((TraceComponent)tc, (String)"morethanonepong.annotation", (Object[])new Object[]{clazz.getName()});
                    throw new DeploymentException(msg);
                }
                this.onMessagePong = onMessagePongLocal;
                onMsgPongProcessed = true;
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("Pong @OnMessage found: Path: " + this.endpointPath + "Endpoint Class: " + clazz.getName() + " Method name: " + this.onMessagePong.method.getName() + " Message Type: " + onMessagePongLocal.getMethodData().getMessageType() + " Message index: " + onMessagePongLocal.getMethodData().getMessageIndex() + " Session index: " + onMessagePongLocal.getMethodData().getSessionIndex()), (Object[])new Object[0]);
                continue;
            }
            onMessageBinaryLocal = this.discoverOnMessageBinaryMethodAnnotation(clazz, endpointConfig, method);
            if (onMessageBinaryLocal.getMethodData().getMessageType() != null) {
                if (onMsgBinaryProcessed) {
                    String msg = Tr.formatMessage((TraceComponent)tc, (String)"morethanonebinary.annotation", (Object[])new Object[]{clazz.getName()});
                    Tr.error((TraceComponent)tc, (String)"morethanonebinary.annotation", (Object[])new Object[]{clazz.getName()});
                    throw new DeploymentException(msg);
                }
                this.onMessageBinary = onMessageBinaryLocal;
                onMsgBinaryProcessed = true;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Binary @OnMessage found: Path: " + this.endpointPath + "Endpoint Class: " + clazz.getName() + " Method name: " + this.onMessageBinary.method.getName() + " Message Type: " + this.onMessageBinary.getMethodData().getMessageType() + " Message index: " + this.onMessageBinary.getMethodData().getMessageIndex() + " Session index: " + this.onMessageBinary.getMethodData().getSessionIndex()), (Object[])new Object[0]);
                }
                this.setMaxMessageSize(method, onMessageBinaryLocal);
                continue;
            }
            onMessageTextLocal = this.discoverOnMessageTextMethodAnnotation(clazz, endpointConfig, method);
            if (onMessageTextLocal.getMethodData().getMessageType() == null) {
                String msg = Tr.formatMessage((TraceComponent)tc, (String)"missing.msgtype.param", (Object[])new Object[]{clazz.getName()});
                Tr.error((TraceComponent)tc, (String)"missing.msgtype.param", (Object[])new Object[]{clazz.getName()});
                throw new DeploymentException(msg);
            }
            if (onMsgTextProcessed) {
                String msg = Tr.formatMessage((TraceComponent)tc, (String)"morethanonetext.annotation", (Object[])new Object[]{clazz.getName()});
                Tr.error((TraceComponent)tc, (String)"morethanonetext.annotation", (Object[])new Object[]{clazz.getName()});
                throw new DeploymentException(msg);
            }
            this.onMessageText = onMessageTextLocal;
            onMsgTextProcessed = true;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Text @OnMessage found: Path: " + this.endpointPath + "Endpoint Class: " + clazz.getName() + " Method name: " + this.onMessageText.method.getName() + " Message Type: " + this.onMessageText.getMethodData().getMessageType() + " Message index: " + this.onMessageText.getMethodData().getMessageIndex() + " Session index: " + this.onMessageText.getMethodData().getSessionIndex()), (Object[])new Object[0]);
            }
            this.setMaxMessageSize(method, onMessageTextLocal);
        }
    }

    private void processOpenCloseError(Class<?> c) throws DeploymentException {
        Method[] methods;
        for (Method method : methods = this.getDeclaredMethodsPrivileged(c)) {
            if (method.isAnnotationPresent(OnOpen.class)) {
                this.processOnOpen(c, method);
            }
            if (method.isAnnotationPresent(OnClose.class)) {
                this.processOnClose(c, method);
            }
            if (!method.isAnnotationPresent(OnError.class)) continue;
            this.processOnError(c, method);
        }
    }

    private void processOnOpen(Class<?> c, Method method) throws DeploymentException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("OnOpen method found in ServerEndpoint class: " + c.getName() + " Method name: " + method.getName()), (Object[])new Object[0]);
        }
        if (this.onOpen != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Two @OnOpen methods on the Annotated endpoint found method 1: " + this.onOpen.getMethod() + "  method 2: " + method), (Object[])new Object[0]);
            }
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"morethanoneonopen.annotation", (Object[])new Object[]{this.onOpen.getMethod().getName(), method.getName()});
            Tr.error((TraceComponent)tc, (String)"morethanoneonopen.annotation", (Object[])new Object[]{this.onOpen.getMethod().getName(), method.getName()});
            throw new DeploymentException(msg);
        }
        this.onOpen = this.initializeEpMethodHelper(method);
        MethodData methodData = this.onOpen.getMethodData();
        Class<?>[] params = method.getParameterTypes();
        for (int i = 0; i < params.length; ++i) {
            Class<?> param = params[i];
            if (methodData.getPathParams() != null && methodData.getPathParams().containsKey(i)) continue;
            if (param.equals(Session.class)) {
                methodData.setSessionIndex(i);
                continue;
            }
            if (param.equals(EndpointConfig.class)) {
                methodData.setEndpointConfigIndex(i);
                continue;
            }
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"invalid.onopen.annotation", (Object[])new Object[]{this.onOpen.getMethod().getName(), c.getName()});
            Tr.error((TraceComponent)tc, (String)"invalid.onopen.annotation", (Object[])new Object[]{this.onOpen.getMethod().getName(), c.getName()});
            this.onOpen = null;
            throw new DeploymentException(msg);
        }
    }

    private void processOnClose(Class<?> c, Method method) throws DeploymentException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("OnClose method found in ServerEndpoint class: " + c.getName() + " Method name: " + method.getName()), (Object[])new Object[0]);
        }
        if (this.onClose != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Two @OnClose methods on the same Annotated endpoint method 1: " + this.onClose.getMethod().getName() + "  method 2: " + method.getName()), (Object[])new Object[0]);
            }
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"morethanoneclose.annotation", (Object[])new Object[]{c.getName(), this.onClose.getMethod().getName(), method.getName()});
            Tr.error((TraceComponent)tc, (String)"morethanoneclose.annotation", (Object[])new Object[]{c.getName(), this.onClose.getMethod().getName(), method.getName()});
            this.onClose = null;
            throw new DeploymentException(msg);
        }
        this.onClose = this.initializeEpMethodHelper(method);
        MethodData methodData = this.onClose.getMethodData();
        Class<?>[] params = method.getParameterTypes();
        for (int i = 0; i < params.length; ++i) {
            Class<?> param = params[i];
            if (methodData.getPathParams() != null && methodData.getPathParams().containsKey(i)) continue;
            if (param.equals(Session.class)) {
                methodData.setSessionIndex(i);
                continue;
            }
            if (param.equals(CloseReason.class)) {
                methodData.setCloseReasonIndex(i);
                continue;
            }
            this.onClose = null;
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"invalid.onclose.annotation", (Object[])new Object[]{method.getName(), c.getName()});
            Tr.error((TraceComponent)tc, (String)"invalid.onclose.annotation", (Object[])new Object[]{method.getName(), c.getName()});
            throw new DeploymentException(msg);
        }
    }

    private void processOnError(Class<?> c, Method method) throws DeploymentException {
        boolean onErrorProcessed = false;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("OnError method found in ServerEndpoint class: " + c.getName() + " Method name: " + method.getName()), (Object[])new Object[0]);
        }
        if (this.onError != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Two @OnError methods on the same Annotated endpoint " + c.getName() + " method 1: " + this.onError.getMethod() + "  method 2: " + method), (Object[])new Object[0]);
            }
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"morethanoneerror.annotation", (Object[])new Object[]{c.getName(), this.onError.getMethod().getName(), method.getName()});
            Tr.error((TraceComponent)tc, (String)"morethanoneerror.annotation", (Object[])new Object[]{c.getName(), this.onError.getMethod().getName(), method.getName()});
            this.onError = null;
            throw new DeploymentException(msg);
        }
        this.onError = this.initializeEpMethodHelper(method);
        MethodData methodData = this.onError.getMethodData();
        Class<?>[] params = method.getParameterTypes();
        for (int i = 0; i < params.length; ++i) {
            Class<?> param = params[i];
            if (methodData.getPathParams() != null && methodData.getPathParams().containsKey(i)) continue;
            if (param.equals(Session.class)) {
                methodData.setSessionIndex(i);
                continue;
            }
            if (param.equals(Throwable.class)) {
                methodData.setThrowableIndex(i);
                onErrorProcessed = true;
                continue;
            }
            this.onError = null;
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"invalid.onerror.annotation", (Object[])new Object[]{method.getName(), c.getName()});
            Tr.error((TraceComponent)tc, (String)"invalid.onerror.annotation", (Object[])new Object[]{method.getName(), c.getName()});
            throw new DeploymentException(msg);
        }
        if (!onErrorProcessed) {
            this.onError = null;
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"missing.throwable", (Object[])new Object[]{method.getName(), c.getName()});
            Tr.error((TraceComponent)tc, (String)"missing.throwable", (Object[])new Object[]{method.getName(), c.getName()});
            throw new DeploymentException(msg);
        }
    }

    private EndpointMethodHelper initializeEpMethodHelper(Method method) throws DeploymentException {
        EndpointMethodHelper epMethodHelper = new EndpointMethodHelper(method);
        MethodDataImpl methodData = new MethodDataImpl();
        epMethodHelper.setMethodData(methodData);
        if (this.shouldProcessPath) {
            epMethodHelper.setEndpointPath(this.endpointPath);
            epMethodHelper.introspectPathParams();
        }
        return epMethodHelper;
    }

    private EndpointMethodHelper discoverOnMessagePongMethodAnnotation(Class<?> c, Method method) throws DeploymentException {
        MethodDataImpl methodData = null;
        EndpointMethodHelper methodHelper = null;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("@OnMessage method found in ServerEndpoint class: " + c.getName() + " Method name: " + method.getName()), (Object[])new Object[0]);
        }
        methodHelper = new EndpointMethodHelper(method);
        methodData = new MethodDataImpl();
        methodHelper.setMethodData(methodData);
        if (this.shouldProcessPath) {
            methodHelper.setEndpointPath(this.endpointPath);
            methodHelper.introspectPathParams();
        }
        Class<?>[] params = method.getParameterTypes();
        for (int i = 0; i < params.length; ++i) {
            Class<?> param = params[i];
            if (methodData.getPathParams() != null && methodData.getPathParams().containsKey(i)) continue;
            if (param.equals(Session.class)) {
                methodData.setSessionIndex(i);
                continue;
            }
            if (messagePongTypesList.contains(param)) {
                if (methodData.getMessageType() != null) continue;
                methodData.setMessageType(param);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("In discoverOnMessagePongMethodAnnotation: Path: " + this.endpointPath + "Endpoint Class: " + c.getName() + " Method name: " + method.getName() + " MethodHelper instance: " + methodHelper + " Setting MessageType in methodData: " + methodData + " param: " + param), (Object[])new Object[0]);
                }
                methodData.setMessageIndex(i);
                continue;
            }
            if (methodData.getMessageType() == null) continue;
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"invalid.pong.annotation", (Object[])new Object[]{method.getName(), c.getName(), param.getName()});
            Tr.error((TraceComponent)tc, (String)"invalid.pong.annotation", (Object[])new Object[]{method.getName(), c.getName(), param.getName()});
            throw new DeploymentException(msg);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Class name: " + c.getName() + " Method name: " + methodHelper.method.getName() + " Message Type: " + methodData.getMessageType() + " Message index: " + methodData.getMessageIndex() + " Session index: " + methodData.getSessionIndex()), (Object[])new Object[0]);
        }
        return methodHelper;
    }

    private EndpointMethodHelper discoverOnMessageBinaryMethodAnnotation(Class<?> c, EndpointConfig endpointConfig, Method method) throws DeploymentException {
        List<Class> decoders = endpointConfig.getDecoders();
        if (decoders == null) {
            decoders = Collections.emptyList();
        }
        EndpointMethodHelper methodHelper = null;
        methodHelper = new EndpointMethodHelper(method);
        MethodDataImpl methodData = new MethodDataImpl();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("In discoverOnMessageBinaryMethodAnnotation: Path: " + this.endpointPath + "Endpoint Class: " + c.getName() + " Method name: " + method.getName() + " New MethodHelper instance: " + methodHelper + " New methodData instance: " + methodData), (Object[])new Object[0]);
        }
        methodHelper.setMethodData(methodData);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("In discoverOnMessageBinaryMethodAnnotation: Path: " + this.endpointPath + "Endpoint Class: " + c.getName() + " Method name: " + method.getName() + " MethodHelper instance: " + methodHelper + " Setting methodData instance to method helper: " + methodData), (Object[])new Object[0]);
        }
        if (this.shouldProcessPath) {
            methodHelper.setEndpointPath(this.endpointPath);
            methodHelper.introspectPathParams();
        }
        Class<?>[] params = method.getParameterTypes();
        for (int i = 0; i < params.length; ++i) {
            Object msg;
            Class<?> param = params[i];
            if (methodData.getPathParams() != null && methodData.getPathParams().containsKey(i)) continue;
            if (param.equals(Session.class)) {
                methodData.setSessionIndex(i);
                continue;
            }
            if (messageBinaryTypesList.contains(param) || param.equals(Boolean.TYPE)) {
                if (methodData.getMessageType() == null) {
                    if (param.equals(Boolean.TYPE)) {
                        methodData.setMsgBooleanPairIndex(i);
                        continue;
                    }
                    methodData.setMessageType(param);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("In discoverOnMessageBinaryMethodAnnotation: Path: " + this.endpointPath + "Endpoint Class: " + c.getName() + " Method name: " + method.getName() + " MethodHelper instance: " + methodHelper + " Setting MessageType in methodData: " + methodData + " param: " + param), (Object[])new Object[0]);
                    }
                    methodData.setMessageIndex(i);
                    continue;
                }
                if (param.equals(Boolean.TYPE)) {
                    if (methodData.getMessageType().equals(byte[].class) || methodData.getMessageType().equals(ByteBuffer.class)) {
                        methodData.setMsgBooleanPairIndex(i);
                        continue;
                    }
                    msg = Tr.formatMessage((TraceComponent)tc, (String)"invalid.binary.param", (Object[])new Object[]{method.getName(), c.getName(), param.getClass().getName()});
                    Tr.error((TraceComponent)tc, (String)"invalid.binary.param", (Object[])new Object[]{method.getName(), c.getName(), param.getClass().getName()});
                    throw new DeploymentException((String)msg);
                }
                msg = Tr.formatMessage((TraceComponent)tc, (String)"morethanone.binary.param", (Object[])new Object[]{method.getName(), c.getName(), param.getClass().getName()});
                Tr.error((TraceComponent)tc, (String)"morethanone.binary.param", (Object[])new Object[]{method.getName(), c.getName(), param.getClass().getName()});
                throw new DeploymentException((String)msg);
            }
            if (decoders.size() > 0) {
                for (Class decoder : decoders) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("looking at decoder: " + decoder), (Object[])new Object[0]);
                    }
                    if (!this.isValid(decoder, true)) {
                        String msg2 = Tr.formatMessage((TraceComponent)tc, (String)"invalid.decoderclass", (Object[])new Object[]{decoder.getName(), param.getClass().getName(), c.getName()});
                        Tr.error((TraceComponent)tc, (String)"invalid.decoderclass", (Object[])new Object[]{decoder.getName(), param.getClass().getName(), c.getName()});
                        throw new DeploymentException(msg2);
                    }
                    ArrayList<Type> interfaces = new ArrayList<Type>();
                    Utils.getAllInterfaces(decoder, interfaces);
                    Object[] ta = interfaces.toArray();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("ta[]: " + Arrays.toString(ta)), (Object[])new Object[0]);
                    }
                    for (Object t : ta) {
                        Type t2;
                        Class<?> clazz2;
                        Type[] ta2;
                        ParameterizedType pt;
                        Type rawType;
                        if (!((Type)t instanceof ParameterizedType)) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)(t + " is instanceof ParameterizedType"), (Object[])new Object[0]);
                        }
                        if (!((rawType = (pt = (ParameterizedType)t).getRawType()) instanceof Class)) continue;
                        Class clazz = (Class)rawType;
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("rawType: " + decoder), (Object[])new Object[0]);
                        }
                        if (clazz.equals(Decoder.Binary.class) && (ta2 = pt.getActualTypeArguments()).length == 1 && (clazz2 = Utils.getClassByType(t2 = ta2[0])) != null && param.equals(clazz2)) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Found match: " + clazz2), (Object[])new Object[0]);
                            }
                            if (methodData.getMessageType() == null) {
                                methodData.setMessageType(param);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)("In discoverOnMessageBinaryMethodAnnotation: Path: " + this.endpointPath + "Endpoint Class: " + c.getName() + " Method name: " + method.getName() + " MethodHelper instance: " + methodHelper + " Setting MessageType in methodData: " + methodData + " param: " + param), (Object[])new Object[0]);
                                }
                                methodData.setMessageIndex(i);
                            } else if (methodData.getMessageType() != param) {
                                String msg3 = Tr.formatMessage((TraceComponent)tc, (String)"morethanone.message.param", (Object[])new Object[]{method.getName(), c.getName(), param.getName()});
                                Tr.error((TraceComponent)tc, (String)"morethanone.message.param", (Object[])new Object[]{method.getName(), c.getName(), param.getName()});
                                throw new DeploymentException(msg3);
                            }
                        }
                        if (!clazz.equals(Decoder.BinaryStream.class) || (ta2 = pt.getActualTypeArguments()).length != 1 || (clazz2 = Utils.getClassByType(t2 = ta2[0])) == null || !param.equals(clazz2)) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Found match: " + clazz2), (Object[])new Object[0]);
                        }
                        if (methodData.getMessageType() == null) {
                            methodData.setMessageType(param);
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("In discoverOnMessageBinaryMethodAnnotation: Path: " + this.endpointPath + "Endpoint Class: " + c.getName() + " Method name: " + method.getName() + " MethodHelper instance: " + methodHelper + " Setting MessageType in methodData: " + methodData + " param: " + param), (Object[])new Object[0]);
                            }
                            methodData.setMessageIndex(i);
                            continue;
                        }
                        if (methodData.getMessageType() == param) continue;
                        String msg4 = Tr.formatMessage((TraceComponent)tc, (String)"morethanone.message.param", (Object[])new Object[]{method.getName(), c.getName(), param.getName()});
                        Tr.error((TraceComponent)tc, (String)"morethanone.message.param", (Object[])new Object[]{method.getName(), c.getName(), param.getName()});
                        throw new DeploymentException(msg4);
                    }
                }
                continue;
            }
            if (methodData.getMessageType() == null) continue;
            msg = Tr.formatMessage((TraceComponent)tc, (String)"invalid.binary.param", (Object[])new Object[]{method.getName(), c.getName(), param.getClass().getName()});
            Tr.error((TraceComponent)tc, (String)"invalid.binary.param", (Object[])new Object[]{method.getName(), c.getName(), param.getClass().getName()});
            throw new DeploymentException((String)msg);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Class name: " + c.getName() + " Method name: " + methodHelper.method.getName() + " Message Type: " + methodData.getMessageType() + " Message index: " + methodData.getMessageIndex() + " Boolean Pair index: " + methodData.getMsgBooleanPairIndex() + " Session index: " + methodData.getSessionIndex()), (Object[])new Object[0]);
        }
        return methodHelper;
    }

    private EndpointMethodHelper discoverOnMessageTextMethodAnnotation(Class<?> c, EndpointConfig endpointConfig, Method method) throws IllegalStateException, DeploymentException {
        List<Class> decoders = endpointConfig.getDecoders();
        if (decoders == null) {
            decoders = Collections.emptyList();
        }
        EndpointMethodHelper methodHelper = null;
        MethodDataImpl methodData = null;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("@OnMessage method found in ServerEndpoint class: " + c.getName() + " Method name: " + method.getName()), (Object[])new Object[0]);
        }
        methodHelper = new EndpointMethodHelper(method);
        methodData = new MethodDataImpl();
        methodHelper.setMethodData(methodData);
        if (this.shouldProcessPath) {
            methodHelper.setEndpointPath(this.endpointPath);
            methodHelper.introspectPathParams();
        }
        Class<?>[] params = method.getParameterTypes();
        int booleanIndex = -1;
        for (int i = 0; i < params.length; ++i) {
            Object msg;
            Class<?> param = params[i];
            if (methodData.getPathParams() != null && methodData.getPathParams().containsKey(i)) continue;
            if (param.equals(Session.class)) {
                methodData.setSessionIndex(i);
                continue;
            }
            if (messageTextTypesList.contains(param)) {
                if (methodData.getMessageType() == null) {
                    if (param.equals(Boolean.TYPE)) {
                        booleanIndex = i;
                    }
                    methodData.setMessageType(param);
                    methodData.setMessageIndex(i);
                    continue;
                }
                if (param.equals(Boolean.TYPE)) {
                    if (methodData.getMessageType().equals(String.class)) {
                        methodData.setMsgBooleanPairIndex(i);
                        continue;
                    }
                    msg = Tr.formatMessage((TraceComponent)tc, (String)"invalid.text.param", (Object[])new Object[]{method.getName(), c.getName(), param.getClass().getName()});
                    Tr.error((TraceComponent)tc, (String)"invalid.text.param", (Object[])new Object[]{method.getName(), c.getName(), param.getClass().getName()});
                    throw new DeploymentException((String)msg);
                }
                if (param.equals(String.class) && !methodData.getMessageType().equals(String.class)) {
                    methodData.setMessageType(param);
                    methodData.setMessageIndex(i);
                    if (booleanIndex == -1) continue;
                    methodData.setMsgBooleanPairIndex(i);
                    continue;
                }
                msg = Tr.formatMessage((TraceComponent)tc, (String)"morethanone.text.param", (Object[])new Object[]{method.getName(), c.getName(), param.getName()});
                Tr.error((TraceComponent)tc, (String)"morethanone.text.param", (Object[])new Object[]{method.getName(), c.getName(), param.getName()});
                throw new DeploymentException((String)msg);
            }
            if (decoders.size() > 0) {
                for (Class decoder : decoders) {
                    Object[] ta;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("looking at decoder: " + decoder), (Object[])new Object[0]);
                    }
                    if (!this.isValid(decoder, true)) {
                        String msg2 = Tr.formatMessage((TraceComponent)tc, (String)"invalid.decoderclass", (Object[])new Object[]{decoder.getName(), method.getName(), c.getName()});
                        Tr.error((TraceComponent)tc, (String)"invalid.decoderclass", (Object[])new Object[]{decoder.getName(), method.getName(), c.getName()});
                        throw new DeploymentException(msg2);
                    }
                    ArrayList<Type> interfaces = new ArrayList<Type>();
                    Utils.getAllInterfaces(decoder, interfaces);
                    for (Object t : ta = interfaces.toArray()) {
                        Type t2;
                        Class<?> clazz2;
                        Type[] ta2;
                        ParameterizedType pt;
                        Type rawType;
                        if (!((Type)t instanceof ParameterizedType) || !((rawType = (pt = (ParameterizedType)t).getRawType()) instanceof Class)) continue;
                        Class clazz = (Class)rawType;
                        if (clazz.equals(Decoder.Text.class) && (ta2 = pt.getActualTypeArguments()).length == 1 && (clazz2 = Utils.getClassByType(t2 = ta2[0])) != null && param.equals(clazz2)) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Found decoder match: " + clazz2), (Object[])new Object[0]);
                            }
                            if (methodData.getMessageType() == null) {
                                methodData.setMessageType(param);
                                methodData.setMessageIndex(i);
                            } else if (methodData.getMessageType() != param) {
                                String msg3 = Tr.formatMessage((TraceComponent)tc, (String)"morethanone.message.param", (Object[])new Object[]{method.getName(), c.getName(), param.getName()});
                                Tr.error((TraceComponent)tc, (String)"morethanone.message.param", (Object[])new Object[]{method.getName(), c.getName(), param.getName()});
                                throw new DeploymentException(msg3);
                            }
                        }
                        if (!clazz.equals(Decoder.TextStream.class) || (ta2 = pt.getActualTypeArguments()).length != 1 || (clazz2 = Utils.getClassByType(t2 = ta2[0])) == null || !param.equals(clazz2)) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Found decoder match: " + clazz2), (Object[])new Object[0]);
                        }
                        if (methodData.getMessageType() == null) {
                            methodData.setMessageType(param);
                            methodData.setMessageIndex(i);
                            continue;
                        }
                        if (methodData.getMessageType() == param) continue;
                        String msg4 = Tr.formatMessage((TraceComponent)tc, (String)"morethanone.message.param", (Object[])new Object[]{method.getName(), c.getName(), param.getName()});
                        Tr.error((TraceComponent)tc, (String)"morethanone.message.param", (Object[])new Object[]{method.getName(), c.getName(), param.getName()});
                        throw new DeploymentException(msg4);
                    }
                }
                continue;
            }
            if (methodData.getMessageType() == null) continue;
            msg = Tr.formatMessage((TraceComponent)tc, (String)"invalid.text.param", (Object[])new Object[]{method.getName(), c.getName(), param.getClass().getName()});
            Tr.error((TraceComponent)tc, (String)"invalid.text.param", (Object[])new Object[]{method.getName(), c.getName(), param.getClass().getName()});
            throw new DeploymentException((String)msg);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Class name: " + c.getName() + " Method name: " + methodHelper.method.getName() + " Message Type: " + methodData.getMessageType() + " Message index: " + methodData.getMessageIndex() + " Boolean Pair index: " + methodData.getMsgBooleanPairIndex() + " Session index: " + methodData.getSessionIndex()), (Object[])new Object[0]);
        }
        return methodHelper;
    }

    public String getEndpointPath() {
        return this.endpointPath;
    }

    public String getRequestPath() {
        return this.requestPath;
    }

    public void setRequestPath(String requestPath) {
        this.requestPath = requestPath;
    }

    public Object clone() throws CloneNotSupportedException {
        AnnotatedEndpoint clone = (AnnotatedEndpoint)super.clone();
        clone.onError = this.onError != null ? (EndpointMethodHelper)this.onError.clone() : null;
        clone.onClose = this.onClose != null ? (EndpointMethodHelper)this.onClose.clone() : null;
        clone.onMessageText = this.onMessageText != null ? (EndpointMethodHelper)this.onMessageText.clone() : null;
        clone.onMessageBinary = this.onMessageBinary != null ? (EndpointMethodHelper)this.onMessageBinary.clone() : null;
        clone.onMessagePong = this.onMessagePong != null ? (EndpointMethodHelper)this.onMessagePong.clone() : null;
        clone.endpointPath = String.copyValueOf(this.endpointPath.toCharArray());
        return clone;
    }

    public Class<?> getServerEndpointClass() {
        return this.sepClass;
    }

    private void setMaxMessageSize(Method method, EndpointMethodHelper endpointMethodHelper) {
        OnMessage onMsgAnnotation = method.getAnnotation(OnMessage.class);
        Long maxMessageSize = onMsgAnnotation.maxMessageSize();
        if (maxMessageSize < -1L) {
            maxMessageSize = -1L;
        }
        endpointMethodHelper.getMethodData().setMaxMessageSize(maxMessageSize);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setMaxMessageSize: maxMessageSize from annotation: " + maxMessageSize), (Object[])new Object[0]);
        }
    }

    private Method[] getDeclaredMethodsPrivileged(final Class<?> clazz) {
        return AccessController.doPrivileged(new PrivilegedAction<Method[]>(){
            static final long serialVersionUID = -7130784288314539102L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Method[] run() {
                return clazz.getDeclaredMethods();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.wsoc.AnnotatedEndpoint$1", 1.class, (String)"websockets", (String)"com.ibm.ws.wsoc.internal.resources.WebSockets");
            }
        });
    }
}

