/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.microprofile.client;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.core.Configuration;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.util.ClassHelper;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.jaxrs.model.ProviderInfo;
import org.apache.cxf.jaxrs.provider.ProviderFactory;
import org.apache.cxf.message.Message;
import org.apache.cxf.microprofile.client.ContractComparator;
import org.apache.cxf.microprofile.client.MicroProfileClientFactoryBean;
import org.eclipse.microprofile.rest.client.ext.ResponseExceptionMapper;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public final class MicroProfileClientProviderFactory
extends ProviderFactory {
    private static final TraceComponent tc = Tr.register(MicroProfileClientProviderFactory.class, null, null);
    static final String CLIENT_FACTORY_NAME = MicroProfileClientProviderFactory.class.getName();
    private List<ProviderInfo<ResponseExceptionMapper<?>>> responseExceptionMappers = new ArrayList(1);
    private List<ProviderInfo<Object>> asyncInvocationInterceptorFactories = new ArrayList<ProviderInfo<Object>>();
    private final Comparator<ProviderInfo<?>> comparator;
    static final long serialVersionUID = 4069403607104942119L;

    private MicroProfileClientProviderFactory(Bus bus, Comparator<ProviderInfo<?>> comparator) {
        super(bus);
        this.comparator = comparator;
    }

    public static MicroProfileClientProviderFactory createInstance(Bus bus, Comparator<ProviderInfo<?>> comparator) {
        if (bus == null) {
            bus = BusFactory.getThreadDefaultBus();
        }
        MicroProfileClientProviderFactory factory = new MicroProfileClientProviderFactory(bus, comparator);
        ProviderFactory.initFactory((ProviderFactory)factory);
        factory.setBusProviders();
        return factory;
    }

    public static MicroProfileClientProviderFactory getInstance(Message m) {
        Endpoint e = m.getExchange().getEndpoint();
        return MicroProfileClientProviderFactory.getInstance(e);
    }

    public static MicroProfileClientProviderFactory getInstance(Endpoint e) {
        return (MicroProfileClientProviderFactory)((Object)e.get((Object)CLIENT_FACTORY_NAME));
    }

    static Comparator<ProviderInfo<?>> createComparator(MicroProfileClientFactoryBean bean) {
        Comparator parent = ProviderFactory::compareCustomStatus;
        return new ContractComparator(bean, parent);
    }

    @FFDCIgnore(value={ClassNotFoundException.class})
    protected void setProviders(boolean custom, boolean busGlobal, Object ... providers) {
        List theProviders = this.prepareProviders(custom, busGlobal, providers, null);
        super.setCommonProviders(theProviders);
        for (ProviderInfo provider : theProviders) {
            Class providerCls = ClassHelper.getRealClass((Bus)this.getBus(), (Object)provider.getProvider());
            if (ResponseExceptionMapper.class.isAssignableFrom(providerCls)) {
                this.addProviderToList(this.responseExceptionMappers, provider);
            }
            String className = "org.eclipse.microprofile.rest.client.ext.AsyncInvocationInterceptorFactory";
            try {
                Class asyncIIFactoryClass = ClassLoaderUtils.loadClass((String)className, MicroProfileClientProviderFactory.class);
                if (!asyncIIFactoryClass.isAssignableFrom(providerCls)) continue;
                this.addProviderToList(this.asyncInvocationInterceptorFactories, provider);
            }
            catch (ClassNotFoundException ex) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("Could not load " + className + " - this is expected in MP Rest Client 1.0"), (Object[])new Object[]{ex});
            }
        }
        this.responseExceptionMappers.sort(this.comparator);
        this.asyncInvocationInterceptorFactories.sort(this.comparator);
        this.injectContextProxies(new Collection[]{this.responseExceptionMappers});
        this.injectContextProxies(new Collection[]{this.asyncInvocationInterceptorFactories});
    }

    public List<ResponseExceptionMapper<?>> createResponseExceptionMapper(Message m, Class<?> paramType) {
        if (this.responseExceptionMappers.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.responseExceptionMappers.stream().map(ProviderInfo::getProvider).sorted(new ResponseExceptionMapperComparator()).collect(Collectors.toList()));
    }

    public List<ProviderInfo<Object>> getAsyncInvocationInterceptorFactories() {
        return this.asyncInvocationInterceptorFactories;
    }

    public void clearProviders() {
        super.clearProviders();
        this.responseExceptionMappers.clear();
        this.asyncInvocationInterceptorFactories.clear();
    }

    public Configuration getConfiguration(Message m) {
        return (Configuration)m.getExchange().getOutMessage().getContextualProperty(Configuration.class.getName());
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class ResponseExceptionMapperComparator
    implements Comparator<ResponseExceptionMapper<?>> {
        static final long serialVersionUID = -7576502504950732135L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private ResponseExceptionMapperComparator() {
        }

        @Override
        public int compare(ResponseExceptionMapper<?> oLeft, ResponseExceptionMapper<?> oRight) {
            return oLeft.getPriority() - oRight.getPriority();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.apache.cxf.microprofile.client.MicroProfileClientProviderFactory$ResponseExceptionMapperComparator", ResponseExceptionMapperComparator.class, null, null);
        }
    }
}

