/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.osgi.response;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.servlet.request.IRequest;
import com.ibm.websphere.servlet.response.IResponse;
import com.ibm.ws.http.channel.outstream.HttpOutputStreamConnectWeb;
import com.ibm.ws.webcontainer.osgi.response.WCOutputStream;
import com.ibm.wsspi.http.HttpCookie;
import com.ibm.wsspi.http.HttpInboundConnection;
import com.ibm.wsspi.http.HttpResponse;
import com.ibm.wsspi.webcontainer.WebContainerRequestState;
import com.ibm.wsspi.webcontainer.util.WrappingEnumeration;
import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;

public class IResponseImpl
implements IResponse {
    private HttpInboundConnection conn = null;
    protected IRequest request = null;
    protected HttpResponse response = null;
    private boolean allocateDirect = false;
    protected WCOutputStream outStream = null;
    private static final TraceComponent tc = Tr.register(IResponseImpl.class, (String)"webcontainer", (String)"com.ibm.ws.webcontainer.resources.LShimMessages");

    public IResponseImpl(IRequest req, HttpInboundConnection connection) {
        this.conn = connection;
        this.request = req;
        this.response = this.conn.getResponse();
        this.allocateDirect = false;
    }

    @Override
    public void addCookie(Cookie cookie) {
        String cookieAttributes;
        String methodName = "addCookie";
        String cookieName = cookie.getName();
        HttpCookie hc = new HttpCookie(cookieName, cookie.getValue());
        hc.setPath(cookie.getPath());
        hc.setVersion(cookie.getVersion());
        hc.setComment(cookie.getComment());
        hc.setDomain(cookie.getDomain());
        hc.setMaxAge(cookie.getMaxAge());
        hc.setSecure(cookie.getSecure());
        hc.setHttpOnly(cookie.isHttpOnly());
        WebContainerRequestState requestState = WebContainerRequestState.getInstance(false);
        if (requestState != null && (cookieAttributes = requestState.getCookieAttributes(cookieName)) != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)methodName, (Object[])new Object[]{"cookieName: " + cookieName + " cookieAttribute: " + cookieAttributes});
            }
            if (cookieAttributes.contains("=")) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)methodName, (Object[])new Object[]{"Setting the cookieAttribute on the HttpCookie"});
                }
                String[] attribute = cookieAttributes.split("=");
                hc.setAttribute(attribute[0], attribute[1]);
            }
            requestState.removeCookieAttributes(cookieName);
        }
        this.response.addCookie(hc);
    }

    @Override
    public void addDateHeader(String name, long t) {
        this.response.addHeader(name, this.conn.getDateFormatter().getRFC1123Time(new Date(t)));
    }

    @Override
    public void addHeader(String name, String value) {
        this.response.addHeader(name, value);
    }

    @Override
    public void addHeader(byte[] name, byte[] value) {
        this.response.addHeader(new String(name), new String(value));
    }

    @Override
    public void addIntHeader(String name, int i) {
        this.response.addHeader(name, Integer.toString(i));
    }

    @Override
    public void clearHeaders() {
        this.response.removeAllHeaders();
    }

    @Override
    public boolean containsHeader(String name) {
        return null != this.response.getHeader(name);
    }

    @Override
    public boolean containsHeader(byte[] name) {
        return this.containsHeader(new String(name));
    }

    @Override
    public void flushBufferedContent() {
    }

    @Override
    public boolean getFlushMode() {
        return false;
    }

    @Override
    public ServletOutputStream getOutputStream() throws IOException {
        if (null == this.outStream) {
            this.outStream = new WCOutputStream((HttpOutputStreamConnectWeb)this.response.getBody());
        }
        return this.outStream;
    }

    @Override
    public boolean isAllocateDirect() {
        return this.allocateDirect;
    }

    @Override
    public boolean isCommitted() {
        return this.response.isCommitted();
    }

    @Override
    public void prepareHeadersForWrite() {
    }

    @Override
    public void removeHeader(String name) {
        this.response.removeHeader(name);
    }

    @Override
    public void removeHeader(byte[] name) {
        this.response.removeHeader(new String(name));
    }

    @Override
    public void setAllocateDirect(boolean allocateDirect) {
        this.allocateDirect = allocateDirect;
    }

    @Override
    public void setContentLanguage(String value) {
        if (this.response.getHeader("Content-Language") != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"setContentLanguage(String)", (Object[])new Object[]{"Ignored as the Content-Language already set"});
            }
            return;
        }
        this.response.setHeader("Content-Language", value);
    }

    @Override
    public void setContentLength(int length) {
        this.response.setContentLength((long)length);
    }

    @Override
    public void setContentLanguage(byte[] value) {
        if (this.response.getHeader("Content-Language") != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"setContentLanguage(byte[])", (Object[])new Object[]{"Ignored as the Content-Language already set"});
            }
            return;
        }
        this.response.setHeader("Content-Language", new String(value));
    }

    @Override
    public void setContentType(String value) {
        this.response.setHeader("Content-Type", value);
    }

    @Override
    public void setContentType(byte[] value) {
        this.response.setHeader("Content-Type", new String(value));
    }

    @Override
    public void setDateHeader(String name, long t) {
        this.response.setHeader(name, this.conn.getDateFormatter().getRFC1123Time(new Date(t)));
    }

    @Override
    public void setFlushMode(boolean flushToWire) {
    }

    @Override
    public void setIsClosing(boolean isClosing) {
        this.outStream.setIsClosing(isClosing);
    }

    @Override
    public void setHeader(String name, String s) {
        this.response.setHeader(name, s);
    }

    @Override
    public void setHeader(byte[] name, byte[] bs) {
        this.response.setHeader(new String(name), new String(bs));
    }

    @Override
    public void setIntHeader(String name, int i) {
        this.setHeader(name, Integer.toString(i));
    }

    @Override
    public void setLastBuffer(boolean writeLastBuffer) {
    }

    @Override
    public void setReason(String reason) {
        this.response.setReason(reason);
    }

    @Override
    public void setReason(byte[] reason) {
        this.response.setReason(new String(reason));
    }

    @Override
    public void setStatusCode(int code) {
        this.response.setStatus(code);
    }

    @Override
    public void writeHeaders() {
        try {
            this.response.getBody().flushHeaders();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void flushBuffer() throws IOException {
        this.response.getBody().flush(false);
    }

    @Override
    public int getBufferSize() {
        return this.response.getBody().getBufferSize();
    }

    @Override
    public void resetBuffer() {
        this.response.getBody().clear();
    }

    @Override
    public void setBufferSize(int bufferSize) {
        this.response.getBody().setBufferSize(bufferSize);
    }

    private Cookie convertHttpCookie(HttpCookie cookie) {
        Cookie rc = new Cookie(cookie.getName(), cookie.getValue());
        rc.setVersion(cookie.getVersion());
        if (null != cookie.getPath()) {
            rc.setPath(cookie.getPath());
        }
        if (null != cookie.getDomain()) {
            rc.setDomain(cookie.getDomain());
        }
        rc.setMaxAge(cookie.getMaxAge());
        rc.setSecure(cookie.isSecure());
        return rc;
    }

    @Override
    public Cookie[] getCookies() {
        List cookies = this.response.getCookies();
        if (null == cookies) {
            return new Cookie[0];
        }
        Cookie[] rc = new Cookie[cookies.size()];
        int i = 0;
        for (HttpCookie cookie : cookies) {
            rc[i++] = this.convertHttpCookie(cookie);
        }
        return rc;
    }

    @Override
    public String getHeader(String name) {
        return this.response.getHeader(name);
    }

    @Override
    public String getHeader(byte[] name) {
        return this.response.getHeader(new String(name));
    }

    @Override
    public Vector[] getHeaderTable() {
        List names = this.response.getHeaderNames();
        Vector[] table = new Vector[]{new Vector(names.size()), new Vector(names.size())};
        for (String name : names) {
            List values = this.response.getHeaders(name);
            for (String value : values) {
                table[0].add(name);
                table[1].add(value);
            }
        }
        return table;
    }

    @Override
    public IRequest getWCCRequest() {
        return this.request;
    }

    @Override
    public void releaseChannel() {
        if (this.conn != null && this.request.isStartAsync()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("releaseChannel for this IResponseImpl: " + this + " and this HttpInboundConnection: " + this.conn), (Object[])new Object[0]);
            }
            this.conn.finish(null);
        }
    }

    @Override
    public Enumeration getHeaderNames() {
        List responseHeaders = this.response.getHeaderNames();
        return new WrappingEnumeration(responseHeaders);
    }

    @Override
    public Enumeration getHeaders(String name) {
        List responseHeadersForName = this.response.getHeaders(name);
        return new WrappingEnumeration(responseHeadersForName);
    }

    @Override
    public void removeCookie(String cookieName) {
        List cookies = this.response.getCookies(cookieName);
        for (HttpCookie cookie : cookies) {
            this.response.removeCookie(cookie);
        }
    }
}

