/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.jdbc;

import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.FFDCSelfIntrospectable;
import com.ibm.ws.jca.adapter.WSConnectionManager;
import com.ibm.ws.jdbc.WSDataSource;
import com.ibm.ws.resource.ResourceRefConfig;
import com.ibm.ws.resource.ResourceRefConfigFactory;
import com.ibm.ws.resource.ResourceRefInfo;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.DSConfig;
import com.ibm.ws.rsadapter.FFDCLogger;
import com.ibm.ws.rsadapter.impl.WSConnectionRequestInfoImpl;
import com.ibm.ws.rsadapter.impl.WSManagedConnectionFactoryImpl;
import com.ibm.ws.rsadapter.jdbc.SerializedDataSourceWrapper;
import com.ibm.ws.rsadapter.jdbc.WSJdbcConnection;
import com.ibm.ws.rsadapter.jdbc.WSJdbcTracer;
import com.ibm.ws.rsadapter.jdbc.WSJdbcUtil;
import com.ibm.ws.rsadapter.jdbc.WSJdbcWrapper;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.wsspi.kernel.service.utils.FilterUtils;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;
import javax.sql.DataSource;

public class WSJdbcDataSource
extends WSJdbcWrapper
implements DataSource,
FFDCSelfIntrospectable,
WSDataSource {
    private static final TraceComponent tc = Tr.register(WSJdbcDataSource.class, (String)"RRA", (String)"com.ibm.ws.rsadapter.resources.IBMDataStoreAdapterNLS");
    protected WSConnectionManager cm;
    private ResourceRefInfo resRefInfo;
    private final transient AtomicReference<Class<?>[]> vendorConnectionInterfaces = new AtomicReference();

    public WSJdbcDataSource(WSManagedConnectionFactoryImpl mcf, WSConnectionManager connMgr) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object[])new Object[]{mcf, connMgr});
        }
        this.mcf = mcf;
        this.cm = connMgr;
        this.resRefInfo = this.cm.getResourceRefInfo();
        this.dsConfig = mcf.dsConfig;
        if (this.resRefInfo != null) {
            J2EEName j2eeName;
            ComponentMetaDataAccessorImpl cmpMDAccessor = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor();
            ComponentMetaData cmd = cmpMDAccessor.getComponentMetaData();
            J2EEName j2EEName = j2eeName = cmd != null ? cmd.getJ2EEName() : null;
            if (isTraceOn && tc.isDebugEnabled() && j2eeName != null) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("the application name is: " + j2eeName.getApplication()), (Object[])new Object[0]);
                Tr.debug((Object)this, (TraceComponent)tc, (String)("the module      name is: " + j2eeName.getModule()), (Object[])new Object[0]);
                Tr.debug((Object)this, (TraceComponent)tc, (String)("the bean        name is: " + j2eeName.getComponent()), (Object[])new Object[0]);
                Tr.debug((Object)this, (TraceComponent)tc, (String)("the res-ref     name is: " + this.resRefInfo.getName()), (Object[])new Object[0]);
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    @Override
    public final Connection getConnection() throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"getConnection", (Object[])new Object[0]);
        }
        int isolationLevelForCRI = this.getDefaultIsolationLevel();
        boolean supportIsolvlSwitching = this.mcf.getHelper().isIsolationLevelSwitchingSupport();
        WSConnectionRequestInfoImpl cri = new WSConnectionRequestInfoImpl(null, null, isolationLevelForCRI, this.mcf.instanceID, supportIsolvlSwitching);
        return this.getConnection(cri);
    }

    protected Connection getConnection(ConnectionRequestInfo connInfo) throws SQLException {
        WSJdbcConnection c;
        WSJdbcConnection connWrapper;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"getConnection", (Object[])new Object[]{AdapterUtil.toString(connInfo)});
        }
        try {
            connWrapper = (WSJdbcConnection)this.cm.allocateConnection((ManagedConnectionFactory)this.mcf, connInfo);
        }
        catch (ResourceException resX) {
            FFDCFilter.processException((Throwable)resX, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDataSource.getConnection", (String)"299", (Object)this);
            SQLException x = AdapterUtil.toSQLException(resX);
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"getConnection", (Object)"Exception");
            }
            throw x;
        }
        try {
            connWrapper.initialize(this.cm);
        }
        catch (SQLException sqlX) {
            FFDCFilter.processException((Throwable)sqlX, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcDataSource.getConnection", (String)"280", (Object)this);
            sqlX = WSJdbcUtil.mapException(connWrapper, sqlX);
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"getConnection", (Object)sqlX);
            }
            throw sqlX;
        }
        Connection connection = c = ((DSConfig)this.dsConfig.get()).enableConnectionCasting ? connWrapper.getCastableWrapper(this.vendorConnectionInterfaces) : connWrapper;
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"getConnection", (Object)c);
        }
        return c;
    }

    @Override
    public final Connection getConnection(String user, String pwd) throws SQLException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"getConnection", (Object[])new Object[]{user, pwd == null ? null : "******"});
        }
        int isolationLevelForCRI = this.getDefaultIsolationLevel();
        WSConnectionRequestInfoImpl _connInf = new WSConnectionRequestInfoImpl(user, pwd, isolationLevelForCRI, this.mcf.instanceID, this.mcf.getHelper().isIsolationLevelSwitchingSupport());
        _connInf.markAsChangable();
        return this.getConnection(_connInf);
    }

    @Override
    public final String getDatabaseProductName() {
        return this.mcf.getHelper().getDatabaseProductName();
    }

    private final int getDefaultIsolationLevel() {
        int defaultIsolationLevel;
        int n = defaultIsolationLevel = this.resRefInfo == null ? 0 : this.resRefInfo.getIsolationLevel();
        if (defaultIsolationLevel == 0) {
            defaultIsolationLevel = ((DSConfig)this.dsConfig.get()).isolationLevel;
        }
        if (defaultIsolationLevel == -1) {
            defaultIsolationLevel = this.mcf.getHelper().getDefaultIsolationLevel();
        }
        return defaultIsolationLevel;
    }

    @Override
    protected Object getJDBCImplObject() throws SQLException {
        return this.mcf.getUnderlyingDataSource();
    }

    @Override
    protected <T> T getJDBCImplObject(Class<T> interfaceClass) throws SQLException {
        Object jdbcImplObject = this.getJDBCImplObject();
        if (jdbcImplObject == null) {
            return null;
        }
        Object impl = WSJdbcTracer.getImpl(jdbcImplObject);
        return (T)(interfaceClass.isInstance(impl) ? impl : null);
    }

    @Override
    public final int getLoginTimeout() throws SQLException {
        return this.mcf.getLoginTimeout();
    }

    @Override
    public final PrintWriter getLogWriter() throws SQLException {
        try {
            return this.mcf.getLogWriter();
        }
        catch (ResourceException x) {
            throw AdapterUtil.toSQLException(x);
        }
    }

    @Override
    protected TraceComponent getTracer() {
        return tc;
    }

    public String[] introspectSelf() {
        FFDCLogger info = new FFDCLogger(this);
        info.append("ResourceRefInfo:", this.resRefInfo);
        info.introspect("Connection Manager:", this.cm);
        info.introspect("ManagedConnectionFactory:", (Object)this.mcf);
        return info.toStringArray();
    }

    @Override
    Object invokeOperation(Object implObject, Method method, Object[] args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, SQLException {
        Class<?>[] types;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)("invokeOperation: " + method.getName()), (Object[])args);
        }
        if ((types = method.getParameterTypes()) != null && types.length == 1 && method.getName().startsWith("set") && Void.TYPE.equals(method.getReturnType())) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)("invokeOperation: " + method.getName()), (Object)"not supported");
            }
            throw new SQLFeatureNotSupportedException(method.getName());
        }
        implObject = this.mcf.getUnderlyingDataSource();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("invoke on " + AdapterUtil.toString(implObject)), (Object[])new Object[0]);
        }
        Object result = method.invoke(implObject, args);
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)("invokeOperation: " + method.getName()), (Object)result);
        }
        return result;
    }

    Object replaceObject(ResourceRefConfigFactory resRefConfigFactory) {
        ResourceRefConfig resRefConfig;
        DSConfig config = (DSConfig)this.dsConfig.get();
        String filter = config.jndiName == null || config.jndiName.startsWith("java:") ? FilterUtils.createPropertyFilter((String)"config.displayId", (String)config.id) : FilterUtils.createPropertyFilter((String)"jndiName", (String)config.jndiName);
        ResourceRefConfig resourceRefConfig = resRefConfig = this.resRefInfo == null ? null : resRefConfigFactory.createResourceRefConfig(DataSource.class.getName());
        if (this.resRefInfo != null) {
            resRefConfig.setBranchCoupling(this.resRefInfo.getBranchCoupling());
            resRefConfig.setCommitPriority(this.resRefInfo.getCommitPriority());
            resRefConfig.setIsolationLevel(this.resRefInfo.getIsolationLevel());
            resRefConfig.setJNDIName(this.resRefInfo.getJNDIName());
            resRefConfig.setLoginConfigurationName(this.resRefInfo.getLoginConfigurationName());
            resRefConfig.setResAuthType(this.resRefInfo.getAuth());
            resRefConfig.setSharingScope(this.resRefInfo.getSharingScope());
        }
        return new SerializedDataSourceWrapper(filter, (ResourceRefInfo)resRefConfig);
    }

    @Override
    protected final RuntimeException runtimeXIfNotClosed(RuntimeException runtimeX) {
        return runtimeX;
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        if (seconds != this.getLoginTimeout()) {
            throw new SQLFeatureNotSupportedException();
        }
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        if (!AdapterUtil.match(out, this.getLogWriter())) {
            throw new SQLFeatureNotSupportedException();
        }
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }
}

