/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collective.utility.tasks;

import com.ibm.websphere.crypto.InvalidPasswordEncodingException;
import com.ibm.websphere.crypto.PasswordUtil;
import com.ibm.websphere.crypto.UnsupportedCryptoAlgorithmException;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.ws.collective.member.internal.ssh.SSHKeyGenerator;
import com.ibm.ws.collective.member.internal.ssh.SSHKeyPair;
import com.ibm.ws.collective.member.internal.ssh.SSHKeyUtility;
import com.ibm.ws.collective.utility.CollectiveUtilityTask;
import com.ibm.ws.collective.utility.ICollectiveRegistrationMBeanConnection;
import com.ibm.ws.collective.utility.ICommonMBeanConnection;
import com.ibm.ws.collective.utility.IFileUtility;
import com.ibm.ws.collective.utility.TaskErrorException;
import com.ibm.ws.collective.utility.utils.CommandUtils;
import com.ibm.ws.collective.utility.utils.ConsoleWrapper;
import com.ibm.ws.collective.utility.utils.Trlog;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLStreamHandler;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.AttributeNotFoundException;
import javax.management.ReflectionException;
import javax.management.RuntimeMBeanException;
import org.apache.commons.io.FilenameUtils;

public abstract class BaseCommandTask
implements CollectiveUtilityTask,
ICommonMBeanConnection {
    private static final String className = BaseCommandTask.class.getName();
    boolean enableTrace = false;
    static final String SLASH = "/";
    static final String NL = System.getProperty("line.separator");
    static final String SSH_KEYS_DIR = "resources/security/ssh";
    static final String SSH_PRIVATE_KEY = "resources/security/ssh/id_rsa";
    static final String SSH_PUBLIC_KEY = "resources/security/ssh/id_rsa.pub";
    static final String COLLECTIVE_RESOURCES_DIR = "resources/collective";
    static final String COLLECTIVE_UUID_FILE = "resources/collective/collective.uuid";
    static final String COLLECTIVE_NAME_FILE = "resources/collective/collective.name";
    static final String COLLECTIVE_ROOT_KEYS_FILE = "resources/collective/rootKeys.p12";
    static final String SERVER_IDENTITY_KEY_FILE = "resources/collective/serverIdentity.p12";
    static final String COLLECTIVE_TRUST_KEY_FILE = "resources/collective/collectiveTrust.p12";
    static final String HTTPS_SSL_KEY_FILE = "resources/security/key.p12";
    static final String HTTPS_TRUST_KEY_FILE = "resources/security/trust.p12";
    static final String COLLECTIVE_ROOT_KEYS_JKS_FILE = "resources/collective/rootKeys.jks";
    static final String SERVER_IDENTITY_KEY_JKS_FILE = "resources/collective/serverIdentity.jks";
    static final String COLLECTIVE_TRUST_KEY_JKS_FILE = "resources/collective/collectiveTrust.jks";
    static final String HTTPS_SSL_KEY_JKS_FILE = "resources/security/key.jks";
    static final String HTTPS_TRUST_KEY_JKS_FILE = "resources/security/trust.jks";
    static final String COLLECTIVE_MARKER_FILE = "resources/collective/.collective";
    static final String COLLECTIVE_SECURITY_DIR = "resources/security";
    static final String COLLECTIVE_PRIVATE_KEY_FILE = "resources/security/ssh/id_rsa";
    static final String COLLECTIVE_PUBLIC_KEY_FILE = "resources/security/ssh/id_rsa.pub";
    static final String DEPLOY_VARIABLES_PARENT_DIR = "configDropins/overrides";
    static final String DEPLOY_VARIABLES_FILE = "deployVariables.xml";
    static final String SERVER_ADMIN_METADATA_FILE = "admin-metadata.xml";
    static final String RUNTIME_ADMIN_METADATA_FILE = "etc/admin-metadata.xml";
    static final String CONTROLLER_ROOT_KEY_ALIAS = "controllerRoot";
    static final String MEMBER_ROOT_KEY_ALIAS = "memberRoot";
    static final String SERVER_IDENTITY_KEY_ALIAS = "serverIdentity";
    static final String HTTPS_KEY_ALIAS = "default";
    static final int VALIDITY_25_YEARS = 9125;
    static final int VALIDITY_5_YEARS = 1825;
    static final String XOR_ENCODING = "xor";
    static final String AES_ENCODING = "aes";
    static final String SAF_KEYRING_URL_PREFIX = "safkeyring:///";
    static final String ARG_REQ_HOST = "--host";
    static final String ARG_REQ_PORT = "--port";
    static final String ARG_REQ_USER = "--user";
    static final String ARG_REQ_PASSWORD = "--password";
    static final String ARG_REQ_CONTROLLER = "--controller";
    static final String ARG_OPT_HOST_NAME = "--hostName";
    static final String ARG_OPT_ENCODING = "--encoding";
    static final String ARG_OPT_KEY = "--key";
    static final String ARG_OPT_CREATE_CONFIG_FILE = "--createConfigFile";
    static final String ARG_OPT_KEYSTORE_FILE = "--keystoreFile";
    static final String ARG_OPT_USE_HOST_CREDENTIALS = "--useHostCredentials";
    static final String ARG_OPT_GEN_DEPLOY_VARIABLES = "--genDeployVariables";
    static final String ARG_OPT_REMOVE_DEPLOY_VARIABLES = "--removeDeployVariables";
    static final String ARG_OPT_USE_COLLECTIVE_SSH_KEY = "--useCollectiveSSHKey";
    static final String ARG_OPT_ENABLE_TRACE = "--trace";
    static final String ARG_REQ_KEYSTORE_PASSWORD = "--keystorePassword";
    static final String ARG_OPT_COLLECTIVE_NAME = "--collectiveName";
    static final String ARG_OPT_AUTO_ACCEPT_CERTS = "--autoAcceptCertificates";
    static final String ARG_OPT_SERVER_IDENTITY_KEYSTORE_PASSWORD = "--serverIdentityKeystorePassword";
    static final String ARG_OPT_SERVER_IDENTITY_CERT_VALIDITY = "--serverIdentityCertificateValidity";
    static final String ARG_OPT_COLLECTIVE_TRUST_KS_PASSWORD = "--collectiveTrustKeystorePassword";
    static final String ARG_OPT_HTTPS_KEYSTORE_PASSWORD = "--httpsKeystorePassword";
    static final String ARG_OPT_HTTPS_CERTIFICATE_SUBJECT = "--httpsCertificateSubject";
    static final String ARG_OPT_HTTPS_CERTIFICATE_VALIDITY = "--httpsCertificateValidity";
    static final String ARG_OPT_HTTPS_TRUSTSTORE_PASSWORD = "--httpsTruststorePassword";
    static final String ARG_OPT_ROOT_KS_PASSWORD = "--rootKeystorePassword";
    static final String ARG_OPT_CERTIFICATE_SUBJECT = "--certificateSubject";
    static final String ARG_OPT_CERTIFICATE_VALIDITY = "--certificateValidity";
    static final String ARG_OPT_RPC_HOST = "--rpcHost";
    static final String ARG_OPT_RPC_PORT = "--rpcPort";
    static final String ARG_OPT_RPC_USER = "--rpcUser";
    static final String ARG_OPT_RPC_USER_PASSWORD = "--rpcUserPassword";
    static final String ARG_OPT_RPC_USER_HOME = "--rpcUserHome";
    static final String ARG_OPT_SSH_PRIVATE_KEY = "--sshPrivateKey";
    static final String ARG_OPT_SSH_PRIVATE_KEY_PASSWORD = "--sshPrivateKeyPassword";
    static final String ARG_OPT_USE_SUDO = "--useSudo";
    static final String ARG_OPT_SUDO_USER = "--sudoUser";
    static final String ARG_OPT_SUDO_USER_PASSWORD = "--sudoUserPassword";
    static final String ARG_OPT_HOST_READ_PATH = "--hostReadPath";
    static final String ARG_OPT_HOST_WRITE_PATH = "--hostWritePath";
    static final String ARG_OPT_HOST_JAVA_HOME = "--hostJavaHome";
    static final String ARG_OPT_SAF_KEYRING = "--safKeyring";
    static final String ARG_OPT_SAF_CERTIFICATE_LABEL = "--safCertificateLabel";
    static final String ARG_OPT_SAF_KEYSTORE_TYPE_LABEL = "--safKeystoreType";
    static final String ARG_OPT_SAF_KEYSTORE_PROVIDER_LABEL = "--safKeystoreProvider";
    static final String ARG_OPT_SETUP_SAF = "--setupSAF";
    static final String ARG_OPT_CERTIFICATE_RDN = "--certificateRdn";
    static final String ARG_OPT_SERVER_IDENTITY_KEYSTORE = "--serverIdentityKeystore";
    static final String ARG_OPT_SERVER_IDENTITY_ALIAS = "--serverIdentityKeystoreAlias";
    static final String ARG_OPT_COLLECTIVE_TRUST_KEYSTORE = "--collectiveTrustKeystore";
    static final String ARG_OPT_SSH_PUBLIC_KEY = "--sshPublicKey";
    protected final String scriptName;
    protected TraceComponent tc = null;
    protected final IFileUtility fileUtility;
    protected ConsoleWrapper stdin;
    protected PrintStream stdout;
    protected PrintStream stderr;
    protected Collection<String> reqArgs = new HashSet<String>();
    protected Collection<String> reqConnectArgs = new HashSet<String>();
    protected Collection<String> promptableArgs = new HashSet<String>();
    protected Collection<String> confirmedArgs = new HashSet<String>();
    protected Collection<String> flagArgs = new HashSet<String>();
    protected Collection<String> knownArgs = new HashSet<String>();
    protected Collection<String> noValueRequiredArgs = new HashSet<String>();
    private String rpcUser;
    private String rpcUserHome;
    private String sshPublicKey;
    private boolean isDefaultHostAuthInfo;
    private String controllerHost;
    private String controllerPort;
    private String controllerUser;
    private String controllerPassword;
    private SingleCollectiveSSHKeyPair singleCollectiveSSHKeyPair;
    private static final Map<String, String> handlers = new HashMap<String, String>();
    Pattern safKeyringPattern = Pattern.compile("(safkeyring|(safkeyringhw|safkeyringhybrid)):/{2,3}\\w.*");

    public BaseCommandTask(TraceComponent tc, String scriptName, IFileUtility fileUtility) {
        this.tc = tc;
        this.scriptName = scriptName;
        this.fileUtility = fileUtility;
    }

    public BaseCommandTask(String scriptName, IFileUtility fileUtility) {
        this.scriptName = scriptName;
        this.fileUtility = fileUtility;
    }

    protected String getMessage(String key, Object ... args) {
        return CommandUtils.getMessage(key, args);
    }

    protected String getOption(String key, Object ... args) {
        return CommandUtils.getOption(key, args);
    }

    protected void addAutoAcceptArgument() {
        this.noValueRequiredArgs.add(ARG_OPT_AUTO_ACCEPT_CERTS);
        this.knownArgs.addAll(this.noValueRequiredArgs);
    }

    protected void handleAutoAcceptArgument(String[] args) {
        String autoAccept = this.getArgumentValue(ARG_OPT_AUTO_ACCEPT_CERTS, args, "false");
        if (autoAccept == null || autoAccept.compareTo("true") == 0) {
            Trlog.debug(className, "handleAutoAcceptArgument", "com.ibm.websphere.collective.utility.autoAcceptCertificates is set to true");
            System.setProperty("com.ibm.websphere.collective.utility.autoAcceptCertificates", "true");
        } else {
            Trlog.debug(className, "handleAutoAcceptArgument", "com.ibm.websphere.collective.utility.autoAcceptCertificates is not set");
        }
    }

    protected abstract void abort(String var1) throws TaskErrorException;

    protected abstract void abortAndPerformCleanup(String var1, File var2) throws TaskErrorException;

    protected String buildScriptOptions(String optionKeyPrefix, String optionDescPrefix) {
        StringBuilder scriptOptions = new StringBuilder();
        if (optionKeyPrefix != null && !optionKeyPrefix.isEmpty() && optionDescPrefix != null && !optionDescPrefix.isEmpty()) {
            Enumeration<String> keys = CommandUtils.getOptions().getKeys();
            TreeSet<String> optionKeys = new TreeSet<String>();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                if (!key.startsWith(optionKeyPrefix)) continue;
                optionKeys.add(key);
            }
            if (optionKeys.size() > 0) {
                for (String optionKey : optionKeys) {
                    String option = optionKey.substring(optionKeyPrefix.length());
                    scriptOptions.append(NL);
                    scriptOptions.append(CommandUtils.getOptions().getString(optionKey));
                    scriptOptions.append(NL);
                    scriptOptions.append(CommandUtils.getOptions().getString(optionDescPrefix + option));
                    scriptOptions.append(NL);
                }
            }
        }
        return scriptOptions.toString();
    }

    protected String getTaskUsage(String usage) {
        StringBuilder scriptHelp = new StringBuilder();
        scriptHelp.append(this.getOption("global.usage", new Object[0]));
        scriptHelp.append(NL);
        scriptHelp.append(this.getOption(usage, new Object[0]));
        return MessageFormat.format(scriptHelp.toString(), this.scriptName);
    }

    protected String getTaskHelp(String desc, String usage, String optionKeyPrefix, String optionDescPrefix, String addonKey, String footer, Object ... args) {
        StringBuilder scriptHelp = new StringBuilder();
        scriptHelp.append(this.getOption("global.description", new Object[0]));
        scriptHelp.append(NL);
        scriptHelp.append(this.getOption(desc, new Object[0]));
        scriptHelp.append(NL);
        scriptHelp.append(NL);
        scriptHelp.append(this.getOption("global.usage", new Object[0]));
        scriptHelp.append(NL);
        scriptHelp.append(this.getOption(usage, new Object[0]));
        scriptHelp.append(NL);
        String options = this.buildScriptOptions(optionKeyPrefix, optionDescPrefix);
        if (!options.isEmpty()) {
            scriptHelp.append(NL);
            scriptHelp.append(this.getOption("global.options", new Object[0]));
            scriptHelp.append(options);
        }
        if (addonKey != null && !addonKey.isEmpty()) {
            scriptHelp.append(NL);
            scriptHelp.append(this.getOption(addonKey, new Object[0]));
        }
        if (footer != null && !footer.isEmpty()) {
            scriptHelp.append(footer);
        }
        if (args.length == 0) {
            return scriptHelp.toString();
        }
        return MessageFormat.format(scriptHelp.toString(), args);
    }

    private String getArgName(String arg) {
        return arg.split("=")[0];
    }

    private boolean isKnownArgument(String arg) {
        String argName = this.getArgName(arg);
        for (String key : this.knownArgs) {
            if (!key.equalsIgnoreCase(argName)) continue;
            return true;
        }
        return false;
    }

    private void checkRequiredArguments(String[] args, boolean supportsDefaultTarget) {
        boolean argFound;
        int reqArgSize;
        String methodName = "checkRequiredArguments";
        Trlog.enter(className, methodName, supportsDefaultTarget);
        StringBuilder message = new StringBuilder();
        int additionalArgs = supportsDefaultTarget ? 1 : 2;
        int additionalReqArgs = 0;
        if (!this.checkArgInArgs(args, ARG_REQ_CONTROLLER)) {
            additionalReqArgs = this.reqConnectArgs.size();
        }
        if (args.length < (reqArgSize = this.reqArgs.size() + additionalArgs + additionalReqArgs)) {
            Trlog.debug(className, methodName, "Insufficient arguments and total arguments is " + args.length + ", less than " + reqArgSize);
            message.append(this.getMessage("insufficientArgs", new Object[0]));
            message.append(NL);
        }
        if (!supportsDefaultTarget && (args.length < 2 || args[1].startsWith("-"))) {
            Trlog.debug(className, methodName, "The target for the task was not specified.");
            message.append(this.getMessage("missingServerName", new Object[0]));
            message.append(NL);
        }
        for (String reqArg : this.reqArgs) {
            String lowerReqArg = reqArg.toLowerCase();
            argFound = false;
            for (String arg : args) {
                if (!arg.toLowerCase().startsWith(lowerReqArg)) continue;
                argFound = true;
                break;
            }
            if (argFound) continue;
            Trlog.debug(className, methodName, "Missing argument: " + reqArg);
            message.append(this.getMessage("missingArg", reqArg));
            message.append(NL);
        }
        if (this.checkArgInArgs(args, ARG_REQ_CONTROLLER) && this.flagArgs.contains(ARG_REQ_CONTROLLER)) {
            this.checkForHostPortUserPassword(args);
            this.checkRequiredControllerArguments(args);
        } else {
            for (String reqConnectArg : this.reqConnectArgs) {
                String lowerReqConnectArg = reqConnectArg.toLowerCase();
                argFound = false;
                for (String arg : args) {
                    if (!arg.toLowerCase().startsWith(lowerReqConnectArg)) continue;
                    argFound = true;
                    break;
                }
                if (argFound) continue;
                Trlog.debug(className, methodName, "Missing argument to connect controller: " + reqConnectArg);
                message.append(this.getMessage("missingArg", reqConnectArg));
                message.append(NL);
            }
        }
        if (!message.toString().isEmpty()) {
            Trlog.debug(className, methodName, message.toString());
            throw new IllegalArgumentException(message.toString());
        }
        Trlog.exit(className, methodName);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void checkRequiredControllerArguments(String[] args) {
        String methodName = "checkRequiredControllerArguments";
        Trlog.enter(className, methodName);
        StringBuilder message = new StringBuilder();
        String theArgumentValue = this.getArgumentValue(ARG_REQ_CONTROLLER, args, null);
        if (theArgumentValue == null) {
            Trlog.exit(className, methodName, "Missing value for argument --controller");
            message.append(this.getMessage("missingValue", ARG_REQ_CONTROLLER));
            message.append(NL);
            throw new IllegalArgumentException(message.toString());
        }
        String[] parms = theArgumentValue.split("@");
        if (parms.length != 2) {
            Trlog.exit(className, methodName, "The number of values specified on the --controller argument is wrong.");
            message.append(this.getMessage("wrongNumberOfValues", ARG_REQ_CONTROLLER, ARG_REQ_CONTROLLER, "user:password@host:port"));
            message.append(NL);
            throw new IllegalArgumentException(message.toString());
        }
        if (parms[0].length() == 0 || parms[1].length() == 0) {
            Trlog.exit(className, methodName, "The wrong number of values were specified on the --controller argument.");
            message.append(this.getMessage("wrongNumberOfValues", ARG_REQ_CONTROLLER, ARG_REQ_CONTROLLER, "user:password@host:port"));
            message.append(NL);
            throw new IllegalArgumentException(message.toString());
        }
        String[] parmsBefore = parms[0].split(":");
        if (parmsBefore.length > 0 && parmsBefore.length <= 2) {
            String pw;
            if (parmsBefore[0].length() == 0) {
                Trlog.exit(className, methodName, "An invalid value for user was specified on the --controller argument");
                message.append(this.getMessage("invalidValue", "user", ARG_REQ_CONTROLLER));
                message.append(NL);
                throw new IllegalArgumentException(message.toString());
            }
            this.controllerUser = parmsBefore[0];
            this.controllerPassword = parmsBefore.length == 2 ? ((pw = parmsBefore[1]).length() == 0 ? this.promptForPassword(ARG_REQ_PASSWORD) : parmsBefore[1]) : this.promptForPassword(ARG_REQ_PASSWORD);
        } else {
            Trlog.exit(className, methodName, "The number of values specified on the --controller argument is wrong.");
            message.append(this.getMessage("wrongNumberOfValuesBefore", ARG_REQ_CONTROLLER, ARG_REQ_CONTROLLER, "user:password@host:port"));
            message.append(NL);
            throw new IllegalArgumentException(message.toString());
        }
        String[] parmsAfter = parms[1].split(":");
        if (parmsAfter.length != 2) {
            Trlog.exit(className, methodName, "The number of values specified on the --controller argument is wrong.");
            message.append(this.getMessage("wrongNumberOfValuesAfter", ARG_REQ_CONTROLLER, ARG_REQ_CONTROLLER, "user:password@host:port"));
            message.append(NL);
            throw new IllegalArgumentException(message.toString());
        }
        if (parmsAfter[0].length() == 0) {
            Trlog.exit(className, methodName, "An invalid value for host was specified on the --controller argument");
            message.append(this.getMessage("invalidValue", "host", ARG_REQ_CONTROLLER));
            message.append(NL);
            throw new IllegalArgumentException(message.toString());
        }
        this.controllerHost = parmsAfter[0];
        if (parmsAfter[1].length() == 0) {
            Trlog.exit(className, methodName, "An invalid value for port was specified on the --controller argument");
            message.append(this.getMessage("invalidValue", "port", ARG_REQ_CONTROLLER));
            message.append(NL);
            throw new IllegalArgumentException(message.toString());
        }
        this.controllerPort = parmsAfter[1];
        Trlog.exit(className, methodName);
    }

    protected void checkForHostPortUserPassword(String[] args) {
        String methodName = "checkForHostPortUserPassword";
        Trlog.enter(className, methodName);
        if (this.checkArgInArgs(args, ARG_REQ_CONTROLLER)) {
            StringBuilder message = new StringBuilder();
            if (this.checkArgInArgs(args, ARG_REQ_HOST)) {
                Trlog.exit(className, methodName, "The option --host is mutually exclusive with <--controller>.");
                message.append(this.getMessage("mutuallyExclusive", ARG_REQ_HOST));
                message.append(NL);
                throw new IllegalArgumentException(message.toString());
            }
            if (this.checkArgInArgs(args, ARG_REQ_PORT)) {
                Trlog.exit(className, methodName, "The option --port is mutually exclusive with <--controller>.");
                message.append(this.getMessage("mutuallyExclusive", ARG_REQ_PORT));
                message.append(NL);
                throw new IllegalArgumentException(message.toString());
            }
            if (this.checkArgInArgs(args, ARG_REQ_USER)) {
                Trlog.exit(className, methodName, "The option --user is mutually exclusive with <--controller>.");
                message.append(this.getMessage("mutuallyExclusive", ARG_REQ_USER));
                message.append(NL);
                throw new IllegalArgumentException(message.toString());
            }
            if (this.checkArgInArgs(args, ARG_REQ_PASSWORD)) {
                Trlog.exit(className, methodName, "The option --password is mutually exclusive with <--controller>.");
                message.append(this.getMessage("mutuallyExclusive", ARG_REQ_PASSWORD));
                message.append(NL);
                throw new IllegalArgumentException(message.toString());
            }
        }
        Trlog.exit(className, methodName);
    }

    protected String getControllerHostArgumentValue() {
        return this.controllerHost;
    }

    protected String getControllerPortArgumentValue() {
        return this.controllerPort;
    }

    protected String getControllerUserArgumentValue() {
        return this.controllerUser;
    }

    @Sensitive
    protected String getControllerPasswordArgumentValue() {
        return this.controllerPassword;
    }

    protected String getControllerHost(String[] args) {
        if (this.checkArgInArgs(args, ARG_REQ_CONTROLLER)) {
            return this.getControllerHostArgumentValue();
        }
        return this.getArgumentValue(ARG_REQ_HOST, args, null);
    }

    protected String getControllerPort(String[] args) {
        if (this.checkArgInArgs(args, ARG_REQ_CONTROLLER)) {
            return this.getControllerPortArgumentValue();
        }
        return this.getArgumentValue(ARG_REQ_PORT, args, null);
    }

    protected String getControllerUser(String[] args) {
        if (this.checkArgInArgs(args, ARG_REQ_CONTROLLER)) {
            return this.getControllerUserArgumentValue();
        }
        return this.getArgumentValue(ARG_REQ_USER, args, null);
    }

    protected String getControllerPassword(String[] args) {
        if (this.checkArgInArgs(args, ARG_REQ_CONTROLLER)) {
            return this.getControllerPasswordArgumentValue();
        }
        return this.getArgumentValue(ARG_REQ_PASSWORD, args, null);
    }

    protected boolean isKeystorePwdUsed(String[] args, Collection<String> pwdArgs) {
        boolean keystorePwdUsed = false;
        for (int i = 2; i < args.length; ++i) {
            String arg = args[i];
            String option = arg.split("=")[0];
            pwdArgs.remove(option);
            if (!option.equals(ARG_REQ_KEYSTORE_PASSWORD)) continue;
            keystorePwdUsed = true;
        }
        return keystorePwdUsed;
    }

    protected void printMissingPasswordArgs(Collection<String> pwdArgs) {
        Iterator<String> iter = pwdArgs.iterator();
        StringBuilder message = new StringBuilder();
        StringBuilder pwdArgsString = new StringBuilder();
        while (iter.hasNext()) {
            String missingArg = iter.next();
            pwdArgsString.append(missingArg);
            pwdArgsString.append("  ");
        }
        message.append(this.getMessage("insufficientArgs", new Object[0]));
        message.append(NL);
        message.append(this.getMessage("missingPasswordArg", ARG_REQ_KEYSTORE_PASSWORD, pwdArgsString));
        message.append(NL);
        Trlog.debug(className, "printMissingPasswordArgs", "Missing the password argument values for  --keystorePassword");
        throw new IllegalArgumentException(message.toString());
    }

    private String getValue(String arg) {
        String[] split = arg.split("=");
        if (split.length == 1) {
            return null;
        }
        if (split.length == 2) {
            return split[1];
        }
        StringBuffer value = new StringBuffer();
        for (int i = 1; i < split.length; ++i) {
            value.append(split[i]);
            if (i >= split.length - 1) continue;
            value.append("=");
        }
        return value.toString();
    }

    protected void validateArgumentList(String[] args, boolean supportsDefaultTarget) {
        this.validateArgumentList(args, true, supportsDefaultTarget);
    }

    protected void validateArgumentList(String[] args, boolean supportsTarget, boolean supportsDefaultTarget) {
        String methodName = "validateArgument";
        Trlog.enter(className, methodName, new Object[]{supportsTarget, supportsDefaultTarget});
        this.checkRequiredArguments(args, !supportsTarget || supportsDefaultTarget);
        int firstArg = 1;
        if (supportsTarget) {
            String primArg;
            if (!supportsDefaultTarget) {
                firstArg = 2;
            } else if (args.length > 1 && !(primArg = args[1]).startsWith("-")) {
                firstArg = 2;
            }
        }
        for (int i = firstArg; i < args.length; ++i) {
            String argName = this.getArgName(args[i]);
            String value = this.getValue(args[i]);
            if (!this.isKnownArgument(argName)) {
                Trlog.debug(className, methodName, "Invalid argument  " + argName);
                throw new IllegalArgumentException(this.getMessage("invalidArg", argName));
            }
            if (this.promptableArgs.contains(argName) || this.confirmedArgs.contains(argName) || this.flagArgs.contains(argName) || value != null || this.noValueRequiredArgs.contains(argName)) continue;
            Trlog.debug(className, methodName, "Missing value for argument " + argName);
            throw new IllegalArgumentException(this.getMessage("missingValue", argName));
        }
        Trlog.exit(className, methodName);
    }

    protected String getTaskTarget(String[] args) {
        String primArg = args[1];
        if (primArg.startsWith("-")) {
            return null;
        }
        return primArg;
    }

    protected String promptForPassword(String arg) {
        return this.stdin.readMaskedText(this.getMessage("password.enterText", arg) + " ");
    }

    private String promptForText(String arg) {
        String read1 = this.stdin.readMaskedText(this.getMessage("password.enterText", arg) + " ");
        String read2 = this.stdin.readMaskedText(this.getMessage("password.reenterText", arg) + " ");
        if (read1 == null && read2 == null) {
            throw new IllegalArgumentException("Unable to read either entry. Aborting prompt.");
        }
        if (read1 == null || read2 == null) {
            this.stdout.println(this.getMessage("password.readError", new Object[0]));
            return this.promptForText(arg);
        }
        if (read1.equals(read2)) {
            return read1;
        }
        this.stdout.println(this.getMessage("password.entriesDidNotMatch", new Object[0]));
        return this.promptForText(arg);
    }

    protected String getArgumentValue(String arg, String[] args, String defalt) {
        String argName = this.getArgName(arg);
        for (int i = 1; i < args.length; ++i) {
            String currentArgName = this.getArgName(args[i]);
            if (!currentArgName.equalsIgnoreCase(argName)) continue;
            String value = this.getValue(args[i]);
            if (value == null && this.promptableArgs.contains(argName)) {
                value = this.promptForPassword(arg);
            } else if (value == null && this.confirmedArgs.contains(argName)) {
                value = this.promptForText(arg);
            }
            return value;
        }
        return defalt;
    }

    protected List<String> getArgumentList(String arg, String[] args, List<String> defalt) {
        ArrayList<String> ret = new ArrayList<String>();
        String argName = this.getArgName(arg);
        for (int i = 1; i < args.length; ++i) {
            String currentArgName = this.getArgName(args[i]);
            if (!currentArgName.equalsIgnoreCase(argName)) continue;
            String value = this.getValue(args[i]);
            ret.add(value);
        }
        if (ret.isEmpty()) {
            return defalt;
        }
        return ret;
    }

    protected String encodePassword(String password, String arg, String encoding, String key) {
        String encoded = null;
        try {
            encoded = PasswordUtil.encode((String)password, (String)encoding, (String)key);
        }
        catch (InvalidPasswordEncodingException e1) {
            e1.printStackTrace(this.stderr);
        }
        catch (UnsupportedCryptoAlgorithmException e1) {
            e1.printStackTrace(this.stderr);
        }
        if (encoded == null) {
            this.stdout.println(this.getMessage("common.encodeError", arg));
        }
        return encoded;
    }

    protected String getHostName() {
        String hostName = null;
        try {
            InetAddress addr = InetAddress.getLocalHost();
            hostName = addr.getCanonicalHostName().toLowerCase();
        }
        catch (UnknownHostException e) {
            this.stderr.println(this.getMessage("create.errGetHostName", "localhost", e.getMessage()));
            hostName = "localhost";
        }
        Trlog.debug(className, "getHostName", "hostName returned = " + hostName);
        return hostName;
    }

    protected File findAvailableBackupFile(File backupTarget) {
        int extension = 1;
        File backupCandidate = new File(backupTarget.getAbsolutePath() + ".old");
        while (backupCandidate.exists()) {
            backupCandidate = new File(backupTarget.getAbsolutePath() + ".old." + extension);
            ++extension;
        }
        Trlog.debug(className, "findAvailableBackupFile", "backupCandidate returned = " + backupCandidate);
        return backupCandidate;
    }

    protected void updateExistingSSLKeys(File httpsKSFile, File tmpHttpsKSFile, File httpsTSFile, File tmpHttpsTSFile, File collectiveResourcesDir) throws TaskErrorException {
        File oldHttpsTSFile;
        File oldHttpsKSFile;
        String methodName = "updateExistingSSLKeys";
        Trlog.enter(className, methodName, new Object[]{httpsKSFile, tmpHttpsKSFile, httpsTSFile, tmpHttpsTSFile, collectiveResourcesDir});
        if (this.fileUtility.exists(httpsKSFile) && !this.fileUtility.renameFile(httpsKSFile, oldHttpsKSFile = this.findAvailableBackupFile(httpsKSFile))) {
            Trlog.exit(className, methodName, "Unable to rename " + httpsKSFile.getAbsolutePath() + " to " + oldHttpsKSFile.getAbsolutePath());
            this.abortAndPerformCleanup(this.getMessage("common.renameFailed", httpsKSFile.getAbsolutePath(), oldHttpsKSFile.getAbsolutePath()), collectiveResourcesDir);
        }
        if (!this.fileUtility.renameFile(tmpHttpsKSFile, httpsKSFile)) {
            Trlog.exit(className, methodName, "Unable to rename " + tmpHttpsKSFile.getAbsolutePath() + " to " + httpsKSFile.getAbsolutePath());
            this.abortAndPerformCleanup(this.getMessage("common.renameFailed", tmpHttpsKSFile.getAbsolutePath(), httpsKSFile.getAbsolutePath()), collectiveResourcesDir);
        }
        if (this.fileUtility.exists(httpsTSFile) && !this.fileUtility.renameFile(httpsTSFile, oldHttpsTSFile = this.findAvailableBackupFile(httpsTSFile))) {
            Trlog.exit(className, methodName, "Unable to rename " + httpsTSFile.getAbsolutePath() + " to " + oldHttpsTSFile.getAbsolutePath());
            this.abortAndPerformCleanup(this.getMessage("common.renameFailed", httpsTSFile.getAbsolutePath(), oldHttpsTSFile.getAbsolutePath()), collectiveResourcesDir);
        }
        if (!this.fileUtility.renameFile(tmpHttpsTSFile, httpsTSFile)) {
            Trlog.exit(className, methodName, "Unable to rename " + tmpHttpsTSFile.getAbsolutePath() + " to " + httpsTSFile.getAbsolutePath());
            this.abortAndPerformCleanup(this.getMessage("common.renameFailed", tmpHttpsTSFile.getAbsolutePath(), httpsTSFile.getAbsolutePath()), collectiveResourcesDir);
        }
        Trlog.exit(className, methodName);
    }

    protected void addHostAuthInfoArgs(boolean addHostLists) {
        this.confirmedArgs.add(ARG_OPT_RPC_USER_PASSWORD);
        this.confirmedArgs.add(ARG_OPT_SSH_PRIVATE_KEY_PASSWORD);
        this.confirmedArgs.add(ARG_OPT_SUDO_USER_PASSWORD);
        this.knownArgs.addAll(this.confirmedArgs);
        this.knownArgs.add(ARG_OPT_RPC_HOST);
        this.knownArgs.add(ARG_OPT_RPC_PORT);
        this.knownArgs.add(ARG_OPT_RPC_USER);
        this.knownArgs.add(ARG_OPT_RPC_USER_HOME);
        this.knownArgs.add(ARG_OPT_SSH_PRIVATE_KEY);
        this.knownArgs.add(ARG_OPT_USE_SUDO);
        this.knownArgs.add(ARG_OPT_SUDO_USER);
        this.knownArgs.add(ARG_OPT_USE_COLLECTIVE_SSH_KEY);
        if (addHostLists) {
            this.knownArgs.add(ARG_OPT_HOST_READ_PATH);
            this.knownArgs.add(ARG_OPT_HOST_WRITE_PATH);
            this.knownArgs.add(ARG_OPT_HOST_JAVA_HOME);
        }
    }

    boolean isDefaultHostAuthInfo(String[] args) {
        boolean isDefault = true;
        for (String arg : args) {
            String lowerArg = arg.toLowerCase();
            if (!lowerArg.startsWith(ARG_OPT_RPC_HOST.toLowerCase()) && !lowerArg.startsWith(ARG_OPT_RPC_PORT.toLowerCase()) && !lowerArg.startsWith(ARG_OPT_RPC_USER.toLowerCase()) && !lowerArg.startsWith(ARG_OPT_RPC_USER_PASSWORD.toLowerCase()) && !lowerArg.startsWith(ARG_OPT_RPC_USER_HOME.toLowerCase()) && !lowerArg.startsWith(ARG_OPT_SSH_PRIVATE_KEY.toLowerCase()) && !lowerArg.startsWith(ARG_OPT_SSH_PRIVATE_KEY_PASSWORD.toLowerCase()) && !lowerArg.startsWith(ARG_OPT_USE_SUDO.toLowerCase()) && !lowerArg.startsWith(ARG_OPT_SUDO_USER.toLowerCase()) && !lowerArg.startsWith(ARG_OPT_SUDO_USER_PASSWORD.toLowerCase()) && !lowerArg.startsWith(ARG_OPT_USE_COLLECTIVE_SSH_KEY.toLowerCase() + "=true")) continue;
            isDefault = false;
        }
        return isDefault;
    }

    void validateUseHostCredentialsOverrides(List<String> list, boolean useHostCredentials) throws TaskErrorException {
        if (useHostCredentials && (this.checkArgInArgs(list, ARG_OPT_RPC_HOST) || this.checkArgInArgs(list, ARG_OPT_RPC_PORT) || this.checkArgInArgs(list, ARG_OPT_RPC_USER) || this.checkArgInArgs(list, ARG_OPT_RPC_USER_HOME) || this.checkArgInArgs(list, ARG_OPT_RPC_USER_PASSWORD) || this.checkArgInArgs(list, ARG_OPT_SSH_PRIVATE_KEY) || this.checkArgInArgs(list, ARG_OPT_SSH_PRIVATE_KEY_PASSWORD) || this.checkArgInArgs(list, ARG_OPT_USE_SUDO) || this.checkArgInArgs(list, ARG_OPT_SUDO_USER) || this.checkArgInArgs(list, ARG_OPT_SUDO_USER_PASSWORD))) {
            this.abort(this.getMessage("baseCommand.useHostCredentialsButOtherCtedentialsAreSet", new Object[0]));
        }
    }

    void validateUseSSHKeyOverrides(List<String> list, boolean useCollectiveSSHKey) throws TaskErrorException {
        if (useCollectiveSSHKey && (this.checkArgInArgs(list, ARG_OPT_USE_HOST_CREDENTIALS) || this.checkArgInArgs(list, ARG_OPT_RPC_HOST) || this.checkArgInArgs(list, ARG_OPT_RPC_PORT) || this.checkArgInArgs(list, ARG_OPT_RPC_USER) || this.checkArgInArgs(list, ARG_OPT_RPC_USER_HOME) || this.checkArgInArgs(list, ARG_OPT_RPC_USER_PASSWORD) || this.checkArgInArgs(list, ARG_OPT_SSH_PRIVATE_KEY) || this.checkArgInArgs(list, ARG_OPT_SSH_PRIVATE_KEY_PASSWORD))) {
            this.abort(this.getMessage("baseCommand.useCollectiveSSHKeyButOtherCommInfoSet", new Object[0]));
        }
    }

    private boolean checkArgInArgs(List<String> list, String key) {
        for (String s : list) {
            if (!s.startsWith(key + "=")) continue;
            return true;
        }
        return false;
    }

    protected boolean checkArgInArgs(String[] args, String key) {
        if (args == null || key == null) {
            return false;
        }
        List<String> list = Arrays.asList(args);
        return this.checkArgInArgs(list, key);
    }

    void validateHostAuthInfoSettings(String rpcUserPassword, String sshKey, String sshKeyPassword, Boolean useSudo, String sudoUser, String sudoUserPassword, Boolean useCollectiveSSHKey, Boolean useCollectiveSSHKeyAvailable) throws TaskErrorException {
        if (rpcUserPassword != null && sshKey != null) {
            this.abort(this.getMessage("hostAuthInfo.bothCredentialsSet", ARG_OPT_RPC_USER, ARG_OPT_SSH_PRIVATE_KEY));
        }
        if (sshKey == null && sshKeyPassword != null) {
            this.abort(this.getMessage("hostAuthInfo.sshKeyPasswordWithoutKey", new Object[0]));
        }
        if (!(useSudo == null || useSudo.booleanValue() || sudoUser == null && sudoUserPassword == null)) {
            this.abort(this.getMessage("hostAuthInfo.useSudoFalseWithSudoOptions", new Object[0]));
        }
        if (useCollectiveSSHKey != null && useCollectiveSSHKey.booleanValue() && !useCollectiveSSHKeyAvailable.booleanValue()) {
            this.abort(this.getMessage("hostAuthInfo.useCollectiveSSHKeyWithDownlevelController", new Object[0]));
        }
    }

    Map<String, Object> buildHostAuthInfo(String rpcHost, int rpcPort, String rpcUser, String rpcUserPassword, String sshKey, String sshKeyPassword, Boolean useSudo, String sudoUser, String sudoUserPassword, List<String> readList, List<String> writeList, String hostJavaHome, Boolean useUseCollectiveSSHKey) {
        HashMap<String, Object> hostAuthInfo = new HashMap<String, Object>();
        hostAuthInfo.put("rpcHost", rpcHost);
        hostAuthInfo.put("rpcPort", rpcPort);
        hostAuthInfo.put("rpcUser", rpcUser);
        if (useUseCollectiveSSHKey != null && useUseCollectiveSSHKey.booleanValue()) {
            hostAuthInfo.put("useCollectiveSSHKey", useUseCollectiveSSHKey);
        }
        if (rpcUserPassword != null) {
            hostAuthInfo.put("rpcUserPassword", PasswordUtil.passwordEncode((String)rpcUserPassword));
        }
        if (sshKey != null) {
            hostAuthInfo.put("sshPrivateKey", sshKey);
        }
        if (sshKeyPassword != null) {
            hostAuthInfo.put("sshPrivateKeyPassword", PasswordUtil.passwordEncode((String)sshKeyPassword));
        }
        if (useSudo == null) {
            useSudo = false;
        }
        hostAuthInfo.put("useSudo", useSudo);
        if (sudoUser != null) {
            hostAuthInfo.put("sudoUser", sudoUser);
        }
        if (sudoUserPassword != null) {
            hostAuthInfo.put("sudoUserPassword", PasswordUtil.passwordEncode((String)sudoUserPassword));
        }
        if (readList != null) {
            hostAuthInfo.put("hostReadList", readList);
        }
        if (writeList != null) {
            hostAuthInfo.put("hostWriteList", writeList);
        }
        if (hostJavaHome != null) {
            hostAuthInfo.put("hostJavaHome", hostJavaHome);
        }
        if (this.singleCollectiveSSHKeyPair != null && !this.singleCollectiveSSHKeyPair.isSupported()) {
            useUseCollectiveSSHKey = false;
        }
        if (useUseCollectiveSSHKey == null || useUseCollectiveSSHKey.booleanValue()) {
            hostAuthInfo.put("collectiveSSHKeySupported", Boolean.TRUE);
        }
        return hostAuthInfo;
    }

    protected Map<String, Object> buildHostAuthInfo(String[] args, SSHKeyGenerator sshKeyGen, SSHKeyUtility sshKeyUtil, ICollectiveRegistrationMBeanConnection registrationMBean, File collectiveResourcesDir, String controllerHostName, int controllerPort, String controllerUser, String controllerPassword, String hostName, boolean isThisHost, boolean readHostLists, String serverName, String serverDir) throws TaskErrorException {
        String methodName = "buildHostAuthInfo";
        Trlog.enter(className, methodName, new Object[]{"isThisHost = " + isThisHost, "hostName = " + hostName});
        String currentUser = System.getProperty("user.name");
        String currentUserHome = System.getProperty("user.home");
        String rpcHost = this.getArgumentValue(ARG_OPT_RPC_HOST, args, hostName);
        int rpcPort = Integer.valueOf(this.getArgumentValue(ARG_OPT_RPC_PORT, args, "22"));
        this.rpcUser = this.getArgumentValue(ARG_OPT_RPC_USER, args, currentUser);
        this.rpcUserHome = this.getArgumentValue(ARG_OPT_RPC_USER_HOME, args, currentUserHome);
        String rpcUserPassword = this.getArgumentValue(ARG_OPT_RPC_USER_PASSWORD, args, null);
        String sshKeyPath = this.getArgumentValue(ARG_OPT_SSH_PRIVATE_KEY, args, null);
        String sshKeyPassword = this.getArgumentValue(ARG_OPT_SSH_PRIVATE_KEY_PASSWORD, args, null);
        String valueStr = this.getArgumentValue(ARG_OPT_USE_SUDO, args, null);
        Boolean useSudo = valueStr == null ? null : Boolean.valueOf(valueStr);
        String sudoUser = this.getArgumentValue(ARG_OPT_SUDO_USER, args, null);
        String sudoUserPassword = this.getArgumentValue(ARG_OPT_SUDO_USER_PASSWORD, args, null);
        String hostJavaHome = this.getArgumentValue(ARG_OPT_HOST_JAVA_HOME, args, null);
        Trlog.debug(className, methodName, "Key arguments: ", new Object[]{"rpcHost = " + rpcHost, "rpcPort = " + rpcPort, "rpcUser = " + this.rpcUser, "rpcUserHome = " + this.rpcUserHome, "sshKeyPath = " + sshKeyPath, "useSudo = " + useSudo, "sudoUser = " + sudoUser, "hostJavaHome = " + hostJavaHome});
        valueStr = this.getArgumentValue(ARG_OPT_USE_COLLECTIVE_SSH_KEY, args, null);
        Boolean useCollectiveSSHKeyExplicitlyRequested = valueStr == null ? false : valueStr.equals("true");
        Boolean useCollectiveSSHKeyExplicitlyDisabled = valueStr == null ? false : valueStr.equals("false");
        Boolean includeUseCollectiveSSHKeyInHostAuthInfo = null;
        Trlog.debug(className, methodName, "Key CollectiveSSHKey arguments: ", new Object[]{"useCollectiveSSHKeyExplicitlyRequested = " + useCollectiveSSHKeyExplicitlyRequested, "useCollectiveSSHKeyExplicitlyDisabled = " + useCollectiveSSHKeyExplicitlyDisabled});
        List<String> readList = null;
        List<String> writeList = null;
        if (readHostLists) {
            readList = this.getArgumentList(ARG_OPT_HOST_READ_PATH, args, null);
            writeList = this.getArgumentList(ARG_OPT_HOST_WRITE_PATH, args, null);
            Trlog.debug(className, methodName, "Key CollectiveSSHKey arguments: ", new Object[]{"readList = " + readList, "writeList = " + writeList});
        }
        this.isDefaultHostAuthInfo = this.isDefaultHostAuthInfo(args);
        Trlog.debug(className, methodName, "isDefaultHostAuthInfo = " + this.isDefaultHostAuthInfo);
        if (useSudo == null && (sudoUser != null || sudoUserPassword != null)) {
            useSudo = true;
        }
        Boolean useCollectiveSSHKeyAvailable = false;
        if (useCollectiveSSHKeyExplicitlyRequested.booleanValue()) {
            useCollectiveSSHKeyAvailable = this.isSingleCollectiveSSHKeyPairSupported(controllerHostName, controllerPort, controllerUser, controllerPassword, registrationMBean, collectiveResourcesDir);
        }
        this.validateHostAuthInfoSettings(rpcUserPassword, sshKeyPath, sshKeyPassword, useSudo, sudoUser, sudoUserPassword, useCollectiveSSHKeyExplicitlyRequested, useCollectiveSSHKeyAvailable);
        String sshKey = null;
        if (this.isDefaultHostAuthInfo && isThisHost) {
            if (serverName != null) {
                if (!useCollectiveSSHKeyExplicitlyDisabled.booleanValue()) {
                    useCollectiveSSHKeyAvailable = this.isSingleCollectiveSSHKeyPairSupported(controllerHostName, controllerPort, controllerUser, controllerPassword, registrationMBean, collectiveResourcesDir);
                }
                Trlog.debug(className, methodName, "useCollectiveSSHKeyAvailable = " + useCollectiveSSHKeyAvailable);
                if (useCollectiveSSHKeyAvailable.booleanValue()) {
                    this.sshPublicKey = this.getSingleCollectivePublicSSHKey();
                }
                if (this.sshPublicKey != null) {
                    this.stdout.println(this.getMessage("join.defaultToSingleSSHKey", controllerHostName));
                    includeUseCollectiveSSHKeyInHostAuthInfo = true;
                } else {
                    sshKey = this.getSSHKey(sshKeyUtil, this.rpcUserHome, serverName, serverDir);
                    this.stdout.println(this.getMessage("join.defaultToSSHKeyGeneration", controllerHostName));
                }
            } else {
                sshKey = this.generateSSHKeyPair(sshKeyGen, sshKeyUtil, hostName);
            }
        } else if (sshKeyPath != null) {
            sshKey = this.readSSHKey(sshKeyPath, sshKeyUtil);
        } else if (useCollectiveSSHKeyExplicitlyRequested.booleanValue()) {
            this.sshPublicKey = this.getSingleCollectivePublicSSHKey();
            if (this.sshPublicKey == null) {
                this.abort(this.getMessage("baseCommand.useCollectiveSSHKeygetPublicSSHKeyNull", new Object[0]));
            }
        }
        if (useCollectiveSSHKeyExplicitlyRequested.booleanValue()) {
            includeUseCollectiveSSHKeyInHostAuthInfo = true;
        } else if (useCollectiveSSHKeyExplicitlyDisabled.booleanValue()) {
            includeUseCollectiveSSHKeyInHostAuthInfo = false;
        }
        Map<String, Object> hostAuthInfo = this.buildHostAuthInfo(rpcHost, rpcPort, this.rpcUser, rpcUserPassword, sshKey, sshKeyPassword, useSudo, sudoUser, sudoUserPassword, readList, writeList, hostJavaHome, includeUseCollectiveSSHKeyInHostAuthInfo);
        Trlog.exit(className, methodName);
        return hostAuthInfo;
    }

    protected void updateAuthorizedKeysFiles(SSHKeyUtility sshKeyUtil) {
        if (this.sshPublicKey != null) {
            try {
                this.stdout.println(this.getMessage("ssh.updateAuthorizedKeys", new Object[0]));
                sshKeyUtil.updateAuthorizedKeys(this.rpcUserHome, this.sshPublicKey);
            }
            catch (IOException e) {
                this.stdout.println(this.getMessage("ssh.cannotUpdateAuthorizedKeys", this.rpcUser, this.rpcUserHome, this.sshPublicKey, e.getMessage()));
            }
        }
    }

    private String getSSHKey(SSHKeyUtility sshKeyUtil, String userHome, String serverName, String serverDir) throws TaskErrorException {
        try {
            String publicKeyComment = "Generated SSH key for Liberty server " + serverName + " for Liberty management.";
            return sshKeyUtil.useSSHKeyPair(publicKeyComment, userHome, serverDir + "resources/security/ssh/id_rsa.pub", serverDir + "resources/security/ssh/id_rsa");
        }
        catch (NoSuchAlgorithmException e) {
            throw new TaskErrorException(this.getMessage("ssh.couldNotCreateSSHKeys", e.getMessage()));
        }
        catch (IllegalStateException e) {
            throw new TaskErrorException(this.getMessage("ssh.invalidSSHKeyPair", e.getMessage()));
        }
        catch (IOException e) {
            throw new TaskErrorException(this.getMessage("ssh.couldNotReadSSHKeys", e.getMessage()));
        }
    }

    protected String getCollectiveSSHKey(SSHKeyUtility sshKeyUtil, String userHome, String commentFillin, String serverDir) throws TaskErrorException {
        try {
            String publicKeyComment = "Generated SSH key for Liberty collective " + commentFillin + " for Liberty management.";
            return sshKeyUtil.useSSHKeyPair(publicKeyComment, userHome, serverDir + "resources/security/ssh/id_rsa.pub", serverDir + "resources/security/ssh/id_rsa");
        }
        catch (NoSuchAlgorithmException e) {
            throw new TaskErrorException(this.getMessage("ssh.couldNotCreateSSHKeys", e.getMessage()));
        }
        catch (IllegalStateException e) {
            throw new TaskErrorException(this.getMessage("ssh.invalidSSHKeyPair", e.getMessage()));
        }
        catch (IOException e) {
            throw new TaskErrorException(this.getMessage("ssh.couldNotReadSSHKeys", e.getMessage()));
        }
    }

    private String readSSHKey(String sshKeyPath, SSHKeyUtility sshKeyUtil) throws TaskErrorException {
        String methodName = "readSSHKey";
        Trlog.enter(className, methodName, "sshKeyPath = " + sshKeyPath);
        File keyFile = new File(sshKeyPath);
        try {
            String privateKey = sshKeyUtil.readStringFromFile(keyFile);
            Trlog.exit(className, methodName, "Got the private key.");
            return PasswordUtil.passwordEncode((String)privateKey);
        }
        catch (IOException e) {
            Trlog.exit(className, methodName, "Caught an IOException: " + e.getMessage());
            throw new TaskErrorException(this.getMessage("ssh.couldNotReadSSHKeys", e.getMessage()));
        }
        catch (Exception e) {
            Trlog.exit(className, methodName, "Exception = " + e);
            return null;
        }
    }

    private String generateSSHKeyPair(SSHKeyGenerator sshKeyGen, SSHKeyUtility sshKeyUtil, String hostName) throws TaskErrorException {
        String publicKeyComment = "Generated SSH key for host " + hostName + " for Liberty management.";
        try {
            SSHKeyPair keyPair = sshKeyGen.generate(publicKeyComment);
            this.sshPublicKey = keyPair.getPublickKey();
            return PasswordUtil.passwordEncode((String)keyPair.getPrivatekey());
        }
        catch (NoSuchAlgorithmException e) {
            throw new TaskErrorException(this.getMessage("ssh.couldNotCreateSSHKeys", e.getMessage()));
        }
        catch (IllegalStateException e) {
            throw new TaskErrorException(this.getMessage("ssh.invalidSSHKeyPair", e.getMessage()));
        }
        catch (IOException e) {
            throw new TaskErrorException(this.getMessage("ssh.couldNotReadSSHKeys", e.getMessage()));
        }
    }

    protected void notifyIfMoreWorkToDo(String targetHostName) {
        if (this.sshPublicKey != null) {
            this.stdout.println(this.getMessage("ssh.installSSHPubKey", targetHostName, this.sshPublicKey));
        }
    }

    protected String insertHostAuthInfo(String[] args) {
        String methodName = "insertHostAuthInfo";
        Trlog.enter(className, methodName);
        String osName = System.getProperty("os.name", "").toUpperCase();
        boolean isWindows = osName.contains("WIN");
        Trlog.debug(className, methodName, "isWindows = " + isWindows);
        if (this.isDefaultHostAuthInfo && !isWindows) {
            Trlog.exit(className, methodName, "Nothing to be specify for a defaultHostAuthInfo on a non Window platform");
            return "";
        }
        Boolean useHostCredentials = Arrays.asList(args).contains(ARG_OPT_USE_HOST_CREDENTIALS);
        boolean firstPrinted = false;
        StringBuilder hostAuthInfoXML = new StringBuilder();
        hostAuthInfoXML.append("    <!-- Remote host authentication configuration -->" + NL);
        hostAuthInfoXML.append("    <hostAuthInfo ");
        if (useHostCredentials.booleanValue()) {
            Trlog.debug(className, methodName, "Use host credentials");
            firstPrinted = this.printLines(firstPrinted, hostAuthInfoXML);
            hostAuthInfoXML.append("useHostCredentials=\"true\"" + NL);
        } else {
            Trlog.debug(className, methodName, "Not use host credentials");
            String rpcHost = this.getArgumentValue(ARG_OPT_RPC_HOST, args, null);
            String rpcPort = this.getArgumentValue(ARG_OPT_RPC_PORT, args, null);
            String rpcUser = this.getArgumentValue(ARG_OPT_RPC_USER, args, null);
            String rpcUserHome = this.getArgumentValue(ARG_OPT_RPC_USER_HOME, args, null);
            String rpcUserPassword = this.getArgumentValue(ARG_OPT_RPC_USER_PASSWORD, args, null);
            String sshKeyPath = this.getArgumentValue(ARG_OPT_SSH_PRIVATE_KEY, args, null);
            String sshKeyPassword = this.getArgumentValue(ARG_OPT_SSH_PRIVATE_KEY_PASSWORD, args, null);
            String useSudo = this.getArgumentValue(ARG_OPT_USE_SUDO, args, null);
            String sudoUser = this.getArgumentValue(ARG_OPT_SUDO_USER, args, null);
            String sudoUserPassword = this.getArgumentValue(ARG_OPT_SUDO_USER_PASSWORD, args, null);
            String useCollectiveSSHKey = this.getArgumentValue(ARG_OPT_USE_COLLECTIVE_SSH_KEY, args, null);
            if (isWindows) {
                if (rpcUser == null) {
                    rpcUser = "admin_user_id";
                }
                if (rpcUserPassword == null) {
                    rpcUserPassword = "admin_user_password";
                }
            }
            if (useCollectiveSSHKey != null) {
                firstPrinted = this.printLines(firstPrinted, hostAuthInfoXML);
                hostAuthInfoXML.append("useCollectiveSSHKey=\"" + useCollectiveSSHKey + "\"" + NL);
            }
            if (rpcHost != null) {
                firstPrinted = this.printLines(firstPrinted, hostAuthInfoXML);
                hostAuthInfoXML.append("rpcHost=\"" + rpcHost + "\"" + NL);
            }
            if (rpcPort != null) {
                firstPrinted = this.printLines(firstPrinted, hostAuthInfoXML);
                hostAuthInfoXML.append("rpcPort=\"" + rpcPort + "\"" + NL);
            }
            if (rpcUser != null) {
                firstPrinted = this.printLines(firstPrinted, hostAuthInfoXML);
                hostAuthInfoXML.append("rpcUser=\"" + rpcUser + "\"" + NL);
            }
            if (rpcUserHome != null) {
                firstPrinted = this.printLines(firstPrinted, hostAuthInfoXML);
                hostAuthInfoXML.append("rpcUserHome=\"" + rpcUserHome + "\"" + NL);
            }
            if (rpcUserPassword != null) {
                firstPrinted = this.printLines(firstPrinted, hostAuthInfoXML);
                hostAuthInfoXML.append("rpcUserPassword=\"" + rpcUserPassword + "\"" + NL);
            }
            if (sshKeyPath != null) {
                firstPrinted = this.printLines(firstPrinted, hostAuthInfoXML);
                hostAuthInfoXML.append("sshPrivateKeyPath=\"" + sshKeyPath + "\"" + NL);
            }
            if (sshKeyPassword != null) {
                firstPrinted = this.printLines(firstPrinted, hostAuthInfoXML);
                hostAuthInfoXML.append("sshPrivateKeyPassword=\"" + sshKeyPassword + "\"" + NL);
            }
            if (useSudo != null) {
                firstPrinted = this.printLines(firstPrinted, hostAuthInfoXML);
                hostAuthInfoXML.append("useSudo=\"" + useSudo + "\"" + NL);
            }
            if (sudoUser != null) {
                firstPrinted = this.printLines(firstPrinted, hostAuthInfoXML);
                hostAuthInfoXML.append("sudoUser=\"" + sudoUser + "\"" + NL);
            }
            if (sudoUserPassword != null) {
                firstPrinted = this.printLines(firstPrinted, hostAuthInfoXML);
                hostAuthInfoXML.append("sudoUserPassword=\"" + sudoUserPassword + "\"" + NL);
            }
        }
        int lastNewline = hostAuthInfoXML.lastIndexOf(NL);
        hostAuthInfoXML.replace(lastNewline, hostAuthInfoXML.length(), " />" + NL + NL);
        Trlog.exit(className, methodName);
        return hostAuthInfoXML.toString();
    }

    private boolean printLines(boolean firstPrinted, StringBuilder hostAuthInfoXML) {
        if (firstPrinted) {
            hostAuthInfoXML.append("                  ");
        }
        return true;
    }

    protected void validateEncoding(String encoding, String key) throws TaskErrorException {
        String methodName = "validateEncoding";
        if (AES_ENCODING.equals(encoding) && key == null) {
            Trlog.debug(className, methodName, "Key is null for the aes encoding");
            this.abort(this.getMessage("encoding.aesRequiresKey", new Object[0]));
        } else if (XOR_ENCODING.equals(encoding) && key != null) {
            Trlog.debug(className, methodName, "the xor encoding does not support a key");
            this.abort(this.getMessage("encoding.xorDoesNotSupportKey", new Object[0]));
        } else if (!(XOR_ENCODING.equals(encoding) || AES_ENCODING.equals(encoding) || this.isSupportedCustomEncoding(encoding))) {
            Trlog.debug(className, methodName, "Unsupported encoding value " + encoding);
            this.abort(this.getMessage("encoding.unsupportedEncoding", encoding));
        }
    }

    private boolean isSupportedCustomEncoding(String encoding) {
        return encoding != null && encoding.length() > 0 && PasswordUtil.isValidCryptoAlgorithm((String)encoding);
    }

    protected String insertHostNameVariable(String hostName) {
        return "    <!-- Define the host name for use by the collective." + NL + "         If the host name needs to be changed, the server should be" + NL + "         removed from the collective and re-joined or re-replicated. -->" + NL + "    <variable name=\"defaultHostName\" value=\"" + hostName + "\" />" + NL;
    }

    protected String insertEncodingKey(String encoding, String key) {
        if (XOR_ENCODING.equals(encoding)) {
            return "";
        }
        return "    <!-- AES key used to encode the keystore passwords -->" + NL + "    <variable name=\"wlp.password.encryption.key\" value=\"" + key + "\" />" + NL + NL;
    }

    protected String getEndpointHost(String endpoint) {
        if (endpoint.contains(":") && endpoint.indexOf(":") == endpoint.lastIndexOf(":")) {
            return endpoint.split(":")[0];
        }
        return endpoint;
    }

    String getIncludePath(String serverDir, File outputFile) {
        File fServerDir = new File(serverDir);
        if (outputFile.getAbsolutePath().startsWith(fServerDir.getAbsolutePath())) {
            return outputFile.getAbsolutePath().replace(fServerDir.getAbsolutePath(), "${server.config.dir}");
        }
        File fWLP_USER = new File(this.fileUtility.getUserDir());
        if (outputFile.getAbsolutePath().startsWith(fWLP_USER.getAbsolutePath())) {
            return outputFile.getAbsolutePath().replace(fWLP_USER.getAbsolutePath(), "${wlp.user.dir}");
        }
        File fWLP_INSTALL = new File(this.fileUtility.getInstallDir());
        if (outputFile.getAbsolutePath().startsWith(fWLP_INSTALL.getAbsolutePath())) {
            return outputFile.getAbsolutePath().replace(fWLP_INSTALL.getAbsolutePath(), "${wlp.install.dir}");
        }
        return outputFile.getAbsolutePath();
    }

    protected File createConfigFileIfNeeded(String serverDir, String[] commandLine, String xmlSnippet) {
        String utilityName = this.scriptName;
        String taskName = this.getTaskName();
        File outputFile = null;
        Argument arg = new Argument(ARG_OPT_CREATE_CONFIG_FILE, commandLine);
        if (arg.isSpecified()) {
            String targetFilepath = arg.getValue();
            outputFile = this.generateConfigFileName(utilityName, taskName, serverDir, targetFilepath);
            String xmlTemplate = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>" + NL + "<server description=\"This file was generated by the ''{0} {1}'' command on {2,date,yyyy-MM-dd HH:mm:ss z}.\">" + NL + "{3}" + NL + "</server>" + NL;
            String xmlData = MessageFormat.format(xmlTemplate, utilityName, taskName, Calendar.getInstance().getTime(), xmlSnippet);
            this.fileUtility.createParentDirectory(this.stdout, outputFile);
            this.fileUtility.writeToFile(this.stderr, xmlData, outputFile);
        }
        return outputFile;
    }

    protected String getIncludeMessage(String serverDir, File outputFile) {
        return "    <include location=\"" + this.getIncludePath(serverDir, outputFile) + "\" />" + NL;
    }

    protected File generateConfigFileName(String utilityName, String taskName, String serverDir, String targetFilepath) {
        File outputFile;
        if (targetFilepath == null || targetFilepath.equals("")) {
            targetFilepath = serverDir + SLASH;
        }
        if (this.fileUtility.isDirectory(outputFile = new File(targetFilepath))) {
            outputFile = new File(outputFile, utilityName + "-" + taskName + "-include.xml");
        }
        if (this.fileUtility.exists(outputFile)) {
            String filePath = FilenameUtils.removeExtension((String)outputFile.getPath());
            String fileExt = FilenameUtils.getExtension((String)outputFile.getPath());
            int counter = 1;
            do {
                outputFile = new File(filePath + counter + "." + fileExt);
                ++counter;
            } while (this.fileUtility.exists(outputFile));
        }
        return outputFile;
    }

    protected boolean isConfigFileInDropins(String[] commandLine, boolean checkDefaultsOnly) {
        boolean match = false;
        String regex = "(.+)/configDropins/(defaults|overrides)/(.+)";
        if (checkDefaultsOnly) {
            regex = "(.+)/configDropins/defaults/(.+)";
        }
        Argument arg = new Argument(ARG_OPT_CREATE_CONFIG_FILE, commandLine);
        String targetFilepath = arg.getValue();
        if (arg.isSpecified() && arg.getValue() != null) {
            match = this.matches(regex, targetFilepath);
        }
        return match;
    }

    private boolean matches(String regex, String path) {
        boolean match = false;
        Pattern filepathPattern = Pattern.compile(regex);
        Matcher matcher = filepathPattern.matcher(path);
        if (matcher.matches()) {
            match = true;
        }
        return match;
    }

    protected void handleConfigXML(PrintStream stdout, String[] args, String serverDir, String configXML) {
        File configFile = this.createConfigFileIfNeeded(serverDir, args, configXML);
        if (configFile == null) {
            stdout.println(this.getMessage("common.updateServerXML", new Object[0]));
            stdout.println(configXML);
        } else {
            boolean checkDefaultsOnly = false;
            if (!this.isConfigFileInDropins(args, checkDefaultsOnly)) {
                String msg = this.getIncludeMessage(serverDir, configFile);
                stdout.println(this.getMessage("common.updateServerXML", new Object[0]));
                stdout.println(msg);
            }
        }
    }

    protected void setupTrace(String[] args, String cName, IFileUtility fileUtil) {
        this.enableTrace = Arrays.asList(args).contains(ARG_OPT_ENABLE_TRACE);
        if (this.enableTrace) {
            Trlog.setup(cName, fileUtil);
        }
    }

    Boolean isSingleCollectiveSSHKeyPairSupported(String controllerHost, int controllerPort, String user, String password, ICollectiveRegistrationMBeanConnection registrationMBean, File collectiveResourcesDir) throws TaskErrorException {
        if (this.enableTrace) {
            Trlog.debug("isSingleCollectiveSSHKeyPairSupported", "isSingleCollectiveSSHKeyPairSupported", "controllerHost=" + controllerHost + "controllerPort=" + controllerPort + "collectiveResourcesDir=" + collectiveResourcesDir.toString());
        }
        if (this.singleCollectiveSSHKeyPair == null) {
            this.singleCollectiveSSHKeyPair = new SingleCollectiveSSHKeyPair(controllerHost, controllerPort, user, password, registrationMBean, collectiveResourcesDir);
        }
        return this.singleCollectiveSSHKeyPair.isSupported();
    }

    String getSingleCollectivePublicSSHKey() {
        String retVal = null;
        if (this.singleCollectiveSSHKeyPair.isSupported()) {
            retVal = this.singleCollectiveSSHKeyPair.getPublicSSHKey();
        }
        return retVal;
    }

    public static void setSAFHandlers() {
        handlers.put("safkeyring", "com.ibm.crypto.provider.safkeyring.Handler");
        handlers.put("safkeyringhw", "com.ibm.crypto.hdwrCCA.provider.safkeyring.Handler");
        handlers.put("safkeyringhybrid", "com.ibm.crypto.ibmjcehybrid.provider.safkeyring.Handler");
    }

    protected String processKeyringURL(String safKeyringURL) {
        String processedUrl = null;
        if (safKeyringURL != null && this.safKeyringPattern.matcher(safKeyringURL).matches()) {
            processedUrl = safKeyringURL;
            if (!safKeyringURL.contains("///")) {
                int index = safKeyringURL.indexOf("//");
                StringBuffer sb = new StringBuffer(safKeyringURL);
                sb.insert(index, SLASH);
                processedUrl = sb.toString();
            }
        }
        return processedUrl;
    }

    protected Boolean verifySAFSSHKeys(String safKeyringURL, String certificateAlias, String safKeystoreType, String safKeystoreProvider, String keystoreRecoveringKeyPassword, Boolean abortOnFailure, File resourcesDir) throws TaskErrorException {
        String effectiveUrl = this.processKeyringURL(safKeyringURL);
        if (effectiveUrl == null) {
            this.issueMessageAndPerhapsAbort(this.getMessage("create.safKeyringBadValue", new Object[0]), abortOnFailure, resourcesDir);
            return false;
        }
        try {
            String keyringPrefix = effectiveUrl.substring(0, effectiveUrl.indexOf(":"));
            String jceHandler = handlers.get(keyringPrefix.toLowerCase());
            URLStreamHandler handler = (URLStreamHandler)Class.forName(jceHandler).newInstance();
            URL url = new URL(null, effectiveUrl, handler);
            KeyStore safKeystore = safKeystoreProvider == null ? KeyStore.getInstance(safKeystoreType) : KeyStore.getInstance(safKeystoreType, safKeystoreProvider);
            safKeystore.load(url.openConnection().getInputStream(), "password".toCharArray());
            PrivateKey privateKey = (PrivateKey)safKeystore.getKey(certificateAlias, keystoreRecoveringKeyPassword == null ? null : keystoreRecoveringKeyPassword.toCharArray());
            if (privateKey == null) {
                throw new Exception("The private key associated with certificate alias: " + certificateAlias + " and keyring:  " + safKeyringURL + " was not found.");
            }
            Certificate cert = safKeystore.getCertificate(certificateAlias);
            PublicKey publicKey = cert.getPublicKey();
            if (publicKey == null) {
                throw new Exception("The public key associated with certificate alias: " + certificateAlias + " and keyring:  " + safKeyringURL + " was not found.");
            }
        }
        catch (Exception e) {
            String suggestion = "\nValidate that the correct keyring path/name was specified.\nValidate that the correct keystore type was specified.\nValidate that the correct provider is defined in java.security.\nValidate that, if safKeystoreProvider option is used, the keystore type is supported by the specified provider.";
            String exceptionMsg = e.getMessage() == null ? "" : (e.getCause() == null ? e.getMessage() : e.getMessage() + ": " + e.getCause().getMessage());
            this.issueMessageAndPerhapsAbort(this.getMessage("ssh.couldNotReadSSHKeys", exceptionMsg + suggestion), abortOnFailure, resourcesDir);
            return false;
        }
        return true;
    }

    protected Boolean verifyFileSSHKeys(SSHKeyUtility sshKeyUtil, String sshPublicKeyPath, String sshPrivateKeyPath, String sshPrivateKeyPassword, Boolean abortOnFailure, File resourcesDir) throws TaskErrorException {
        String readPrivateKey = null;
        String readPublicKey = null;
        try {
            if (sshPublicKeyPath != null && !sshPublicKeyPath.isEmpty()) {
                readPublicKey = this.readSSHKey(sshPublicKeyPath, sshKeyUtil);
            }
            if (sshPrivateKeyPath != null && !sshPrivateKeyPath.isEmpty()) {
                readPrivateKey = this.readSSHKey(sshPrivateKeyPath, sshKeyUtil);
            }
        }
        catch (TaskErrorException tee) {
            throw tee;
        }
        catch (Exception e) {
            this.issueMessageAndPerhapsAbort(this.getMessage("ssh.couldNotReadSSHKeys", e.getMessage()), abortOnFailure, resourcesDir);
            return false;
        }
        if (readPrivateKey == null) {
            this.issueMessageAndPerhapsAbort(this.getMessage("ssh.couldNotReadSSHKeys", "Could not read private key from path:" + sshPrivateKeyPath), abortOnFailure, resourcesDir);
            return false;
        }
        if (readPublicKey == null) {
            this.issueMessageAndPerhapsAbort(this.getMessage("ssh.couldNotReadSSHKeys", "Could not read public key from path:" + sshPublicKeyPath), abortOnFailure, resourcesDir);
            return false;
        }
        return true;
    }

    protected Boolean verifySAFSSL(List<String> customKeystores, String certificateAlias, String safKeystoreType, String safKeystoreProvider, Boolean abortOnFailure, File resourcesDir) throws TaskErrorException {
        for (String keystoreURL : customKeystores) {
            String effectiveUrl = this.processKeyringURL(keystoreURL);
            if (effectiveUrl == null) {
                this.issueMessageAndPerhapsAbort(this.getMessage("create.safKeyringBadValue", new Object[0]), abortOnFailure, resourcesDir);
                return false;
            }
            try {
                String keyringPrefix = effectiveUrl.substring(0, effectiveUrl.indexOf(":"));
                String jceHandler = handlers.get(keyringPrefix.toLowerCase());
                URLStreamHandler handler = (URLStreamHandler)Class.forName(jceHandler).newInstance();
                URL url = new URL(null, effectiveUrl, handler);
                KeyStore safKeystore = safKeystoreProvider == null ? KeyStore.getInstance(safKeystoreType) : KeyStore.getInstance(safKeystoreType, safKeystoreProvider);
                safKeystore.load(url.openConnection().getInputStream(), "password".toCharArray());
                if (certificateAlias != null && !safKeystore.containsAlias(certificateAlias)) {
                    throw new Exception("Certificate with alias " + certificateAlias + " is not found in specified keystore");
                }
                if (safKeystore.size() >= 1) continue;
                throw new Exception(safKeystore + " keystore should have atleast one certificate installed");
            }
            catch (Exception e) {
                String suggestion = "\nValidate that the correct keyring path/name was specified.\nValidate that the correct keystore type was specified.\nValidate that the correct provider is defined in java.security.\nValidate that, if safKeystoreProvider option is used, the keystore type is supported by the specified provider.";
                String exceptionMsg = e.getMessage() == null ? "" : (e.getCause() == null ? e.getMessage() : e.getMessage() + ": " + e.getCause().getMessage());
                this.issueMessageAndPerhapsAbort(this.getMessage("custom.couldNotOpenKeystore", keystoreURL, exceptionMsg + suggestion), abortOnFailure, resourcesDir);
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Boolean verifyFileSSL(String serverIdentitycustomKS, String collectiveTrustcustomKS, String serverIdentityAlias, String serverIdentityKeystorePassword, String collectiveTrustKSPassword, Boolean abortOnFailure, File resourcesDir) throws TaskErrorException {
        KeyStore serverIdentityKeystore = null;
        KeyStore collectiveTrustKeystore = null;
        FileInputStream serverIdentityFS = null;
        FileInputStream collectiveTrustFS = null;
        String suggestion = "\nValidate that the correct file path/name was specified.\nValidate that correct keystore password is provided";
        try {
            serverIdentityFS = new FileInputStream(serverIdentitycustomKS);
            try {
                serverIdentityKeystore = KeyStore.getInstance("PKCS12");
                serverIdentityKeystore.load(serverIdentityFS, serverIdentityKeystorePassword.toCharArray());
            }
            catch (IOException io) {
                try {
                    serverIdentityKeystore = KeyStore.getInstance("JKS");
                    serverIdentityKeystore.load(serverIdentityFS, serverIdentityKeystorePassword.toCharArray());
                }
                catch (IOException io2) {
                    if (io.getCause() instanceof UnrecoverableKeyException || io2.getCause() instanceof UnrecoverableKeyException) {
                        throw new Exception("Provided serverIdentityKeystorePassword is incorrect");
                    }
                    throw new Exception("Could not open serverIdentityKeystore using PKCS12 or JKS");
                }
            }
            finally {
                serverIdentityFS.close();
            }
            collectiveTrustFS = new FileInputStream(collectiveTrustcustomKS);
            try {
                collectiveTrustKeystore = KeyStore.getInstance("PKCS12");
                collectiveTrustKeystore.load(collectiveTrustFS, collectiveTrustKSPassword.toCharArray());
            }
            catch (IOException io) {
                try {
                    collectiveTrustKeystore = KeyStore.getInstance("JKS");
                    collectiveTrustKeystore.load(collectiveTrustFS, collectiveTrustKSPassword.toCharArray());
                }
                catch (IOException io2) {
                    if (io.getCause() instanceof UnrecoverableKeyException || io2.getCause() instanceof UnrecoverableKeyException) {
                        throw new Exception("Provided collectiveTrustKSPassword is incorrect");
                    }
                    throw new Exception("Could not open collectiveTrustKeystore using PKCS12 or JKS");
                }
            }
            finally {
                collectiveTrustFS.close();
            }
            if (serverIdentityAlias != null && !serverIdentityKeystore.containsAlias(serverIdentityAlias)) {
                throw new Exception("Certificate with alias " + serverIdentityAlias + " is not found in specified keystore");
            }
            if (serverIdentityKeystore.size() < 1) {
                throw new Exception(serverIdentitycustomKS + " keystore should have atleast one certificate installed");
            }
            if (collectiveTrustKeystore.size() < 1) {
                throw new Exception(collectiveTrustcustomKS + " keystore should have atleast one certificate installed");
            }
        }
        catch (TaskErrorException tee) {
            throw tee;
        }
        catch (Exception e) {
            String exceptionMsg = e.getMessage() == null ? "" : (e.getCause() == null ? e.getMessage() : e.getMessage() + ": " + e.getCause().getMessage());
            this.issueMessageAndPerhapsAbort(this.getMessage("custom.couldNotOpenKeystore", serverIdentitycustomKS, exceptionMsg + suggestion), abortOnFailure, resourcesDir);
            return false;
        }
        return true;
    }

    private void issueMessageAndPerhapsAbort(String message, Boolean abortAfterMessage, File resourcesDir) throws TaskErrorException {
        if (abortAfterMessage.booleanValue()) {
            this.abortAndPerformCleanup(message, resourcesDir);
        } else {
            this.stdout.println(message);
        }
    }

    protected String customArgsFound(String[] args) throws TaskErrorException {
        String serverIdentityKeystore = this.getArgumentValue(ARG_OPT_SERVER_IDENTITY_KEYSTORE, args, null);
        String collectiveTrustKeystore = this.getArgumentValue(ARG_OPT_COLLECTIVE_TRUST_KEYSTORE, args, null);
        String type = "FILE";
        List<String> list = Arrays.asList(args);
        String effectiveServerIdentityUrl = this.processKeyringURL(serverIdentityKeystore);
        String effectiveCollectiveTrustUrl = this.processKeyringURL(collectiveTrustKeystore);
        if (list.contains(ARG_OPT_SETUP_SAF) || serverIdentityKeystore != null && effectiveServerIdentityUrl != null || collectiveTrustKeystore != null && effectiveCollectiveTrustUrl != null) {
            type = "SAF";
        }
        if (serverIdentityKeystore != null && effectiveServerIdentityUrl == null || collectiveTrustKeystore != null && effectiveCollectiveTrustUrl == null) {
            type = "CUSTOMFILE";
        }
        if (type.equals("SAF") || type.equals("CUSTOMFILE")) {
            String operation = this.getTaskName();
            this.checkSAFwithFileArgs(operation, args);
            this.validateCustomSAFOptions(operation, args);
        }
        return type;
    }

    protected boolean isContollerUsingCustomKeystore(String controllerHost, int controllerPort, String user, String password, ICollectiveRegistrationMBeanConnection registrationMBean, File collectiveResourcesDir) throws TaskErrorException {
        boolean supported = false;
        try {
            supported = registrationMBean.isContollerUsingCustomKeystore(controllerHost, controllerPort, user, password);
        }
        catch (AttributeNotFoundException e) {
            if (this.enableTrace) {
                Trlog.debug("isContollerUsingCustomKeystore", "isContollerUsingCustomKeystore", "AttributeNotFoundException while invoking the MBean for checkCustomKeystores, downlevel collective controller: ", e);
            }
        }
        catch (RuntimeMBeanException e) {
            if (this.enableTrace) {
                Trlog.debug("isContollerUsingCustomKeystore", "isContollerUsingCustomKeystore", "Caught RuntimeMBeanException, this may be expected, but here's the stack incase it helps.", e);
            }
            if (e.getCause() instanceof IllegalStateException) {
                this.abortAndPerformCleanup(this.getMessage("common.isThirdPartyKeystoresUsed", controllerHost), collectiveResourcesDir);
            } else if (e.getCause() instanceof IllegalArgumentException) {
                this.abortAndPerformCleanup(this.getMessage("common.connectionError", controllerHost, controllerPort, user, e.getMessage()), collectiveResourcesDir);
            } else {
                if (this.enableTrace) {
                    Trlog.debug("isContollerUsingCustomKeystore", "isContollerUsingCustomKeystore", "Unexpected RuntimeMBeanException while invoking the MBean: " + e.getMessage(), e);
                }
                this.stderr.println(this.getMessage("error", e.getMessage()));
                this.abortAndPerformCleanup(this.getMessage("common.connectionError", controllerHost, controllerPort, user, e.getMessage()), collectiveResourcesDir);
            }
        }
        catch (UnknownHostException e) {
            if (this.enableTrace) {
                Trlog.debug("isContollerUsingCustomKeystore", "isContollerUsingCustomKeystore", "UnknownHostException while invoking the MBean: " + e.getMessage(), e);
            }
            this.abortAndPerformCleanup(this.getMessage("common.hostError", controllerHost), collectiveResourcesDir);
        }
        catch (ConnectException e) {
            if (this.enableTrace) {
                Trlog.debug("isContollerUsingCustomKeystore", "isContollerUsingCustomKeystore", "ConnectException while invoking the MBean: " + e.getMessage(), e);
            }
            this.abortAndPerformCleanup(this.getMessage("common.portError", String.valueOf(controllerPort)), collectiveResourcesDir);
        }
        catch (IOException e) {
            if (this.enableTrace) {
                Trlog.debug("isContollerUsingCustomKeystore", "isContollerUsingCustomKeystore", "IOException while invoking the MBean: " + e.getMessage(), e);
            }
            this.stdout.println("IOException while invoking the MBean: " + e);
            this.abortAndPerformCleanup(this.getMessage("common.connectionError", controllerHost, controllerPort, user, e.getMessage()), collectiveResourcesDir);
        }
        catch (Exception e) {
            if (this.enableTrace) {
                Trlog.debug("isContollerUsingCustomKeystore", "isContollerUsingCustomKeystore", "Unexpected Exception while invoking the MBean: " + e.getMessage(), e);
            }
            this.stdout.println("Unexpected Exception while invoking the MBean: " + e);
            this.stderr.println(this.getMessage("error", e.getMessage()));
            this.abortAndPerformCleanup(this.getMessage("common.connectionError", controllerHost, controllerPort, user, e.getMessage()), collectiveResourcesDir);
        }
        return supported;
    }

    protected void checkSAFwithFileArgs(String operation, String[] args) throws TaskErrorException {
        block4: {
            boolean foundCustomCollectiveTrust;
            boolean foundCustomServerIdentity;
            ArrayList<String> fileArgs;
            block3: {
                List<String> list = Arrays.asList(args);
                fileArgs = new ArrayList<String>();
                fileArgs.add(ARG_OPT_SERVER_IDENTITY_CERT_VALIDITY);
                fileArgs.add(ARG_OPT_HTTPS_CERTIFICATE_SUBJECT);
                fileArgs.add(ARG_OPT_HTTPS_CERTIFICATE_VALIDITY);
                fileArgs.add(ARG_OPT_HTTPS_KEYSTORE_PASSWORD);
                fileArgs.add(ARG_OPT_HTTPS_TRUSTSTORE_PASSWORD);
                fileArgs.add(ARG_OPT_ROOT_KS_PASSWORD);
                ArrayList<String> SAFArgs = new ArrayList<String>();
                SAFArgs.add(ARG_OPT_SAF_CERTIFICATE_LABEL);
                SAFArgs.add(ARG_OPT_SAF_KEYRING);
                SAFArgs.add(ARG_OPT_SSH_PUBLIC_KEY);
                SAFArgs.add(ARG_OPT_SSH_PRIVATE_KEY);
                SAFArgs.add(ARG_OPT_SSH_PRIVATE_KEY_PASSWORD);
                ArrayList<String> commonKeystoreParams = new ArrayList<String>();
                commonKeystoreParams.add(ARG_OPT_SERVER_IDENTITY_KEYSTORE);
                commonKeystoreParams.add(ARG_OPT_SERVER_IDENTITY_ALIAS);
                commonKeystoreParams.add(ARG_OPT_SERVER_IDENTITY_KEYSTORE_PASSWORD);
                commonKeystoreParams.add(ARG_OPT_COLLECTIVE_TRUST_KEYSTORE);
                commonKeystoreParams.add(ARG_OPT_COLLECTIVE_TRUST_KS_PASSWORD);
                if (operation.equals("create")) {
                    commonKeystoreParams.addAll(SAFArgs);
                }
                commonKeystoreParams.addAll(fileArgs);
                boolean foundSAFSetup = list.contains(ARG_OPT_SETUP_SAF);
                foundCustomServerIdentity = this.checkArgInArgs(args, ARG_OPT_SERVER_IDENTITY_KEYSTORE);
                foundCustomCollectiveTrust = this.checkArgInArgs(args, ARG_OPT_COLLECTIVE_TRUST_KEYSTORE);
                if (!foundSAFSetup) break block3;
                for (String value : commonKeystoreParams) {
                    boolean foundValue = this.checkArgInArgs(args, value);
                    if (!foundValue || !foundSAFSetup) continue;
                    this.abort(this.getMessage("custom.ArugmentswithSAFWideArgument", ARG_OPT_SETUP_SAF, value));
                }
                break block4;
            }
            if (!foundCustomServerIdentity || !foundCustomCollectiveTrust) break block4;
            for (String value : fileArgs) {
                if (!this.checkArgInArgs(args, value)) continue;
                this.abort(this.getMessage("custom.ArugmentswithSAFWideArgument", "--serverIdentityKeystore & --collectiveTrustKeystore", value));
            }
        }
    }

    protected void validateCustomSAFOptions(String operation, String[] args) throws TaskErrorException {
        String keystorePassword = this.getArgumentValue(ARG_REQ_KEYSTORE_PASSWORD, args, null);
        String serverIdentityKeystore = this.getArgumentValue(ARG_OPT_SERVER_IDENTITY_KEYSTORE, args, null);
        String serverIdentityPw = this.getArgumentValue(ARG_OPT_SERVER_IDENTITY_KEYSTORE_PASSWORD, args, null);
        String collectiveTrustKeystore = this.getArgumentValue(ARG_OPT_COLLECTIVE_TRUST_KEYSTORE, args, null);
        String collectiveTrustPw = this.getArgumentValue(ARG_OPT_COLLECTIVE_TRUST_KS_PASSWORD, args, null);
        String effectiveServerIdentityUrl = this.processKeyringURL(serverIdentityKeystore);
        String effectiveCollectiveTrustUrl = this.processKeyringURL(collectiveTrustKeystore);
        String safKeyRing = this.getArgumentValue(ARG_OPT_SAF_KEYRING, args, null);
        String safCertificateLabel = this.getArgumentValue(ARG_OPT_SAF_CERTIFICATE_LABEL, args, null);
        if (serverIdentityKeystore != null && collectiveTrustKeystore == null || collectiveTrustKeystore != null && serverIdentityKeystore == null) {
            this.abort(this.getMessage("custom.missingKeystoreTruststore", ARG_OPT_SERVER_IDENTITY_KEYSTORE, ARG_OPT_COLLECTIVE_TRUST_KEYSTORE));
        }
        if (serverIdentityKeystore != null && collectiveTrustKeystore != null) {
            boolean safKeystores = false;
            if (effectiveServerIdentityUrl != null && effectiveCollectiveTrustUrl != null) {
                safKeystores = true;
            }
            if (operation.equals("create") && safKeystores && (safKeyRing == null || safCertificateLabel == null)) {
                this.abort(this.getMessage("custom.SAFSSLwithoutSAFSSH", new Object[0]));
            }
            if (!(effectiveServerIdentityUrl == null && effectiveCollectiveTrustUrl == null || safKeystores)) {
                this.abort(this.getMessage("custom.KeystoreTrustoreNotConsitent", new Object[0]));
            }
            if (!(safKeystores || serverIdentityPw != null && collectiveTrustPw != null || keystorePassword != null)) {
                this.abort(this.getMessage("custom.missingKeystorePassword", ARG_REQ_KEYSTORE_PASSWORD, ARG_OPT_SERVER_IDENTITY_KEYSTORE_PASSWORD, ARG_OPT_COLLECTIVE_TRUST_KS_PASSWORD));
            }
        }
    }

    protected String insertCustomSSLConfigs(String[] args, String safCertificateRdn, String serverIdentityKS, String serverIdentityAlias, String encodedServerIdentityKeystorePassword, String collectiveTrustKS, String encodedCollectiveTrustKSPassword) {
        String safKeystoreType = this.getArgumentValue(ARG_OPT_SAF_KEYSTORE_TYPE_LABEL, args, null);
        String safKeystoreProvider = this.getArgumentValue(ARG_OPT_SAF_KEYSTORE_PROVIDER_LABEL, args, null);
        StringBuffer KeystoreConfigInfoXML = new StringBuffer();
        String serverKeyAlias = "";
        String safKeystoreProviderValue = "";
        String safKeystoreTypeValue = "";
        String serverIdentityAttributes = "";
        String collectiveTrustAttributes = "";
        if (serverIdentityAlias != null) {
            serverKeyAlias = "serverKeyAlias=\"" + serverIdentityAlias + "\"";
        }
        if (safKeystoreProvider != null) {
            safKeystoreProviderValue = "provider=\"" + safKeystoreProvider + "\" ";
        }
        safKeystoreTypeValue = safKeystoreType != null ? "type=\"" + safKeystoreType + "\" " : "type=\"JCERACFKS\" ";
        if (encodedServerIdentityKeystorePassword != null && encodedCollectiveTrustKSPassword != null) {
            serverIdentityAttributes = "              password=\"" + encodedServerIdentityKeystorePassword + "\" />";
            collectiveTrustAttributes = "              password=\"" + encodedCollectiveTrustKSPassword + "\" />";
        } else {
            serverIdentityAttributes = "              password=\"password\" fileBased=\"false\" readOnly=\"true\" " + safKeystoreTypeValue + safKeystoreProviderValue + "/>";
            collectiveTrustAttributes = "              password=\"password\" fileBased=\"false\" readOnly=\"true\" " + safKeystoreTypeValue + safKeystoreProviderValue + "/>";
        }
        if (safCertificateRdn != null) {
            KeystoreConfigInfoXML.append("    <!-- collective certificate. Where the rdn attribute value is the safCertificateRdn value -->" + NL + "    <collectiveCertificate rdn=\"" + safCertificateRdn + "\" />" + NL + NL);
        }
        KeystoreConfigInfoXML.append("    <!-- clientAuthenticationSupported set to enable bidirectional trust -->" + NL + "    <ssl id=\"defaultSSLConfig\"" + NL + "         keyStoreRef=\"defaultKeyStore\" " + serverKeyAlias + NL + "         trustStoreRef=\"defaultTrustStore\"" + NL + "         clientAuthenticationSupported=\"true\" />" + NL + NL + "    <!-- inbound (HTTPS) keystore. Where the location attribute is the  safCommonKeyring value  -->" + NL + "    <keyStore id=\"defaultKeyStore\" location=\"" + serverIdentityKS + "\"" + NL + serverIdentityAttributes + NL + NL + "    <!-- inbound (HTTPS) truststore -->" + NL + "    <keyStore id=\"defaultTrustStore\" location=\"" + collectiveTrustKS + "\"" + NL + collectiveTrustAttributes + NL + NL + "    <!-- server identity keystore -->" + NL + "    <keyStore id=\"serverIdentity\" location=\"" + serverIdentityKS + "\"" + NL + serverIdentityAttributes + NL + NL + "    <!-- collective trust keystore -->" + NL + "    <keyStore id=\"collectiveTrust\" location=\"" + collectiveTrustKS + "\"" + NL + collectiveTrustAttributes + NL + NL);
        return KeystoreConfigInfoXML.toString();
    }

    static {
        BaseCommandTask.setSAFHandlers();
    }

    class SingleCollectiveSSHKeyPair {
        private boolean supported = false;
        private String collectivePublicKeyValue = null;

        SingleCollectiveSSHKeyPair(String controllerHost, int controllerPort, String user, String password, ICollectiveRegistrationMBeanConnection registrationMBean, File collectiveResourcesDir) throws TaskErrorException {
            try {
                this.collectivePublicKeyValue = registrationMBean.getPublicSSHKey(controllerHost, controllerPort, user, password);
                this.supported = true;
            }
            catch (AttributeNotFoundException anfe) {
                this.supported = false;
                if (BaseCommandTask.this.enableTrace) {
                    Trlog.debug("SingleCollectiveSSHKeyPair", "SingleCollectiveSSHKeyPair", "AttributeNotFoundException for publicSSHKey, controller is back level", anfe);
                }
            }
            catch (ReflectionException e) {
                if (BaseCommandTask.this.enableTrace) {
                    Trlog.debug("SingleCollectiveSSHKeyPair", "SingleCollectiveSSHKeyPair", "ReflectionException while invoking the MBean for getPublicSSHKey, downlevel collective controller: ", e);
                }
                this.supported = false;
            }
            catch (RuntimeMBeanException e) {
                if (BaseCommandTask.this.enableTrace) {
                    Trlog.debug("SingleCollectiveSSHKeyPair", "SingleCollectiveSSHKeyPair", "Caught RuntimeMBeanException, this may be expected, but here's the stack incase it helps.", e);
                }
                if (e.getCause() instanceof IllegalStateException) {
                    BaseCommandTask.this.abortAndPerformCleanup(BaseCommandTask.this.getMessage("common.getPublicSSHKeyIll", controllerHost), collectiveResourcesDir);
                } else if (e.getCause() instanceof IllegalArgumentException) {
                    BaseCommandTask.this.abortAndPerformCleanup(BaseCommandTask.this.getMessage("common.connectionError", controllerHost, controllerPort, user, e.getMessage()), collectiveResourcesDir);
                } else {
                    if (BaseCommandTask.this.enableTrace) {
                        Trlog.debug("SingleCollectiveSSHKeyPair", "SingleCollectiveSSHKeyPair", "Unexpected RuntimeMBeanException while invoking the MBean: " + e.getMessage(), e);
                    }
                    BaseCommandTask.this.stderr.println(BaseCommandTask.this.getMessage("error", e.getMessage()));
                    BaseCommandTask.this.abortAndPerformCleanup(BaseCommandTask.this.getMessage("common.connectionError", controllerHost, controllerPort, user, e.getMessage()), collectiveResourcesDir);
                }
            }
            catch (UnknownHostException e) {
                if (BaseCommandTask.this.enableTrace) {
                    Trlog.debug("SingleCollectiveSSHKeyPair", "SingleCollectiveSSHKeyPair", "UnknownHostException while invoking the MBean: " + e.getMessage(), e);
                }
                BaseCommandTask.this.abortAndPerformCleanup(BaseCommandTask.this.getMessage("common.hostError", controllerHost), collectiveResourcesDir);
            }
            catch (ConnectException e) {
                if (BaseCommandTask.this.enableTrace) {
                    Trlog.debug("SingleCollectiveSSHKeyPair", "SingleCollectiveSSHKeyPair", "ConnectException while invoking the MBean: " + e.getMessage(), e);
                }
                BaseCommandTask.this.abortAndPerformCleanup(BaseCommandTask.this.getMessage("common.portError", String.valueOf(controllerPort)), collectiveResourcesDir);
            }
            catch (IOException e) {
                if (BaseCommandTask.this.enableTrace) {
                    Trlog.debug("SingleCollectiveSSHKeyPair", "SingleCollectiveSSHKeyPair", "IOException while invoking the MBean: " + e.getMessage(), e);
                }
                BaseCommandTask.this.stdout.println("IOException while invoking the MBean: " + e);
                BaseCommandTask.this.abortAndPerformCleanup(BaseCommandTask.this.getMessage("common.connectionError", controllerHost, controllerPort, user, e.getMessage()), collectiveResourcesDir);
            }
            catch (Exception e) {
                if (BaseCommandTask.this.enableTrace) {
                    Trlog.debug("SingleCollectiveSSHKeyPair", "SingleCollectiveSSHKeyPair", "Unexpected Exception while invoking the MBean: " + e.getMessage(), e);
                }
                BaseCommandTask.this.stdout.println("Unexpected Exception while invoking the MBean: " + e);
                BaseCommandTask.this.stderr.println(BaseCommandTask.this.getMessage("error", e.getMessage()));
                BaseCommandTask.this.abortAndPerformCleanup(BaseCommandTask.this.getMessage("common.connectionError", controllerHost, controllerPort, user, e.getMessage()), collectiveResourcesDir);
            }
        }

        boolean isSupported() {
            return this.supported;
        }

        String getPublicSSHKey() {
            return this.collectivePublicKeyValue;
        }
    }

    class Argument {
        private boolean specified = false;
        private final String value;

        Argument(String argName, String[] commandLine) {
            String MAGICAL_SENTINEL = "@!$#%$#%32543265k425k4/3nj5k43n?m2|5k4\\n5k2345";
            this.value = BaseCommandTask.this.getArgumentValue(argName, commandLine, "@!$#%$#%32543265k425k4/3nj5k43n?m2|5k4\\n5k2345");
            if (this.value != "@!$#%$#%32543265k425k4/3nj5k43n?m2|5k4\\n5k2345") {
                this.specified = true;
            }
        }

        boolean isSpecified() {
            return this.specified;
        }

        String getValue() {
            return this.value;
        }
    }
}

