/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collective.singleton.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.collective.member.HostNameUtility;
import com.ibm.ws.collective.singleton.HostSingletonElectorHelper;
import com.ibm.ws.collective.singleton.ServiceEndpointIdentityImpl;
import com.ibm.ws.collective.singleton.internal.MessengerImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.collective.repository.RepositoryMember;
import com.ibm.wsspi.collective.singleton.ServiceEndpointIdentity;
import com.ibm.wsspi.collective.singleton.SingletonService;
import com.ibm.wsspi.collective.singleton.extender.Elector;
import com.ibm.wsspi.collective.singleton.extender.SingletonServiceExtender;
import com.ibm.wsspi.collective.singleton.extender.exceptions.ElectorException;
import com.ibm.wsspi.collective.singleton.messaging.Messenger;
import com.ibm.wsspi.collective.singleton.provider.Candidate;
import com.ibm.wsspi.collective.singleton.provider.Participant;
import com.ibm.wsspi.collective.singleton.provider.SingletonServiceManagerProvider;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class SingletonServiceImpl
implements SingletonServiceExtender {
    private static final TraceComponent tc = Tr.register(SingletonServiceImpl.class, (String)"Singleton", (String)"com.ibm.ws.collective.singleton.internal.resources.SingletonMessages");
    private static final String SINGLETON_REPOSITORY_PATH = "/sys.was.system/singleton/";
    private final String name;
    private final SingletonService.SingletonScope scope;
    private Elector elector;
    private Messenger messenger;
    private Participant localParticipant;
    private Participant previousParticipant;
    private ServiceEndpointIdentity leader;
    private SingletonServiceManagerProvider manager;
    private RepositoryMember member;
    private final ScheduledExecutorService scheduledExecutor;
    static final long serialVersionUID = -3340935532688218048L;

    public SingletonServiceImpl(String name, SingletonService.SingletonScope scope, ScheduledExecutorService scheduledExecutorService) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("The singleton service name cannot be null or empty");
        }
        this.name = name;
        this.scope = scope;
        this.leader = ServiceEndpointIdentityImpl.NULL_IDENTITY;
        this.messenger = new MessengerImpl();
        this.scheduledExecutor = scheduledExecutorService;
    }

    public void setSingletonServiceManager(SingletonServiceManagerProvider manager) {
        this.manager = manager;
    }

    public String getName() {
        return this.name;
    }

    public SingletonService.SingletonScope getScope() {
        return this.scope;
    }

    @FFDCIgnore(value={ElectorException.class})
    public void setElector(Elector e) throws ElectorException {
        this.elector = e;
        try {
            e.start();
        }
        catch (ElectorException e1) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Caught ElectorException", (Object[])new Object[]{e1});
            }
            throw e1;
        }
    }

    public void setMessenger(Messenger m) {
        this.messenger = m;
    }

    public Messenger getMessenger() {
        return this.messenger;
    }

    @FFDCIgnore(value={ElectorException.class})
    public void registerParticipant(Participant p) throws ElectorException {
        this.localParticipant = p;
        this.previousParticipant = null;
        ServiceEndpointIdentity identity = this.manager.createServiceEndpointIdentity(this.name, this.scope);
        p.setIdentity(identity);
        try {
            this.elector.participantRegistered(identity);
        }
        catch (ElectorException e) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Caught ElectorException", (Object[])new Object[]{e});
            }
            throw e;
        }
        Tr.info((TraceComponent)tc, (String)"LOCAL_PARTICIPANT_REGISTERED", (Object[])new Object[]{identity});
    }

    @FFDCIgnore(value={ElectorException.class})
    public void unregisterParticipant(Participant p) throws ElectorException {
        this.previousParticipant = this.localParticipant;
        this.localParticipant = null;
        ServiceEndpointIdentity identity = p.getIdentity();
        try {
            this.elector.participantUnregistered(identity);
        }
        catch (ElectorException e) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Caught ElectorException", (Object[])new Object[]{e});
            }
            throw e;
        }
        Tr.info((TraceComponent)tc, (String)"LOCAL_PARTICIPANT_UNREGISTERED", (Object[])new Object[]{identity});
    }

    public Set<ServiceEndpointIdentity> getParticipants() {
        return this.elector.getParticipants();
    }

    @FFDCIgnore(value={ElectorException.class})
    public ServiceEndpointIdentity registerCandidate(Candidate c) throws ElectorException {
        this.localParticipant = c;
        this.previousParticipant = null;
        ServiceEndpointIdentity identity = this.manager.createServiceEndpointIdentity(this.name, this.scope);
        c.setIdentity(identity);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Registering candidate with identity: " + identity + " to SingletonService " + this), (Object[])new Object[0]);
        }
        try {
            this.elector.candidateRegistered(identity);
        }
        catch (ElectorException e) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Caught ElectorException", (Object[])new Object[]{e});
            }
            throw e;
        }
        return this.leader;
    }

    @FFDCIgnore(value={ElectorException.class})
    public void unregisterCandidate(Candidate c) throws ElectorException {
        this.previousParticipant = this.localParticipant;
        this.localParticipant = null;
        ServiceEndpointIdentity identity = c.getIdentity();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Unegistering candidate with identity: " + identity + " from SingletonService " + this), (Object[])new Object[0]);
        }
        try {
            this.elector.candidateUnregistered(identity);
            Tr.info((TraceComponent)tc, (String)"LOCAL_CANDIDATE_UNREGISTERED", (Object[])new Object[]{identity});
        }
        catch (ElectorException e) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Caught ElectorException", (Object[])new Object[]{e});
            }
            throw e;
        }
    }

    public Set<ServiceEndpointIdentity> getCandidates() {
        return this.elector.getCandidates();
    }

    public ServiceEndpointIdentity getLeader() {
        if (this.leader == null || this.leader.isNull()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Getting leader from elector", (Object[])new Object[0]);
            }
            this.leader = this.elector.getLeader();
        }
        return this.leader;
    }

    public void leaderElected(ServiceEndpointIdentity id) {
        this.leader = id;
        if (this.localParticipant != null) {
            if (this.leader.equals(this.localParticipant.getIdentity())) {
                if (this.localParticipant instanceof Candidate) {
                    Tr.info((TraceComponent)tc, (String)"LOCAL_CANDIDATE_ELECTED", (Object[])new Object[]{id});
                    ((Candidate)this.localParticipant).elected();
                    if (this.scope.equals((Object)SingletonService.SingletonScope.COLLECTIVE)) {
                        this.scheduledExecutor.execute(new StoreLeaderID(id, false));
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"A participant was elected?!?!", (Object[])new Object[0]);
                }
            } else {
                Tr.info((TraceComponent)tc, (String)"REMOTE_CANDIDATE_ELECTED", (Object[])new Object[]{id});
                this.localParticipant.leaderElected(this.leader);
            }
        }
    }

    public void leaderUnelected(ServiceEndpointIdentity id) {
        Participant participant = this.localParticipant;
        if (participant == null && this.previousParticipant != null) {
            participant = this.previousParticipant;
        }
        try {
            if (participant != null) {
                if (participant instanceof Candidate) {
                    if (this.leader.equals(participant.getIdentity())) {
                        ((Candidate)participant).unelected();
                        Tr.info((TraceComponent)tc, (String)"LOCAL_CANDIDATE_UNELECTED", (Object[])new Object[]{id});
                    }
                } else {
                    Tr.info((TraceComponent)tc, (String)"REMOTE_CANDIDATE_UNELECTED", (Object[])new Object[]{id});
                    participant.leaderUnelected(id);
                }
                this.leader = ServiceEndpointIdentityImpl.NULL_IDENTITY;
            }
        }
        finally {
            this.previousParticipant = null;
        }
    }

    public void participantRegistered(ServiceEndpointIdentity participant) {
        if (this.localParticipant != null && this.localParticipant.getIdentity().equals(this.leader)) {
            Tr.info((TraceComponent)tc, (String)"REMOTE_PARTICIPANT_REGISTERED", (Object[])new Object[]{participant});
            ((Candidate)this.localParticipant).participantRegistered(participant);
        }
    }

    public void participantUnregistered(ServiceEndpointIdentity participant) {
        if (this.localParticipant != null && this.localParticipant.getIdentity().equals(this.leader)) {
            Tr.info((TraceComponent)tc, (String)"REMOTE_PARTICIPANT_UNREGISTERED", (Object[])new Object[]{participant});
            ((Candidate)this.localParticipant).participantUnregistered(participant);
        }
    }

    public void candidateRegistered(ServiceEndpointIdentity candidate) {
        if (this.localParticipant != null && this.localParticipant.getIdentity().equals(this.leader)) {
            Tr.info((TraceComponent)tc, (String)"REMOTE_CANDIDATE_REGISTERED", (Object[])new Object[]{candidate});
            ((Candidate)this.localParticipant).candidateRegistered(candidate);
        }
    }

    public void candidateUnregistered(ServiceEndpointIdentity candidate) {
        if (this.localParticipant != null && this.localParticipant.getIdentity().equals(this.leader)) {
            Tr.info((TraceComponent)tc, (String)"REMOTE_CANDIDATE_UNREGISTERED", (Object[])new Object[]{candidate});
            ((Candidate)this.localParticipant).candidateUnregistered(candidate);
        }
    }

    public void setRepositoryMember(RepositoryMember member) {
        this.member = member;
    }

    public RepositoryMember getRepositoryMember() {
        return this.member;
    }

    public Participant getLocalParticipant() {
        return this.localParticipant;
    }

    public void partitioned() {
        if (this.localParticipant != null) {
            this.localParticipant.partitioned();
        }
    }

    public void unPartitioned() {
        if (this.localParticipant != null) {
            this.localParticipant.unPartitioned();
        }
    }

    public ServiceEndpointIdentity getServiceEndpointIdentity(String s) {
        ServiceEndpointIdentity id;
        if (s == null || s.isEmpty()) {
            id = ServiceEndpointIdentityImpl.NULL_IDENTITY;
        } else {
            id = new ServiceEndpointIdentityImpl();
            id.fromCanonicalForm(s);
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FFDCIgnore(value={IllegalStateException.class})
    private void storeLeaderToRepository(ServiceEndpointIdentity leader) {
        boolean success = false;
        try {
            String path = SINGLETON_REPOSITORY_PATH + this.name + "/leader";
            success = this.member.exists(path) ? this.member.setData(path, (Object)leader.toCanonicalForm()) : this.member.create(path, (Object)leader.toCanonicalForm());
            if (!success && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Could not store leader in repository.", (Object[])new Object[0]);
            }
        }
        catch (IllegalStateException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Could not store leader in repository, with exception " + e), (Object[])new Object[0]);
            }
        }
        catch (Exception interval) {
            FFDCFilter.processException((Throwable)interval, (String)"com.ibm.ws.collective.singleton.internal.SingletonServiceImpl", (String)"475", (Object)this, (Object[])new Object[]{leader});
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Could not store leader in repository, with exception " + e), (Object[])new Object[0]);
            }
        }
        finally {
            int interval = 5;
            if (!success) {
                this.scheduledExecutor.schedule(new StoreLeaderID(leader, true), 5L, TimeUnit.SECONDS);
            }
        }
    }

    boolean amIStillLeader() {
        return this.localParticipant != null && this.localParticipant instanceof Candidate && this.leader.equals(this.localParticipant.getIdentity());
    }

    public String getQualifiedElectorIdentity() {
        String electorID = this.elector.getIdentity();
        String identity = this.name + "#" + this.scope.name() + "#";
        if (this.scope == SingletonService.SingletonScope.HOST) {
            identity = identity + HostNameUtility.getFullyQualifiedHostName() + "#";
        }
        identity = identity + electorID;
        return identity;
    }

    public boolean electorsOfSameSingleton(String id1, String id2) {
        boolean sameFlag = false;
        if (id1 == null || id2 == null) {
            return sameFlag;
        }
        String[] id1Parts = id1.split("#");
        String[] id2Parts = id2.split("#");
        if (id1Parts.length < 3 || id2Parts.length < 3) {
            return sameFlag;
        }
        String id1Name = id1Parts[0];
        String id2Name = id2Parts[0];
        String id1Scope = id1Parts[1];
        String id2Scope = id2Parts[1];
        if (id1Name.equals(id2Name) && id1Scope.equals(id2Scope)) {
            String id1Host = "none";
            String id2Host = "none";
            if (id1Scope.equals(SingletonService.SingletonScope.HOST.name()) && id2Scope.equals(SingletonService.SingletonScope.HOST.name())) {
                String electorId2;
                String electorId1;
                if (id1Parts.length < 4 || id2Parts.length < 4) {
                    return sameFlag;
                }
                id1Host = id1Parts[2];
                id2Host = id2Parts[2];
                if (id1Host.equals(id2Host) && HostSingletonElectorHelper.electorsOfSameSingleton(electorId1 = id1Parts[3], electorId2 = id2Parts[3])) {
                    sameFlag = true;
                }
            } else if (id1Scope.equals(SingletonService.SingletonScope.COLLECTIVE.name()) && id2Scope.equals(SingletonService.SingletonScope.COLLECTIVE.name())) {
                sameFlag = true;
            }
        }
        return sameFlag;
    }

    void setLeaderIdentity(Candidate leader, ServiceEndpointIdentity identity) {
        leader.setIdentity(identity);
    }

    void setLocalParticipantAsLeader(Candidate leader) {
        this.localParticipant = leader;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    final class StoreLeaderID
    implements Runnable {
        private final ServiceEndpointIdentity leader;
        private final boolean checkForLeader;
        static final long serialVersionUID = -6587335971158994869L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public StoreLeaderID(ServiceEndpointIdentity id, boolean checkForLeader) {
            this.leader = id;
            this.checkForLeader = checkForLeader;
        }

        @Override
        public synchronized void run() {
            if (this.checkForLeader) {
                if (SingletonServiceImpl.this.amIStillLeader()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"The local candidate in ScheduledStoreLeaderToRepository() is still the elected leader:", (Object[])new Object[]{this.leader + ", store the leader id to respository again as the previous store operation failed"});
                    }
                    SingletonServiceImpl.this.storeLeaderToRepository(this.leader);
                }
            } else {
                SingletonServiceImpl.this.storeLeaderToRepository(this.leader);
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.collective.singleton.internal.SingletonServiceImpl$StoreLeaderID", StoreLeaderID.class, (String)"Singleton", (String)"com.ibm.ws.collective.singleton.internal.resources.SingletonMessages");
        }
    }
}

