/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.jca.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.websphere.security.auth.data.AuthData;
import com.ibm.websphere.security.auth.data.AuthDataProvider;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.SecurityService;
import com.ibm.ws.security.authentication.principals.WSPrincipal;
import com.ibm.ws.security.authentication.utility.SubjectHelper;
import com.ibm.ws.security.intfc.SubjectManagerService;
import com.ibm.ws.security.jca.AuthDataService;
import com.ibm.ws.security.kerberos.auth.KerberosService;
import com.ibm.ws.security.kerberos.auth.Krb5LoginModuleWrapper;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.security.auth.callback.WSMappingCallbackHandler;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.ietf.jgss.GSSCredential;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class AuthDataServiceImpl
implements AuthDataService {
    private static final TraceComponent tc = Tr.register(AuthDataServiceImpl.class, (String)"AuthData", null);
    protected static final String CFG_KEY_ID = "id";
    protected static final String CFG_KEY_DISPLAY_ID = "config.displayId";
    protected static final String CFG_KEY_USER = "user";
    protected static final String CFG_KEY_PASSWORD = "password";
    protected static final String KEY_SECURITY_SERVICE = "securityService";
    private static final String KEY_AUTH_DATA_ALIAS = "com.ibm.mapping.authDataAlias";
    private final AtomicServiceReference<SecurityService> securityServiceRef = new AtomicServiceReference("securityService");
    private final AtomicServiceReference<KerberosService> krb5ServiceRef = new AtomicServiceReference("krb5Service");
    private final AtomicServiceReference<AuthDataProvider> authDataProviderRef = new AtomicServiceReference("authDataProvider");
    private final AtomicServiceReference<SubjectManagerService> smServiceRef = new AtomicServiceReference("subjectManagerService");
    static final long serialVersionUID = -6455923475118738991L;

    @Reference(service=SecurityService.class, policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL)
    protected void setSecurityService(ServiceReference<SecurityService> ref) {
        this.securityServiceRef.setReference(ref);
    }

    protected void unsetSecurityService(ServiceReference<SecurityService> reference) {
        this.securityServiceRef.unsetReference(reference);
    }

    protected void setKrb5Service(ServiceReference<KerberosService> ref) {
        this.krb5ServiceRef.setReference(ref);
    }

    protected void unsetKrb5Service(ServiceReference<KerberosService> ref) {
        this.krb5ServiceRef.unsetReference(ref);
    }

    protected void setAuthDataProvider(ServiceReference<AuthDataProvider> reference) {
        this.authDataProviderRef.setReference(reference);
    }

    protected void unsetAuthDataProvider(ServiceReference<AuthDataProvider> reference) {
        this.authDataProviderRef.unsetReference(reference);
    }

    protected void setSubjectManagerService(ServiceReference<SubjectManagerService> reference) {
        this.smServiceRef.setReference(reference);
    }

    protected void unsetSubjectManagerService(ServiceReference<SubjectManagerService> reference) {
        this.smServiceRef.unsetReference(reference);
    }

    protected void activate(ComponentContext cc, Map<String, Object> props) {
        this.krb5ServiceRef.activate(cc);
        this.authDataProviderRef.activate(cc);
        this.securityServiceRef.activate(cc);
        this.smServiceRef.activate(cc);
    }

    protected void deactivate(ComponentContext cc) {
        this.krb5ServiceRef.deactivate(cc);
        this.authDataProviderRef.deactivate(cc);
        this.securityServiceRef.deactivate(cc);
        this.smServiceRef.deactivate(cc);
    }

    @Override
    public Subject getSubject(ManagedConnectionFactory managedConnectionFactory, String jaasEntryName, Map<String, Object> loginData) throws LoginException {
        if (jaasEntryName != null) {
            return this.createSubjectUsingJAAS(jaasEntryName, managedConnectionFactory, loginData);
        }
        return this.createSubjectUsingAuthData(managedConnectionFactory, loginData);
    }

    private Subject createSubjectUsingJAAS(String jaasEntryName, ManagedConnectionFactory managedConnectionFactory, Map<String, Object> loginData) throws LoginException {
        WSMappingCallbackHandler callbackHandler = new WSMappingCallbackHandler(loginData, managedConnectionFactory);
        LoginContext loginContext = new LoginContext(jaasEntryName, (CallbackHandler)callbackHandler);
        loginContext.login();
        Subject subject = loginContext.getSubject();
        this.addInvocationSubjectPrincipal(subject);
        return subject;
    }

    private Subject createSubjectUsingAuthData(ManagedConnectionFactory managedConnectionFactory, Map<String, Object> loginData) throws LoginException {
        String authDataAlias = this.getAuthDataAlias(loginData);
        AuthData authData = this.getAuthData(authDataAlias);
        return this.obtainSubject(managedConnectionFactory, authData);
    }

    private String getAuthDataAlias(Map<String, Object> loginData) {
        return loginData != null ? (String)loginData.get(KEY_AUTH_DATA_ALIAS) : null;
    }

    private AuthData getAuthData(String authDataAlias) throws LoginException {
        AuthDataProvider cfr_ignored_0 = (AuthDataProvider)this.authDataProviderRef.getService();
        return AuthDataProvider.getAuthData((String)authDataAlias);
    }

    private Subject obtainSubject(ManagedConnectionFactory managedConnectionFactory, AuthData authData) throws LoginException {
        if (authData.getKrb5Principal() != null) {
            return this.doKerberosLogin(authData.getKrb5Principal());
        }
        Subject subject = this.createSubject(managedConnectionFactory, authData);
        this.addInvocationSubjectPrincipal(subject);
        this.optimize(subject);
        return subject;
    }

    private Subject doKerberosLogin(String principal) throws LoginException {
        final Subject subject = new Subject();
        Krb5LoginModuleWrapper krb5 = new Krb5LoginModuleWrapper();
        HashMap<String, String> options = new HashMap<String, String>();
        HashMap sharedState = new HashMap();
        Path keytab = ((KerberosService)this.krb5ServiceRef.getService()).getKeytab();
        options.put("isInitiator", "true");
        options.put("refreshKrb5Config", "true");
        options.put("doNotPrompt", "true");
        options.put("useKeyTab", "true");
        if (keytab != null) {
            options.put("keyTab", keytab.toAbsolutePath().toString());
        }
        options.put("principal", principal);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            options.put("debug", "true");
            Tr.debug((TraceComponent)tc, (String)("All kerberos config properties are: " + options), (Object[])new Object[0]);
        }
        krb5.initialize(subject, null, sharedState, options);
        krb5.login();
        krb5.commit();
        Set<GSSCredential> gssCreds = subject.getPrivateCredentials(GSSCredential.class);
        if (gssCreds == null || gssCreds.size() == 0) {
            final GSSCredential gssCred = SubjectHelper.createGSSCredential((Subject)subject);
            if (System.getSecurityManager() == null) {
                subject.getPrivateCredentials().add(gssCred);
            } else {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){
                    static final long serialVersionUID = 4094042810491084230L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public Void run() {
                        subject.getPrivateCredentials().add(gssCred);
                        return null;
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.jca.internal.AuthDataServiceImpl$1", 1.class, (String)"AuthData", null);
                    }
                });
            }
        }
        return subject;
    }

    private Subject createSubject(ManagedConnectionFactory managedConnectionFactory, AuthData authData) {
        Subject subject = new Subject();
        String userName = authData.getUserName();
        char[] password = authData.getPassword();
        final PasswordCredential passwordCredential = new PasswordCredential(userName, password);
        passwordCredential.setManagedConnectionFactory(managedConnectionFactory);
        final Set<Object> creds = subject.getPrivateCredentials();
        if (System.getSecurityManager() == null) {
            creds.add(passwordCredential);
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){
                static final long serialVersionUID = -6208202862021938456L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Void run() {
                    creds.add(passwordCredential);
                    return null;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.jca.internal.AuthDataServiceImpl$2", 2.class, (String)"AuthData", null);
                }
            });
        }
        return subject;
    }

    private void addInvocationSubjectPrincipal(final Subject subject) {
        final WSPrincipal principal = this.getInvocationSubjectPrincipal();
        if (principal != null) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){
                static final long serialVersionUID = -3173843023571210550L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Void run() {
                    subject.getPrincipals().add((Principal)principal);
                    return null;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.jca.internal.AuthDataServiceImpl$3", 3.class, (String)"AuthData", null);
                }
            });
        }
    }

    @FFDCIgnore(value={Exception.class})
    private WSPrincipal getInvocationSubjectPrincipal() {
        Subject finalInvocationSubject;
        WSPrincipal principal = null;
        SubjectManagerService sms = (SubjectManagerService)this.smServiceRef.getService();
        if (sms != null && (finalInvocationSubject = sms.getInvocationSubject()) != null) {
            try {
                principal = AccessController.doPrivileged(new GetInvocationSubjectAction(finalInvocationSubject));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return principal;
    }

    private void optimize(final Subject subject) {
        if (System.getSecurityManager() == null) {
            subject.setReadOnly();
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){
                static final long serialVersionUID = 3833164123161684182L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Void run() {
                    subject.setReadOnly();
                    return null;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.jca.internal.AuthDataServiceImpl$4", 4.class, (String)"AuthData", null);
                }
            });
        }
    }

    @Trivial
    private static class GetInvocationSubjectAction
    implements PrivilegedAction<WSPrincipal> {
        final Subject subj;

        public GetInvocationSubjectAction(Subject subject) {
            this.subj = subject;
        }

        @Override
        public WSPrincipal run() {
            WSPrincipal invocationSubjectPrincipal = this.subj.getPrincipals(WSPrincipal.class).iterator().next();
            return new WSPrincipal(invocationSubjectPrincipal.getName(), invocationSubjectPrincipal.getAccessId(), invocationSubjectPrincipal.getAuthenticationMethod());
        }
    }
}

