/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.config14.sources;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.kernel.service.util.SecureAction;
import com.ibm.ws.microprofile.config14.sources.ConfigString;
import com.ibm.ws.microprofile.config14.sources.ExtendedConfigSource;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.security.AccessController;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class SystemConfig14Source
implements ExtendedConfigSource {
    private static final TraceComponent tc = Tr.register(SystemConfig14Source.class, (String)"APPCONFIG", (String)"com.ibm.ws.microprofile.config14.resources.Config14");
    static final SecureAction priv = (SecureAction)AccessController.doPrivileged(SecureAction.get());
    private final int ordinal = SystemConfig14Source.getSystemOrdinal();
    private final String name = Tr.formatMessage((TraceComponent)tc, (String)"system.properties.config.source", (Object[])new Object[0]);
    static final long serialVersionUID = 8959902425823355868L;

    public String getName() {
        return this.name;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public Map<String, String> getProperties() {
        return priv.getProperties().entrySet().stream().filter(e -> e.getKey() instanceof String && e.getValue() instanceof String).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (String)e.getValue()));
    }

    public Set<String> getPropertyNames() {
        return this.getProperties().keySet();
    }

    public String getValue(String key) {
        return priv.getProperty(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfigString getConfigString(String key) {
        Properties properties = priv.getProperties();
        ConfigString result = null;
        Properties properties2 = properties;
        synchronized (properties2) {
            if (properties.containsKey(key)) {
                result = ConfigString.of(properties.getProperty(key));
            }
        }
        if (result == null) {
            result = ConfigString.MISSING;
        }
        return result;
    }

    @Trivial
    public static int getSystemOrdinal() {
        String ordinalProp = SystemConfig14Source.getOrdinalSystemProperty();
        int ordinal = 400;
        if (ordinalProp != null) {
            ordinal = Integer.parseInt(ordinalProp);
        }
        return ordinal;
    }

    @Trivial
    private static String getOrdinalSystemProperty() {
        return priv.getProperty("config_ordinal");
    }

    public String toString() {
        return "System Properties Config Source";
    }
}

