/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.openapi.impl.core.jackson;

import com.fasterxml.jackson.databind.introspect.Annotated;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.microprofile.openapi.impl.model.media.SchemaImpl;
import com.ibm.ws.microprofile.openapi.impl.model.media.XMLImpl;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.eclipse.microprofile.openapi.models.media.XML;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
class JAXBAnnotationsHelper {
    private static final String JAXB_DEFAULT = "##default";
    static final long serialVersionUID = 7662281919025378215L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    private JAXBAnnotationsHelper() {
    }

    public static void apply(Annotated member, Schema property) {
        if (member.hasAnnotation(XmlElementWrapper.class) || member.hasAnnotation(XmlElement.class)) {
            JAXBAnnotationsHelper.applyElement(member, property);
        } else if (member.hasAnnotation(XmlAttribute.class) && JAXBAnnotationsHelper.isAttributeAllowed(property)) {
            JAXBAnnotationsHelper.applyAttribute(member, property);
        }
    }

    private static void applyElement(Annotated member, Schema property) {
        XmlElementWrapper wrapper = (XmlElementWrapper)member.getAnnotation(XmlElementWrapper.class);
        if (wrapper != null) {
            XML xml = JAXBAnnotationsHelper.getXml(property);
            xml.setWrapped(Boolean.valueOf(true));
            if (!(JAXB_DEFAULT.equals(wrapper.name()) || wrapper.name().isEmpty() || wrapper.name().equals(((SchemaImpl)property).getName()))) {
                xml.setName(wrapper.name());
            }
        } else {
            XmlElement element = (XmlElement)member.getAnnotation(XmlElement.class);
            if (element != null) {
                JAXBAnnotationsHelper.setName(element.namespace(), element.name(), property);
            }
        }
    }

    private static void applyAttribute(Annotated member, Schema property) {
        XmlAttribute attribute = (XmlAttribute)member.getAnnotation(XmlAttribute.class);
        if (attribute != null) {
            XML xml = JAXBAnnotationsHelper.getXml(property);
            xml.setAttribute(Boolean.valueOf(true));
            JAXBAnnotationsHelper.setName(attribute.namespace(), attribute.name(), property);
        }
    }

    private static XML getXml(Schema property) {
        XML existing = property.getXml();
        if (existing != null) {
            return existing;
        }
        XMLImpl created = new XMLImpl();
        property.setXml((XML)created);
        return created;
    }

    private static boolean setName(String ns, String name, Schema property) {
        String useNS;
        String useName;
        boolean apply = false;
        String cleanName = StringUtils.trimToNull((String)name);
        if (!JAXBAnnotationsHelper.isEmpty(cleanName) && !cleanName.equals(((SchemaImpl)property).getName())) {
            useName = cleanName;
            apply = true;
        } else {
            useName = null;
        }
        String cleanNS = StringUtils.trimToNull((String)ns);
        if (!JAXBAnnotationsHelper.isEmpty(cleanNS)) {
            useNS = cleanNS;
            apply = true;
        } else {
            useNS = null;
        }
        if (apply) {
            JAXBAnnotationsHelper.getXml(property).name(useName).namespace(useNS);
        }
        return apply;
    }

    private static boolean isAttributeAllowed(Schema property) {
        if (property.getType() == Schema.SchemaType.ARRAY || property.getType() == Schema.SchemaType.OBJECT) {
            return false;
        }
        return StringUtils.isBlank((CharSequence)property.getRef());
    }

    private static boolean isEmpty(String name) {
        return StringUtils.isEmpty((CharSequence)name) || JAXB_DEFAULT.equals(name);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.microprofile.openapi.impl.core.jackson.JAXBAnnotationsHelper", JAXBAnnotationsHelper.class, (String)"MPOPENAPI", (String)"com.ibm.ws.microprofile.openapi.resources.OpenAPI");
    }
}

