/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.openapi.impl.parser.processors;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.microprofile.openapi.impl.parser.OpenAPIResolver;
import com.ibm.ws.microprofile.openapi.impl.parser.ResolverCache;
import com.ibm.ws.microprofile.openapi.impl.parser.models.RefFormat;
import com.ibm.ws.microprofile.openapi.impl.parser.processors.OperationProcessor;
import com.ibm.ws.microprofile.openapi.impl.parser.processors.ParameterProcessor;
import com.ibm.ws.microprofile.openapi.impl.parser.processors.SchemaProcessor;
import com.ibm.ws.microprofile.openapi.impl.parser.util.RefUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.Paths;
import org.eclipse.microprofile.openapi.models.callbacks.Callback;
import org.eclipse.microprofile.openapi.models.media.Content;
import org.eclipse.microprofile.openapi.models.media.MediaType;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;
import org.eclipse.microprofile.openapi.models.parameters.RequestBody;
import org.eclipse.microprofile.openapi.models.responses.APIResponse;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class PathsProcessor {
    private final OpenAPI openAPI;
    private final ResolverCache cache;
    private final OpenAPIResolver.Settings settings;
    private final ParameterProcessor parameterProcessor;
    private final OperationProcessor operationProcessor;
    static final long serialVersionUID = -7139704180439545226L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public PathsProcessor(ResolverCache cache, OpenAPI openAPI) {
        this(cache, openAPI, new OpenAPIResolver.Settings());
    }

    public PathsProcessor(ResolverCache cache, OpenAPI openAPI, OpenAPIResolver.Settings settings) {
        this.openAPI = openAPI;
        this.cache = cache;
        this.settings = settings;
        this.parameterProcessor = new ParameterProcessor(cache, openAPI);
        this.operationProcessor = new OperationProcessor(cache, openAPI);
    }

    public void processPaths() {
        Paths pathMap = this.openAPI.getPaths();
        if (pathMap == null) {
            return;
        }
        for (String pathStr : pathMap.keySet()) {
            PathItem pathItem = (PathItem)pathMap.get(pathStr);
            this.addParametersToEachOperation(pathItem);
            if (pathItem.getRef() != null) {
                RefFormat refFormat = RefUtils.computeRefFormat(pathItem.getRef());
                PathItem resolvedPath = this.cache.loadRef(pathItem.getRef(), refFormat, PathItem.class);
                String pathRef = pathItem.getRef().split("#")[0];
                this.updateLocalRefs(resolvedPath, pathRef);
                if (resolvedPath != null) {
                    this.openAPI.path(pathStr, resolvedPath);
                    pathItem = resolvedPath;
                }
            }
            List<Parameter> processedPathParameters = this.parameterProcessor.processParameters(pathItem.getParameters());
            pathItem.setParameters(processedPathParameters);
            this.addParametersToEachOperation(pathItem);
            Map operationMap = pathItem.readOperationsMap();
            for (PathItem.HttpMethod httpMethod : operationMap.keySet()) {
                Operation operation = (Operation)operationMap.get(httpMethod);
                this.operationProcessor.processOperation(operation);
            }
        }
    }

    private void addParametersToEachOperation(PathItem pathItem) {
        if (this.settings.addParametersToEachOperation()) {
            List operations;
            List parameters = pathItem.getParameters();
            if (parameters != null && (operations = pathItem.readOperations()) != null) {
                for (Operation operation : operations) {
                    ArrayList<Parameter> parametersToAdd = new ArrayList<Parameter>();
                    List existingParameters = operation.getParameters();
                    for (Parameter parameterToAdd : parameters) {
                        boolean matched = false;
                        for (Parameter existingParameter : existingParameters) {
                            if (parameterToAdd.getIn() == null || !parameterToAdd.getIn().equals((Object)existingParameter.getIn()) || !parameterToAdd.getName().equals(existingParameter.getName())) continue;
                            matched = true;
                        }
                        if (matched) continue;
                        parametersToAdd.add(parameterToAdd);
                    }
                    if (parametersToAdd.size() <= 0) continue;
                    operation.getParameters().addAll(0, parametersToAdd);
                }
            }
            pathItem.setParameters(null);
        }
    }

    protected void updateLocalRefs(PathItem path, String pathRef) {
        if (path.getParameters() != null) {
            List params = path.getParameters();
            for (Parameter param : params) {
                this.updateLocalRefs(param, pathRef);
            }
        }
        List ops = path.readOperations();
        for (Operation op : ops) {
            if (op.getParameters() != null) {
                for (Parameter param : op.getParameters()) {
                    this.updateLocalRefs(param, pathRef);
                }
            }
            if (op.getResponses() != null) {
                for (APIResponse response : op.getResponses().values()) {
                    this.updateLocalRefs(response, pathRef);
                }
            }
            if (op.getRequestBody() != null) {
                this.updateLocalRefs(op.getRequestBody(), pathRef);
            }
            if (op.getCallbacks() == null) continue;
            Map callbacks = op.getCallbacks();
            for (String name : callbacks.keySet()) {
                Callback callback = (Callback)callbacks.get(name);
                if (callback == null) continue;
                for (String callbackName : callback.keySet()) {
                    PathItem pathItem = (PathItem)callback.get((Object)callbackName);
                    this.updateLocalRefs(pathItem, pathRef);
                }
            }
        }
    }

    protected void updateLocalRefs(APIResponse response, String pathRef) {
        if (response.getContent() != null) {
            Content content = response.getContent();
            for (String key : content.keySet()) {
                MediaType mediaType = (MediaType)content.get(key);
                if (mediaType.getSchema() == null) continue;
                this.updateLocalRefs(mediaType.getSchema(), pathRef);
            }
        }
    }

    protected void updateLocalRefs(Parameter param, String pathRef) {
        if (param.getSchema() != null) {
            this.updateLocalRefs(param.getSchema(), pathRef);
        }
        if (param.getContent() != null) {
            Content content = param.getContent();
            for (String key : content.keySet()) {
                MediaType mediaType = (MediaType)content.get(key);
                if (mediaType.getSchema() == null) continue;
                this.updateLocalRefs(mediaType.getSchema(), pathRef);
            }
        }
    }

    protected void updateLocalRefs(RequestBody body, String pathRef) {
        if (body.getContent() != null) {
            Content content = body.getContent();
            for (String key : content.keySet()) {
                MediaType mediaType = (MediaType)content.get(key);
                if (mediaType.getSchema() == null) continue;
                this.updateLocalRefs(mediaType.getSchema(), pathRef);
            }
        }
    }

    protected void updateLocalRefs(Schema model, String pathRef) {
        if (model.getRef() != null) {
            if (this.isLocalRef(model.getRef())) {
                model.setRef(this.computeLocalRef(model.getRef(), pathRef));
            }
        } else if (model.getProperties() != null) {
            if (model.getProperties() != null) {
                Map properties = model.getProperties();
                for (String key : properties.keySet()) {
                    Schema property = (Schema)properties.get(key);
                    if (property == null) continue;
                    this.updateLocalRefs(property, pathRef);
                }
            }
        } else if (SchemaProcessor.isComposedSchema(model)) {
            if (model.getAllOf() != null) {
                for (Schema innerModel : model.getAllOf()) {
                    this.updateLocalRefs(innerModel, pathRef);
                }
            }
            if (model.getAnyOf() != null) {
                for (Schema innerModel : model.getAnyOf()) {
                    this.updateLocalRefs(innerModel, pathRef);
                }
            }
            if (model.getOneOf() != null) {
                for (Schema innerModel : model.getOneOf()) {
                    this.updateLocalRefs(innerModel, pathRef);
                }
            }
        } else if (model.getType() == Schema.SchemaType.ARRAY && model.getItems() != null) {
            this.updateLocalRefs(model.getItems(), pathRef);
        }
    }

    protected boolean isLocalRef(String ref) {
        return ref.startsWith("#");
    }

    protected String computeLocalRef(String ref, String prefix) {
        return prefix + ref;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.microprofile.openapi.impl.parser.processors.PathsProcessor", PathsProcessor.class, (String)"MPOPENAPI", (String)"com.ibm.ws.microprofile.openapi.resources.OpenAPI");
    }
}

