/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxrs20.appsecurity.security;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.jaxrs20.appsecurity.component.SSLSupportService;
import com.ibm.ws.jaxrs20.appsecurity.security.JaxRsProxySSLSocketFactory;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.ssl.SSLSupport;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocketFactory;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class JaxRsSSLManager {
    private static final TraceComponent tc = Tr.register(JaxRsSSLManager.class, (String)"com.ibm.ws.jaxrs20.appsecurity", null);
    static final long serialVersionUID = -6831088170268315856L;

    public static SSLSocketFactory getProxySSLSocketFactoryBySSLRef(String sslRef, Map<String, Object> props) {
        return SSLSupportService.isSSLSupportServiceReady() ? new JaxRsProxySSLSocketFactory(sslRef, props) : null;
    }

    /*
     * WARNING - void declaration
     */
    @FFDCIgnore(value={PrivilegedActionException.class})
    public static SSLSocketFactory getSSLSocketFactoryBySSLRef(String sslRef, Map<String, Object> props, boolean fallbackOnDefault) {
        if (!SSLSupportService.isSSLSupportServiceReady()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The SSL support service is not ready and can't create SSLSocketFactory", (Object[])new Object[0]);
            }
            return null;
        }
        SSLSupport sslSupportService = SSLSupportService.getSSLSupport();
        JSSEHelper jsseHelper = sslSupportService.getJSSEHelper();
        Boolean sslCfgExists = null;
        try {
            final JSSEHelper f_jsseHelper = jsseHelper;
            if (sslRef != null) {
                final String f_sslRef = sslRef;
                try {
                    sslCfgExists = AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){
                        static final long serialVersionUID = 6298864253220951585L;
                        private static final /* synthetic */ TraceComponent $$$tc$$$;

                        @Override
                        public Boolean run() throws SSLException {
                            return f_jsseHelper.doesSSLConfigExist(f_sslRef);
                        }

                        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                        static {
                            $$$tc$$$ = Tr.register((String)"com.ibm.ws.jaxrs20.appsecurity.security.JaxRsSSLManager$1", 1.class, (String)"com.ibm.ws.jaxrs20.appsecurity", null);
                        }
                    });
                }
                catch (PrivilegedActionException pae) {
                    Throwable cause = pae.getCause();
                    throw (SSLException)cause;
                }
                if (!sslCfgExists.booleanValue()) {
                    return null;
                }
            }
            return SSLSupportService.getSSLSocketFactory(sslRef);
        }
        catch (SSLException f_jsseHelper) {
            void e;
            FFDCFilter.processException((Throwable)f_jsseHelper, (String)"com.ibm.ws.jaxrs20.appsecurity.security.JaxRsSSLManager", (String)"80", null, (Object[])new Object[]{sslRef, props, fallbackOnDefault});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("SSL Exception with ssl ref id " + sslRef + ": " + e.toString()), (Object[])new Object[0]);
            }
            throw new IllegalArgumentException((Throwable)e);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jaxrs20.appsecurity.security.JaxRsSSLManager", (String)"85", null, (Object[])new Object[]{sslRef, props, fallbackOnDefault});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Exception with ssl ref id " + sslRef + ": " + e.toString()), (Object[])new Object[0]);
            }
            throw new IllegalStateException(e);
        }
    }
}

