/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxrs20.security;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authorization.util.RoleMethodAuthUtil;
import com.ibm.ws.security.authorization.util.UnauthenticatedException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.security.Principal;
import javax.annotation.Priority;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Response;
import org.apache.cxf.interceptor.security.AccessDeniedException;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;

@Priority(value=2000)
@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class LibertyAuthFilter
implements ContainerRequestFilter {
    static final long serialVersionUID = -8672157833445251942L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @FFDCIgnore(value={UnauthenticatedException.class, UnauthenticatedException.class, AccessDeniedException.class})
    public void filter(ContainerRequestContext context) {
        Message m = JAXRSUtils.getCurrentMessage();
        try {
            try {
                this.handleMessage(m);
            }
            catch (UnauthenticatedException ex) {
                try {
                    if (this.authenticate(m)) {
                        this.handleMessage(m);
                        return;
                    }
                }
                catch (UnauthenticatedException unauthenticatedException) {
                    // empty catch block
                }
                context.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
            }
        }
        catch (AccessDeniedException ex) {
            context.abortWith(Response.status((Response.Status)Response.Status.FORBIDDEN).build());
        }
    }

    private boolean authenticate(Message m) {
        HttpServletRequest req = (HttpServletRequest)m.get((Object)"HTTP.REQUEST");
        HttpServletResponse res = (HttpServletResponse)m.get((Object)"HTTP.RESPONSE");
        try {
            return req.authenticate(res);
        }
        catch (IOException | ServletException throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.jaxrs20.security.LibertyAuthFilter", (String)"71", (Object)this, (Object[])new Object[]{m});
            return false;
        }
    }

    private void handleMessage(Message message) throws UnauthenticatedException {
        HttpServletRequest req = (HttpServletRequest)message.get((Object)"HTTP.REQUEST");
        Method method = MessageUtils.getTargetMethod((Message)message, () -> new AccessDeniedException("Method is not available : Unauthorized"));
        if (RoleMethodAuthUtil.parseMethodSecurity((Method)method, (Principal)req.getUserPrincipal(), s -> req.isUserInRole(s))) {
            return;
        }
        throw new AccessDeniedException("Unauthorized");
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.jaxrs20.security.LibertyAuthFilter", LibertyAuthFilter.class, null, null);
    }
}

