/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.request.timing.queue;

import com.ibm.wsspi.requestContext.RequestContext;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;

public class QueueableRequest
implements Delayed {
    private final RequestContext requestContext;
    private volatile long queueTime;
    private volatile long delay;

    public QueueableRequest(RequestContext requestContext, long delay) {
        this.requestContext = requestContext;
        this.queueTime = System.nanoTime();
        this.delay = delay > 0L ? delay : 0L;
    }

    @Override
    public int compareTo(Delayed delayed) {
        if (this == delayed) {
            return 0;
        }
        long diff = this.getDelay(TimeUnit.MILLISECONDS) - delayed.getDelay(TimeUnit.MILLISECONDS);
        return diff == 0L ? 0 : (diff < 0L ? -1 : 1);
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return this.delay - TimeUnit.MILLISECONDS.convert(System.nanoTime() - this.queueTime, TimeUnit.NANOSECONDS);
    }

    public RequestContext getRequestContext() {
        return this.requestContext;
    }

    public boolean interruptRequest() {
        return false;
    }

    public long getInitialDelay() {
        return this.delay;
    }

    public void resetDelay(long delay) {
        this.queueTime = System.nanoTime();
        this.delay = delay > 0L ? delay : 0L;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.queueTime ^ this.queueTime >>> 32);
        long seqNumber = this.requestContext.getRequestId().getSequenceNumber();
        result = 31 * result + (int)(seqNumber ^ seqNumber >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        QueueableRequest other = (QueueableRequest)obj;
        return !(this.requestContext == null ? other.requestContext != null : !this.requestContext.getRequestId().getId().equals(other.requestContext.getRequestId().getId()));
    }
}

