/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.jwt.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.security.jwt.Builder;
import com.ibm.websphere.security.jwt.Claims;
import com.ibm.websphere.security.jwt.InvalidBuilderException;
import com.ibm.websphere.security.jwt.InvalidClaimException;
import com.ibm.websphere.security.jwt.InvalidTokenException;
import com.ibm.websphere.security.jwt.JwtException;
import com.ibm.websphere.security.jwt.JwtToken;
import com.ibm.websphere.security.jwt.KeyException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.jwt.config.JwtConfig;
import com.ibm.ws.security.jwt.internal.ClaimsImpl;
import com.ibm.ws.security.jwt.internal.TokenImpl;
import com.ibm.ws.security.jwt.utils.IssuerUtils;
import com.ibm.ws.security.jwt.utils.JwtUtils;
import com.ibm.ws.security.wim.VMMService;
import com.ibm.ws.ssl.KeyStoreService;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceMap;
import com.ibm.wsspi.ssl.SSLSupport;
import java.security.Key;
import java.security.interfaces.RSAPrivateKey;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jose4j.lang.JoseException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={Builder.class}, immediate=true, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"}, name="builder")
public class BuilderImpl
implements Builder {
    private static final TraceComponent tc = Tr.register(BuilderImpl.class, (String)"JWTBUILDER", (String)"com.ibm.ws.security.jwt.internal.resources.JWTMessages");
    private Claims claims;
    private static boolean active = false;
    private String alg;
    private String sharedKey;
    private Key privateKey;
    private String configId;
    private static final String DEFAULT_ID = "defaultJWT";
    private static final String KEY_JWT_SERVICE = "jwtConfig";
    private static final String CFG_KEY_ID = "id";
    private final Object initlock = new Object(){
        static final long serialVersionUID = -1480829133143250052L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.jwt.internal.BuilderImpl$1", 1.class, (String)"JWTBUILDER", (String)"com.ibm.ws.security.jwt.internal.resources.JWTMessages");
        }
    };
    private static ConcurrentServiceReferenceMap<String, JwtConfig> jwtServiceMapRef = new ConcurrentServiceReferenceMap("jwtConfig");
    private final String KEY_VMM_SERVICE = "vmmService";
    private final AtomicServiceReference<VMMService> vmmServiceRef = new AtomicServiceReference("vmmService");
    public static final String KEY_SSL_SUPPORT = "sslSupport";
    private final AtomicServiceReference<SSLSupport> sslSupportRef = new AtomicServiceReference("sslSupport");
    public static final String KEY_KEYSTORE_SERVICE = "keyStoreService";
    private final AtomicServiceReference<KeyStoreService> keyStoreServiceRef = new AtomicServiceReference("keyStoreService");
    static final long serialVersionUID = 4342277611391973126L;

    public BuilderImpl() {
    }

    public BuilderImpl(String builderConfigId) throws InvalidBuilderException {
        this.claims = new ClaimsImpl();
        this.configId = builderConfigId;
        JwtConfig jwtConfig = this.getConfig(builderConfigId);
        this.setClaimsUsingTheConfig(jwtConfig);
    }

    private JwtConfig getConfig(String configId) throws InvalidBuilderException {
        JwtConfig jwtConfig = this.getTheServiceConfig(configId);
        if (jwtConfig == null) {
            String err = Tr.formatMessage((TraceComponent)tc, (String)"JWT_BUILDER_INVALID", (Object[])new Object[]{configId});
            throw new InvalidBuilderException(err);
        }
        return jwtConfig;
    }

    private void setClaimsUsingTheConfig(JwtConfig jwtConfig) throws InvalidBuilderException {
        String scope;
        List<String> aud;
        String issuer = IssuerUtils.getIssuerUrl(jwtConfig);
        if (issuer != null) {
            this.getClaims().put("iss", issuer);
        }
        this.getClaims().put("token_type", "Bearer");
        long exp = -2L;
        this.getClaims().put("exp", exp);
        long iat = -2L;
        this.getClaims().put("iat", iat);
        boolean isJti = jwtConfig.getJti();
        if (isJti) {
            String jti = JwtUtils.getRandom(16);
            this.getClaims().put("jti", jti);
        }
        if ((aud = jwtConfig.getAudiences()) != null) {
            this.getClaims().put("aud", aud);
        }
        if ((scope = jwtConfig.getScope()) != null) {
            this.getClaims().put("scope", scope);
        }
        if (jwtConfig.getSignatureAlgorithm() != null) {
            this.alg = jwtConfig.getSignatureAlgorithm();
        }
        if (jwtConfig.getSharedKey() != null) {
            this.sharedKey = jwtConfig.getSharedKey();
        }
    }

    private JwtConfig getTheServiceConfig(String builderConfigId) {
        return (JwtConfig)jwtServiceMapRef.getService((Object)builderConfigId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(service=JwtConfig.class, name="jwtConfig", policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE, policyOption=ReferencePolicyOption.RELUCTANT)
    protected void setJwtConfig(ServiceReference<JwtConfig> ref) {
        Object object = this.initlock;
        synchronized (object) {
            jwtServiceMapRef.putReference((Object)((String)ref.getProperty(CFG_KEY_ID)), ref);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unsetJwtConfig(ServiceReference<JwtConfig> ref) {
        Object object = this.initlock;
        synchronized (object) {
            jwtServiceMapRef.removeReference((Object)((String)ref.getProperty(CFG_KEY_ID)), ref);
        }
    }

    @Reference(service=VMMService.class, name="vmmService", policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL, policyOption=ReferencePolicyOption.GREEDY)
    protected void setVmmService(ServiceReference<VMMService> ref) {
        this.vmmServiceRef.setReference(ref);
    }

    protected void unsetVmmService(ServiceReference<VMMService> ref) {
        this.vmmServiceRef.unsetReference(ref);
    }

    @Reference(service=KeyStoreService.class, name="keyStoreService", policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL, policyOption=ReferencePolicyOption.GREEDY)
    protected void setKeyStoreService(ServiceReference<KeyStoreService> ref) {
        this.keyStoreServiceRef.setReference(ref);
    }

    protected void unsetKeyStoreService(ServiceReference<KeyStoreService> ref) {
        this.keyStoreServiceRef.unsetReference(ref);
    }

    @Reference(service=SSLSupport.class, name="sslSupport", policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL, policyOption=ReferencePolicyOption.GREEDY)
    protected void setSslSupport(ServiceReference<SSLSupport> ref) {
        this.sslSupportRef.setReference(ref);
    }

    protected void updatedSslSupport(ServiceReference<SSLSupport> ref) {
        this.sslSupportRef.setReference(ref);
    }

    protected void unsetSslSupport(ServiceReference<SSLSupport> ref) {
        this.sslSupportRef.unsetReference(ref);
    }

    @Activate
    protected void activate(ComponentContext cc) {
        jwtServiceMapRef.activate(cc);
        this.vmmServiceRef.activate(cc);
        this.keyStoreServiceRef.activate(cc);
        this.sslSupportRef.activate(cc);
        JwtUtils.setVMMService(this.vmmServiceRef);
        JwtUtils.setKeyStoreService(this.keyStoreServiceRef);
        JwtUtils.setSSLSupportService(this.sslSupportRef);
        active = true;
    }

    @Modified
    protected void modify(Map<String, Object> properties) {
    }

    @Deactivate
    protected void deactivate(int reason, ComponentContext cc) {
        jwtServiceMapRef.deactivate(cc);
        this.vmmServiceRef.deactivate(cc);
        this.keyStoreServiceRef.deactivate(cc);
        this.sslSupportRef.deactivate(cc);
        JwtUtils.setVMMService(null);
        JwtUtils.setKeyStoreService(null);
        JwtUtils.setSSLSupportService(null);
        active = false;
    }

    @Override
    public Builder create() throws InvalidBuilderException {
        if (!active) {
            String err = Tr.formatMessage((TraceComponent)tc, (String)"JWT_BUILDER_NOT_ACTIVE", (Object[])new Object[]{DEFAULT_ID});
            throw new InvalidBuilderException(err);
        }
        return this.create(DEFAULT_ID);
    }

    @Override
    public synchronized Builder create(String builderConfigId) throws InvalidBuilderException {
        if (builderConfigId == null || builderConfigId.isEmpty()) {
            String err = Tr.formatMessage((TraceComponent)tc, (String)"JWT_BUILDER_INVALID", (Object[])new Object[]{builderConfigId});
            throw new InvalidBuilderException(err);
        }
        if (!active) {
            String err = Tr.formatMessage((TraceComponent)tc, (String)"JWT_BUILDER_NOT_ACTIVE", (Object[])new Object[]{builderConfigId});
            throw new InvalidBuilderException(err);
        }
        return new BuilderImpl(builderConfigId);
    }

    @Override
    public Builder issuer(String issuerUrl) throws InvalidClaimException {
        if (issuerUrl == null || issuerUrl.isEmpty()) {
            String err = Tr.formatMessage((TraceComponent)tc, (String)"JWT_INVALID_CLAIM_VALUE_ERR", (Object[])new Object[]{"iss", issuerUrl});
            throw new InvalidClaimException(err);
        }
        this.claims.put("iss", issuerUrl);
        return this;
    }

    @Override
    public Builder audience(List<String> newaudiences) throws InvalidClaimException {
        ArrayList<String> audiences;
        if (newaudiences != null && !newaudiences.isEmpty()) {
            audiences = new ArrayList<String>();
            for (String aud : newaudiences) {
                if (aud == null || aud.trim().isEmpty() || audiences.contains(aud)) continue;
                audiences.add(aud);
            }
            if (audiences.isEmpty()) {
                String err = Tr.formatMessage((TraceComponent)tc, (String)"JWT_INVALID_CLAIM_VALUE_ERR", (Object[])new Object[]{"aud", newaudiences});
                throw new InvalidClaimException(err);
            }
        } else {
            String err = Tr.formatMessage((TraceComponent)tc, (String)"JWT_INVALID_CLAIM_VALUE_ERR", (Object[])new Object[]{"aud", newaudiences});
            throw new InvalidClaimException(err);
        }
        this.claims.put("aud", audiences);
        return this;
    }

    @Override
    public Builder expirationTime(long exp) throws InvalidClaimException {
        long currTime = System.currentTimeMillis() / 1000L;
        if (exp < currTime) {
            String err = Tr.formatMessage((TraceComponent)tc, (String)"JWT_INVALID_EXP_CLAIM_ERR", (Object[])new Object[]{"exp", exp, JwtUtils.getDate(exp * 1000L), JwtUtils.getDate(currTime * 1000L)});
            throw new InvalidClaimException(err);
        }
        this.claims.put("exp", exp);
        return this;
    }

    private Builder issueTime(long iat) throws InvalidClaimException {
        if (iat <= 0L) {
            String err = Tr.formatMessage((TraceComponent)tc, (String)"JWT_INVALID_TIME_CLAIM_ERR", (Object[])new Object[]{"iat"});
            throw new InvalidClaimException(err);
        }
        this.claims.put("iat", iat);
        return this;
    }

    @Override
    public Builder jwtId(boolean create) {
        if (create) {
            String jti = JwtUtils.getRandom(16);
            this.claims.put("jti", jti);
        } else {
            this.claims.remove("jti");
        }
        return this;
    }

    @Override
    public Builder notBefore(long time_from) throws InvalidClaimException {
        if (time_from <= 0L) {
            String err = Tr.formatMessage((TraceComponent)tc, (String)"JWT_INVALID_TIME_CLAIM_ERR", (Object[])new Object[]{"nbf"});
            throw new InvalidClaimException(err);
        }
        this.claims.put("nbf", time_from);
        return this;
    }

    @Override
    public Builder subject(String username) throws InvalidClaimException {
        if (username == null || username.isEmpty()) {
            String err = Tr.formatMessage((TraceComponent)tc, (String)"JWT_INVALID_CLAIM_VALUE_ERR", (Object[])new Object[]{"sub", username});
            throw new InvalidClaimException(err);
        }
        this.claims.put("sub", username);
        return this;
    }

    @Override
    public Builder signWith(String algorithm, Key key) throws KeyException {
        if (algorithm == null || algorithm.isEmpty() || !algorithm.equals("RS256")) {
            String err = Tr.formatMessage((TraceComponent)tc, (String)"JWT_INVALID_ALGORITHM_ERR", (Object[])new Object[]{algorithm, "RS256"});
            throw new KeyException(err);
        }
        if (key == null || !(key instanceof RSAPrivateKey)) {
            String err = Tr.formatMessage((TraceComponent)tc, (String)"JWT_INVALID_KEY_ERR", (Object[])new Object[]{algorithm, key});
            throw new KeyException(err);
        }
        this.alg = algorithm;
        this.privateKey = key;
        return this;
    }

    @Override
    public Builder signWith(String algorithm, String key) throws KeyException {
        if (algorithm == null || algorithm.isEmpty() || !algorithm.equals("HS256")) {
            String err = Tr.formatMessage((TraceComponent)tc, (String)"JWT_INVALID_ALGORITHM_ERR", (Object[])new Object[]{algorithm, "HS256"});
            throw new KeyException(err);
        }
        if (key == null || key.isEmpty()) {
            String err = Tr.formatMessage((TraceComponent)tc, (String)"JWT_INVALID_KEY_ERR", (Object[])new Object[]{algorithm, key});
            throw new KeyException(err);
        }
        this.alg = algorithm;
        this.sharedKey = key;
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Builder claim(String name, Object value) throws InvalidClaimException {
        if (!this.isValidClaim(name, value)) return this;
        if (name.equals("aud")) {
            if (value instanceof ArrayList) {
                this.audience((ArrayList)value);
                return this;
            }
            if (!(value instanceof String)) {
                String msg = Tr.formatMessage((TraceComponent)tc, (String)"JWT_INVALID_CLAIM_VALUE_TYPE", (Object[])new Object[]{"aud"});
                throw new InvalidClaimException(msg);
            }
            String[] auds = ((String)value).split(" ");
            ArrayList<String> audList = new ArrayList<String>();
            String[] stringArray = auds;
            int n = stringArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    if (audList.isEmpty()) return this;
                    this.audience(audList);
                    return this;
                }
                String aud = stringArray[n2];
                if (!aud.isEmpty()) {
                    audList.add(aud.trim());
                }
                ++n2;
            }
        }
        if (name.equals("exp")) {
            if (value instanceof Long) {
                this.expirationTime((Long)value);
                return this;
            }
            if (value instanceof Integer) {
                this.expirationTime(((Integer)value).longValue());
                return this;
            }
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"JWT_INVALID_CLAIM_VALUE_TYPE", (Object[])new Object[]{"exp"});
            throw new InvalidClaimException(msg);
        }
        if (name.equals("iat")) {
            if (value instanceof Long) {
                this.issueTime((Long)value);
                return this;
            }
            if (value instanceof Integer) {
                this.expirationTime(((Integer)value).longValue());
                return this;
            }
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"JWT_INVALID_CLAIM_VALUE_TYPE", (Object[])new Object[]{"iat"});
            throw new InvalidClaimException(msg);
        }
        if (name.equals("nbf")) {
            if (value instanceof Long) {
                this.notBefore((Long)value);
                return this;
            }
            if (value instanceof Integer) {
                this.expirationTime(((Integer)value).longValue());
                return this;
            }
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"JWT_INVALID_CLAIM_VALUE_TYPE", (Object[])new Object[]{"nbf"});
            throw new InvalidClaimException(msg);
        }
        if (!name.equals("iss") && !name.equals("sub")) {
            this.claims.put(name, value);
            return this;
        }
        if (!(value instanceof String)) {
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"JWT_INVALID_CLAIM_VALUE_TYPE", (Object[])new Object[]{name});
            throw new InvalidClaimException(msg);
        }
        if (name.equals("iss")) {
            this.issuer((String)value);
            return this;
        }
        this.subject((String)value);
        return this;
    }

    @Override
    public Builder claim(Map<String, Object> map) throws InvalidClaimException {
        if (map == null) {
            String err = Tr.formatMessage((TraceComponent)tc, (String)"JWT_INVALID_CLAIMS_ERR", (Object[])new Object[0]);
            throw new InvalidClaimException(err);
        }
        return this.copyClaimsMap(map);
    }

    @Override
    public Builder fetch(String name) throws InvalidClaimException {
        if (JwtUtils.isNullEmpty(name)) {
            String err = Tr.formatMessage((TraceComponent)tc, (String)"JWT_INVALID_CLAIM_ERR", (Object[])new Object[]{name});
            throw new InvalidClaimException(err);
        }
        String sub = this.claims.getSubject();
        if (!JwtUtils.isNullEmpty(sub)) {
            Object obj = null;
            try {
                obj = JwtUtils.fetch(name, sub);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.jwt.internal.BuilderImpl", (String)"570", (Object)this, (Object[])new Object[]{name});
            }
            if (obj != null) {
                this.claims.put(name, obj);
            }
        }
        return this;
    }

    @Override
    public Builder remove(String name) throws InvalidClaimException {
        if (JwtUtils.isNullEmpty(name)) {
            String err = Tr.formatMessage((TraceComponent)tc, (String)"JWT_INVALID_CLAIM_ERR", (Object[])new Object[]{name});
            throw new InvalidClaimException(err);
        }
        this.claims.remove(name);
        return this;
    }

    @Override
    public Builder claimFrom(String jsonOrJwt, String claim) throws InvalidClaimException, InvalidTokenException {
        if (JwtUtils.isNullEmpty(claim)) {
            String err = Tr.formatMessage((TraceComponent)tc, (String)"JWT_INVALID_CLAIM_ERR", (Object[])new Object[]{claim});
            throw new InvalidClaimException(err);
        }
        if (this.isValidToken(jsonOrJwt)) {
            boolean isJson;
            String decoded = jsonOrJwt;
            if (JwtUtils.isBase64Encoded(jsonOrJwt)) {
                decoded = JwtUtils.decodeFromBase64String(jsonOrJwt);
            }
            if (!(isJson = JwtUtils.isJson(decoded))) {
                String jwtPayload = JwtUtils.getPayload(jsonOrJwt);
                decoded = JwtUtils.decodeFromBase64String(jwtPayload);
            }
            if (decoded != null) {
                Object claimValue = null;
                try {
                    claimValue = JwtUtils.claimFromJsonObject(decoded, claim);
                    if (claimValue != null) {
                        this.claims.put(claim, claimValue);
                    }
                }
                catch (JoseException joseException) {
                    FFDCFilter.processException((Throwable)joseException, (String)"com.ibm.ws.security.jwt.internal.BuilderImpl", (String)"636", (Object)this, (Object[])new Object[]{jsonOrJwt, claim});
                    String err = Tr.formatMessage((TraceComponent)tc, (String)"JWT_INVALID_TOKEN_ERR", (Object[])new Object[0]);
                    throw new InvalidTokenException(err);
                }
            }
        }
        return this;
    }

    @Override
    public Builder claimFrom(String jsonOrJwt) throws InvalidTokenException {
        boolean isJson;
        this.isValidToken(jsonOrJwt);
        String decoded = jsonOrJwt;
        if (JwtUtils.isBase64Encoded(jsonOrJwt)) {
            decoded = JwtUtils.decodeFromBase64String(jsonOrJwt);
        }
        if (!(isJson = JwtUtils.isJson(decoded))) {
            String jwtPayload = JwtUtils.getPayload(jsonOrJwt);
            decoded = JwtUtils.decodeFromBase64String(jwtPayload);
        }
        if (decoded != null) {
            Map claimsFromAnother = null;
            try {
                claimsFromAnother = JwtUtils.claimsFromJsonObject(decoded);
            }
            catch (JoseException joseException) {
                FFDCFilter.processException((Throwable)joseException, (String)"com.ibm.ws.security.jwt.internal.BuilderImpl", (String)"685", (Object)this, (Object[])new Object[]{jsonOrJwt});
                String err = Tr.formatMessage((TraceComponent)tc, (String)"JWT_INVALID_TOKEN_ERR", (Object[])new Object[0]);
                throw new InvalidTokenException(err);
            }
            if (claimsFromAnother != null && !claimsFromAnother.isEmpty()) {
                this.claims.putAll(claimsFromAnother);
            }
        }
        return this;
    }

    @Override
    public Builder claimFrom(JwtToken jwt, String claimName) throws InvalidClaimException, InvalidTokenException {
        this.isValidToken(jwt);
        if (JwtUtils.isNullEmpty(claimName)) {
            String err = Tr.formatMessage((TraceComponent)tc, (String)"JWT_INVALID_CLAIM_ERR", (Object[])new Object[]{claimName});
            throw new InvalidClaimException(err);
        }
        if (jwt.getClaims().get(claimName) != null) {
            this.claims.put(claimName, jwt.getClaims().get(claimName));
        }
        return this;
    }

    @Override
    public Builder claimFrom(JwtToken jwt) throws InvalidTokenException {
        if (jwt == null || jwt.getClaims().isEmpty()) {
            String err = Tr.formatMessage((TraceComponent)tc, (String)"JWT_INVALID_TOKEN_ERR", (Object[])new Object[0]);
            throw new InvalidTokenException(err);
        }
        this.claims.putAll(jwt.getClaims());
        return this;
    }

    @Override
    public JwtToken buildJwt() throws JwtException, InvalidBuilderException {
        JwtConfig config = this.getConfig(this.configId);
        TokenImpl jwt = new TokenImpl(this, config);
        return jwt;
    }

    public Claims getClaims() {
        return this.claims;
    }

    public Key getKey() {
        return this.privateKey;
    }

    public String getSharedKey() {
        return this.sharedKey;
    }

    public String getAlgorithm() {
        return this.alg;
    }

    private boolean isValidClaim(String key, Object value) throws InvalidClaimException {
        String err = null;
        if (JwtUtils.isNullEmpty(key)) {
            err = Tr.formatMessage((TraceComponent)tc, (String)"JWT_INVALID_CLAIM_ERR", (Object[])new Object[]{key});
            throw new InvalidClaimException(err);
        }
        if (value == null) {
            err = Tr.formatMessage((TraceComponent)tc, (String)"JWT_INVALID_CLAIM_VALUE_ERR", (Object[])new Object[]{key, "null"});
            throw new InvalidClaimException(err);
        }
        return true;
    }

    private boolean isValidToken(String tokenString) throws InvalidTokenException {
        String err = null;
        if (JwtUtils.isNullEmpty(tokenString)) {
            err = Tr.formatMessage((TraceComponent)tc, (String)"JWT_INVALID_TOKEN_ERR", (Object[])new Object[0]);
            throw new InvalidTokenException(err);
        }
        return true;
    }

    private boolean isValidToken(JwtToken jwt) throws InvalidTokenException {
        String err = null;
        if (jwt == null) {
            err = Tr.formatMessage((TraceComponent)tc, (String)"JWT_INVALID_TOKEN_ERR", (Object[])new Object[0]);
            throw new InvalidTokenException(err);
        }
        return true;
    }

    private Builder copyClaimsMap(Map<String, Object> map) throws InvalidClaimException {
        Set<Map.Entry<String, Object>> entries = map.entrySet();
        for (Map.Entry<String, Object> entry : entries) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Builder Claims Key : " + key + ", Value: " + value), (Object[])new Object[0]);
            }
            this.claim(key, value);
        }
        return this;
    }
}

