/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.jwt.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.jwt.config.JwtConfig;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class IssuerUtils {
    private static final TraceComponent tc = Tr.register(IssuerUtils.class, (String)"JWTBUILDER", (String)"com.ibm.ws.security.jwt.internal.resources.JWTMessages");
    public static final String JWT_CONTEXT_PATH = "/jwt/";
    static final long serialVersionUID = 9033317311752260482L;

    public static String getIssuerUrl(JwtConfig jwtConfig) {
        String issuerUrl = jwtConfig.getIssuerUrl();
        String configId = jwtConfig.getId();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("issuer url is:" + issuerUrl), (Object[])new Object[0]);
        }
        if (issuerUrl != null && !issuerUrl.isEmpty()) {
            return issuerUrl;
        }
        issuerUrl = jwtConfig.getResolvedHostAndPortUrl();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("issuer url after resolving the host and port is:" + issuerUrl), (Object[])new Object[0]);
        }
        if (issuerUrl != null && !issuerUrl.isEmpty()) {
            return issuerUrl + JWT_CONTEXT_PATH + configId;
        }
        return configId;
    }
}

