/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.app.manager.war.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.app.manager.ApplicationManager;
import com.ibm.ws.app.manager.module.AbstractDeployedAppInfoFactory;
import com.ibm.ws.app.manager.module.DeployedAppInfo;
import com.ibm.ws.app.manager.module.DeployedAppInfoFactory;
import com.ibm.ws.app.manager.module.DeployedAppServices;
import com.ibm.ws.app.manager.module.internal.ModuleHandler;
import com.ibm.ws.app.manager.war.internal.WARDeployedAppInfo;
import com.ibm.ws.app.manager.war.internal.ZipUtils;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.application.handler.ApplicationInformation;
import com.ibm.wsspi.kernel.service.location.WsResource;
import java.io.File;
import java.io.IOException;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={DeployedAppInfoFactory.class}, property={"service.vendor=IBM", "type:String=war"})
public class WARDeployedAppInfoFactoryImpl
extends AbstractDeployedAppInfoFactory
implements DeployedAppInfoFactory {
    private static final TraceComponent tc = Tr.register(WARDeployedAppInfoFactoryImpl.class, (String[])new String[]{"webcontainer", "applications", "app.manager"}, (String)"com.ibm.ws.app.manager.war.internal.resources.Messages", (String)"com.ibm.ws.app.manager.war.internal.WARDeployedAppInfoFactoryImpl");
    @Reference
    protected DeployedAppServices deployedAppServices;
    @Reference(target="(type=web)")
    protected ModuleHandler webModuleHandler;
    @Reference
    protected ApplicationManager applicationManager;
    static final long serialVersionUID = -7594168883236154685L;

    protected void prepareExpansion() throws IOException {
        WsResource expansionResource = this.deployedAppServices.getLocationAdmin().resolveResource("${server.config.dir}/apps/expanded/");
        expansionResource.create();
    }

    protected WsResource resolveExpansion(String appName) {
        return this.deployedAppServices.getLocationAdmin().resolveResource("${server.config.dir}/apps/expanded/" + appName + ".war/");
    }

    protected void expand(String name, File collapsedFile, WsResource expandedResource, File expandedFile) throws IOException {
        File failedDelete;
        String collapsedPath = collapsedFile.getAbsolutePath();
        if (expandedFile.exists() && (failedDelete = ZipUtils.deleteWithRetry(expandedFile)) != null) {
            if (failedDelete == expandedFile) {
                throw new IOException("Failed to delete [ " + expandedFile.getAbsolutePath() + " ]");
            }
            throw new IOException("Failed to delete [ " + expandedFile.getAbsolutePath() + " ] because [ " + failedDelete.getAbsolutePath() + " ] could not be deleted.");
        }
        expandedResource.create();
        ZipUtils.unzip(collapsedFile, expandedFile, false, collapsedFile.lastModified());
    }

    /*
     * WARNING - void declaration
     */
    public WARDeployedAppInfo createDeployedAppInfo(ApplicationInformation<DeployedAppInfo> appInfo) throws UnableToAdaptException {
        String warPid = appInfo.getPid();
        String warName = appInfo.getName();
        String warPath = appInfo.getLocation();
        File warFile = new File(warPath);
        Tr.debug((TraceComponent)tc, (String)("Create deployed application: PID [ " + warPid + " ] Name [ " + warName + " ] Location [ " + warPath + " ]"), (Object[])new Object[0]);
        AbstractDeployedAppInfoFactory.BinaryType appType = this.getApplicationType(warFile, warPath);
        if (appType == AbstractDeployedAppInfoFactory.BinaryType.LOOSE) {
            Tr.info((TraceComponent)tc, (String)"info.loose.app", (Object[])new Object[]{warName, warPath});
        } else if (appType == AbstractDeployedAppInfoFactory.BinaryType.DIRECTORY) {
            Tr.info((TraceComponent)tc, (String)"info.directory.app", (Object[])new Object[]{warName, warPath});
        } else if (this.applicationManager.getExpandApps()) {
            try {
                this.prepareExpansion();
                WsResource expandedResource = this.resolveExpansion(warName);
                File expandedFile = expandedResource.asFile();
                if (this.applicationManager.shouldExpand(expandedFile.getName(), warFile, expandedFile)) {
                    Tr.info((TraceComponent)tc, (String)"info.expanding.app", (Object[])new Object[]{warName, warPath, expandedFile.getAbsolutePath()});
                    this.expand(warName, warFile, expandedResource, expandedFile);
                }
                Container expandedContainer = this.deployedAppServices.setupContainer(warPid, expandedFile);
                appInfo.setContainer(expandedContainer);
            }
            catch (IOException expandedResource) {
                void e;
                FFDCFilter.processException((Throwable)expandedResource, (String)"com.ibm.ws.app.manager.war.internal.WARDeployedAppInfoFactoryImpl", (String)"113", (Object)((Object)this), (Object[])new Object[]{appInfo});
                Tr.error((TraceComponent)tc, (String)"warning.could.not.expand.application", (Object[])new Object[]{warName, e.getMessage()});
            }
        } else {
            Tr.info((TraceComponent)tc, (String)"info.unexpanded.app", (Object[])new Object[]{warName, warPath});
        }
        WARDeployedAppInfo deployedApp = new WARDeployedAppInfo(appInfo, this.deployedAppServices, this.webModuleHandler);
        appInfo.setHandlerInfo((Object)deployedApp);
        return deployedApp;
    }
}

