/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.internal.impl;

import com.ibm.ejs.ras.Untraceable;
import com.ibm.websphere.logging.WsLevel;
import com.ibm.websphere.ras.DataFormatHelper;
import com.ibm.websphere.ras.Traceable;
import com.ibm.websphere.ras.TruncatableThrowable;
import com.ibm.ws.logging.collector.DateFormatHelper;
import com.ibm.ws.logging.data.GenericData;
import com.ibm.ws.logging.data.KeyValuePair;
import com.ibm.ws.logging.internal.WsLogRecord;
import com.ibm.ws.logging.internal.impl.BaseTraceService;
import com.ibm.ws.logging.internal.impl.LoggingConstants;
import java.lang.reflect.Array;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class BaseTraceFormatter
extends Formatter {
    public static final String banner = "********************************************************************************";
    public static final Object NULL_ID = null;
    public static final String NULL_FORMATTED_MSG = null;
    static final int basicNameLength = 13;
    static final int enhancedNameLength = 60;
    static final int COLLECTION_DEPTH_LIMIT = AccessController.doPrivileged(new PrivilegedAction<Integer>(){

        @Override
        public Integer run() {
            return Integer.getInteger("com.ibm.ws.logging.collectionDepthLimit", 8);
        }
    });
    static final String pad8 = "        ";
    static final String basicPadding = "                                 ";
    static final String advancedPadding = "          ";
    static final String enhancedPadding = "                                                                                                               ";
    static final String nlBasicPadding = LoggingConstants.nl + "                                 ";
    static final String nlAdvancedPadding = LoggingConstants.nl + "          ";
    static final String nlEnhancedPadding = LoggingConstants.nl + "                                                                                                               ";
    static final String nullParamString = "null";
    static final String badParamString = "<malformed parameter>";
    static final String emptyString = "";
    static final String emptyStringReplacement = "\"\"";
    static final String ENTRY = "Entry ";
    static final String EXIT = "Exit ";
    static final String SYSOUT = "SystemOut";
    static final String SYSERR = "SystemErr";
    private static final char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final String NAME_FORMAT = "[%-8s] ";
    private static final String N_INFO = String.format("[%-8s] ", Level.INFO.getLocalizedName());
    private static final String N_AUDIT = String.format("[%-8s] ", WsLevel.AUDIT.getLocalizedName());
    private static final String N_EVENT = String.format("[%-8s] ", WsLevel.EVENT.getLocalizedName());
    private static final String N_WARN = String.format("[%-8s] ", Level.WARNING.getLocalizedName());
    private static final String N_ERROR = String.format("[%-8s] ", WsLevel.ERROR.getLocalizedName());
    private static final String N_FATAL = String.format("[%-8s] ", WsLevel.FATAL.getLocalizedName());
    final LoggingConstants.TraceFormat traceFormat;
    static boolean useIsoDateFormat = false;

    public static final String levelToString(Level level) {
        if (level != null) {
            int l = level.intValue();
            if (l == WsLevel.FATAL.intValue()) {
                return N_FATAL;
            }
            if (l == WsLevel.ERROR.intValue()) {
                return N_ERROR;
            }
            if (l == Level.WARNING.intValue()) {
                return N_WARN;
            }
            if (l == WsLevel.AUDIT.intValue()) {
                return N_AUDIT;
            }
            if (l == Level.INFO.intValue()) {
                return N_INFO;
            }
            if (level == WsLevel.EVENT) {
                return N_EVENT;
            }
        }
        return emptyString;
    }

    public static final String levelValToString(Integer level) {
        if (level != null) {
            int l = level;
            if (l == 1100) {
                return N_FATAL;
            }
            if (l == 1000) {
                return N_ERROR;
            }
            if (l == 900) {
                return N_WARN;
            }
            if (l == 850) {
                return N_AUDIT;
            }
            if (l == 800) {
                return N_INFO;
            }
            if (level == 500) {
                return N_EVENT;
            }
        }
        return emptyString;
    }

    public BaseTraceFormatter(LoggingConstants.TraceFormat traceFormat) {
        this.traceFormat = traceFormat;
    }

    public LoggingConstants.TraceFormat getTraceFormat() {
        return this.traceFormat;
    }

    @Override
    public String format(LogRecord r) {
        String text = this.formatMessage(r);
        return this.createFormattedString(r, NULL_ID, text);
    }

    public String traceLogFormat(LogRecord logRecord, Object id, String formattedMsg, String formattedVerboseMsg) {
        String txt = formattedVerboseMsg == null ? this.formatVerboseMessage(logRecord, formattedMsg, false) : formattedVerboseMsg;
        return this.createFormattedString(logRecord, id, txt);
    }

    @Override
    public String formatMessage(LogRecord logRecord) {
        if (System.getSecurityManager() == null) {
            return this.formatMessage(logRecord, logRecord.getParameters(), true);
        }
        final LogRecord f_logRecord = logRecord;
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return BaseTraceFormatter.this.formatMessage(f_logRecord, f_logRecord.getParameters(), true);
            }
        });
    }

    private String formatMessage(LogRecord logRecord, Object[] logParams, boolean useResourceBundle) {
        String txt;
        ResourceBundle rb;
        boolean hasParams = logParams != null && logParams.length > 0;
        String msg = logRecord.getMessage();
        if (useResourceBundle && (rb = logRecord.getResourceBundle()) != null) {
            try {
                msg = rb.getString(msg);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (msg != null && hasParams && msg.contains("{0")) {
            Object[] formattedParams = new Object[logParams.length];
            for (int i = 0; i < logParams.length; ++i) {
                formattedParams[i] = logParams[i] instanceof TruncatableThrowable ? DataFormatHelper.throwableToString((TruncatableThrowable)logParams[i]) : (logParams[i] instanceof Throwable ? DataFormatHelper.throwableToString(new TruncatableThrowable((Throwable)logParams[i])) : (logParams[i] instanceof Untraceable ? logParams[i].getClass().getName() : (logParams[i] instanceof Traceable ? this.formatTraceable((Traceable)logParams[i]) : logParams[i])));
            }
            txt = MessageFormat.format(msg, formattedParams);
        } else {
            txt = msg + (hasParams ? " " + this.formatObj(logParams) : emptyString);
        }
        return txt;
    }

    public String formatVerboseMessage(LogRecord logRecord, String msg) {
        return this.formatVerboseMessage(logRecord, msg, true);
    }

    public String formatVerboseMessage(LogRecord logRecord, String formattedMsg, boolean useResourceBundle) {
        Object[] logParams = logRecord.getParameters();
        if (logParams != null) {
            for (int i = 0; i < logParams.length; ++i) {
                Object newLogParam;
                Object logParam = logParams[i];
                if (logParam == null || (newLogParam = this.formatVerboseObj(logParam)) == null) continue;
                Object[] newLogParams = new Object[logParams.length];
                System.arraycopy(logParams, 0, newLogParams, 0, i);
                newLogParams[i] = newLogParam;
                ++i;
                while (i < logParams.length) {
                    logParam = logParams[i];
                    if (logParam != null) {
                        newLogParam = this.formatVerboseObj(logParam);
                        newLogParams[i] = newLogParam != null ? newLogParam : logParam;
                    }
                    ++i;
                }
                return this.formatMessage(logRecord, newLogParams, useResourceBundle);
            }
        }
        if (formattedMsg == null) {
            formattedMsg = this.formatMessage(logRecord, logParams, useResourceBundle);
        }
        return formattedMsg;
    }

    private Object formatVerboseObj(Object obj) {
        if (obj instanceof TruncatableThrowable) {
            TruncatableThrowable truncatable = (TruncatableThrowable)obj;
            Throwable wrappedException = truncatable.getWrappedException();
            return DataFormatHelper.throwableToString(wrappedException);
        }
        if (obj instanceof Throwable) {
            return DataFormatHelper.throwableToString((Throwable)obj);
        }
        return null;
    }

    public String consoleLogFormat(LogRecord logRecord, String txt) {
        StringBuilder sb = new StringBuilder(256);
        sb.append(BaseTraceFormatter.levelToString(logRecord.getLevel()));
        sb.append(txt);
        Throwable t = logRecord.getThrown();
        if (t != null) {
            String s = t.getLocalizedMessage();
            if (s == null) {
                s = t.toString();
            }
            sb.append(LoggingConstants.nl).append(s);
        }
        return sb.toString();
    }

    public String consoleLogFormat(GenericData genData) {
        StringBuilder sb = new StringBuilder(256);
        KeyValuePair[] pairs = genData.getPairs();
        KeyValuePair kvp = null;
        String message = null;
        String throwable = null;
        Integer levelValue = null;
        for (KeyValuePair p : pairs) {
            if (p == null || p.isList()) continue;
            kvp = p;
            if (kvp.getKey().equals("formattedMsg")) {
                message = kvp.getStringValue();
                continue;
            }
            if (kvp.getKey().equals("levelValue")) {
                levelValue = kvp.getIntValue();
                continue;
            }
            if (!kvp.getKey().equals("throwable_localized")) continue;
            throwable = kvp.getStringValue();
        }
        sb.append(BaseTraceFormatter.levelValToString(levelValue));
        sb.append(message);
        if (throwable != null) {
            sb.append(LoggingConstants.nl).append(throwable);
        }
        return sb.toString();
    }

    public String messageLogFormat(LogRecord logRecord, String formattedVerboseMsg) {
        String stackTrace;
        StringBuilder sb = new StringBuilder(256);
        String sym = this.getMarker(logRecord);
        String name = null;
        name = logRecord.getLoggerName() != null && (logRecord.getLoggerName().equals(SYSOUT) || logRecord.getLoggerName().equals(SYSERR)) ? BaseTraceFormatter.nonNullString(logRecord.getLoggerName(), null) : BaseTraceFormatter.nonNullString(logRecord.getLoggerName(), logRecord.getSourceClassName());
        sb.append('[').append(DateFormatHelper.formatTime(logRecord.getMillis(), useIsoDateFormat)).append("] ");
        sb.append(DataFormatHelper.getThreadId()).append(' ');
        this.formatFixedString(sb, name, 60);
        sb.append(sym);
        sb.append(formattedVerboseMsg);
        if (logRecord.getThrown() != null && (stackTrace = this.getStackTrace(logRecord)) != null) {
            sb.append(LoggingConstants.nl).append(stackTrace);
        }
        return sb.toString();
    }

    public String messageLogFormat(GenericData genData) {
        StringBuilder sb = new StringBuilder(256);
        String name = null;
        KeyValuePair[] pairs = genData.getPairs();
        KeyValuePair kvp = null;
        String message = null;
        Long datetime = null;
        String level = emptyString;
        String loggerName = null;
        String srcClassName = null;
        String throwable = null;
        for (KeyValuePair p : pairs) {
            if (p == null || p.isList()) continue;
            kvp = p;
            if (kvp.getKey().equals("message")) {
                message = kvp.getStringValue();
                continue;
            }
            if (kvp.getKey().equals("ibm_datetime")) {
                datetime = kvp.getLongValue();
                continue;
            }
            if (kvp.getKey().equals("severity")) {
                level = kvp.getStringValue();
                continue;
            }
            if (kvp.getKey().equals("module")) {
                loggerName = kvp.getStringValue();
                continue;
            }
            if (kvp.getKey().equals("ibm_className")) {
                srcClassName = kvp.getStringValue();
                continue;
            }
            if (!kvp.getKey().equals("throwable")) continue;
            throwable = kvp.getStringValue();
        }
        name = BaseTraceFormatter.nonNullString(loggerName, srcClassName);
        sb.append('[').append(DateFormatHelper.formatTime(datetime, useIsoDateFormat)).append("] ");
        sb.append(DataFormatHelper.getThreadId()).append(' ');
        this.formatFixedString(sb, name, 60);
        sb.append(" " + level + " ");
        sb.append(message);
        if (throwable != null) {
            sb.append(LoggingConstants.nl).append(throwable);
        }
        return sb.toString();
    }

    private String createFormattedString(LogRecord logRecord, Object id, String txt) {
        WsLogRecord wsLogRecord = this.getWsLogRecord(logRecord);
        String method = logRecord.getSourceMethodName();
        String className = logRecord.getSourceClassName();
        String stackTrace = this.getStackTrace(logRecord);
        String sym = this.getMarker(logRecord);
        StringBuilder sb = new StringBuilder(256);
        sb.append('[').append(DateFormatHelper.formatTime(logRecord.getMillis(), useIsoDateFormat)).append("] ");
        sb.append(DataFormatHelper.getThreadId());
        switch (this.traceFormat) {
            default: {
                String objId = this.generateObjectId(id, true);
                String name = BaseTraceFormatter.nonNullString(logRecord.getSourceClassName(), logRecord.getLoggerName());
                sb.append(" id=").append(objId).append(' ');
                this.formatFixedString(sb, name, 60);
                sb.append(sym);
                if (method != null) {
                    sb.append(method).append(' ');
                }
                sb.append(txt);
                if (stackTrace == null) break;
                sb.append(LoggingConstants.nl).append(stackTrace);
                break;
            }
            case BASIC: {
                String name = BaseTraceFormatter.nonNullString(logRecord.getLoggerName(), logRecord.getSourceClassName());
                sb.append(' ');
                this.fixedClassString(sb, name, 13);
                sb.append(sym);
                if (className != null) {
                    sb.append(className);
                }
                sb.append(' ');
                if (method != null) {
                    sb.append(method);
                }
                sb.append(' ');
                sb.append(txt);
                if (stackTrace == null) break;
                sb.append(nlBasicPadding).append(stackTrace);
                break;
            }
            case ADVANCED: {
                String x;
                String objId = this.generateObjectId(id, false);
                String name = BaseTraceFormatter.nonNullString(logRecord.getLoggerName(), null);
                sb.append(' ');
                sb.append(sym);
                sb.append("UOW=");
                if (wsLogRecord != null) {
                    sb.append(wsLogRecord.getCorrelationId());
                }
                sb.append(" source=").append(name);
                if (className != null) {
                    sb.append(" class=").append(className);
                }
                if (method != null) {
                    sb.append(" method=").append(method);
                }
                if (id != null) {
                    sb.append(" id=").append(objId);
                }
                if (wsLogRecord != null) {
                    sb.append(" org=");
                    sb.append(wsLogRecord.getOrganization());
                    sb.append(" prod=");
                    sb.append(wsLogRecord.getProduct());
                    sb.append(" component=");
                    sb.append(wsLogRecord.getComponent());
                    x = wsLogRecord.getReporterOrSourceThreadName();
                } else {
                    x = Thread.currentThread().getName();
                }
                if (x != null) {
                    sb.append(" thread=[").append(x).append("]");
                }
                sb.append(nlAdvancedPadding).append(txt);
                if (stackTrace == null) break;
                sb.append(nlAdvancedPadding).append(stackTrace);
            }
        }
        return sb.toString();
    }

    public String traceFormatGenData(GenericData genData) {
        KeyValuePair[] pairs = genData.getPairs();
        KeyValuePair kvp = null;
        String txt = null;
        Integer id = null;
        Integer levelVal = null;
        String className = null;
        String method = null;
        String loggerName = null;
        Long ibm_datetime = null;
        String corrId = null;
        String org = null;
        String prod = null;
        String component = null;
        String sym = null;
        String logLevel = null;
        String threadName = null;
        String stackTrace = null;
        for (KeyValuePair p : pairs) {
            if (p == null || p.isList()) continue;
            kvp = p;
            if (kvp.getKey().equals("message")) {
                txt = kvp.getStringValue();
                continue;
            }
            if (kvp.getKey().equals("ibm_datetime")) {
                ibm_datetime = kvp.getLongValue();
                continue;
            }
            if (kvp.getKey().equals("severity")) {
                sym = " " + kvp.getStringValue() + " ";
                continue;
            }
            if (kvp.getKey().equals("ibm_className")) {
                className = kvp.getStringValue();
                continue;
            }
            if (kvp.getKey().equals("ibm_methodName")) {
                method = kvp.getStringValue();
                continue;
            }
            if (kvp.getKey().equals("module")) {
                loggerName = kvp.getStringValue();
                continue;
            }
            if (kvp.getKey().equals("objectId")) {
                id = kvp.getIntValue();
                continue;
            }
            if (kvp.getKey().equals("correlationId")) {
                corrId = kvp.getStringValue();
                continue;
            }
            if (kvp.getKey().equals("org")) {
                org = kvp.getStringValue();
                continue;
            }
            if (kvp.getKey().equals("product")) {
                prod = kvp.getStringValue();
                continue;
            }
            if (kvp.getKey().equals("component")) {
                component = kvp.getStringValue();
                continue;
            }
            if (kvp.getKey().equals("loglevel")) {
                logLevel = kvp.getStringValue();
                continue;
            }
            if (kvp.getKey().equals("threadName")) {
                threadName = kvp.getStringValue();
                continue;
            }
            if (kvp.getKey().equals("levelValue")) {
                levelVal = kvp.getIntValue();
                continue;
            }
            if (!kvp.getKey().equals("throwable")) continue;
            stackTrace = kvp.getStringValue();
        }
        StringBuilder sb = new StringBuilder(256);
        sb.append('[').append(DateFormatHelper.formatTime(ibm_datetime, useIsoDateFormat)).append("] ");
        sb.append(DataFormatHelper.getThreadId());
        switch (this.traceFormat) {
            default: {
                String objId = this.generateObjectId(id, true);
                String name = BaseTraceFormatter.nonNullString(className, loggerName);
                sb.append(" id=").append(objId).append(' ');
                this.formatFixedString(sb, name, 60);
                sb.append(sym);
                if (method != null) {
                    sb.append(method).append(' ');
                }
                sb.append(txt);
                if (stackTrace == null) break;
                sb.append(LoggingConstants.nl).append(stackTrace);
                break;
            }
            case BASIC: {
                String name = BaseTraceFormatter.nonNullString(loggerName, className);
                sb.append(' ');
                this.fixedClassString(sb, name, 13);
                sb.append(sym);
                if (className != null) {
                    sb.append(className);
                }
                sb.append(' ');
                if (method != null) {
                    sb.append(method);
                }
                sb.append(' ');
                sb.append(txt);
                if (stackTrace == null) break;
                sb.append(nlBasicPadding).append(stackTrace);
                break;
            }
            case ADVANCED: {
                String objId = this.generateObjectId(id, false);
                String name = BaseTraceFormatter.nonNullString(loggerName, null);
                sb.append(' ');
                sb.append(sym);
                sb.append("UOW=");
                if (corrId != null) {
                    sb.append(corrId);
                }
                sb.append(" source=").append(name);
                if (className != null) {
                    sb.append(" class=").append(className);
                }
                if (method != null) {
                    sb.append(" method=").append(method);
                }
                if (id != null) {
                    sb.append(" id=").append(objId);
                }
                if (org != null && prod != null && component != null) {
                    sb.append(" org=");
                    sb.append(org);
                    sb.append(" prod=");
                    sb.append(prod);
                    sb.append(" component=");
                    sb.append(component);
                } else {
                    sb.append(" thread=[").append(threadName).append("]");
                }
                sb.append(nlAdvancedPadding).append(txt);
                if (stackTrace == null) break;
                sb.append(nlAdvancedPadding).append(stackTrace);
            }
        }
        return sb.toString();
    }

    private String getStackTrace(LogRecord logRecord) {
        Throwable t = logRecord.getThrown();
        if (t != null) {
            return DataFormatHelper.throwableToString(t);
        }
        return null;
    }

    private final String generateObjectId(Object id, boolean fixedWidth) {
        return this.generateObjectId(System.identityHashCode(id), fixedWidth);
    }

    private final String generateObjectId(Integer id, boolean fixedWidth) {
        String objId;
        if (id != null) {
            objId = Integer.toHexString(id);
            if (objId.length() < 8) {
                StringBuilder builder = new StringBuilder();
                builder.append("00000000");
                builder.append(objId);
                objId = builder.substring(builder.length() - 8);
            }
        } else {
            objId = fixedWidth ? pad8 : emptyString;
        }
        return objId;
    }

    private void formatFixedString(StringBuilder output, String s, int len) {
        if (s == null) {
            s = nullParamString;
        }
        if (s.length() > len) {
            output.append(s.substring(s.length() - len, s.length()));
        } else {
            output.append(s);
            if (len > s.length()) {
                output.append(enhancedPadding.substring(0, len - s.length()));
            }
        }
    }

    private void fixedClassString(StringBuilder output, String s, int len) {
        int i;
        if (s == null) {
            s = nullParamString;
        }
        if ((i = s.lastIndexOf(46)) >= 0) {
            s = s.substring(i + 1);
        }
        if (s.length() > len) {
            output.append(s.substring(0, len));
        } else {
            output.append(s);
            if (len > s.length()) {
                output.append(enhancedPadding.substring(0, len - s.length()));
            }
        }
    }

    private String formatTraceable(Traceable t) {
        String formatted;
        try {
            formatted = t.toTraceString();
        }
        catch (Exception e) {
            formatted = "<Exception " + e + " caught while calling toTraceString() on object " + t.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(t)) + ">";
        }
        return formatted;
    }

    public String formatObj(Object objs) {
        String ans;
        block12: {
            String nlPad;
            block8: {
                block9: {
                    StringBuilder sb;
                    block11: {
                        int len;
                        block10: {
                            ans = emptyString;
                            nlPad = LoggingConstants.TraceFormat.ADVANCED.equals((Object)this.traceFormat) ? nlAdvancedPadding : (LoggingConstants.TraceFormat.BASIC.equals((Object)this.traceFormat) ? nlBasicPadding : nlEnhancedPadding);
                            String nlPadA = nlPad + " ";
                            if (objs == null) break block8;
                            if (!objs.getClass().isArray()) break block9;
                            sb = new StringBuilder();
                            len = Array.getLength(objs);
                            if (!objs.getClass().getName().equals("[B")) break block10;
                            int COLUMNS = 32;
                            byte[] b = (byte[])objs;
                            int printLen = len > 16384 ? 16384 : len;
                            sb.append(nlPad).append(objs.toString()).append(",len=").append(len);
                            for (int i = 0; i < printLen; ++i) {
                                if (i % 32 == 0) {
                                    sb.append(nlPadA + '|' + DataFormatHelper.padHexString(i, 4) + '|');
                                }
                                if (i % 4 == 0) {
                                    sb.append(" ");
                                }
                                sb.append(hexChars[b[i] >> 4 & 0xF]);
                                sb.append(hexChars[b[i] & 0xF]);
                            }
                            if (printLen == len) break block11;
                            sb.append(nlPadA).append(" ...");
                            break block11;
                        }
                        if (objs.getClass().getName().equals("[C")) {
                            sb.append((char[])objs);
                        } else {
                            for (int i = 0; i < len; ++i) {
                                String s = this.formatObj(Array.get(objs, i));
                                if (s.startsWith(LoggingConstants.nl)) {
                                    sb.append(s);
                                } else {
                                    sb.append(nlPad + s);
                                }
                                if (sb.length() <= 16384) continue;
                                sb.append(nlPad + "...");
                                break;
                            }
                        }
                    }
                    ans = sb.toString();
                    break block12;
                }
                ans = nlPad + this.formatObject(objs, 0);
                break block12;
            }
            ans = nlPad + nullParamString;
        }
        return ans;
    }

    private String formatObject(Object objs, int depth) {
        if (objs == null) {
            return nullParamString;
        }
        if (depth >= COLLECTION_DEPTH_LIMIT) {
            return "Collection depth limit exceeded";
        }
        if (objs instanceof Untraceable) {
            return objs.getClass().getName();
        }
        if (objs instanceof Traceable) {
            return this.formatTraceable((Traceable)objs);
        }
        if (objs instanceof TruncatableThrowable) {
            return DataFormatHelper.throwableToString((TruncatableThrowable)objs);
        }
        if (objs instanceof Throwable) {
            return DataFormatHelper.throwableToString(new TruncatableThrowable((Throwable)objs));
        }
        if (objs instanceof Collection) {
            Object[] objArray = null;
            int retryableExceptionCount = 0;
            while (objArray == null) {
                try {
                    if (retryableExceptionCount >= 100) {
                        return "[Caught too many exceptions while logging collection type " + objs.getClass().getName() + "]";
                    }
                    objArray = ((Collection)objs).toArray();
                }
                catch (ConcurrentModificationException cme) {
                    ++retryableExceptionCount;
                }
                catch (NoSuchElementException nsee) {
                    ++retryableExceptionCount;
                }
                catch (Throwable t) {
                    return "[Caught " + t.toString() + " while logging collection type " + objs.getClass().getName() + "]";
                }
            }
            StringBuilder sb = new StringBuilder("[");
            if (objArray.length != 0) {
                sb.append(this.formatObject(objArray[0], depth + 1));
            }
            for (int i = 1; i < objArray.length; ++i) {
                sb.append(", ").append(this.formatObject(objArray[i], depth + 1));
            }
            sb.append("]");
            return sb.toString();
        }
        try {
            Class<?> cls = objs.getClass();
            String className = cls.getName();
            if (Proxy.isProxyClass(cls) || className.contains("$Proxy$_$$_Weld")) {
                return "Proxy for " + className + "@" + Integer.toHexString(System.identityHashCode(objs));
            }
            return objs.toString();
        }
        catch (Exception e) {
            String s = objs == null ? nullParamString : objs.getClass().getName();
            return "<Exception " + e + " caught while calling toString() on object " + s + "@" + Integer.toHexString(System.identityHashCode(objs)) + ">";
        }
    }

    private static String nonNullString(String parameter, String alternate) {
        if (parameter != null) {
            return parameter;
        }
        if (alternate != null) {
            return alternate;
        }
        return emptyString;
    }

    private String getMarker(LogRecord logRecord) {
        String message;
        Level level = logRecord.getLevel();
        if (level == null) {
            return " Z ";
        }
        if (level.getName() == SYSERR) {
            return " R ";
        }
        if (level.getName() == SYSOUT) {
            return " O ";
        }
        LevelFormat f = LevelFormat.findFormat(level);
        if (f == null) {
            return " Z ";
        }
        if (f.level == Level.FINER && (message = logRecord.getMessage()) != null) {
            if (message.equals(ENTRY) || message.startsWith("ENTRY")) {
                return " > ";
            }
            if (message.equals(EXIT) || message.startsWith("RETURN")) {
                return " < ";
            }
        }
        return f.marker;
    }

    public WsLogRecord getWsLogRecord(LogRecord logRecord) {
        return logRecord instanceof WsLogRecord ? (WsLogRecord)logRecord : null;
    }

    protected String formatStreamOutput(GenericData genData) {
        KeyValuePair[] pairs;
        String txt = null;
        String loglevel = null;
        KeyValuePair kvp = null;
        for (KeyValuePair p : pairs = genData.getPairs()) {
            if (p == null || p.isList()) continue;
            kvp = p;
            if (kvp.getKey().equals("message")) {
                txt = kvp.getStringValue();
                continue;
            }
            if (!kvp.getKey().equals("loglevel")) continue;
            loglevel = kvp.getStringValue();
        }
        String message = BaseTraceService.filterStackTraces(txt);
        if (message != null && loglevel.equals(SYSERR)) {
            message = "[err] " + message;
        }
        return message;
    }

    static enum LevelFormat {
        FATAL(WsLevel.FATAL, " F "),
        ERROR(WsLevel.ERROR, " E "),
        WARNING(Level.WARNING, " W "),
        AUDIT(WsLevel.AUDIT, " A "),
        INFO(Level.INFO, " I "),
        CONFIG(Level.CONFIG, " C "),
        DETAIL(WsLevel.DETAIL, " D "),
        EVENT(WsLevel.FINE, " 1 "),
        FINE(Level.FINE, " 1 "),
        FINER(Level.FINER, " 2 "),
        FINEST(Level.FINEST, " 3 ");

        final Level level;
        final int id;
        final String marker;

        private LevelFormat(Level l, String s) {
            this.level = l;
            this.id = l.intValue();
            this.marker = s;
        }

        public static LevelFormat findFormat(Level level) {
            int levelId = level.intValue();
            for (LevelFormat f : LevelFormat.values()) {
                if (level == f.level) {
                    return f;
                }
                if (levelId != f.id) continue;
                return f;
            }
            return null;
        }
    }
}

