/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.junit5;

import com.icegreen.greenmail.configuration.GreenMailConfiguration;
import com.icegreen.greenmail.util.GreenMail;
import com.icegreen.greenmail.util.GreenMailProxy;
import com.icegreen.greenmail.util.ServerSetup;
import com.icegreen.greenmail.util.ServerSetupTest;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class GreenMailExtension
extends GreenMailProxy
implements BeforeAllCallback,
AfterAllCallback,
BeforeEachCallback,
AfterEachCallback {
    private final ServerSetup[] serverSetups;
    private GreenMail greenMail;
    private boolean perMethod = true;

    public GreenMailExtension(ServerSetup serverSetup) {
        this.serverSetups = new ServerSetup[]{serverSetup};
    }

    public GreenMailExtension() {
        this(ServerSetupTest.ALL);
    }

    public GreenMailExtension(ServerSetup[] serverSetups) {
        this.serverSetups = serverSetups;
    }

    public void beforeEach(ExtensionContext context) {
        if (this.perMethod) {
            this.greenMail = new GreenMail(this.serverSetups);
            this.start();
        }
    }

    public void afterEach(ExtensionContext context) {
        if (this.perMethod) {
            this.stop();
        }
    }

    public void beforeAll(ExtensionContext context) throws Exception {
        if (!this.perMethod) {
            this.greenMail = new GreenMail(this.serverSetups);
            this.start();
        }
    }

    public void afterAll(ExtensionContext context) throws Exception {
        if (!this.perMethod) {
            this.stop();
        }
    }

    public GreenMailExtension withPerMethodLifecycle(boolean perMethod) {
        this.perMethod = perMethod;
        return this;
    }

    protected GreenMail getGreenMail() {
        return this.greenMail;
    }

    public GreenMailExtension withConfiguration(GreenMailConfiguration config) {
        super.withConfiguration(config);
        return this;
    }
}

