/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.imap;

import com.icegreen.greenmail.imap.ImapConstants;
import com.icegreen.greenmail.imap.ImapHostManager;
import com.icegreen.greenmail.imap.ImapRequestHandler;
import com.icegreen.greenmail.imap.ImapResponse;
import com.icegreen.greenmail.imap.ImapSession;
import com.icegreen.greenmail.imap.ImapSessionImpl;
import com.icegreen.greenmail.server.ProtocolHandler;
import com.icegreen.greenmail.user.UserManager;
import com.icegreen.greenmail.util.InternetPrintWriter;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImapHandler
implements ImapConstants,
ProtocolHandler {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private ImapRequestHandler requestHandler = new ImapRequestHandler();
    private ImapSession session;
    private Socket socket;
    private BufferedReader in;
    private InputStream ins;
    private InternetPrintWriter out;
    private OutputStream outs;
    UserManager userManager;
    private ImapHostManager imapHost;

    public ImapHandler(UserManager userManager, ImapHostManager imapHost, Socket socket) {
        this.userManager = userManager;
        this.imapHost = imapHost;
        this.socket = socket;
    }

    public void forceConnectionClose(String message) {
        ImapResponse response = new ImapResponse(this.outs);
        response.byeResponse(message);
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.ins = this.socket.getInputStream();
            this.in = new BufferedReader(new InputStreamReader(this.socket.getInputStream(), "ASCII"), 512);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            this.outs = new BufferedOutputStream(this.socket.getOutputStream(), 1024);
            this.out = new InternetPrintWriter(this.outs, true);
            ImapResponse response = new ImapResponse(this.outs);
            String responseBuffer = "IMAP4rev1 Server GreenMail ready";
            response.okResponse(null, responseBuffer);
            this.session = new ImapSessionImpl(this.imapHost, this.userManager, this, this.socket.getInetAddress().getHostAddress());
            while (this.requestHandler.handleRequest(this.ins, this.outs, this.session)) {
            }
        }
        catch (Exception e) {
            this.log.error("Can not handle IMAP connection", (Throwable)e);
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            if (this.socket != null && !this.socket.isClosed()) {
                this.socket.close();
            }
        }
        catch (IOException e) {
            this.log.warn("Can not close socket", (Throwable)e);
        }
        finally {
            this.socket = null;
        }
        try {
            if (this.in != null) {
                this.in.close();
            }
        }
        catch (Exception e) {
            this.log.warn("Can not close input stream", (Throwable)e);
        }
        finally {
            this.in = null;
        }
        try {
            if (this.out != null) {
                this.out.close();
            }
        }
        catch (Exception e) {
            this.log.warn("Can not close writer", (Throwable)e);
        }
        finally {
            this.out = null;
        }
        try {
            if (this.outs != null) {
                this.outs.close();
            }
        }
        catch (Exception e) {
            this.log.warn("Can not close output stream", (Throwable)e);
        }
        finally {
            this.outs = null;
        }
        this.session = null;
    }
}

