/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.imap;

import com.icegreen.greenmail.imap.AuthorizationException;
import com.icegreen.greenmail.imap.ImapConstants;
import com.icegreen.greenmail.imap.ImapHostManager;
import com.icegreen.greenmail.store.FolderException;
import com.icegreen.greenmail.store.InMemoryStore;
import com.icegreen.greenmail.store.MailFolder;
import com.icegreen.greenmail.store.Store;
import com.icegreen.greenmail.store.StoredMessage;
import com.icegreen.greenmail.user.GreenMailUser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class ImapHostManagerImpl
implements ImapHostManager,
ImapConstants {
    private Store store;
    private MailboxSubscriptions subscriptions;

    public ImapHostManagerImpl() {
        this.store = new InMemoryStore();
        this.subscriptions = new MailboxSubscriptions();
    }

    public ImapHostManagerImpl(Store store) {
        this.store = store;
        this.subscriptions = new MailboxSubscriptions();
    }

    @Override
    public List<StoredMessage> getAllMessages() {
        ArrayList<StoredMessage> ret = new ArrayList<StoredMessage>();
        try {
            Collection<MailFolder> boxes = this.store.listMailboxes("*");
            Iterator<MailFolder> i$ = boxes.iterator();
            while (i$.hasNext()) {
                MailFolder boxe;
                MailFolder folder = boxe = i$.next();
                ret.addAll(folder.getMessages());
            }
        }
        catch (FolderException e) {
            throw new RuntimeException(e);
        }
        return ret;
    }

    @Override
    public char getHierarchyDelimiter() {
        return '.';
    }

    @Override
    public MailFolder getFolder(GreenMailUser user, String mailboxName) {
        String name = this.getQualifiedMailboxName(user, mailboxName);
        MailFolder folder = this.store.getMailbox(name);
        return this.checkViewable(folder);
    }

    @Override
    public MailFolder getFolder(GreenMailUser user, String mailboxName, boolean mustExist) throws FolderException {
        MailFolder folder = this.getFolder(user, mailboxName);
        if (mustExist && folder == null) {
            throw new FolderException("No such store.");
        }
        return folder;
    }

    private MailFolder checkViewable(MailFolder folder) {
        return folder;
    }

    @Override
    public MailFolder getInbox(GreenMailUser user) throws FolderException {
        return this.getFolder(user, "INBOX");
    }

    @Override
    public void createPrivateMailAccount(GreenMailUser user) throws FolderException {
        MailFolder root = this.store.getMailbox("#mail");
        MailFolder userRoot = this.store.createMailbox(root, user.getQualifiedMailboxName(), false);
        this.store.createMailbox(userRoot, "INBOX", true);
    }

    @Override
    public MailFolder createMailbox(GreenMailUser user, String mailboxName) throws AuthorizationException, FolderException {
        String qualifiedName = this.getQualifiedMailboxName(user, mailboxName);
        if (this.store.getMailbox(qualifiedName) != null) {
            throw new FolderException("Mailbox already exists.");
        }
        StringTokenizer tokens = new StringTokenizer(qualifiedName, HIERARCHY_DELIMITER);
        if (tokens.countTokens() < 2) {
            throw new FolderException("Cannot create store at namespace level.");
        }
        String namespaceRoot = tokens.nextToken();
        MailFolder folder = this.store.getMailbox(namespaceRoot);
        if (folder == null) {
            throw new FolderException("Invalid namespace.");
        }
        while (tokens.hasMoreTokens()) {
            String childName = tokens.nextToken();
            MailFolder child = this.store.getMailbox(folder, childName);
            if (child == null) {
                boolean makeSelectable = !tokens.hasMoreTokens();
                child = this.store.createMailbox(folder, childName, makeSelectable);
            }
            folder = child;
        }
        return folder;
    }

    @Override
    public void deleteMailbox(GreenMailUser user, String mailboxName) throws FolderException, AuthorizationException {
        MailFolder toDelete = this.getFolder(user, mailboxName, true);
        if (this.store.getChildren(toDelete).isEmpty()) {
            toDelete.deleteAllMessages();
            toDelete.signalDeletion();
            this.store.deleteMailbox(toDelete);
        } else if (toDelete.isSelectable()) {
            toDelete.deleteAllMessages();
            this.store.setSelectable(toDelete, false);
        } else {
            throw new FolderException("Can't delete a non-selectable store with children.");
        }
    }

    @Override
    public void renameMailbox(GreenMailUser user, String oldMailboxName, String newMailboxName) throws FolderException, AuthorizationException {
        MailFolder existingFolder = this.getFolder(user, oldMailboxName, true);
        String userInboxName = this.getQualifiedMailboxName(user, "INBOX");
        if (userInboxName.equals(existingFolder.getFullName())) {
            long[] uids;
            MailFolder newBox = this.createMailbox(user, newMailboxName);
            for (long uid : uids = existingFolder.getMessageUids()) {
                existingFolder.copyMessage(uid, newBox);
            }
            existingFolder.deleteAllMessages();
            return;
        }
        this.store.renameMailbox(existingFolder, newMailboxName);
    }

    @Override
    public Collection listSubscribedMailboxes(GreenMailUser user, String mailboxPattern) throws FolderException {
        return this.listMailboxes(user, mailboxPattern, true);
    }

    @Override
    public Collection listMailboxes(GreenMailUser user, String mailboxPattern) throws FolderException {
        return this.listMailboxes(user, mailboxPattern, false);
    }

    private Collection listMailboxes(GreenMailUser user, String mailboxPattern, boolean subscribedOnly) throws FolderException {
        ArrayList<MailFolder> mailboxes = new ArrayList<MailFolder>();
        String qualifiedPattern = this.getQualifiedMailboxName(user, mailboxPattern);
        for (MailFolder folder : this.store.listMailboxes(qualifiedPattern)) {
            if (subscribedOnly && !this.subscriptions.isSubscribed(user, folder)) {
                folder = null;
            }
            if ((folder = this.checkViewable(folder)) == null) continue;
            mailboxes.add(folder);
        }
        return mailboxes;
    }

    @Override
    public void subscribe(GreenMailUser user, String mailboxName) throws FolderException {
        MailFolder folder = this.getFolder(user, mailboxName, true);
        this.subscriptions.subscribe(user, folder);
    }

    @Override
    public void unsubscribe(GreenMailUser user, String mailboxName) throws FolderException {
        MailFolder folder = this.getFolder(user, mailboxName, true);
        this.subscriptions.unsubscribe(user, folder);
    }

    private String getQualifiedMailboxName(GreenMailUser user, String mailboxName) {
        String userNamespace = user.getQualifiedMailboxName();
        if ("INBOX".equalsIgnoreCase(mailboxName)) {
            return "#mail" + HIERARCHY_DELIMITER + userNamespace + HIERARCHY_DELIMITER + "INBOX";
        }
        if (mailboxName.startsWith(NAMESPACE_PREFIX)) {
            return mailboxName;
        }
        if (mailboxName.length() == 0) {
            return "#mail" + HIERARCHY_DELIMITER + userNamespace;
        }
        return "#mail" + HIERARCHY_DELIMITER + userNamespace + HIERARCHY_DELIMITER + mailboxName;
    }

    @Override
    public Store getStore() {
        return this.store;
    }

    private static class MailboxSubscriptions {
        private Map<String, List<String>> userSubs = new HashMap<String, List<String>>();

        private MailboxSubscriptions() {
        }

        void subscribe(GreenMailUser user, MailFolder folder) throws FolderException {
            this.getUserSubs(user).add(folder.getFullName());
        }

        void unsubscribe(GreenMailUser user, MailFolder folder) throws FolderException {
            this.getUserSubs(user).remove(folder.getFullName());
        }

        boolean isSubscribed(GreenMailUser user, MailFolder folder) {
            return this.getUserSubs(user).contains(folder.getFullName());
        }

        private List<String> getUserSubs(GreenMailUser user) {
            List<String> subs = this.userSubs.get(user.getLogin());
            if (subs == null) {
                subs = new ArrayList<String>();
                this.userSubs.put(user.getLogin(), subs);
            }
            return subs;
        }
    }
}

