/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.server;

import com.icegreen.greenmail.Managers;
import com.icegreen.greenmail.server.ProtocolHandler;
import com.icegreen.greenmail.util.DummySSLServerSocketFactory;
import com.icegreen.greenmail.util.ServerSetup;
import com.icegreen.greenmail.util.Service;
import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractServer
extends Service {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final InetAddress bindTo;
    protected ServerSocket serverSocket = null;
    protected Managers managers;
    protected ServerSetup setup;
    private Vector<ProtocolHandler> handlers = new Vector();

    protected AbstractServer(ServerSetup setup, Managers managers) {
        this.setup = setup;
        try {
            this.bindTo = setup.getBindAddress() == null ? InetAddress.getByName("0.0.0.0") : InetAddress.getByName(setup.getBindAddress());
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
        this.managers = managers;
    }

    protected abstract ProtocolHandler createProtocolHandler(Socket var1);

    protected synchronized ServerSocket openServerSocket() throws IOException {
        ServerSocket ret = null;
        BindException retEx = null;
        for (int i = 0; i < 25 && null == ret; ++i) {
            try {
                if (this.setup.isSecure()) {
                    ret = DummySSLServerSocketFactory.getDefault().createServerSocket(this.setup.getPort(), 0, this.bindTo);
                    continue;
                }
                ret = new ServerSocket(this.setup.getPort(), 0, this.bindTo);
                continue;
            }
            catch (BindException e) {
                try {
                    retEx = e;
                    Thread.sleep(10L);
                    continue;
                }
                catch (InterruptedException ignored) {
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug("Can not open port, retrying ...", (Throwable)e);
                }
            }
        }
        if (null == ret && null != retEx) {
            throw retEx;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            try {
                this.serverSocket = this.openServerSocket();
                this.setRunning(true);
                AbstractServer abstractServer = this;
                synchronized (abstractServer) {
                    this.notifyAll();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            while (this.keepOn()) {
                try {
                    Socket clientSocket = this.serverSocket.accept();
                    if (!this.keepOn()) {
                        clientSocket.close();
                        continue;
                    }
                    final ProtocolHandler handler = this.createProtocolHandler(clientSocket);
                    this.addHandler(handler);
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            handler.run();
                            AbstractServer.this.removeHandler(handler);
                        }
                    }).start();
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            this.quit();
        }
    }

    private void addHandler(ProtocolHandler handler) {
        this.handlers.add(handler);
    }

    private void removeHandler(ProtocolHandler handler) {
        this.handlers.remove(handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void quit() {
        try {
            Vector<ProtocolHandler> vector = this.handlers;
            synchronized (vector) {
                for (ProtocolHandler handler : this.handlers) {
                    handler.close();
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            if (null != this.serverSocket) {
                if (!this.serverSocket.isClosed()) {
                    this.serverSocket.close();
                }
                this.serverSocket = null;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getBindTo() {
        return this.bindTo.getHostAddress();
    }

    public int getPort() {
        return this.setup.getPort();
    }

    public String getProtocol() {
        return this.setup.getProtocol();
    }

    public ServerSetup getServerSetup() {
        return this.setup;
    }

    @Override
    public String toString() {
        return null != this.setup ? this.setup.getProtocol() + ':' + this.setup.getPort() : super.toString();
    }
}

