/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.smtp;

import com.icegreen.greenmail.smtp.SmtpHandler;
import com.icegreen.greenmail.util.InternetPrintWriter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmtpConnection {
    private static final int TIMEOUT_MILLIS = 30000;
    private InetAddress serverAddress;
    protected static final Logger log = LoggerFactory.getLogger(SmtpConnection.class);
    Socket sock;
    InetAddress clientAddress;
    InternetPrintWriter out;
    BufferedReader in;
    SmtpHandler handler;
    String heloName;

    public SmtpConnection(SmtpHandler handler, Socket sock) throws IOException {
        try {
            this.serverAddress = InetAddress.getLocalHost();
        }
        catch (UnknownHostException uhe) {
            log.error("Could not get address of localhost", (Throwable)uhe);
        }
        this.sock = sock;
        sock.setSoTimeout(30000);
        this.clientAddress = sock.getInetAddress();
        OutputStream o = sock.getOutputStream();
        InputStream i = sock.getInputStream();
        this.out = new InternetPrintWriter(o, true);
        this.in = new BufferedReader(new InputStreamReader(i));
        this.handler = handler;
    }

    public void send(String line) {
        if (log.isTraceEnabled()) {
            log.trace("S: " + line);
        }
        this.out.println(line);
    }

    public BufferedReader getReader() {
        return this.in;
    }

    public String receiveLine() throws IOException {
        String line = this.in.readLine();
        if (log.isTraceEnabled()) {
            log.trace("C: " + line);
        }
        return line;
    }

    public String getClientAddress() {
        return this.clientAddress.getHostAddress();
    }

    public InetAddress getServerAddress() {
        return this.serverAddress;
    }

    public String getServerGreetingsName() {
        InetAddress serverAddress = this.getServerAddress();
        if (serverAddress != null) {
            return serverAddress.toString();
        }
        return System.getProperty("user.name");
    }

    public String getHeloName() {
        return this.heloName;
    }

    public void setHeloName(String n) {
        this.heloName = n;
    }

    public void quit() {
        this.handler.close();
    }
}

