/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.store;

import com.icegreen.greenmail.store.FolderException;
import com.icegreen.greenmail.store.MailMessageAttributes;
import com.icegreen.greenmail.store.SimpleMessageAttributes;
import java.util.Date;
import javax.mail.Flags;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;

public class StoredMessage {
    private MimeMessage mimeMessage;
    private Date internalDate;
    private long uid;
    private SimpleMessageAttributes attributes;

    StoredMessage(MimeMessage mimeMessage, Date internalDate, long uid) {
        this.mimeMessage = mimeMessage;
        this.internalDate = internalDate;
        this.uid = uid;
    }

    public MimeMessage getMimeMessage() {
        return this.mimeMessage;
    }

    public Flags getFlags() {
        try {
            return this.getMimeMessage().getFlags();
        }
        catch (MessagingException e) {
            throw new IllegalStateException("Can not access flags", e);
        }
    }

    public boolean isSet(Flags.Flag flag) {
        try {
            return this.getMimeMessage().isSet(flag);
        }
        catch (MessagingException e) {
            throw new IllegalStateException("Can not access flag " + flag, e);
        }
    }

    public void setFlag(Flags.Flag flag, boolean value) {
        try {
            this.getMimeMessage().setFlag(flag, value);
        }
        catch (MessagingException e) {
            throw new IllegalStateException("Can not set flag " + flag + " to " + value, e);
        }
    }

    public void setFlags(Flags flags, boolean value) {
        try {
            this.getMimeMessage().setFlags(flags, value);
        }
        catch (MessagingException e) {
            throw new IllegalStateException("Can not set flags " + flags + " to " + value, e);
        }
    }

    public Date getInternalDate() {
        return this.internalDate;
    }

    public long getUid() {
        return this.uid;
    }

    public MailMessageAttributes getAttributes() throws FolderException {
        if (this.attributes == null) {
            this.attributes = new SimpleMessageAttributes();
            try {
                this.attributes.setAttributesFor(this.mimeMessage);
            }
            catch (MessagingException e) {
                throw new FolderException("Could not parse mime message." + e.getMessage());
            }
        }
        return this.attributes;
    }
}

