/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.user;

import com.icegreen.greenmail.imap.ImapHostManager;
import com.icegreen.greenmail.user.GreenMailUser;
import com.icegreen.greenmail.user.UserException;
import com.icegreen.greenmail.user.UserImpl;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class UserManager {
    private Map<String, GreenMailUser> _users = Collections.synchronizedMap(new HashMap());
    private ImapHostManager imapHostManager;

    public UserManager(ImapHostManager imapHostManager) {
        this.imapHostManager = imapHostManager;
    }

    public GreenMailUser getUser(String login) {
        return this._users.get(UserManager.normalizerUserName(login));
    }

    public GreenMailUser getUserByEmail(String email) {
        return this.getUser(email);
    }

    public GreenMailUser createUser(String email, String login, String password) throws UserException {
        UserImpl user = new UserImpl(email, login, password, this.imapHostManager);
        user.create();
        this.addUser(user);
        return user;
    }

    private void addUser(GreenMailUser user) {
        this.deleteUser(user);
        this._users.put(UserManager.normalizerUserName(user.getLogin()), user);
    }

    public void deleteUser(GreenMailUser user) {
        if ((user = this._users.remove(UserManager.normalizerUserName(user.getLogin()))) != null) {
            user.delete();
        }
    }

    public boolean test(String userid, String password) {
        GreenMailUser u = this.getUser(userid);
        return null != u && u.getPassword().equals(password);
    }

    public ImapHostManager getImapHostManager() {
        return this.imapHostManager;
    }

    private static String normalizerUserName(String login) {
        return login.trim().toLowerCase(Locale.ENGLISH);
    }
}

