/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.util;

import com.icegreen.greenmail.Managers;
import com.icegreen.greenmail.imap.ImapServer;
import com.icegreen.greenmail.pop3.Pop3Server;
import com.icegreen.greenmail.smtp.SmtpManager;
import com.icegreen.greenmail.smtp.SmtpServer;
import com.icegreen.greenmail.store.StoredMessage;
import com.icegreen.greenmail.user.GreenMailUser;
import com.icegreen.greenmail.user.UserException;
import com.icegreen.greenmail.util.GreenMailOperations;
import com.icegreen.greenmail.util.GreenMailUtil;
import com.icegreen.greenmail.util.ServerSetup;
import com.icegreen.greenmail.util.ServerSetupTest;
import com.icegreen.greenmail.util.Service;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;

public class GreenMail
implements GreenMailOperations {
    private Managers managers;
    private Map<String, Service> services;
    private ServerSetup[] config;

    public GreenMail() {
        this(ServerSetupTest.ALL);
    }

    public GreenMail(ServerSetup config) {
        this(new ServerSetup[]{config});
    }

    public GreenMail(ServerSetup[] config) {
        this.config = config;
        this.init();
    }

    private void init() {
        if (this.managers == null) {
            this.managers = new Managers();
        }
        if (this.services == null) {
            this.services = GreenMail.createServices(this.config, this.managers);
        }
    }

    @Override
    public synchronized void start() {
        this.init();
        for (Service service : this.services.values()) {
            service.startService(null);
        }
        boolean allup = false;
        for (int i = 0; i < 200 && !allup; ++i) {
            allup = true;
            for (Service service : this.services.values()) {
                allup = allup && service.isRunning();
            }
            if (allup) continue;
            try {
                this.wait(5L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (!allup) {
            throw new RuntimeException("Couldnt start at least one of the mail services.");
        }
    }

    @Override
    public synchronized void stop() {
        if (this.services != null) {
            for (Service service : this.services.values()) {
                if (!service.isRunning()) continue;
                service.stopService(null);
            }
        }
        this.managers = new Managers();
        this.services = null;
    }

    @Override
    public void reset() {
        this.stop();
        this.start();
    }

    private static Map<String, Service> createServices(ServerSetup[] config, Managers mgr) {
        HashMap<String, Service> srvc = new HashMap<String, Service>();
        for (ServerSetup setup : config) {
            if (srvc.containsKey(setup.getProtocol())) {
                throw new IllegalArgumentException("Server '" + setup.getProtocol() + "' was found at least twice in the array");
            }
            String protocol = setup.getProtocol();
            if (protocol.startsWith("smtp")) {
                srvc.put(protocol, new SmtpServer(setup, mgr));
                continue;
            }
            if (protocol.startsWith("pop3")) {
                srvc.put(protocol, new Pop3Server(setup, mgr));
                continue;
            }
            if (!protocol.startsWith("imap")) continue;
            srvc.put(protocol, new ImapServer(setup, mgr));
        }
        return srvc;
    }

    @Override
    public SmtpServer getSmtp() {
        return (SmtpServer)this.services.get("smtp");
    }

    @Override
    public ImapServer getImap() {
        return (ImapServer)this.services.get("imap");
    }

    @Override
    public Pop3Server getPop3() {
        return (Pop3Server)this.services.get("pop3");
    }

    @Override
    public SmtpServer getSmtps() {
        return (SmtpServer)this.services.get("smtps");
    }

    @Override
    public ImapServer getImaps() {
        return (ImapServer)this.services.get("imaps");
    }

    @Override
    public Pop3Server getPop3s() {
        return (Pop3Server)this.services.get("pop3s");
    }

    @Override
    public Managers getManagers() {
        return this.managers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean waitForIncomingEmail(long timeout, int emailCount) {
        SmtpManager.WaitObject o = this.managers.getSmtpManager().createAndAddNewWaitObject(emailCount);
        if (null == o) {
            return true;
        }
        SmtpManager.WaitObject waitObject = o;
        synchronized (waitObject) {
            long t0 = System.currentTimeMillis();
            while (!o.isArrived()) {
                try {
                    o.wait(timeout);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("Thread was interrupted while waiting", e);
                }
                if (System.currentTimeMillis() - t0 <= timeout) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean waitForIncomingEmail(int emailCount) {
        return this.waitForIncomingEmail(5000L, emailCount);
    }

    @Override
    public MimeMessage[] getReceivedMessages() {
        List<StoredMessage> msgs = this.managers.getImapHostManager().getAllMessages();
        MimeMessage[] ret = new MimeMessage[msgs.size()];
        for (int i = 0; i < msgs.size(); ++i) {
            StoredMessage storedMessage = msgs.get(i);
            ret[i] = storedMessage.getMimeMessage();
        }
        return ret;
    }

    @Override
    public MimeMessage[] getReceviedMessagesForDomain(String domain) {
        List<StoredMessage> msgs = this.managers.getImapHostManager().getAllMessages();
        ArrayList<MimeMessage> ret = new ArrayList<MimeMessage>();
        try {
            for (StoredMessage msg : msgs) {
                String tos = GreenMailUtil.getAddressList(msg.getMimeMessage().getAllRecipients());
                if (!tos.toLowerCase().contains(domain)) continue;
                ret.add(msg.getMimeMessage());
            }
        }
        catch (MessagingException e) {
            throw new RuntimeException(e);
        }
        return ret.toArray(new MimeMessage[ret.size()]);
    }

    @Override
    public GreenMailUser setUser(String login, String password) {
        return this.setUser(login, login, password);
    }

    @Override
    public GreenMailUser setUser(String email, String login, String password) {
        GreenMailUser user = this.managers.getUserManager().getUser(email);
        if (null == user) {
            try {
                user = this.managers.getUserManager().createUser(email, login, password);
            }
            catch (UserException e) {
                throw new RuntimeException(e);
            }
        } else {
            user.setPassword(password);
        }
        return user;
    }

    @Override
    public void setQuotaSupported(boolean isEnabled) {
        this.managers.getImapHostManager().getStore().setQuotaSupported(isEnabled);
    }

    @Override
    public void setUsers(Properties users) {
        for (Object o : users.keySet()) {
            String email = (String)o;
            String password = users.getProperty(email);
            this.setUser(email, email, password);
        }
    }

    public GreenMailUtil util() {
        return GreenMailUtil.instance();
    }
}

