/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.util;

import com.icegreen.greenmail.user.GreenMailUser;
import com.icegreen.greenmail.util.DummySSLSocketFactory;
import com.icegreen.greenmail.util.ServerSetup;
import com.icegreen.greenmail.util.ServerSetupTest;
import com.sun.mail.imap.IMAPStore;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.Quota;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GreenMailUtil {
    private static final Logger log = LoggerFactory.getLogger(GreenMailUtil.class);
    private static int generateCount = 0;
    private static final String generateSet = "abcdefghijkmnopqrstuvwxyzABCDEFGHJKLMNPRSTUVWXYZ23456789";
    private static final int generateSetSize = "abcdefghijkmnopqrstuvwxyzABCDEFGHJKLMNPRSTUVWXYZ23456789".length();
    private static GreenMailUtil instance = new GreenMailUtil();

    private GreenMailUtil() {
    }

    public static GreenMailUtil instance() {
        return instance;
    }

    public static void copyStream(InputStream src, OutputStream dest) throws IOException {
        int read;
        byte[] buffer = new byte[1024];
        while ((read = src.read(buffer)) > -1) {
            dest.write(buffer, 0, read);
        }
        dest.flush();
    }

    public static MimeMessage newMimeMessage(InputStream inputStream) {
        try {
            return new MimeMessage(Session.getDefaultInstance((Properties)new Properties()), inputStream);
        }
        catch (MessagingException e) {
            throw new RuntimeException(e);
        }
    }

    public static MimeMessage newMimeMessage(String mailString) throws MessagingException {
        try {
            byte[] bytes = mailString.getBytes("US-ASCII");
            return GreenMailUtil.newMimeMessage(new ByteArrayInputStream(bytes));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean hasNonTextAttachments(Part m) {
        try {
            Object content = m.getContent();
            if (content instanceof MimeMultipart) {
                MimeMultipart mm = (MimeMultipart)content;
                for (int i = 0; i < mm.getCount(); ++i) {
                    BodyPart p = mm.getBodyPart(i);
                    if (!GreenMailUtil.hasNonTextAttachments((Part)p)) continue;
                    return true;
                }
                return false;
            }
            return !m.getContentType().trim().toLowerCase().startsWith("text");
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static int getLineCount(String str) {
        LineNumberReader reader = new LineNumberReader(new StringReader(str));
        try {
            reader.skip(Long.MAX_VALUE);
            int n = reader.getLineNumber();
            return n;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                log.warn("Can not close reader", (Throwable)e);
            }
        }
    }

    public static String getBody(Part msg) {
        String all = GreenMailUtil.getWholeMessage(msg);
        int i = all.indexOf("\r\n\r\n");
        return all.substring(i + 4, all.length());
    }

    public static String getHeaders(Part msg) {
        String all = GreenMailUtil.getWholeMessage(msg);
        int i = all.indexOf("\r\n\r\n");
        return all.substring(0, i);
    }

    public static String getWholeMessage(Part msg) {
        try {
            ByteArrayOutputStream bodyOut = new ByteArrayOutputStream();
            msg.writeTo((OutputStream)bodyOut);
            return bodyOut.toString("US-ASCII").trim();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] getBodyAsBytes(Part msg) {
        return GreenMailUtil.getBody(msg).getBytes();
    }

    public static byte[] getHeaderAsBytes(Part part) {
        return GreenMailUtil.getHeaders(part).getBytes();
    }

    public static String toString(Part msg) {
        return GreenMailUtil.getWholeMessage(msg);
    }

    public static String random() {
        Random r = new Random();
        int nbrOfLetters = r.nextInt(3) + 5;
        return GreenMailUtil.random(nbrOfLetters);
    }

    public static String random(int nbrOfLetters) {
        Random r = new Random();
        StringBuilder ret = new StringBuilder();
        while (nbrOfLetters > 0) {
            int pos = (r.nextInt(generateSetSize) + ++generateCount) % generateSetSize;
            ret.append(generateSet.charAt(pos));
            --nbrOfLetters;
        }
        return ret.toString();
    }

    public static void sendTextEmailTest(String to, String from, String subject, String msg) {
        try {
            GreenMailUtil.sendTextEmail(to, from, subject, msg, ServerSetupTest.SMTP);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static void sendTextEmailSecureTest(String to, String from, String subject, String msg) {
        try {
            GreenMailUtil.sendTextEmail(to, from, subject, msg, ServerSetupTest.SMTPS);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String getAddressList(Address[] addresses) {
        if (null == addresses) {
            return null;
        }
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < addresses.length; ++i) {
            if (i > 0) {
                ret.append(", ");
            }
            ret.append(addresses[i].toString());
        }
        return ret.toString();
    }

    public static void sendTextEmail(String to, String from, String subject, String msg, ServerSetup setup) {
        try {
            Session session = GreenMailUtil.getSession(setup);
            InternetAddress[] tos = new InternetAddress[]{new InternetAddress(to)};
            InternetAddress[] froms = new InternetAddress[]{new InternetAddress(from)};
            MimeMessage mimeMessage = new MimeMessage(session);
            mimeMessage.setSubject(subject);
            mimeMessage.setFrom((Address)froms[0]);
            mimeMessage.setRecipients(Message.RecipientType.TO, (Address[])tos);
            mimeMessage.setText(msg);
            Transport.send((Message)mimeMessage);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static void sendMimeMessage(MimeMessage mimeMessage) {
        try {
            Transport.send((Message)mimeMessage);
        }
        catch (MessagingException e) {
            throw new RuntimeException(e);
        }
    }

    public static void sendMessageBody(String to, String from, String subject, Object body, String contentType, ServerSetup serverSetup) {
        try {
            Session smtpSession = GreenMailUtil.getSession(serverSetup);
            MimeMessage mimeMessage = new MimeMessage(smtpSession);
            mimeMessage.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)to));
            mimeMessage.setFrom((Address)new InternetAddress(from));
            mimeMessage.setSubject(subject);
            mimeMessage.setContent(body, contentType);
            GreenMailUtil.sendMimeMessage(mimeMessage);
        }
        catch (AddressException e) {
            throw new RuntimeException(e);
        }
        catch (MessagingException e) {
            throw new RuntimeException(e);
        }
    }

    public static void sendAttachmentEmail(String to, String from, String subject, String msg, byte[] attachment, String contentType, String filename, String description, ServerSetup setup) {
        MimeMultipart multiPart = GreenMailUtil.createMultipartWithAttachment(msg, attachment, contentType, filename, description);
        GreenMailUtil.sendMessageBody(to, from, subject, multiPart, null, setup);
    }

    private static MimeMultipart createMultipartWithAttachment(String msg, final byte[] attachment, final String contentType, final String filename, String description) {
        try {
            MimeMultipart multiPart = new MimeMultipart();
            MimeBodyPart textPart = new MimeBodyPart();
            multiPart.addBodyPart((BodyPart)textPart);
            textPart.setText(msg);
            MimeBodyPart binaryPart = new MimeBodyPart();
            multiPart.addBodyPart((BodyPart)binaryPart);
            DataSource ds = new DataSource(){

                public InputStream getInputStream() throws IOException {
                    return new ByteArrayInputStream(attachment);
                }

                public OutputStream getOutputStream() throws IOException {
                    ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
                    byteStream.write(attachment);
                    return byteStream;
                }

                public String getContentType() {
                    return contentType;
                }

                public String getName() {
                    return filename;
                }
            };
            binaryPart.setDataHandler(new DataHandler(ds));
            binaryPart.setFileName(filename);
            binaryPart.setDescription(description);
            return multiPart;
        }
        catch (MessagingException e) {
            throw new RuntimeException(e);
        }
    }

    public static Session getSession(ServerSetup setup) {
        return GreenMailUtil.getSession(setup, null);
    }

    public static Session getSession(ServerSetup setup, Properties mailProps) {
        Properties props = new Properties();
        props.put("mail.smtps.starttls.enable", Boolean.TRUE);
        if (setup.isSecure()) {
            props.setProperty("mail.smtp.socketFactory.class", DummySSLSocketFactory.class.getName());
        }
        props.setProperty("mail.transport.protocol", setup.getProtocol());
        props.setProperty("mail.smtps.port", String.valueOf(setup.getPort()));
        props.setProperty("mail.smtp.port", String.valueOf(setup.getPort()));
        props.setProperty("mail.smtp.localaddress", String.valueOf(ServerSetup.getLocalHostAddress()));
        props.setProperty("mail.smtps.localaddress", String.valueOf(ServerSetup.getLocalHostAddress()));
        props.setProperty("mail." + setup.getProtocol() + ".port", String.valueOf(setup.getPort()));
        props.setProperty("mail." + setup.getProtocol() + ".host", String.valueOf(setup.getBindAddress()));
        if (setup.isSecure() && "smtps".equals(setup.getProtocol())) {
            props.setProperty("mail.smtp.host", String.valueOf(setup.getBindAddress()));
        }
        if (null != mailProps && !mailProps.isEmpty()) {
            props.putAll((Map<?, ?>)mailProps);
        }
        if (log.isDebugEnabled()) {
            log.debug("Mail session properties are " + props);
        }
        return Session.getInstance((Properties)props, null);
    }

    public static void setQuota(GreenMailUser user, Quota quota) {
        Session session = GreenMailUtil.getSession(ServerSetupTest.IMAP);
        try {
            IMAPStore store = (IMAPStore)session.getStore("imap");
            store.connect(user.getEmail(), user.getPassword());
            store.setQuota(quota);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Can not set quota " + quota + " for user " + user, ex);
        }
    }

    public static Quota[] getQuota(GreenMailUser user, String quotaRoot) {
        Session session = GreenMailUtil.getSession(ServerSetupTest.IMAP);
        try {
            IMAPStore store = (IMAPStore)session.getStore("imap");
            store.connect(user.getEmail(), user.getPassword());
            return store.getQuota(quotaRoot);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Can not get quota for quota root " + quotaRoot + " for user " + user, ex);
        }
    }
}

