/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.imap;

import com.icegreen.greenmail.imap.ImapConstants;
import com.icegreen.greenmail.imap.commands.ImapCommand;
import com.icegreen.greenmail.store.MessageFlags;
import com.icegreen.greenmail.util.InternetPrintWriter;
import java.io.OutputStream;
import javax.mail.Flags;

public class ImapResponse
implements ImapConstants {
    private InternetPrintWriter writer;
    private String tag = "*";

    public ImapResponse(OutputStream output) {
        this.writer = new InternetPrintWriter(output, true);
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public void commandComplete(ImapCommand command) {
        this.commandComplete(command, null);
    }

    public void commandComplete(ImapCommand command, String responseCode) {
        this.tag();
        this.message("OK");
        this.responseCode(responseCode);
        this.commandName(command);
        this.message("completed.");
        this.end();
    }

    public void commandFailed(ImapCommand command, String reason) {
        this.commandFailed(command, null, reason);
    }

    public void commandFailed(ImapCommand command, String responseCode, String reason) {
        this.tag();
        this.message("NO");
        this.responseCode(responseCode);
        this.commandName(command);
        this.message("failed.");
        this.message(reason);
        this.end();
    }

    public void commandError(String message) {
        this.tag();
        this.message("BAD");
        this.message(message);
        this.end();
    }

    public void badResponse(String message) {
        this.untagged();
        this.message("BAD");
        this.message(message);
        this.end();
    }

    public void okResponse(String responseCode, String message) {
        this.untagged();
        this.message("OK");
        this.responseCode(responseCode);
        this.message(message);
        this.end();
    }

    public void flagsResponse(Flags flags) {
        this.untagged();
        this.message("FLAGS");
        this.message(MessageFlags.format(flags));
        this.end();
    }

    public void existsResponse(int count) {
        this.untagged();
        this.message(count);
        this.message("EXISTS");
        this.end();
    }

    public void recentResponse(int count) {
        this.untagged();
        this.message(count);
        this.message("RECENT");
        this.end();
    }

    public void expungeResponse(int msn) {
        this.untagged();
        this.message(msn);
        this.message("EXPUNGE");
        this.end();
    }

    public void fetchResponse(int msn, String msgData) {
        this.untagged();
        this.message(msn);
        this.message("FETCH");
        this.message('(' + msgData + ')');
        this.end();
    }

    public void commandResponse(ImapCommand command, String message) {
        this.untagged();
        this.commandName(command);
        this.message(message);
        this.end();
    }

    public void taggedResponse(String message) {
        this.tag();
        this.message(message);
        this.end();
    }

    public void untaggedResponse(String message) {
        this.untagged();
        this.message(message);
        this.end();
    }

    public void byeResponse(String message) {
        this.untaggedResponse("BYE " + message);
    }

    private void untagged() {
        this.writer.print("*");
    }

    private void tag() {
        this.writer.print(this.tag);
    }

    private void commandName(ImapCommand command) {
        String name = command.getName();
        this.writer.print(" ");
        this.writer.print(name);
    }

    private void message(String message) {
        if (message != null) {
            this.writer.print(" ");
            this.writer.print(message);
        }
    }

    private void message(int number) {
        this.writer.print(" ");
        this.writer.print(number);
    }

    private void responseCode(String responseCode) {
        if (responseCode != null) {
            this.writer.print(" [");
            this.writer.print(responseCode);
            this.writer.print("]");
        }
    }

    private void end() {
        this.writer.println();
        this.writer.flush();
    }

    public void permanentFlagsResponse(Flags flags) {
        this.untagged();
        this.message("OK");
        this.responseCode("PERMANENTFLAGS " + MessageFlags.format(flags));
        this.end();
    }
}

