/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.imap.commands;

import com.icegreen.greenmail.imap.commands.AppendCommand;
import com.icegreen.greenmail.imap.commands.AuthenticateCommand;
import com.icegreen.greenmail.imap.commands.CapabilityCommand;
import com.icegreen.greenmail.imap.commands.CheckCommand;
import com.icegreen.greenmail.imap.commands.CloseCommand;
import com.icegreen.greenmail.imap.commands.CopyCommand;
import com.icegreen.greenmail.imap.commands.CreateCommand;
import com.icegreen.greenmail.imap.commands.DeleteCommand;
import com.icegreen.greenmail.imap.commands.ExamineCommand;
import com.icegreen.greenmail.imap.commands.ExpungeCommand;
import com.icegreen.greenmail.imap.commands.FetchCommand;
import com.icegreen.greenmail.imap.commands.ImapCommand;
import com.icegreen.greenmail.imap.commands.ListCommand;
import com.icegreen.greenmail.imap.commands.LoginCommand;
import com.icegreen.greenmail.imap.commands.LogoutCommand;
import com.icegreen.greenmail.imap.commands.LsubCommand;
import com.icegreen.greenmail.imap.commands.NoopCommand;
import com.icegreen.greenmail.imap.commands.QuotaCommand;
import com.icegreen.greenmail.imap.commands.QuotaRootCommand;
import com.icegreen.greenmail.imap.commands.RenameCommand;
import com.icegreen.greenmail.imap.commands.SearchCommand;
import com.icegreen.greenmail.imap.commands.SelectCommand;
import com.icegreen.greenmail.imap.commands.SetQuotaCommand;
import com.icegreen.greenmail.imap.commands.StatusCommand;
import com.icegreen.greenmail.imap.commands.StoreCommand;
import com.icegreen.greenmail.imap.commands.SubscribeCommand;
import com.icegreen.greenmail.imap.commands.UidCommand;
import com.icegreen.greenmail.imap.commands.UnsubscribeCommand;
import java.util.HashMap;
import java.util.Map;

public class ImapCommandFactory {
    private final Map<String, Class<? extends ImapCommand>> _imapCommands = new HashMap<String, Class<? extends ImapCommand>>();

    public ImapCommandFactory() {
        this._imapCommands.put("CAPABILITY", CapabilityCommand.class);
        this._imapCommands.put("NOOP", NoopCommand.class);
        this._imapCommands.put("LOGOUT", LogoutCommand.class);
        this._imapCommands.put("AUTHENTICATE", AuthenticateCommand.class);
        this._imapCommands.put("LOGIN", LoginCommand.class);
        this._imapCommands.put("SELECT", SelectCommand.class);
        this._imapCommands.put("EXAMINE", ExamineCommand.class);
        this._imapCommands.put("CREATE", CreateCommand.class);
        this._imapCommands.put("DELETE", DeleteCommand.class);
        this._imapCommands.put("RENAME", RenameCommand.class);
        this._imapCommands.put("SUBSCRIBE", SubscribeCommand.class);
        this._imapCommands.put("UNSUBSCRIBE", UnsubscribeCommand.class);
        this._imapCommands.put("LIST", ListCommand.class);
        this._imapCommands.put("LSUB", LsubCommand.class);
        this._imapCommands.put("STATUS", StatusCommand.class);
        this._imapCommands.put("APPEND", AppendCommand.class);
        this._imapCommands.put("CHECK", CheckCommand.class);
        this._imapCommands.put("CLOSE", CloseCommand.class);
        this._imapCommands.put("EXPUNGE", ExpungeCommand.class);
        this._imapCommands.put("COPY", CopyCommand.class);
        this._imapCommands.put("SEARCH", SearchCommand.class);
        this._imapCommands.put("FETCH", FetchCommand.class);
        this._imapCommands.put("STORE", StoreCommand.class);
        this._imapCommands.put("UID", UidCommand.class);
        this._imapCommands.put("SETQUOTA", SetQuotaCommand.class);
        this._imapCommands.put("QUOTA", QuotaCommand.class);
        this._imapCommands.put("GETQUOTAROOT", QuotaRootCommand.class);
    }

    public ImapCommand getCommand(String commandName) {
        Class<? extends ImapCommand> cmdClass = this._imapCommands.get(commandName.toUpperCase());
        if (cmdClass == null) {
            return null;
        }
        return this.createCommand(cmdClass);
    }

    private ImapCommand createCommand(Class<? extends ImapCommand> commandClass) {
        try {
            ImapCommand cmd = commandClass.newInstance();
            if (cmd instanceof UidCommand) {
                ((UidCommand)cmd).setCommandFactory(this);
            }
            return cmd;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create command instance: " + commandClass.getName(), e);
        }
    }
}

