/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.imap.commands;

import com.icegreen.greenmail.imap.ImapRequestLineReader;
import com.icegreen.greenmail.imap.ImapResponse;
import com.icegreen.greenmail.imap.ImapSession;
import com.icegreen.greenmail.imap.ProtocolException;
import com.icegreen.greenmail.imap.commands.AuthenticatedStateCommand;
import com.icegreen.greenmail.imap.commands.CommandParser;
import com.icegreen.greenmail.store.FolderException;
import com.icegreen.greenmail.store.MailFolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

class ListCommand
extends AuthenticatedStateCommand {
    public static final String NAME = "LIST";
    public static final String ARGS = "<reference-name> <mailbox-name-with-wildcards>";
    private ListCommandParser parser = new ListCommandParser();

    ListCommand() {
    }

    @Override
    protected void doProcess(ImapRequestLineReader request, ImapResponse response, ImapSession session) throws ProtocolException, FolderException {
        Collection<MailFolder> mailboxes;
        boolean removeUserPrefix;
        String referenceName = this.parser.mailbox(request);
        String mailboxPattern = this.parser.listMailbox(request);
        this.parser.endLine(request);
        if (mailboxPattern.length() == 0) {
            String referenceRoot;
            if (referenceName.startsWith(NAMESPACE_PREFIX)) {
                removeUserPrefix = false;
                int firstDelimiter = referenceName.indexOf(46);
                referenceRoot = firstDelimiter == -1 ? referenceName : referenceName.substring(0, firstDelimiter);
            } else {
                referenceRoot = "";
                removeUserPrefix = true;
            }
            MailFolder referenceFolder = this.getMailbox(referenceRoot, session, false);
            if (referenceFolder == null) {
                referenceFolder = this.getMailbox("", session, true);
                removeUserPrefix = true;
            }
            mailboxes = new ArrayList<MailFolder>(1);
            mailboxes.add(referenceFolder);
        } else {
            String searchPattern = mailboxPattern.charAt(0) == '#' ? mailboxPattern : this.combineSearchTerms(referenceName, mailboxPattern);
            removeUserPrefix = searchPattern.charAt(0) != '#';
            mailboxes = this.doList(session, searchPattern);
        }
        String personalNamespace = "#mail." + session.getUser().getQualifiedMailboxName();
        int prefixLength = personalNamespace.length();
        Iterator<MailFolder> i$ = mailboxes.iterator();
        while (i$.hasNext()) {
            MailFolder mailboxe;
            MailFolder folder = mailboxe = i$.next();
            StringBuilder message = new StringBuilder("(");
            if (!folder.isSelectable()) {
                message.append("\\Noselect");
            }
            message.append(") \"");
            message.append('.');
            message.append("\" ");
            String mailboxName = folder.getFullName();
            if (removeUserPrefix) {
                mailboxName = mailboxName.length() <= prefixLength ? "" : mailboxName.substring(prefixLength + 1);
            }
            if (mailboxName.length() == 0) {
                message.append("\"\"");
            } else {
                message.append(mailboxName);
            }
            response.commandResponse(this, message.toString());
        }
        session.unsolicitedResponses(response);
        response.commandComplete(this);
    }

    protected Collection<MailFolder> doList(ImapSession session, String searchPattern) throws FolderException {
        return session.getHost().listMailboxes(session.getUser(), searchPattern);
    }

    private String combineSearchTerms(String referenceName, String mailboxMatch) {
        StringBuilder buffer = new StringBuilder(mailboxMatch);
        if (referenceName.endsWith(HIERARCHY_DELIMITER)) {
            if (buffer.charAt(0) == '.') {
                buffer.deleteCharAt(0);
            }
        } else if (buffer.charAt(0) != '.' && referenceName.length() != 0) {
            buffer.insert(0, '.');
        }
        buffer.insert(0, referenceName);
        return buffer.toString();
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getArgSyntax() {
        return ARGS;
    }

    private static class ListCommandParser
    extends CommandParser {
        private ListCommandParser() {
        }

        public String listMailbox(ImapRequestLineReader request) throws ProtocolException {
            char next = request.nextWordChar();
            switch (next) {
                case '\"': {
                    return this.consumeQuoted(request);
                }
                case '{': {
                    return this.consumeLiteral(request);
                }
            }
            return this.consumeWord(request, new ListCharValidator());
        }

        private class ListCharValidator
        extends CommandParser.ATOM_CHARValidator {
            private ListCharValidator() {
            }

            @Override
            public boolean isValid(char chr) {
                return ListCommandParser.this.isListWildcard(chr) || super.isValid(chr);
            }
        }
    }
}

