/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.imap.commands;

import com.icegreen.greenmail.imap.AuthorizationException;
import com.icegreen.greenmail.imap.ImapRequestLineReader;
import com.icegreen.greenmail.imap.ImapResponse;
import com.icegreen.greenmail.imap.ImapSession;
import com.icegreen.greenmail.imap.ProtocolException;
import com.icegreen.greenmail.imap.commands.QuotaCommand;
import com.icegreen.greenmail.store.FolderException;
import javax.mail.Quota;

public class QuotaRootCommand
extends QuotaCommand {
    public static final String NAME = "GETQUOTAROOT";

    @Override
    protected void doProcess(ImapRequestLineReader request, ImapResponse response, ImapSession session) throws ProtocolException, FolderException, AuthorizationException {
        if (!session.getHost().getStore().isQuotaSupported()) {
            response.commandFailed(this, "Quota is not supported. Activate quota capability first");
        }
        String root = this.parser.mailbox(request);
        Quota[] quota = session.getHost().getStore().getQuota(root, session.getUser().getQualifiedMailboxName());
        StringBuilder buf = new StringBuilder("QUOTAROOT ");
        buf.append(root);
        for (Quota q : quota) {
            buf.append(' ');
            this.appendQuotaRootName(q, buf);
        }
        response.untaggedResponse("QUOTAROOT " + root);
        for (Quota q : quota) {
            buf = new StringBuilder();
            this.appendQuota(q, buf);
            response.untaggedResponse(buf.toString());
        }
        response.commandComplete(this);
    }

    @Override
    protected String getArgSyntax() {
        return "quota-root--arg";
    }

    @Override
    public String getName() {
        return NAME;
    }
}

