/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.imap.commands;

import com.icegreen.greenmail.imap.ImapRequestLineReader;
import com.icegreen.greenmail.imap.ImapResponse;
import com.icegreen.greenmail.imap.ImapSession;
import com.icegreen.greenmail.imap.ImapSessionFolder;
import com.icegreen.greenmail.imap.ProtocolException;
import com.icegreen.greenmail.imap.commands.CommandParser;
import com.icegreen.greenmail.imap.commands.SearchKey;
import com.icegreen.greenmail.imap.commands.SearchTermBuilder;
import com.icegreen.greenmail.imap.commands.SelectedStateCommand;
import com.icegreen.greenmail.imap.commands.UidEnabledCommand;
import com.icegreen.greenmail.store.FolderException;
import javax.mail.search.AndTerm;
import javax.mail.search.NotTerm;
import javax.mail.search.SearchTerm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SearchCommand
extends SelectedStateCommand
implements UidEnabledCommand {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String NAME = "SEARCH";
    public static final String ARGS = "<search term>";
    private SearchCommandParser parser = new SearchCommandParser();

    SearchCommand() {
    }

    @Override
    protected void doProcess(ImapRequestLineReader request, ImapResponse response, ImapSession session) throws ProtocolException, FolderException {
        this.doProcess(request, response, session, false);
    }

    @Override
    public void doProcess(ImapRequestLineReader request, ImapResponse response, ImapSession session, boolean useUids) throws ProtocolException, FolderException {
        SearchTerm searchTerm = this.parser.searchTerm(request);
        this.parser.endLine(request);
        ImapSessionFolder folder = session.getSelected();
        long[] uids = folder.search(searchTerm);
        StringBuilder idList = new StringBuilder();
        for (int i = 0; i < uids.length; ++i) {
            if (i > 0) {
                idList.append(" ");
            }
            long uid = uids[i];
            if (useUids) {
                idList.append(uid);
                continue;
            }
            int msn = folder.getMsn(uid);
            idList.append(msn);
        }
        response.commandResponse(this, idList.toString());
        boolean omitExpunged = !useUids;
        session.unsolicitedResponses(response, omitExpunged);
        response.commandComplete(this);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getArgSyntax() {
        return ARGS;
    }

    private class SearchCommandParser
    extends CommandParser {
        private SearchCommandParser() {
        }

        public SearchTerm searchTerm(ImapRequestLineReader request) throws ProtocolException {
            SearchTerm resultTerm = null;
            SearchTermBuilder b = null;
            boolean negated = false;
            char next = request.nextChar();
            StringBuilder sb = new StringBuilder();
            while (next != '\n') {
                block11: {
                    if (next != ' ' && next != '\r') {
                        sb.append(next);
                    }
                    request.consume();
                    next = request.nextChar();
                    if (next != ' ' && next != '\n') continue;
                    if (SearchCommand.this.log.isDebugEnabled()) {
                        SearchCommand.this.log.debug("Search request is '" + sb.toString() + '\'');
                    }
                    if (null == b) {
                        try {
                            SearchKey key = SearchKey.valueOf(sb.toString());
                            if (SearchKey.NOT == key) {
                                negated = true;
                                break block11;
                            }
                            b = SearchTermBuilder.create(key);
                        }
                        catch (IllegalArgumentException ex) {
                            SearchCommand.this.log.warn("Ignoring not yet implemented search command '" + sb.toString() + "'", (Throwable)ex);
                            negated = false;
                        }
                    } else if (b.expectsParameter()) {
                        b = b.addParameter(sb.toString());
                    }
                }
                if (b != null && !b.expectsParameter()) {
                    SearchTerm searchTerm = b.build();
                    if (negated) {
                        searchTerm = new NotTerm(searchTerm);
                        negated = false;
                    }
                    b = null;
                    resultTerm = resultTerm == null ? searchTerm : new AndTerm(resultTerm, searchTerm);
                }
                sb = new StringBuilder();
                next = request.nextChar();
            }
            return resultTerm;
        }
    }
}

